#include "tcl.h"
#include "tk.h"
#include "TTW.h"

/// ===================================
/// Tcl_DString ₷NX

// ====== CX^X ======
TTW_DString::TTW_DString(){
	::Tcl_DStringInit(&dstr);
}

TTW_DString::TTW_DString(int length){
	::Tcl_DStringInit(&dstr);
	::Tcl_DStringSetLength(&dstr, length);
}

TTW_DString::TTW_DString(const char *str){
	::Tcl_DStringInit(&dstr);
	::Tcl_DStringAppend(&dstr, str, -1);
}

TTW_DString::TTW_DString(const char *str, int length){
	::Tcl_DStringInit(&dstr);
	::Tcl_DStringAppend(&dstr, str, length);
}

TTW_DString::TTW_DString(const Tcl_DString &rhs){
	::Tcl_DStringInit(&dstr);
	::Tcl_DStringAppend(&dstr, Tcl_DStringValue(&rhs), Tcl_DStringLength(&rhs));
}

TTW_DString::TTW_DString(const TTW_DString &rhs){
	::Tcl_DStringInit(&dstr);
	::Tcl_DStringAppend(&dstr, Tcl_DStringValue(&rhs.dstr), Tcl_DStringLength(&rhs.dstr));
}

TTW_DString::TTW_DString(Tcl_Obj *obj){
	::Tcl_DStringInit(&dstr);
	if (!obj) return;
	int length; const char *str = TTW_GetString(obj, length);
	::Tcl_DStringAppend(&dstr, str, length);
}

TTW_DString &TTW_DString::operator =(const char *rhs){
	::Tcl_DStringFree(&dstr);
	::Tcl_DStringAppend(&dstr, rhs, -1);
	return *this;
}
TTW_DString &TTW_DString::operator =(const Tcl_DString &rhs){
	::Tcl_DStringFree(&dstr);
	::Tcl_DStringAppend(&dstr, Tcl_DStringValue(&rhs), Tcl_DStringLength(&rhs));
	return *this;
}
TTW_DString &TTW_DString::operator =(const TTW_DString &rhs){
	::Tcl_DStringFree(&dstr);
	::Tcl_DStringAppend(&dstr, Tcl_DStringValue(&rhs.dstr), Tcl_DStringLength(&rhs.dstr));
	return *this;
}
TTW_DString &TTW_DString::operator =(Tcl_Obj *obj){
	::Tcl_DStringFree(&dstr);
	if (!obj) return *this;
	int length; const char *str = TTW_GetString(obj, length);
	::Tcl_DStringAppend(&dstr, str, length);
	return *this;
}

TTW_DString::~TTW_DString(){
	::Tcl_DStringFree(&dstr);
}

// ====== ̃ZbgAǉ ======
TTW_DString &TTW_DString::Move(Tcl_DString &rhs){
	::Tcl_DStringFree(&dstr);
	dstr = rhs;
	// shallow copy ̂߁Arhs  Free ƁA
	// CX^X̓eB
	// nꂽ rhs ŉĂvȂ悤ɁA
	// Free ̑ Init B
	::Tcl_DStringInit(&rhs);
	return *this;
}

TTW_DString &TTW_DString::Move(TTW_DString &rhs){
	::Tcl_DStringFree(&dstr);
	dstr = rhs.dstr;
	::Tcl_DStringInit(&rhs.dstr);
	return *this;
}

TTW_DString &TTW_DString::Set(const char *rhs, int length){
	::Tcl_DStringFree(&dstr);
	::Tcl_DStringAppend(&dstr, rhs, length);
	return *this;
}
TTW_DString &TTW_DString::Append(const char *rhs, int length){
	::Tcl_DStringAppend(&dstr, rhs, length);
	return *this;
}

TTW_DString &TTW_DString::operator << (const char *rhs){
	::Tcl_DStringAppend(&dstr, rhs, -1);
	return *this;
}

TTW_DString &TTW_DString::operator << (const Tcl_DString &rhs){
	::Tcl_DStringAppend(&dstr, Tcl_DStringValue(&rhs), Tcl_DStringLength(&rhs));
	return *this;
}

TTW_DString &TTW_DString::operator << (const TTW_DString &rhs){
	::Tcl_DStringAppend(&dstr, rhs, rhs.Length());
	return *this;
}

TTW_DString &TTW_DString::operator << (Tcl_Obj *obj){
	if (!obj) return *this;
	int length; const char *str = TTW_GetString(obj, length);
	::Tcl_DStringAppend(&dstr, str, length);
	return *this;
}

// ====== R[hϊ ======
TTW_DString &TTW_DString::SysToUtf8(const char *str, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_ExternalToUtfDString(0, str, -1, &dstr);
	return *this;
}
TTW_DString &TTW_DString::SysToUtf8(const char *str, int length, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_ExternalToUtfDString(0, str, length, &dstr);
	return *this;
}
TTW_DString &TTW_DString::SysToUtf8(const Tcl_DString &str, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_ExternalToUtfDString(0, Tcl_DStringValue(&str), Tcl_DStringLength(&str), &dstr);
	return *this;
}
TTW_DString &TTW_DString::SysToUtf8(const TTW_DString &str, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_ExternalToUtfDString(0, str, str.Length(), &dstr);
	return *this;
}

TTW_DString &TTW_DString::ToUtf8(Tcl_Encoding enc, const char *str, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_ExternalToUtfDString(enc, str, -1, &dstr);
	return *this;
}
TTW_DString &TTW_DString::ToUtf8(Tcl_Encoding enc, const char *str, int length, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_ExternalToUtfDString(enc, str, length, &dstr);
	return *this;
}
TTW_DString &TTW_DString::ToUtf8(Tcl_Encoding enc, const Tcl_DString &str, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_ExternalToUtfDString(enc, Tcl_DStringValue(&str), Tcl_DStringLength(&str), &dstr);
	return *this;
}
TTW_DString &TTW_DString::ToUtf8(Tcl_Encoding enc, const TTW_DString &str, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_ExternalToUtfDString(enc, str, str.Length(), &dstr);
	return *this;
}

/// ŗ^ꂽ UTF8 VXeGR[fBOɕϊĊi[
TTW_DString &TTW_DString::Utf8ToSys(const char *str, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_UtfToExternalDString(0, str, -1, &dstr);
	return *this;
}

TTW_DString &TTW_DString::Utf8ToSys(const char *str, int length, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_UtfToExternalDString(0, str, length, &dstr);
	return *this;
}

TTW_DString &TTW_DString::Utf8ToSys(const Tcl_DString &str, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_UtfToExternalDString(0, Tcl_DStringValue(&str), Tcl_DStringLength(&str), &dstr);
	return *this;
}

TTW_DString &TTW_DString::Utf8ToSys(const TTW_DString &str, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_UtfToExternalDString(0, str, str.Length(), &dstr);
	return *this;
}

TTW_DString &TTW_DString::Utf8ToSys(Tcl_Obj *obj, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	if (!obj) return *this;
	int length; const char *str = TTW_GetString(obj, length);
	::Tcl_UtfToExternalDString(0, str, length, &dstr);
	return *this;
}

/// ŗ^ꂽ UTF8 w肳ꂽGR[fBOɕϊĊi[
TTW_DString &TTW_DString::Utf8To(Tcl_Encoding dst_enc, const char *utf8_str, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_UtfToExternalDString(dst_enc, utf8_str, -1, &dstr);
	return *this;
}

TTW_DString &TTW_DString::Utf8To(Tcl_Encoding dst_enc, const char *utf8_str, int length, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_UtfToExternalDString(dst_enc, utf8_str, length, &dstr);
	return *this;
}

TTW_DString &TTW_DString::Utf8To(Tcl_Encoding dst_enc, const Tcl_DString &utf8_str, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_UtfToExternalDString(dst_enc, Tcl_DStringValue(&utf8_str), Tcl_DStringLength(&utf8_str), &dstr);
	return *this;
}

TTW_DString &TTW_DString::Utf8To(Tcl_Encoding dst_enc, const TTW_DString &utf8_str, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	::Tcl_UtfToExternalDString(dst_enc, utf8_str, utf8_str.Length(), &dstr);
	return *this;
}

TTW_DString &TTW_DString::Utf8To(Tcl_Encoding dst_enc, Tcl_Obj *obj, bool append){
	if (!append) ::Tcl_DStringFree(&dstr);
	if (!obj) return *this;
	int length; const char *str = TTW_GetString(obj, length);
	::Tcl_UtfToExternalDString(dst_enc, str, length, &dstr);
	return *this;
}

// ====== 擾 ======
TTW_DString::operator const char *() const{
	return Tcl_DStringValue(&dstr);
}

TTW_DString::operator char *(){
	return Tcl_DStringValue(&dstr);
}

const char *TTW_DString::Value() const{
	return Tcl_DStringValue(&dstr);
}

char *TTW_DString::Value(){
	return Tcl_DStringValue(&dstr);
}

// ====== 񒷎擾AύX ======
int TTW_DString::Length() const{
	return Tcl_DStringLength(&dstr);
}

void TTW_DString::SetLength(int len){
	::Tcl_DStringSetLength(&dstr, len);
}

void TTW_DString::Clear(){
	::Tcl_DStringFree(&dstr);
}

// ====== Tcl List֘A ======
void TTW_DString::StartSubList(){
	::Tcl_DStringStartSublist(&dstr);
}

void TTW_DString::EndSubList(){
	::Tcl_DStringEndSublist(&dstr);
}

TTW_DString &TTW_DString::AppendElement(const char *rhs){
	::Tcl_DStringAppendElement(&dstr, rhs);
	return *this;
}

TTW_DString &TTW_DString::AppendElement(const Tcl_DString &rhs){
	::Tcl_DStringAppendElement(&dstr, Tcl_DStringValue(&rhs));
	return *this;
}

TTW_DString &TTW_DString::AppendElement(const TTW_DString &rhs){
	::Tcl_DStringAppendElement(&dstr, rhs);
	return *this;
}

TTW_DString &TTW_DString::AppendElement(Tcl_Obj *obj){
	if (!obj) return *this;
	::Tcl_DStringAppendElement(&dstr, TTW_GetString(obj));
	return *this;
}

TTW_DString &TTW_Format(Tcl_Interp *interp, TTW_DString &utf8_lhs, const char *utf8_fmt, const TTW_ListObj &rhs){
	int objc;
	Tcl_Obj **objv;
	::Tcl_ListObjGetElements(interp, const_cast<TTW_ListObj &>(rhs), &objc, &objv);
	Tcl_Obj *obj = ::Tcl_Format(interp, utf8_fmt, objc, objv);
	utf8_lhs << obj;
	Tcl_DecrRefCount(obj);
	return utf8_lhs;
}

TTW_DString &TTW_Format(TTW_DString &utf8_lhs, const char *utf8_fmt, const TTW_ListObj &rhs){
	return TTW_Format(0, utf8_lhs, utf8_fmt, rhs);
}

/// ===================================
/// Tcl_ListObj ₷NX
/// ====== CX^X ======
TTW_ListObj::TTW_ListObj() : interp(0){
	listObj = 0;
}
TTW_ListObj::TTW_ListObj(int objc, Tcl_Obj *objv[]) : interp(0){
	listObj = ::Tcl_NewListObj(objc, objv);
}
TTW_ListObj::TTW_ListObj(const TTW_ListObj &rhs) : interp(0){
	listObj = ::Tcl_DuplicateObj(rhs.listObj);
}
TTW_ListObj & TTW_ListObj::operator = (const TTW_ListObj &rhs){
	if (listObj) Tcl_DecrRefCount(listObj);
	listObj = ::Tcl_DuplicateObj(rhs.listObj);
	return *this;
}
TTW_ListObj & TTW_ListObj::Move(Tcl_Obj *rhs){
	if (listObj) Tcl_DecrRefCount(listObj);
	listObj = rhs;
	return *this;
}
TTW_ListObj & TTW_ListObj::Copy(Tcl_Obj *rhs){
	if (listObj) Tcl_DecrRefCount(listObj);
	listObj = ::Tcl_DuplicateObj(rhs);
	return *this;
}

TTW_ListObj::~TTW_ListObj(){
	if (listObj) Tcl_DecrRefCount(listObj);
}

/// ====== G[ݒ ======
void TTW_ListObj::SetInterp(Tcl_Interp *interp_){
	interp = interp_;
}
Tcl_Interp *TTW_ListObj::GetInterp(){
	return interp;
}

/// ====== Xgvf擾 ======
// ŎQƃJE^𑝂₳Ȃ̂ŁA
// TTW_ListObj ̐Ԃ̊OŎgꍇ
// QƃJE^𑝂₷KvB
TTW_ListObj::operator Tcl_Obj *(){
	if (!listObj) listObj = ::Tcl_NewObj();
	return listObj;
}
/*
TTW_ListObj::operator Tcl_Obj *() const{
	if (!listObj) listObj = ::Tcl_NewObj();
	return listObj;
}
*/
Tcl_Obj *TTW_ListObj::operator [](int idx){
	if (!listObj) return 0;
	Tcl_Obj *obj = 0;
	::Tcl_ListObjIndex(interp, listObj, idx, &obj);
	return obj;
}
const Tcl_Obj *TTW_ListObj::operator [](int idx) const{
	if (!listObj) return 0;
	Tcl_Obj *obj = 0;
	::Tcl_ListObjIndex(interp, listObj, idx, &obj);
	return obj;
}

int TTW_ListObj::Count() const{
	if (!listObj) return 0;
	int cnt = -1;
	::Tcl_ListObjLength(interp, listObj, &cnt);
	return cnt;
}

/// ====== X^bN̏ ======
Tcl_Obj *TTW_ListObj::Push(Tcl_Obj *obj){
	if (!listObj) listObj = ::Tcl_NewObj();
	::Tcl_ListObjAppendElement(interp, listObj, obj);
	return obj;
}
Tcl_Obj *TTW_ListObj::Last(){
	if (!listObj) return 0;
	int cnt = -1;
	::Tcl_ListObjLength(interp, listObj, &cnt);
	if (cnt < 0) return 0;
	Tcl_Obj *obj;
	::Tcl_ListObjIndex(interp, listObj, cnt-1, &obj);
	return obj;
}
void TTW_ListObj::Pop(){
	if (!listObj) return;
	int cnt = -1;
	::Tcl_ListObjLength(interp, listObj, &cnt);
	if (cnt < 0) return;
	::Tcl_ListObjReplace(interp, listObj, cnt-1, 1, 0, 0);
}

/// ====== vfǉ ======
TTW_ListObj &TTW_ListObj::operator << (bool b){
	if (!listObj) listObj = ::Tcl_NewObj();
	::Tcl_ListObjAppendElement(interp, listObj, ::Tcl_NewBooleanObj(b ? 1 : 0));
	return *this;
}
TTW_ListObj &TTW_ListObj::operator << (int i){
	if (!listObj) listObj = ::Tcl_NewObj();
	::Tcl_ListObjAppendElement(interp, listObj, ::Tcl_NewIntObj(i));
	return *this;
}
TTW_ListObj &TTW_ListObj::operator << (long l){
	if (!listObj) listObj = ::Tcl_NewObj();
	::Tcl_ListObjAppendElement(interp, listObj, ::Tcl_NewLongObj(l));
	return *this;
}
TTW_ListObj &TTW_ListObj::operator << (double d){
	if (!listObj) listObj = ::Tcl_NewObj();
	::Tcl_ListObjAppendElement(interp, listObj, ::Tcl_NewDoubleObj(d));
	return *this;
}
TTW_ListObj &TTW_ListObj::operator << (Tcl_WideInt &wi){
	if (!listObj) listObj = ::Tcl_NewObj();
	::Tcl_ListObjAppendElement(interp, listObj, ::Tcl_NewWideIntObj(wi));
	return *this;
}
TTW_ListObj &TTW_ListObj::operator << (mp_int &mp){
	if (!listObj) listObj = ::Tcl_NewObj();
	::Tcl_ListObjAppendElement(interp, listObj, ::Tcl_NewBignumObj(&mp));
	return *this;
}
TTW_ListObj &TTW_ListObj::operator << (const char *utf8){
	if (!listObj) listObj = ::Tcl_NewObj();
	::Tcl_ListObjAppendElement(interp, listObj, ::Tcl_NewStringObj(utf8, -1));
	return *this;
}
TTW_ListObj &TTW_ListObj::operator << (Tcl_DString &utf8){
	if (!listObj) listObj = ::Tcl_NewObj();
	::Tcl_ListObjAppendElement(interp, listObj, ::Tcl_NewStringObj(Tcl_DStringValue(&utf8), Tcl_DStringLength(&utf8)));
	return *this;
}
TTW_ListObj &TTW_ListObj::operator << (const TTW_DString &utf8){
	if (!listObj) listObj = ::Tcl_NewObj();
	::Tcl_ListObjAppendElement(interp, listObj, ::Tcl_NewStringObj(utf8, utf8.Length()));
	return *this;
}
TTW_ListObj &TTW_ListObj::operator << (Tcl_Obj *obj){
	if (!listObj) listObj = ::Tcl_NewObj();
	::Tcl_ListObjAppendElement(interp, listObj, obj);
	return *this;
}
TTW_ListObj &TTW_ListObj::operator << (TTW_ListObj &obj){
	if (!listObj) listObj = ::Tcl_NewObj();
	::Tcl_ListObjAppendElement(interp, listObj, obj.listObj);
	return *this;
}

/// ===================================
/// Tcl_Obj l擾֐Q

bool TTW_GetBoolean(Tcl_Interp *interp, Tcl_Obj *obj, bool when_null){
	if (!obj) return when_null;
	int b; ::Tcl_GetBooleanFromObj(interp, obj, &b);
	return (b != 0);
}

bool TTW_GetBoolean(Tcl_Obj *obj, bool when_null){
	if (!obj) return when_null;
	int b; ::Tcl_GetBooleanFromObj(0, obj, &b);
	return (b != 0);
}

// ByteArray

double TTW_GetDouble(Tcl_Interp *interp, Tcl_Obj *obj, double when_null){
	if (!obj) return when_null;
	double d; ::Tcl_GetDoubleFromObj(interp, obj, &d);
	return d;
}

double TTW_GetDouble(Tcl_Obj *obj, double when_null){
	if (!obj) return when_null;
	double d; ::Tcl_GetDoubleFromObj(0, obj, &d);
	return d;
}

// Index
int TTW_GetInt(Tcl_Interp *interp, Tcl_Obj *obj, int when_null){
	if (!obj) return when_null;
	int i; ::Tcl_GetIntFromObj(interp, obj, &i);
	return i;
}
int TTW_GetInt(Tcl_Obj *obj, int when_null){
	if (!obj) return when_null;
	int i; ::Tcl_GetIntFromObj(0, obj, &i);
	return i;
}

long TTW_GetLong(Tcl_Interp *interp, Tcl_Obj *obj, long when_null){
	if (!obj) return when_null;
	long l; ::Tcl_GetLongFromObj(interp, obj, &l);
	return l;
}

long TTW_GetLong(Tcl_Obj *obj, long when_null){
	if (!obj) return when_null;
	long l; ::Tcl_GetLongFromObj(0, obj, &l);
	return l;
}

const char *TTW_GetString(Tcl_Obj *obj, const char *when_null){
	if (!obj) return when_null;
	return ::Tcl_GetStringFromObj(obj, 0);
}

const char *TTW_GetString(Tcl_Obj *obj, int &length, const char *when_null){
	if (!obj) return when_null;
	return ::Tcl_GetStringFromObj(obj, &length);
}

Tcl_UniChar *TTW_GetUnicode(Tcl_Obj *obj, Tcl_UniChar *when_null){
	if (!obj) return when_null;
	return ::Tcl_GetUnicodeFromObj(obj, 0);
}

Tcl_UniChar *TTW_GetUnicode(Tcl_Obj *obj, int &length, Tcl_UniChar *when_null){
	if (!obj) return when_null;
	return ::Tcl_GetUnicodeFromObj(obj, &length);
}

Tcl_WideInt TTW_GetWideInt(Tcl_Interp *interp, Tcl_Obj *obj, Tcl_WideInt when_null){
	if (!obj) return when_null;
	Tcl_WideInt wi; ::Tcl_GetWideIntFromObj(interp, obj, &wi);
	return wi;
}

Tcl_WideInt TTW_GetWideInt(Tcl_Obj *obj, Tcl_WideInt when_null){
	if (!obj) return when_null;
	Tcl_WideInt wi; ::Tcl_GetWideIntFromObj(0, obj, &wi);
	return wi;
}

#if 0
mp_int TTW_GetBignum(Tcl_Interp *interp, Tcl_Obj *obj){
	mp_int bn; ::Tcl_GetBignumFromObj(interp, obj, &bn);
	return bn;
}

mp_int TTW_GetBignum(Tcl_Obj *obj, mp_int when_null){
	if (!obj) return when_null;
	mp_int bn; ::Tcl_GetBignumFromObj(0, obj, &bn);
	return bn;
}
#endif

// RegExp

/// ===================================
/// t@C֘A
Tcl_Obj *TTW_FSJoinToPath (Tcl_Obj *pathPtr, TTW_ListObj &list){
	int objc;
	Tcl_Obj **objv;
	::Tcl_ListObjGetElements(list.GetInterp(), list, &objc, &objv);
	return ::Tcl_FSJoinToPath(pathPtr, objc, objv);
}
