/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: lychee.h 297 2010-08-29 06:25:52Z sirakaba $
*******************************************************************************/

#ifndef H_LOADED_LYCHEE
#define H_LOADED_LYCHEE

#define wxUSE_UNICODE       1
#include "../common/header/plugin.h"
#include <wx/treectrl.h>
#include <wx/listctrl.h>
#include <wx/imaglist.h>
#include <wx/mimetype.h>
#include <wx/xrc/xmlres.h>
#include <wx/stdpaths.h>
#include <wx/dir.h>
#include <wx/dynarray.h>

#include "../common/handle/TPIHandle.h"

WX_DECLARE_OBJARRAY(TPI_FILEINFO, ArrayTPI_FILEINFO);

#include "cls_listctrl.h"
#include "cls_config.h"

#ifdef __WINDOWS__
#define TPI_EXT wxT(".dll")
#define EXE_EXT wxT(".exe")
#define DIR_APP wxT("explorer ")
#else
#define TPI_EXT wxT(".so")
#define EXE_EXT (wxString) wxEmptyString
#define DIR_APP wxT("dolphin ")
#endif

#define L_DIR_BIN wxT("./")
#define L_DIR_SHR wxT("../share/")
#define L_DIR_B_LIB L_DIR_BIN wxT("lib/")
#define L_DIR_S_XRC L_DIR_SHR wxT("xrc/")
#define L_DIR_S_ICO L_DIR_SHR wxT("ico/")
#define L_DIR_S_LOC L_DIR_SHR wxT("locale/")

#define AskDlg(msg, parent) wxMessageBox(msg, wxT("Lychee"), wxCENTRE | wxYES_NO | wxICON_QUESTION, parent)

class Lychee: public wxApp
{
public:
	bool OnInit();
	Lychee() : lc(wxLANGUAGE_DEFAULT){}
private:
	wxLocale lc;
};

#endif
