/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: cls_filedroptarget.cpp 333 2010-09-23 04:23:28Z sirakaba $
*******************************************************************************/

#include "lychee.h"

#include "frm_main.h"
#include "cls_filedroptarget.h"

//******************************************************************************
// myFileDropTarget
//******************************************************************************

myFileDropTarget::myFileDropTarget(MainFrame * mainFrame)
{
	this->mainFrame = mainFrame;
}

//******************************************************************************
// Event handler.
//******************************************************************************

bool myFileDropTarget::OnDropFiles(wxCoord, wxCoord, const wxArrayString & asFiles)
{
	wxCommandEvent e;

	// ファイルが存在するか確認。
	if (asFiles.GetCount() == 1 && ::wxFileExists(asFiles[0]))
	{
		// 対応しているかどうか確認。
		wxULongLong_t llFileCount = 0;
		if (this->mainFrame->LoadTPI(asFiles[0], & llFileCount))
		{
			// 書庫を開く。
			e.SetInt(1);
			e.SetExtraLong((long) llFileCount);
			this->mainFrame->fnArchive = wxFileName(asFiles[0]);
			this->mainFrame->OnArcOpen(e);
			return true;
		}
	}

	// 対応していない場合は書庫の作成を試みる。
	wxArrayString as = asFiles;
	e.SetClientData(& as);
	this->mainFrame->OnArcCreate(e);

	return true;
}

//******************************************************************************
// myFileDataObject
//******************************************************************************

#ifdef __LINUX__
bool myFileDataObject::GetDataHere(void * buf) const
{
	wxString filenames;
	for (size_t i = 0; i < m_filenames.GetCount(); i++)
	{
		filenames += wxT("file:") + m_filenames[i] + wxT("\r\n");
	}
	memcpy(buf, filenames.mbc_str(), strlen(filenames.mbc_str()) + 1);
	return true;
}

size_t myFileDataObject::GetDataSize() const
{
	size_t res = 1;
	for (size_t i = 0; i < m_filenames.GetCount(); i++)
	{
		res += strlen(m_filenames[i].mbc_str()) + 5 + 2; // "file:" (5) + "\r\n" (2)
	}
	return res;
}

void myFileDataObject::AddFile(const wxString & filename)
{
	m_filenames.Add(filename);
}
#endif
