/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.events.EventProducer;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontConfig;
import org.apache.fop.fonts.FontEventAdapter;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.util.LogUtil;

public final class DefaultFontConfig
implements FontConfig {
    private static final Log log = LogFactory.getLog(DefaultFontConfig.class);
    private final List<Directory> directories = new ArrayList<Directory>();
    private final List<Font> fonts = new ArrayList<Font>();
    private final List<String> referencedFontFamilies = new ArrayList<String>();
    private final boolean autoDetectFonts;

    private DefaultFontConfig(boolean autoDetectFonts) {
        this.autoDetectFonts = autoDetectFonts;
    }

    public List<Font> getFonts() {
        return Collections.unmodifiableList(this.fonts);
    }

    public List<Directory> getDirectories() {
        return Collections.unmodifiableList(this.directories);
    }

    public List<String> getReferencedFontFamily() {
        return Collections.unmodifiableList(this.referencedFontFamilies);
    }

    public boolean isAutoDetectFonts() {
        return this.autoDetectFonts;
    }

    public static final class DefaultFontConfigParser
    implements FontConfig.FontConfigParser {
        public DefaultFontConfig parse(Configuration cfg, boolean strict) throws FOPException {
            return new ParserHelper(cfg, strict).instance;
        }

        public DefaultFontConfig parse(Configuration cfg, boolean strict, FontEventAdapter eventAdapter) throws FOPException {
            return new ParserHelper(cfg, strict, eventAdapter).instance;
        }

        @Override
        public FontConfig parse(Configuration cfg, FontManager fontManager, boolean strict, EventProducer eventProducer) throws FOPException {
            return this.parse(cfg, strict);
        }
    }

    public static final class Directory {
        private final String directory;
        private final boolean recursive;

        private Directory(String directory, boolean recurse) {
            this.directory = directory;
            this.recursive = recurse;
        }

        public String getDirectory() {
            return this.directory;
        }

        public boolean isRecursive() {
            return this.recursive;
        }
    }

    public static final class Font {
        private final String metrics;
        private final String embedUri;
        private String afm;
        private String pfm;
        private final String subFont;
        private final boolean kerning;
        private final boolean advanced;
        private final String encodingMode;
        private final String embeddingMode;
        private final boolean embedAsType1;
        private final boolean simulateStyle;
        private final List<FontTriplet> tripletList = new ArrayList<FontTriplet>();

        public String getEncodingMode() {
            return this.encodingMode;
        }

        public List<FontTriplet> getTripletList() {
            return Collections.unmodifiableList(this.tripletList);
        }

        private Font(String metrics, String embed, String afm, String pfm, String subFont, boolean kerning, boolean advanced, String encodingMode, String embeddingMode, boolean simulateStyle, boolean embedAsType1) {
            this.metrics = metrics;
            this.embedUri = embed;
            this.afm = afm;
            this.pfm = pfm;
            this.subFont = subFont;
            this.kerning = kerning;
            this.advanced = advanced;
            this.encodingMode = encodingMode;
            this.embeddingMode = embeddingMode;
            this.simulateStyle = simulateStyle;
            this.embedAsType1 = embedAsType1;
        }

        public boolean isKerning() {
            return this.kerning;
        }

        public boolean isAdvanced() {
            return this.advanced;
        }

        public String getMetrics() {
            return this.metrics;
        }

        public String getEmbedURI() {
            return this.embedUri;
        }

        public String getSubFont() {
            return this.subFont;
        }

        public String getEmbeddingMode() {
            return this.embeddingMode;
        }

        public String getAfm() {
            return this.afm;
        }

        public String getPfm() {
            return this.pfm;
        }

        public boolean getSimulateStyle() {
            return this.simulateStyle;
        }

        public boolean getEmbedAsType1() {
            return this.embedAsType1;
        }
    }

    private static final class ParserHelper {
        private boolean strict;
        private Configuration config;
        private Configuration fontInfoCfg;
        private FontEventAdapter eventAdapter;
        private DefaultFontConfig instance;

        private ParserHelper(Configuration cfg, boolean strict) throws FOPException {
            this(cfg, strict, (FontEventAdapter)null);
        }

        private ParserHelper(Configuration cfg, boolean strict, FontEventAdapter eventAdapter) throws FOPException {
            this.eventAdapter = eventAdapter;
            if (cfg == null || cfg.getChild("fonts", false) == null) {
                this.instance = null;
            } else {
                this.strict = strict;
                this.config = cfg;
                this.fontInfoCfg = cfg.getChild("fonts", false);
                this.instance = new DefaultFontConfig(this.fontInfoCfg.getChild("auto-detect", false) != null);
                this.parse();
            }
        }

        private void parse() throws FOPException {
            this.parseFonts();
            this.parseReferencedFonts();
            this.parseDirectories();
        }

        private void parseFonts() throws FOPException {
            for (Configuration fontCfg : this.fontInfoCfg.getChildren("font")) {
                String embed = fontCfg.getAttribute("embed-url", null);
                if (embed == null) {
                    LogUtil.handleError((Log)log, (String)"Font configuration without embed-url attribute", (boolean)this.strict);
                    continue;
                }
                Font font = new Font(fontCfg.getAttribute("metrics-url", null), embed, fontCfg.getAttribute("embed-url-afm", null), fontCfg.getAttribute("embed-url-pfm", null), fontCfg.getAttribute("sub-font", null), fontCfg.getAttributeAsBoolean("kerning", true), fontCfg.getAttributeAsBoolean("advanced", true), fontCfg.getAttribute("encoding-mode", EncodingMode.AUTO.getName()), fontCfg.getAttribute("embedding-mode", EncodingMode.AUTO.getName()), fontCfg.getAttributeAsBoolean("simulate-style", false), fontCfg.getAttributeAsBoolean("embed-as-type1", false));
                this.instance.fonts.add(font);
                boolean hasTriplets = false;
                for (Configuration tripletCfg : fontCfg.getChildren("font-triplet")) {
                    FontTriplet fontTriplet = this.getFontTriplet(tripletCfg, this.strict);
                    font.tripletList.add(fontTriplet);
                    hasTriplets = true;
                }
                if (!hasTriplets) {
                    LogUtil.handleError((Log)log, (String)"font without font-triplet", (boolean)this.strict);
                }
                try {
                    if (this.eventAdapter != null && font.getSimulateStyle() && !this.config.getAttribute("mime").equals("application/pdf")) {
                        this.eventAdapter.fontFeatureNotSuppprted(this, "simulate-style", "PDF");
                    }
                    if (this.eventAdapter == null || !font.getEmbedAsType1() || this.config.getAttribute("mime").equals("application/postscript")) continue;
                    throw new FOPException("The embed-as-type1 attribute is only supported in postscript");
                }
                catch (ConfigurationException ex) {
                    LogUtil.handleException((Log)log, (Exception)ex, (boolean)true);
                }
            }
        }

        private void parseReferencedFonts() throws FOPException {
            Configuration referencedFontsCfg = this.fontInfoCfg.getChild("referenced-fonts", false);
            if (referencedFontsCfg != null) {
                for (Configuration match : referencedFontsCfg.getChildren("match")) {
                    try {
                        this.instance.referencedFontFamilies.add(match.getAttribute("font-family"));
                    }
                    catch (ConfigurationException ce) {
                        LogUtil.handleException((Log)log, (Exception)ce, (boolean)this.strict);
                    }
                }
            }
        }

        private void parseDirectories() throws FOPException {
            for (Configuration directoriesCfg : this.fontInfoCfg.getChildren("directory")) {
                String directory;
                boolean recursive = directoriesCfg.getAttributeAsBoolean("recursive", false);
                try {
                    directory = directoriesCfg.getValue();
                }
                catch (ConfigurationException e) {
                    LogUtil.handleException((Log)log, (Exception)e, (boolean)this.strict);
                    continue;
                }
                if (directory == null) {
                    LogUtil.handleException((Log)log, (Exception)new FOPException("directory defined without value"), (boolean)this.strict);
                    continue;
                }
                this.instance.directories.add(new Directory(directory, recursive));
            }
        }

        private FontTriplet getFontTriplet(Configuration tripletCfg, boolean strict) throws FOPException {
            try {
                String name = tripletCfg.getAttribute("name");
                if (name == null) {
                    LogUtil.handleError((Log)log, (String)"font-triplet without name", (boolean)strict);
                    return null;
                }
                String weightStr = tripletCfg.getAttribute("weight");
                if (weightStr == null) {
                    LogUtil.handleError((Log)log, (String)"font-triplet without weight", (boolean)strict);
                    return null;
                }
                int weight = FontUtil.parseCSS2FontWeight(FontUtil.stripWhiteSpace(weightStr));
                String style = tripletCfg.getAttribute("style");
                if (style == null) {
                    LogUtil.handleError((Log)log, (String)"font-triplet without style", (boolean)strict);
                    return null;
                }
                style = FontUtil.stripWhiteSpace(style);
                return FontInfo.createFontKey(name, style, weight);
            }
            catch (ConfigurationException e) {
                LogUtil.handleException((Log)log, (Exception)e, (boolean)strict);
                return null;
            }
        }
    }
}

