/*SIE-SVG without Plugin under LGPL2.1 & GPL2.0 & Mozilla Public License
 *http://sie.sourceforge.jp/
 *Usage: <script defer="defer" type="text/javascript" src="sie.js"></script>
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla SVG Cairo Renderer project.
 *
 * The Initial Developer of the Original Code is IBM Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Parts of this file contain code derived from the following files(s)
 * of the Mozilla SVG project (these parts are Copyright (C) by their
 * respective copyright-holders):
 *    layout/svg/renderer/src/libart/nsSVGLibartBPathBuilder.cpp
 *
 * Contributor(s):DHRNAME revulo bellbind
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */
if(!Object._create){Object._create=function(b){var c=function(){};c.prototype=b.prototype;b=void 0;return new c}}function DOMException(c){Error.apply(this,arguments);this.code=c;var b=["","Index Size Error","DOMString Size Error","Hierarchy Request Error","Wrong　Document　Error","Invalid　Character　Error","No Data Allowed　Error","No Modification Allowed Error","Not Found Error","Not Supported　Error","Inuse　Attribute　Error","Invalid State　Error","Syntax Error","Invalid Modification　Error","Namespace Error","Invalid Access Error"];this.message=b[c]}(function(b){b.prototype=new Error()})(DOMException);DOMImplementation={hasFeature:function(c,b){switch(c){case"CORE":case"XML":case"Events":case"StyleSheets":case"org.w3c.svg.static":case"org.w3c.dom.svg.static":return true;default:if(b==="2.0"){return true}else{return false}}},createDocumentType:function(d,e,b){var c=new Node();c.publicId=e;c.systemId=b;return c},createDocument:function(d,g,b){try{var c;if(d&&DOMImplementation[d]&&DOMImplementation[d].Document){c=new (DOMImplementation[d].Document);this._doc_&&(c._document_=this._doc_)}else{c=new Document()}c.implementation=this;c.doctype=b||null;c.documentElement=c.createElementNS(d,g);return c}catch(f){}},"http://www.w3.org/2000/xmlns":{}};function Node(){this.childNodes=[];this._capter=[]}Node.prototype={tar:null,firstChild:null,previousSibling:null,nextSibling:null,attributes:null,namespaceURI:null,localName:null,lastChild:null,prefix:null,ownerDocument:null,parentNode:null,replaceChild:function(b,d){this.insertBefore(b,d);var c=this.removeChild(d);return c},appendChild:function(b){this.insertBefore(b,null);return b},hasChildNodes:function(){if(this.childNodes.length>0){return true}else{return false}},cloneNode:function(b){var c;if(this.hasOwnProperty("ownerDocument")){c=this.ownerDocument.importNode(this,b)}else{c=new Node()}return c},normalize:function(){var g=this.childNodes;try{for(var c=g.length-1;c<0;--c){var f=g[c],b=f.nextSibling;if(b){if(f.nodeType===3&&b.nodeType===3){f.appendData(b.data);f.legnth=f.data.length;this.removeChild(b)}else{f.normalize()}}else{f.normalize()}}}catch(d){}},isSupported:function(c,b){return(this.ownerDocument.implementation.hasFeature(c+"",b+""))},hasAttributes:function(){if(this.attributes.length>0){return true}else{return false}}};Array.prototype.item=function(b){if(!this[b]){return null}return(this[b])};function NamedNodeMap(){}Array.prototype._copyNode=function __nnmp_c(e,c){for(var d=0,b=e.length;d<b;d++){this[d]=e[d].cloneNode(c)}};NamedNodeMap.prototype={length:0,getNamedItem:function(b){},setNamedItem:function(b){},removeNamedItem:function(b){},item:function(b){return this[b]},getNamedItemNS:function(e,d){var c;for(var f=0,b=this.length;f<b;f++){c=this[f];if(c.namespaceURI===e&&c.localName===d){this._num=f;return c}}f=c=void 0;return null},setNamedItemNS:function(b){var c=this.getNamedItemNS(b.namespaceURI,b.localName),d;if(c){d=this[this._num];this[this._num]=b;b=c=void 0;return d}else{if(b.ownerElement!==void 0){throw (new DOMException(10))}this[this.length]=b;this.length+=1;b=void 0;return null}},removeNamedItemNS:function(c,b){var d=this.getNamedItemNS(c,b);if(!d){throw (new DOMException(8))}else{var e=this[this._num];delete (this[this._num]);this.length-=1;tgas=void 0;return e}},_copyNode:Array.prototype._copyNode};function CharacterData(){}CharacterData.prototype=Object._create(Node);(function(b){b.length=0;b.childNodes=[];b._capter=[];b.substringData=function(e,d){if(e<0||d<0||e>this.length){throw (new DOMException(1))}if(e+d>this.length){d=this.length-e}var c=this.data.substr(e,d);return c};b.replaceData=function(e,d,c){if(e<0||d<0||e>this.length){throw (new DOMException(1))}this.deleteData(e,d);this.insertData(e,c)};b=void 0})(CharacterData.prototype);function Attr(){}Attr.prototype=Object._create(Node);(function(b){b.nodeType=2;b.nodeValue=null;b.childNodes=[];b._capter=[];b=void 0})(Attr.prototype);function Element(){Node.apply(this);this.attributes=new NamedNodeMap()}Element.prototype=Object._create(Node);(function(b){b.nodeType=1;b.nodeValue=null;b.getAttribute=function(c){return(this.getAttributeNS(null,c))};b.setAttribute=function(c,d){this.setAttributeNS(null,c,d)};b.removeAttribute=function(c){this.removeAttributeNS(null,c)};b.getAttributeNode=function(c){};b.setAttributeNode=function(c){};b.removeAttributeNode=function(c){var d=this.attributes.removeNamedItemNS(c.namespaceURI,c.localName);return d};b.getElementsByTagName=function(c){};b.getAttributeNS=function(d,c){var e=this.getAttributeNodeNS(d,c);if(!e){return null}else{return(e.nodeValue)}};b.setAttributeNS=function(c,f,d){var e=this.ownerDocument.createAttributeNS(c,f);e.nodeValue=d+"";e.value=d+"";this.setAttributeNodeNS(e)};b.removeAttributeNS=function(d,c){};b.getAttributeNodeNS=function(d,c){var e=this.attributes.getNamedItemNS(d,c);return e};b.getElementsByTagNameNS=function(f,k){var v=[],g=0;var c=this.childNodes;for(var o=0,e=c.length;o<e;o++){var p=c[o];if(p.nodeType===1){var u=(f==="*")?p.namespaceURI:f;var t=(k==="*")?p.localName:k;if((p.namespaceURI===u)&&(p.localName===t)){v[g++]=p}var r=p.getElementsByTagNameNS(f,k);if(r){for(var l=0,q=r.length;l<q;++l){v[g++]=r[l]}}u=t=r=void 0}}c=o=l=e=q=void 0;if(g===0){g=void 0;return null}g=void 0;return v};b.hasAttribute=function(c){return(this.hasAttributeNS(null,c))};b.hasAttributeNS=function(d,c){if(this.getAttributeNodeNS(d,c)){return true}else{return false}};b=void 0})(Element.prototype);function Text(){}Text.prototype=Object._create(CharacterData);(function(b){b.nodeType=3;b.nodeName="#text";b.splitText=function(f){var e=this.substringData(0,f-1);this.replaceData(0,this.length-1,e);var c="";if(this.length!==f){c=this.substringData(f,this.length-1)}var d=this.ownerDocument.createTextNode(c);if(this.parentNode){this.parentNode.insertBefore(d,this.nextSibling)}return d};b=void 0})(Text.prototype);function Comment(){}Comment.prototype=Object._create(CharacterData);Comment.prototype.nodeType=8;Comment.prototype.nodeName="#comment";function CDATASection(){this.nodeType=4;this.nodeName="#cdata-section"}CDATASection.prototype=Object._create(Text);function DocumentType(){Node.apply(this);this.name="";this.entities=new NamedNodeMap();this.notations=new NamedNodeMap();this.publicId="";this.systemId="";this.internalSubset="";this.nodeValue=null;this.nodeType=10}DocumentType.prototype=Object._create(Node);function Notation(){Node.apply(this);this.publicId=this.systemId=this.nodeValue=null;this.nodeType=12}Notation.prototype=Object._create(Node);function Entity(){Node.apply(this);this.publicId=this.systemId=this.notationName=null;this.nodeValue=null;this.nodeType=6}Entity.prototype=Object._create(Node);function EntityReference(){Node.apply(this);this.nodeValue=null;this.nodeType=5}EntityReference.prototype=Object._create(Node);function ProcessingInstruction(){Node.apply(this);this.nodeType=7}ProcessingInstruction.prototype=Object._create(Node);function DocumentFragment(){this.nodeName="#document-fragment";this.nodeValue=null;this.nodeType=11}DocumentFragment.prototype=Object._create(Node);function Document(){Node.apply(this);this.nodeName="#document";this.nodeValue=null;this.nodeType=9;this._id={}}Document.prototype=Object._create(Node);(function(d,c,b,f,e){d.createElement=function(g){};d.createDocumentFragment=function(){var g=new DocumentFragment();g.ownerDocument=this;return g};d.createTextNode=function(i){var g=new c();g.data=g.nodeValue=i+"";g.length=i.length;g.ownerDocument=this;return g};d.createComment=function(i){var g=new e();g.data=g.nodeValue=i;g.length=i.length;g.ownerDocument=this;return g};d.createCDATASection=function(i){var g=new CDATASection();g.data=g.nodeValue=i;g.length=i.length;g.ownerDocument=this;return g};d.createProcessingInstruction=function(j,i){var g=new ProcessingInstruction();g.target=g.nodeName=j;g.data=g.nodeValue=i;g.ownerDocument=this;return g};d.createAttribute=function(g){};d.createEntityReference=function(g){var i=new EntityReference();i.nodeName=g;i.ownerDocument=this;return i};d.getElementsByTagName=function(g){return this.getElementsByTagNameNS("*",g)};d.importNode=function(t,u){var z,j=t.nodeType,p,r,v,l,k,g;if(j===2){k=t.namespaceURI;k=(k==="")?null:k;z=this.createAttributeNS(k,t.nodeName);z.nodeValue=t.nodeValue}else{if(j===3){z=this.createTextNode(t.data)}else{if(j===1){z=this.createElementNS(t.namespaceURI,t.nodeName);p=t.attributes;for(var o=0;p[o];++o){g=p[o];k=g.namespaceURI;k=(k==="")?null:k;r=this.createAttributeNS(k,g.nodeName);r.nodeValue=g.nodeValue;z.setAttributeNodeNS(r)}if(u){v=t.firstChild;while(v){l=this.importNode(v,true);z.appendChild(l);v=v.nextSibling}}o=void 0}else{if(j===8){z=this.createComment(t.data)}else{if(j===11){z=this.createDocumentFragment();if(u){g=t.childNodes;for(var o=0,q=g.length;o<q;o++){l=this.importNode(g[o],true);z.appendChild(l)}}o=q=void 0}else{if(j===4){z=this.createCDATASection(t.data)}else{if(j===5){z=this.createEntityReference(t.nodeName);if(u){v=t.firstChild;while(v){l=this.importNode(v,true);z.appendChild(l);v=v.nextSibling}}}else{if(j===6){z=new Entity();z.publicId=t.publicId;z.systemId=t.systemId;z.notationName=t.notationName}else{if(j===7){z=this.createProcessingInstruction(t.nodeName,t.nodeValue)}else{if(j===12){z=new Notation();z.publicId=t.publicId;z.systemId=t.systemId}else{throw (new DOMException(9))}}}}}}}}}}t=u=j=p=r=v=l=k=g=void 0;return z};d.createElementNS=function(i,q){var l,k=null,g=null;if(!q){throw (new DOMException(5))}if(q.indexOf(":")!==-1){var o=q.split(":");k=o[0];g=o[1]}else{g=q}var r=false;if(i){var j=this.implementation;if(!!j[i]){if(!!j[i][g]){r=true}}}if(r){l=new (j[i][g])(this._document_)}else{l=new b()}l.namespaceURI=i;l.nodeName=l.tagName=q;l.localName=g;l.prefix=k;l.ownerDocument=this;j=i=q=k=g=r=void 0;return l};d._document_=document;d.createAttributeNS=function(i,k){var g=new f(),j;g.namespaceURI=i;g.nodeName=g.name=k;if(i&&(k.indexOf(":")!==-1)){j=k.split(":");g.prefix=j[0];g.localName=j[1]}else{g.prefix=null;g.localName=k}g.ownerDocument=this;j=k=void 0;return g};d.getElementsByTagNameNS=function(i,g){if((typeof i!=="string")||(typeof g!=="string")){throw new Error("Argument not string")}var k=this.documentElement,j=k.getElementsByTagNameNS(i,g);if(((g===k.localName)||(g==="*"))&&((i===k.namespaceURI)||(i==="*"))){if(j){j.unshift(k)}else{j=[k]}}k=void 0;return j};d.getElementById=function(g){g+="";var i=!!this._id[g]?this._id[g]:null;if(i&&(i.id!==g)){i=null}return i};d=void 0;Document._destroy=function(){c=b=f=e=void 0}})(Document.prototype,Text,Element,Attr,Comment);function EventException(){DOMException.call(this);if(this.code===0){this.message="Uuspecified Event Type Error"}}EventException.prototype=Object._create(DOMException);Node.prototype.addEventListener=function(e,g,b){this.removeEventListener(e,g,b);var d=new EventListener(b,e,g),c=e.charAt(0),f;this._capter.push(d);if((c!=="D")&&(c!=="S")&&(e!=="beginEvent")&&(e!=="endEvent")&&(e!=="repeatEvent")){f=this;f._tar&&f._tar.attachEvent("on"+e,(function(j,i){return function(){var k=j.ownerDocument.createEvent("MouseEvents");k.initMouseEvent(i,true,true,j.ownerDocument.defaultView,0);j.dispatchEvent(k);j.ownerDocument._window.event.cancelBubble=true;k=void 0}})(f,e))}e=g=b=d=c=f=void 0};Node.prototype.removeEventListener=function(e,g,b){var f=this._capter;for(var d=0,c=f.length;d<c;d++){if(f[d]._listener===g){f[d]=void 0}}d=c=f=void 0};Node.prototype.dispatchEvent=function(q){if(!q.type){throw new EventException(0)}var d=this,e=d.ownerDocument,k=q.timeStamp,s=q.type,t=q.bubbles,f,p,o=1,c="1",r="3",i;if(!e._isLoaded){if(!e._limit_time_){e._limit_time_=k}else{if((k-e._limit_time_)>1000){f=e.implementation._buffer_||[];p=f.length;f[p]=this;f[p+1]=q;e.implementation._buffer_=f;d=e=k=s=t=f=p=o=void 0;return true}}}q.target=d;q.eventPhase=1;e[r]=null;while(d.parentNode){d.parentNode[c]=d;d[r]=d.parentNode;d=d.parentNode}e[c]=d;d[r]=e;d=this;while(e){q.currentTarget=e;if(e===d){o=2}q.eventPhase=o;i=e._capter;for(var g=0,b=i.length;g<b;++g){if(i[g]&&(s===i[g]._type)){i[g].handleEvent(q)}}if(q._stop){break}if(e===d){if(!t){break}o=3}e=e[o]}var l=q._default;q=d=i=n=e=o=f=g=b=s=k=t=c=r=void 0;return l};function EventListener(b,c,d){this._cap=b;this._type=c;this._listener=d}EventListener.prototype={handleEvent:function(b){try{var f=b.eventPhase,c=this._cap;if(f===1){c=c?false:true}if(!c&&(b.type===this._type)){this._listener(b)}b=f=c=void 0}catch(d){}}};function Event(){}Event.prototype={timeStamp:0,type:null,target:null,currentTarget:null,eventPhase:1,bubbles:false,cancelable:false,_stop:false,_default:true,stopPropagation:function(){this._stop=true},preventDefault:function(){if(this.cancelable){this._default=false;this.target.ownerDocument._window.event.returnValue=false}},initEvent:function(b,d,c){this.type=b;this.bubbles=d;this.cancelable=c;b=d=c=void 0}};Document.prototype.createEvent=function(d){var c,b=this._cevent[d];if(b){c=new b()}else{if(d==="SVGEvents"){c=new SVGEvent()}else{if(d==="TimeEvents"){c=new TimeEvent()}else{c=new Event()}}}c.type=d;c.timeStamp=+(new Date());b=d=void 0;return c};function UIEvent(){this.view;this.detail=0}UIEvent.prototype=Object._create(Event);UIEvent.prototype.initUIEvent=function(c,f,e,d,b){this.initEvent(c,f,e);this.detail=b;this.view=d};function MouseEvent(b){UIEvent.apply(this,arguments);this.screenX;this.screenY;this.clientX=this.clientY=0;this.ctrlKey=this.shiftKey=this.altKey=this.metaKey=false;this.button;this.relatedTarget}MouseEvent.prototype=Object._create(UIEvent);MouseEvent.prototype.initMouseEvent=function(r,e,p,f,j,o,g,b,l,i,s,d,q,k,c){this.initUIEvent(r,e,p,f,j);this.screenX=o;this.screenY=g;this.clientX=b;this.clientY=l;this.ctrlKey=i;this.shiftKey=d;this.altKey=s;this.metaKey=q;this.button=k;this.relatedTarget=c};function MutationEvent(){}MutationEvent.prototype=Object._create(Event);(function(){this.initMutationEvent=function(b,g,f,c,j,d,e,i){this.initEvent(b,g,f);this.relatedNode=c;this.prevValue=j;this.newValue=d;this.attrName=e;this.attrChange=i;b=g=f=c=j=d=e=i=void 0};this.relatedNode=null;this.prevValue=this.newValue=this.attrName=null;this.attrChange=2}).apply(MutationEvent.prototype);Element.prototype.setAttributeNodeNS=function(d){if(d.ownerDocument!==this.ownerDocument){throw (new DOMException(4))}var c=this.attributes.setNamedItemNS(d);d.ownerElement=this;if((d.localName==="id")&&!this.ownerDocument._id[d.nodeValue]){this.ownerDocument._id[d.nodeValue]=this}var b=this.ownerDocument.createEvent("MutationEvents");if(!c){b.initEvent("DOMAttrModified",true,false);b.relatedNode=d;b.newValue=d.nodeValue;b.attrName=d.nodeName}else{b.initMutationEvent("DOMAttrModified",true,false,d,c.nodeValue,d.nodeValue,d.nodeName,1)}this.dispatchEvent(b);b=void 0;return c};Node.prototype.insertBefore=function(c,d){var r=this.parentNode,k,u,e=this,f=0,v,z,q,p;while(r){if(r===c){throw (new DOMException(3))}r=r.parentNode}if(this.ownerDocument!==c.ownerDocument){throw (new DOMException(4))}if(c.parentNode){c.parentNode.removeChild(c)}if(!d){if(!this.firstChild){this.firstChild=c}if(this.lastChild){c.previousSibling=this.lastChild;this.lastChild.nextSibling=c}this.lastChild=c;this.childNodes.push(c);c.nextSibling=null}else{if(d.parentNode!==this){throw (new DOMException(8))}v=this.firstChild;if(v===d){this.firstChild=c}while(v){if(v===d){this.childNodes.splice(f,1,c,d);break}++f;v=v.nextSibling}k=d.previousSibling;if(k){k.nextSibling=c}d.previousSibling=c;c.previousSibling=k;c.nextSibling=d}c.parentNode=this;if((c.nodeType===5)||(c.nodeType===11)){var b=c.childNodes.concat([]);for(var g=0,o=b.length;g<o;g++){this.insertBefore(b[g],c)}b=void 0}u=this.ownerDocument.createEvent("MutationEvents");u.initMutationEvent("DOMNodeInserted",true,false,this,null,null,null,null);c.dispatchEvent(u);do{z=e;e=e.parentNode}while(e);if(z!==this.ownerDocument.documentElement){u=q=r=k=e=z=p=void 0;return c}u=this.ownerDocument.createEvent("MutationEvents");u.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);c.dispatchEvent(u);if(!c.hasChildNodes()){return c}if(c.getElementsByTagNameNS){q=c.getElementsByTagNameNS("*","*")}else{q=c.childNodes}if(q){for(var g=0,l=q.length;g<l;++g){p=q[g];p.dispatchEvent(u);p=null}}u=q=r=k=f=v=e=z=p=void 0;return c};Node.prototype.removeChild=function(l){if(!(l instanceof Node)){throw (new Error())}if(l.parentNode!==this){throw (new DOMException(8))}if(l.ownerDocument!==this.ownerDocument){throw (new Error())}var b=this.ownerDocument.createEvent("MutationEvents"),f;b.initMutationEvent("DOMNodeRemovedFromDocument",false,false,null,null,null,null,null);l.dispatchEvent(b);if(l.getElementsByTagNameNS){f=l.getElementsByTagNameNS("*","*")}else{f=l.childNodes}if(f){b.initMutationEvent("DOMNodeRemovedFromDocument",false,false,null,null,null,null,null);for(var e=0,k=f.length;e<k;++e){var g=f[e];b.target=g;g.dispatchEvent(b);g=void 0}}b.initMutationEvent("DOMNodeRemoved",true,false,this,null,null,null,null);l.dispatchEvent(b);b=f=void 0;l.parentNode=null;var d=this.firstChild,c=0;while(d){if(d===l){this.childNodes.splice(c,1);break}++c;d=d.nextSibling}if(this.firstChild===l){this.firstChild=l.nextSibling}if(this.lastChild===l){this.lastChild=l.previousSibling}l.previousSibling&&(l.previousSibling.nextSibling=l.nextSibling);l.nextSibling&&(l.nextSibling.previousSibling=l.previousSibling);l.nextSibling=l.previousSibling=null;d=c=void 0;return l};CharacterData.prototype.appendData=function(b){var d=this.data,c;this.data+=b;this.length=this.data.length;c=this.ownerDocument.createEvent("MutationEvents");c.initMutationEvent("DOMCharacterDataModified",true,false,null,d,this.data,null,null);this.parentNode.dispatchEvent(c);c=b=d=void 0};CharacterData.prototype.insertData=function(g,b){var d=this.data,f=this.substring(0,g-1),e=this.substring(g,this.length-g),c;this.data=f+this.data+e;this.length=this.data.length;c=this.ownerDocument.createEvent("MutationEvents");c.initMutationEvent("DOMCharacterDataModified",true,false,null,d,this.data,null,null);this.parentNode.dispatchEvent(c);c=b=d=f=e=void 0};CharacterData.prototype.deleteData=function(d,c){var b=this.data;pre=this.substring(0,d-1),next=this.substring(d+c,this.length-1),evt;if(d+c>this.length){next=""}this.data=pre+next;this.length=this.data.length;evt=this.ownerDocument.createEvent("MutationEvents");evt.initMutationEvent("DOMCharacterDataModified",true,false,null,b,this.data,null,null);this.parentNode.dispatchEvent(evt);evt=b=void 0};Document.prototype._cevent={MutationEvents:MutationEvent,MouseEvents:MouseEvent,UIEvents:UIEvent};function StyleSheet(){this.type="text/css";this.disabled=false;this.ownerNode=null;this.parentStyleSheet=null;this.href=null;this.title="";this.media=new MediaList()}function MediaList(){this.mediaText="";this.length=0}MediaList.prototype={item:function(b){return(this[b])},deleteMedium:function(b){for(var c=0,d=this.length;c<d;++c){if(this[c]===b){delete this[c];--this.length;return}}throw (new DOMException(DOMException.NOT_FOUND_ERR))},appendMedium:function(b){this[this.length]=b;++this.length}};function LinkStyle(){this.sheet=new StyleSheet()}function DocumentStyle(){this.styleSheets=[]}function CSSRule(){this.cssText="";this.parentStyleSheet;this.parentRule=null}function CSSStyleRule(){CSSRule.call(this);this.type=1;this.selectorText="";this.style=new CSSStyleDeclaration();this.style.parentRule=null}CSSStyleRule.prototype=Object._create(CSSRule);function CSSMediaRule(){CSSRule.call(this);this.type=4;this.media=new MediaList();this.cssRules=[]}CSSMediaRule.prototype=Object._create(CSSRule);CSSMediaRule.prototype.insertRule=function(c,b){this.cssRules.splice(b,c,1);this.media.appendMedium(c);return this};CSSMediaRule.prototype.deleteRule=function(b){};function CSSFontFaceRule(){CSSRule.call(this);this.type=5;this.style}CSSFontFaceRule.prototype=Object._create(CSSRule);function CSSPageRule(){CSSRule.call(this);this.type=6;this.selectorText="";this.style}CSSPageRule.prototype=Object._create(CSSRule);function CSSImportRule(){CSSRule.call(this);this.type=3;this.href="";this.media=new MediaList();this.styleSheet=null}CSSImportRule.prototype=Object._create(CSSRule);function CSSCharsetRule(){CSSRule.call(this);this.type=2;this.encoding=""}CSSCharsetRule.prototype=Object._create(CSSRule);function CSSUnknownRule(){CSSRule.call(this);this.type=0}CSSUnknownRule.prototype=Object._create(CSSRule);function CSSStyleDeclaration(){this._list=[];this._list._fontSize=this._list._opacity=null}CSSStyleDeclaration.prototype={cssText:"",length:0,parentRule:null,_urlreg:/url\(#([^)]+)/,getPropertyValue:function(c){var d=this.getPropertyCSSValue(c);if(d){var b=d.cssText;return(b.slice(b.indexOf(":")+1))}else{return""}},getPropertyCSSValue:function(d){var j=d,f,b;d+=":";if(d===":"){return null}for(var e=0,c=this._list,g=c.length;e<g;++e){f=c[e];b=f.cssText;if(b.indexOf(d)>-1){f._empercents=c._fontSize;e=c=g=b=j=d=void 0;return f}}e=c=g=j=d=void 0;return null},removeProperty:function(b){var c=this.getPropertyCSSValue(b);if(c){this._list.splice(c._num,1);--this.length}},getPropertyPriority:function(b){var c=this.getPropertyCSSValue(b);if(c){return(c._priority)}else{return""}},_isFillStroke:{fill:1,stroke:1},_isColor:{color:1},_isStop:{"stop-color":1},_isRS:{r:1,"#":1},setProperty:function(g,o,k){var e=g,c=null,b,j,l,d=null,f=null,q,p,i;if(!!this[g]){c=this.getPropertyCSSValue(g)}e+=":";e+=o;if(this._isFillStroke[g]){if(c){b=c}else{b=new SVGPaint()}j=0;l=o.charAt(0);if(this._isRS[l]||b._keywords[o]){j=1;f=o}else{if(o==="none"){j=101}else{if(this._urlreg.test(o)){j=107;d=RegExp.$1}else{if(o==="currentColor"){j=102}}}}b.setPaint(j,d,f,null);j=l=d=f=void 0}else{if(this._isStop[g]){if(c){b=c}else{b=new SVGColor()}if(o==="currentColor"){b.colorType=3}else{b.colorType=1}b.setRGBColor(o)}else{if(c){b=c}else{b=new CSSPrimitiveValue()}}}b._priority=k;b.cssText=e;if(!c){b._num=this._list.length;this._list[b._num]=b;this[g]=1;++this.length}if(o==="inherit"){b.cssValueType=0}else{if(g==="opacity"){this._list._opacity=+o}else{if(g==="font-size"){if(/(%|em|ex)/.test(o)){c="_"+RegExp.$1;b[c]=parseFloat(o)}else{this._em=this._ex=this["_%"]=null;this._list._fontSize=parseFloat(o)}}}}e=void 0},item:function(b){if(b>=this.length){var c=""}else{var c=this._list[b].cssText.substring(0,this._list[b].cssText.indexOf(":"))}return c}};function CSSValue(){}CSSValue.prototype={cssText:"",cssValueType:3,_isDefault:0};function CSSPrimitiveValue(){}(function(b){b.prototype=Object._create(CSSValue)})(CSSPrimitiveValue);(function(){this._n=[1,0.01,1,1,1,35.43307,3.543307,90,1.25,15,1,180/Math.PI,90/100,1,1000,1,1000,1];this.cssValueType=1;this.primitiveType=0;this._value=null;this._percent=0;this._empercent=0;this._em=this._ex=this["_%"]=null;this.setFloatValue=function(b,c){if((0>=b)&&(b>=19)){throw new DOMException(15)}this.primitiveType=b;this._value=c*this._n[b-1]};this._regd=/[\d\.]+/;this.getFloatValue=function(c){if((0>=c)&&(c>=19)){throw new DOMException(15)}if(this._value||(this._value===0)){return(this._value/this._n[c-1])}else{var b=this.cssText,f=b.slice(-1),e=0,d=+(b.match(this._regd));d=isNaN(d)?0:d;if(f>="0"&&f<="9"){e=1;if(c===1){c=b=f=e=void 0;return d}}else{if(f==="%"){d*=this._percent;e=2}else{if((f==="m")&&(b.charAt(b.length-2)==="e")){d*=this._empercent;e=3}else{if((f==="x")&&(b.charAt(b.length-2)==="e")){e=4}else{if((f==="x")&&(b.charAt(b.length-2)==="p")){e=5}else{if((f==="m")&&(b.charAt(b.length-2)==="c")){e=6}else{if((f==="m")&&(b.charAt(b.length-2)==="m")){e=7}else{if(f==="n"){e=8}else{if(f==="t"){e=9}else{if(f==="c"){e=10}}}}}}}}}}d=d*this._n[e-1]/this._n[c-1];b=f=e=c=void 0;return d}};this.setStringValue=function(c,b){if(18>=c&&c>=23){throw new DOMException(15)}this._value=b};this.getStringValue=function(b){if(18>=b&&b>=23){throw new DOMException(15)}return(this._value)};this.getCounterValue=function(){if(this.primitiveType!==23){throw new DOMException(15)}return(new Counter())};this.getRectValue=function(){if(this.primitiveType!==24){throw new DOMException(15)}return(new Rect())};this.getRGBColorValue=function(){if(this.primitiveType!==25){throw new DOMException(15)}var b=new RGBColor(),c=this.cssText,d=SVGColor.prototype._keywords[c];if(c.indexOf("%",5)>0){c=c.replace(/[\d.]+%/g,function(e){return Math.round((2.55*parseFloat(e)))})}else{if(c.indexOf("#")>-1){c=c.replace(/[\da-f][\da-f]/gi,function(e){return parseInt(e,16)})}}d=d||c.match(/\d+/g);b.red.setFloatValue(1,parseFloat(d[0]));b.green.setFloatValue(1,parseFloat(d[1]));b.blue.setFloatValue(1,parseFloat(d[2]));d=c=void 0;return(b)}}).apply(CSSPrimitiveValue.prototype);function CSSValueList(){this.cssValueType=2;this.length=0}CSSValueList.prototype=Object._create(CSSValue);CSSValueList.prototype.item=function(b){return(this[b])};function RGBColor(){var b=CSSPrimitiveValue;this.red=new b();this.green=new b();this.blue=new b();b=void 0;this.red.primitiveType=this.green.primitiveType=this.blue.primitiveType=1}function Rect(){var b=CSSPrimitiveValue;this.top=new b();this.right=new b();this.bottom=new b();this.left=new b();b=void 0}function Counter(){this.identifier=this.listStyle=this.separator=""}function ElementCSSInlineStyle(){var b=CSSStyleDeclaration;this.style=new b();this._attributeStyle=new b();b=void 0}var n="none",m="normal",a="auto",CSS2Properties={fill:"black",stroke:n,cursor:a,visibility:"visible",display:"inline-block",opacity:"1",fillOpacity:"1",strokeWidth:"1",strokeDasharray:n,strokeDashoffset:"0",strokeLinecap:"butt",strokeLinejoin:"miter",strokeMiterlimit:"4",strokeOpacity:"1",writingMode:"lr-tb",fontFamily:"serif",fontSize:"12",color:"black",fontSizeAdjust:n,fontStretch:m,fontStyle:m,fontVariant:m,fontWeight:m,font:"inline",stopColor:"black",stopOpacity:"1",textAnchor:"start",azimuth:"center",clip:a,direction:"ltr",letterSpacing:m,lineHeight:m,overflow:"visible",textAlign:"left",textDecoration:n,textIndent:"0",textShadow:n,textTransform:n,unicodeBidi:m,verticalAlign:"baseline",whiteSpace:m,wordSpacing:m,zIndex:a,mask:n,markerEnd:n,markerMid:n,markerStart:n,fillRule:"nonzero",enableBackground:"accumulate",filter:n,floodColor:"black",floodOpacity:"1",lightingColor:"white",pointerEvents:"visiblePainted",colorInterpolation:"sRGB",colorInterpolationFilters:"linearRGB",colorProfile:a,colorRendering:a,imageRendering:a,marker:"",shapeRendering:a,textRendering:a,alignmentBaseline:"",baselineShift:"baseline",dominantBaseline:a,glyphOrientationHorizontal:"0deg",glyphOrientationVertical:a,kerning:a};n=m=a=void 0;CSS2Properties.visibility._n=1;function CSSStyleSheet(){StyleSheet.apply(this);this.ownerRule=null;this.cssRules=[]}CSSStyleSheet.prototype=Object._create(StyleSheet);CSSStyleSheet.prototype.insertRule=function(g,e){var l=new CSSStyleRule(),b=l.style,j,f=g.match(/\{[\s\S]+\}/),c;l.parentStyleSheet=this;b.cssText=g;f=f.replace(/^[^a-z\-]+/,"").replace(/\:\s+/g,":").replace(/\s*;[^a-z\-]*/g,";");j=f.split(";");for(var d=0,k=j.length;d<k;++d){ai=j[d],c=ai.split(":");if(ai!==""){b.setProperty(c[0],c[1])}ai=c=void 0}j=f=b=void 0;this.cssRules.splice(e,l,1)};CSSStyleSheet.prototype.deleteRule=function(b){this.cssRules.splice(b,1)};Document.prototype.defaultView=new ViewCSS();function ViewCSS(){}ViewCSS.prototype.getComputedStyle=function(c,g){var e=new CSSStyleDeclaration(),d,f,b=1;e.getPropertyCSSValue=(function(i,j){return function(k){var q=i,p=null,r;while(q&&(!p||(p.cssValueType===0))){if(q._runtimeStyle&&q._runtimeStyle[k]){p=q._runtimeStyle.getPropertyCSSValue(k)}else{if(q.style&&q.style[k]){p=q.style.getPropertyCSSValue(k)}else{if(q._attributeStyle&&q._attributeStyle[k]){p=q._attributeStyle.getPropertyCSSValue(k)}else{if(q._rules){for(var o=0,l=q._rules.length;o<l;++o){q._rules[o].style[k]&&(p=q._rules[o].style.getPropertyCSSValue(k))}}}}}q=q.parentNode}if(!p||(p.cssValueType===0)){j&&(p=j[k])}if(p&&p.setRGBColor&&((p.paintType===102)||(p.colorType===3))){p.setRGBColor(this.getPropertyValue("color"))}else{if(p&&(p._em||p._ex||p["_%"])){q=i;r=1;while(q){if(q.style._list._fontSize){r=q.style._list._fontSize;break}q=q.parentNode}if(p._em){r*=p._em}else{if(p._ex){r*=p._ex*0.5}else{if(p["_%"]){r*=p["_%"]/100}}}p.cssText="font-size:"+r+"px"}}q=void 0;return p}})(c,this._defaultCSS);d=c;while(d){if(d.style){f=d.style._list._opacity||d._attributeStyle._list._opacity;b*=f||1}d=d.parentNode}e._list._opacity=b;d=pelt=b=f=void 0;e._document=c.ownerDocument;return e};Document.prototype.getOverrideStyle=function(c,f){var b=c;if(!!b._runtimeStyle){return(b._runtimeStyle)}else{var e=new CSSStyleDeclaration(),d=e.setProperty;b._runtimeStyle=e}e.setProperty=(function(g,i){return function(r,u,t){g.call(i,r,u,t);var p=c,j=p._tar,o=false,q=false;if((p.localName==="g")||(p.localName==="a")){var k=p.getElementsByTagNameNS("http://www.w3.org/2000/svg","*");if(k){for(var l=0,v=k.length;l<v;++l){var s=k[l];s.getScreenCTM&&NAIBU._setPaint(s,s.getScreenCTM());s=void 0}k=void 0}j=null}if(!j){return}p.getScreenCTM&&NAIBU._setPaint(p,p.getScreenCTM());j=p=u=void 0}})(d,e);return e};DOMImplementation.createCSSStyleSheet=function(j,g){var f=new CSSStyleSheet();f.title=j;var b=new MediaList();b.mediaText=g;if(g&&(g!=="")){var c=g.split(",");for(var e=0,d=c.length;e<d;++e){b.appendMedium(c[e])}}f.media=b;return f};function TimeEvent(){Event.apply(this);this.view;this.detail}TimeEvent.counstructor=Event;TimeEvent.prototype=Object._create(Event);TimeEvent.prototype.initTimeEvent=function(c,d,b){this.type=c;this.view=d;this.detail=b};var NAIBU={};function SVGException(b){this.code=b;if(this.code===0){this.message="SVG Wrong Type Error"}else{if(this.code===1){this.message="SVG Invalid Value Error"}else{if(this.code===2){this.message="SVG　Matrix Not Invertable"}}}}SVGException.prototype=Object._create(Error);function SVGElement(){Element.call(this);SVGStylable.call(this);this.transform=new SVGAnimatedTransformList();this.addEventListener("DOMAttrModified",function(evt){if(evt.eventPhase===3){return}var name=evt.attrName,tar=evt.target;if(!!CSS2Properties[name]||(name.indexOf("-")>-1)){tar._attributeStyle.setProperty(name,evt.newValue,"")}if(evt.relatedNode.localName==="id"){tar.id=evt.newValue}else{if((name==="transform")&&!!tar.transform){var tft=evt.newValue,degR=tar._degReg,coma=tft.match(tar._comaReg),list=tft.match(tar._strReg),a,b,c,d,e,f,lis,com,deg,rad,degli,s,cm,degz,etod=evt.target.ownerDocument.documentElement,ttb=tar.transform.baseVal;for(var j=0,cli=coma.length;j<cli;j++){s=etod.createSVGTransform();lis=list[j],com=coma[j];deg=lis.match(degR);degli=deg.length;if(degli===6){cm=s.matrix;cm.a=+(deg[0]);cm.b=+(deg[1]);cm.c=+(deg[2]);cm.d=+(deg[3]);cm.e=+(deg[4]);cm.f=+(deg[5])}else{if(degli===3){degz=+(deg[0]);s.setRotate(degz,+(deg[1]),+(deg[2]))}else{if(degli<=2){degz=+(deg[0]);if(com==="translate"){s.setTranslate(degz,+(deg[1]||0))}else{if(com==="scale"){s.setScale(degz,+(deg[1]||deg[0]))}else{if(com==="rotate"){s.setRotate(degz,0,0)}else{if(com==="skewX"){s.setSkewX(degz)}else{if(com==="skewY"){s.setSkewY(degz)}}}}}}}}ttb.appendItem(s)}tft=degR=coma=list=a=b=c=d=e=f=lis=com=deg=rad=degli=s=cm=degz=etod=ttb=void 0}else{if(name==="style"){var sc=evt.newValue,style=tar.style,a,ai,m;style.cssText=sc;if(sc!==""){sc=sc.replace(tar._shouReg,"").replace(tar._conReg,":").replace(tar._bouReg,";");a=sc.split(";");for(var i=0,ali=a.length;i<ali;++i){ai=a[i],m=ai.split(":");if(ai!==""){style.setProperty(m[0],m[1])}ai=m=void 0}}a=sc=style=void 0}else{if(name==="class"){tar.className=evt.newValue}else{if(name.indexOf("on")===0){NAIBU._temp_doc=tar.ownerDocument;NAIBU.eval("with(NAIBU._temp_doc){document._s = function(evt){"+evt.newValue+"}}");var v=name.slice(2);if(v==="load"){v="SVGLoad"}else{if(v==="unload"){v="SVGUnload"}else{if(v==="abort"){v="SVGAbort"}else{if(v==="error"){v="SVGError"}else{if(v==="resize"){v="SVGResize"}else{if(v==="scroll"){v="SVGScroll"}else{if(v==="zoom"){v="SVGZoom"}else{if(v==="begin"){v="beginEvent"}else{if(v==="end"){v="endEvent"}else{if(v==="repeat"){v="repeatEvent"}}}}}}}}}}tar.addEventListener(v,document._s,false)}else{if(evt.relatedNode.nodeName==="xml:base"){tar.xmlbase=evt.newValue}else{if(!!tar[name]&&(tar[name] instanceof SVGAnimatedLength)){var tea=tar[name],tod=tar.nearestViewportElement||tar.ownerDocument.documentElement,tvw=tod.viewport.width,tvh=tod.viewport.height,s,n=evt.newValue.slice(-2),m=n.charAt(1),type=1,_parseFloat=parseFloat;if(m>="0"&&m<="9"){}else{if(m==="%"){if(tar._x1width[name]){tea.baseVal._percent=tvw*0.01}else{if(tar._y1height[name]){tea.baseVal._percent=tvh*0.01}else{tea.baseVal._percent=Math.sqrt((tvw*tvw+tvh*tvh)/2)*0.01}}type=2}else{if(n==="em"){type=3}else{if(n==="ex"){type=4}else{if(n==="px"){type=5}else{if(n==="cm"){type=6}else{if(n==="mm"){type=7}else{if(n==="in"){type=8}else{if(n==="pt"){type=9}else{if(n==="pc"){type=10}}}}}}}}}}s=_parseFloat(evt.newValue);s=isNaN(s)?0:s;tea.baseVal.newValueSpecifiedUnits(type,s);tea=tod=tvw=tvh=n=type=_parseFloat=s=void 0}}}}}}}evt=_parseFloat=name=tar=null},false)}SVGElement.prototype=Object._create(Element);NAIBU.eval=function(c){var d=document,b=d.createElement("script");b.text=c;(d.documentElement||d.body).appendChild(b)};(function(){this._degReg=/[\-\d\.e]+/g;this._comaReg=/[A-Za-z]+(?=\s*\()/g;this._strReg=/\([^\)]+\)/g;this._syouReg=/^[^a-z\-]+/;this._conReg=/\:\s+/g;this._bouReg=/\s*;[^a-z\-]*/g;this._cacheMatrix=null;this._x1width={x:1,x1:1,x2:1,width:1,cx:1};this._y1height={y:1,y1:1,y2:1,height:1,cy:1};this.id=null;this.xmlbase=null;this.ownerSVGElement;this.viewportElement;this.nearestViewportElement=null;this.farthestViewportElement=null;this.getBBox=function(){var q=new SVGRect(),e=this._tar.path.value,c=this.ownerDocument.documentElement.viewport,b=c.width,l=c.height,p=0,j=0,o=e.match(/[0-9\-]+/g),g,f;for(var d=0,k=o.length;d<k;d+=2){g=+(o[d]),f=+(o[d+1]);b=b>g?g:b;l=l>f?f:l;p=p>g?p:g;j=j>f?j:f}q.x=b;q.y=l;q.width=p-b;q.height=j-l;g=f=e=o=b=l=p=j=c=void 0;return q};this.getCTM=function(){var c,b;if(!!this._cacheMatrix){c=this._cacheMatrix}else{b=this.transform.baseVal.consolidate();if(b){b=b.matrix}else{b=this.ownerDocument.documentElement.createSVGMatrix()}if(this.parentNode&&!!this.parentNode.getCTM){c=this.parentNode.getCTM().multiply(b)}else{c=b}b=void 0;this._cacheMatrix=c}return c};this.getScreenCTM=function(){if(!this.parentNode){return null}var b=this.nearestViewportElement||this.ownerDocument.documentElement;var c=b.getScreenCTM().multiply(this.getCTM());b=null;return c};this.getTransformToElement=function(b){var c=this.getScreenCTM().inverse().multiply(b.getScreenCTM());return c}}).apply(SVGElement.prototype);function SVGAnimatedBoolean(){this.animVal=this.baseVal=true}function SVGAnimatedString(){this.animVal=this.baseVal=""}function SVGStringList(){}SVGStringList.prototype=Object._create(Array);(function(){this.numberOfItems=0;this.clear=function(){for(var b=0,c=this.length;b<c;++b){delete this[b]}this.numberOfItems=0};this.initialize=function(b){this.clear();this[0]=b;this.numberOfItems=1;return b};this.getItem=function(b){if(b>=this.numberOfItems||b<0){throw (new DOMException(1))}else{return(this[b])}};this.insertItemBefore=function(c,b){if(b>=this.numberOfItems){this.appendItem(c)}else{this.splice(b,1,c,this.getItem[b]);++this.numberOfItems}return c};this.replaceItem=function(c,b){if(b>=this.numberOfItems||b<0){throw (new DOMException(1))}else{this.splice(b,1,c)}return c};this.removeItem=function(b){if(b>=this.numberOfItems||b<0){throw (new DOMException(1))}else{this.splice(b,1);--this.numberOfItems}return newItem};this.appendItem=function(b){this[this.numberOfItems]=b;++this.numberOfItems}}).apply(SVGStringList.prototype);function SVGAnimatedEnumeration(){this.baseVal=0;this.animVal=0}function SVGAnimatedInteger(){this.baseVal=0;this.animVal=0}function SVGNumber(){this.value=0}function SVGAnimatedNumber(){this.baseVal=this.animVal=0}function SVGNumberList(){}function SVGAnimatedNumberList(){this.animVal=this.baseVal=new SVGNumberList()}function SVGLength(){}SVGLength.prototype={unitType:0,value:0,valueInSpecifiedUnits:0,valueAsString:"0",_percent:0.01,_fontSize:12,newValueSpecifiedUnits:function(b,d){var e=1,c="";if(b===1){}else{if(b===5){c="px"}else{if(b===2){e=this._percent;c="%"}else{if(b===3){e=this._fontSize;c="em"}else{if(b===4){e=this._fontSize*0.5;c="ex"}else{if(b===6){e=35.43307;c="cm"}else{if(b===7){e=3.543307;c="mm"}else{if(b===8){e=90;c="in"}else{if(b===9){e=1.25;c="pt"}else{if(b===10){e=15;c="pc"}else{throw new DOMException(9)}}}}}}}}}}this.unitType=b;this.value=d*e;this.valueInSpecifiedUnits=d;this.valueAsString=d+c;d=b=e=c=void 0},convertToSpecifiedUnits:function(c){if(this.value===0){this.newValueSpecifiedUnits(c,0);return}var b=this.value;this.newValueSpecifiedUnits(c,this.valueInSpecifiedUnits);b=b/this.value*this.valueInSpecifiedUnits;this.newValueSpecifiedUnits(c,b)},_emToUnit:function(b){if((this.unitType===3)||(this.unitType===4)){this._fontSize=b;this.newValueSpecifiedUnits(this.unitType,this.valueInSpecifiedUnits)}}};function SVGAnimatedLength(){this.animVal;this.baseVal=new SVGLength();this.baseVal.unitType=1}function SVGLengthList(){}function SVGAnimatedLengthList(){this.animVal=this.baseVal=new SVGLengthList()}function SVGAngle(){}SVGAngle.prototype={unitType:0,value:0,valueInSpecifiedUnits:0,valueAsString:"0",newValueSpecifiedUnits:function(b,d){var e=1,c="";if(b===1){}else{if(b===2){c="deg"}else{if(b===3){e=Math.PI/180;c="rad"}else{if(b===4){e=9/10;c="grad"}else{throw new DOMException(9)}}}}this.unitType=b;this.value=d*e;this.valueInSpecifiedUnits=d;this.valueAsString=d+c;e=c=void 0},convertToSpecifiedUnits:function(c){if(this.value===0){this.newValueSpecifiedUnits(c,0);return}var b=this.value;this.newValueSpecifiedUnits(c,this.valueInSpecifiedUnits);b=b/this.value*this.valueInSpecifiedUnits;this.newValueSpecifiedUnits(c,b)}};function SVGAnimatedAngle(){this.baseVal=new SVGAngle();this.animVal=this.baseVal}function SVGColor(){CSSValue.apply(this);this.rgbColor=new RGBColor()}SVGColor.prototype=Object._create(CSSValue);(function(){this.colorType=0;this.iccColor=null;this._regD=/\d+/g;this._regDP=/[\d.]+%/g;this._exceptionsvg=1;this.setRGBColor=function(j){var e,d,i,f,c;if(!j||(typeof j!=="string")){throw new SVGException(this._exceptionsvg)}e=this._keywords[j];if(e){}else{if(j.indexOf("%",5)>0){j=j.replace(this._regDP,function(b){return Math.round((2.55*parseFloat(b)))});e=j.match(this._regD)}else{if(j.indexOf("#")===0){e=[];d=parseInt;if(j.length<5){i=j.charAt(1);f=j.charAt(2);c=j.charAt(3);j="#"+i+i+f+f+c+c}e[0]=d(j.slice(1,3),16)+"";e[1]=d(j.slice(3,5),16)+"";e[2]=d(j.slice(5,7),16)+"";i=f=c=void 0}else{e=j.match(this._regD);if(!e||(e.length<3)){j=void 0;throw new SVGException(this._exceptionsvg)}}}}j=this.rgbColor;j.red.setFloatValue(1,e[0]);j.green.setFloatValue(1,e[1]);j.blue.setFloatValue(1,e[2]);j=e=d=void 0};this.setColor=function(b,c,d){this.colorType=b;if((b===1)&&d){throw new SVGException(this._exceptionsvg)}else{if(b===1){this.setRGBColor(c)}else{if(c&&(b===3)){this.setRGBColor(c)}else{if((b===0)&&(c||d)){throw new SVGException(this._exceptionsvg)}else{if((b===2)&&(c||!d)){throw new SVGException(this._exceptionsvg)}}}}}b=c=void 0};this._keywords={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],grey:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagree:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}}).apply(SVGColor.prototype);function SVGRect(){this.x=0;this.y=0;this.width=0;this.height=0}function SVGAnimatedRect(){this.animVal=this.baseVal=new SVGRect()}function SVGStylable(){this.className=new SVGAnimatedString();this.style=new CSSStyleDeclaration();this._attributeStyle=new CSSStyleDeclaration()}SVGElement.prototype.getPresentationAttribute=function(b){var c=this._attributeStyle.getPropertyCSSValue(b);if(c){return c}else{return null}};function SVGURIReference(){this.href=new SVGAnimatedString();this._instance=null;this._text="";this.addEventListener("DOMAttrModified",function(b){if((b.relatedNode.namespaceURI==="http://www.w3.org/1999/xlink")&&(b.attrName==="xlink:href")){b.target.href.baseVal=b.newValue;b.target.ownerDocument.documentElement._svgload_limited++}b=void 0},false);this.addEventListener("DOMNodeInserted",function(c){var b=c.target;if(c.eventPhase===3){return}b.addEventListener("DOMNodeInsertedIntoDocument",function(l){var s=l.target,g=location.href,t=s.href.baseVal,B=s.ownerDocument,d=B.URL,f=/\.+\//g,r=/\/[^\/]+?(\/[^\/]*?)$/,o,v,e,A,z,i,C,p,q,k,u,j;if(t!==""){e=s.xmlbase;if(!e){A=s.parentNode;z=null;while(!z&&A){z=A.xmlbase;A=A.parentNode}e=z}o=function(D,E){if(t.indexOf(":")>-1){i=t}else{if(D.indexOf(":")>-1){E=D}else{f.lastIndex=0;while(f.exec(D)){E=E.replace(r,"$1")}E=E.replace(/\/[^\/]+?$/,"/");E=E+D.replace(f,"")}}return E};g=o(d,g);if(e){g=o(e,g)}if(t.indexOf("#")===0){i=t}else{if(!i){g=g.replace(/\/[^\/]+?$/,"/");f.lastIndex=0;while(f.exec(t)){g=g.replace(r,"$1")}i=g+t.replace(f,"")}}v=s.getAttributeNS("http://www.w3.org/1999/xlink","show")||"embed";if(v==="replace"){s._tar.setAttribute("href",i)}else{if(v==="new"){s._tar.setAttribute("target","_blank");s._tar.setAttribute("href",i)}else{if(v==="embed"){C=NAIBU.xmlhttp;p=i.indexOf("#");if(p>-1){q=i.slice(p+1);i=i.replace(/#.+$/,"")}else{q=null}if(t.indexOf("#")===0){k=B.getElementById(q);s._instance=k;j=SVGURIReference;SVGURIReference=function(){};u=B.createEvent("SVGEvents");u.initEvent("S_Load",false,false);s.dispatchEvent(u);SVGURIReference=j;s=C=void 0}else{if(i.indexOf("data:")>-1){s._tar.src=i;s=C=void 0}else{if((i.indexOf("http:")>-1)){if((s.localName==="image")&&(i.indexOf(".svg")===-1)){s._tar.src=i}else{s.ownerDocument.documentElement._svgload_limited++;C.open("GET",i,true);C.setRequestHeader("X-Requested-With","XMLHttpRequest");C.onreadystatechange=function(){if((C.readyState===4)&&(C.status===200)){var D=C.getResponseHeader("Content-Type")||"text",H,J,F,E,G,I;if((D.indexOf("text")>-1)||(D.indexOf("xml")>-1)||(D.indexOf("script")>-1)){if(s.localName!=="script"&&s.localName!=="style"){H=new ActiveXObject("MSXML2.DomDocument");J=C.responseText.replace(/!DOCTYPE/,"!--").replace(/(dtd">|\]>)/,"-->");G=NAIBU.doc;G.async=G.validateOnParse=G.resolveExternals=G.preserveWhiteSpace=false;H.loadXML(J);F=H.documentElement;I=SVGURIReference;SVGURIReference=function(){};s._instance=s.ownerDocument.importNode(F,true);SVGURIReference=I;if(q){s._instance=s._instance.ownerDocument.getElementById(q)}}else{s._text=C.responseText}}else{if(!!s._tar){s._tar.src=i}}E=s.ownerDocument.createEvent("SVGEvents");E.initEvent("S_Load",false,false);s.dispatchEvent(E);s.ownerDocument.documentElement._svgload_limited--;if(s.ownerDocument.documentElement._svgload_limited<0){E=s.ownerDocument.createEvent("SVGEvents");E.initEvent("SVGLoad",false,false);s.ownerDocument.documentElement.dispatchEvent(E)}s=D=H=J=E=I=G=void 0;C.onreadystatechange=NAIBU.emptyFunction;C=void 0}};C.send(null)}}}}}}}s.ownerDocument.documentElement._svgload_limited--}l=g=t=e=o=A=d=z=f=i=p=q=B=k=u=v=j=void 0},false);b=c=void 0},false)}function SVGCSSRule(){CSSRule.apply(this);this.COLOR_PROFILE_RULE=7}SVGCSSRule.prototype=Object._create(CSSRule);function SVGDocument(){Document.apply(this);DocumentStyle.apply(this);this.title="";this.referrer=document.referrer;this.domain=document.domain;this.URL=document.location;this.rootElement}SVGDocument.prototype=Object._create(Document);SVGDocument.prototype._domnodeEvent=function(){var b=this.createEvent("MutationEvents");b.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);return b};function SVGSVGElement(c){SVGElement.apply(this,arguments);c&&(this._tar=c.createElement("v:group"));c=void 0;this._svgload_limited=0;var b=SVGAnimatedLength;this.x=new b();this.y=new b();this.width=new b();this.height=new b();b=void 0;this.contentScriptType="application/ecmascript";this.contentStyleType="text/css";this.viewport=this.createSVGRect();this.useCurrentView=false;this.currentView=new SVGViewSpec(this);this.currentScale=1;this.currentTranslate=this.createSVGPoint();this.viewBox=this.currentView.viewBox;this.preserveAspectRatio=this.currentView.preserveAspectRatio;this.zoomAndPan=1;this._tx=0;this._ty=0;this._currentTime=0;this.addEventListener("DOMAttrModified",function(o){if(o.eventPhase===3){return}var g=o.target,e=o.attrName,f,l,i,j,k,d;if(e==="viewBox"){g._cacheScreenCTM=null;f=g.viewBox.baseVal;l=o.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/);f.x=parseFloat(l[0]);f.y=parseFloat(l[1]);f.width=parseFloat(l[2]);f.height=parseFloat(l[3]);g.viewBox.baseVal._isUsed=1}else{if(e==="preserveAspectRatio"){g._cacheScreenCTM=null;i=o.newValue;j=g.preserveAspectRatio.baseVal;k=1;d=0;if(!!i.match(/x(Min|Mid|Max)Y(Min|Mid|Max)(?:\s+(meet|slice))?/)){switch(RegExp.$1){case"Min":k+=1;break;case"Mid":k+=2;break;case"Max":k+=3;break}switch(RegExp.$2){case"Min":break;case"Mid":k+=3;break;case"Max":k+=6;break}if(RegExp.$3==="slice"){d=2}else{d=1}}j.align=k;j.meetOrSlice=d}else{if(e==="width"){g.viewport.width=g.width.baseVal.value}else{if(e==="height"){g.viewport.height=g.height.baseVal.value}}}}o=e=f=l=i=j=k=d=void 0},false);this.addEventListener("SVGLoad",function(d){d.target.addEventListener("DOMAttrModified",function(q){var l,r,f,o;if(q.eventPhase===3){l=q.target;if(l.parentNode){r=l.ownerDocument._domnodeEvent();r.target=l;r.eventPhase=2;f=l._capter;for(var g=0,e=f.length;g<e;++g){if(f[g]){f[g].handleEvent(r)}}if(((l.localName==="g")||(l.localName==="a"))&&(l.namespaceURI==="http://www.w3.org/2000/svg")){l._cacheMatrix=void 0;if(l.firstChild){o=l.getElementsByTagNameNS("http://www.w3.org/2000/svg","*");for(var k=0,p=o.length;k<p;++k){l=o[k];l._cacheMatrix=void 0;r=l.ownerDocument.createEvent("MutationEvents");r.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);r.target=l;r.eventPhase=2;f=l._capter;for(var g=0,e=f.length;g<e;++g){if(f[g]){f[g].handleEvent(r)}}}}}}}r=l=q=f=o=void 0},false);d.target.addEventListener("DOMNodeRemovedFromDocument",function(f){var e=f.target;e._tar&&e._tar.parentNode&&e._tar.parentNode.removeChild(e._tar);f=e=void 0},true);d=void 0},false)}SVGSVGElement.prototype=Object._create(SVGElement);(function(b){b.forceRedraw=function(){};b.getCurrentTime=function(){return(this._currentTime)};b.setCurrentTime=function(c){this._currentTime=c};b.createSVGNumber=function(){var c=new SVGNumber();c.value=0;return c};b.createSVGAngle=function(){var c=new SVGAngle();c.value=0;c.unitType=1;return c};b.createSVGLength=function(){var c=new SVGLength();c.unitType=1;return c};b.createSVGPoint=function(){return new SVGPoint()};b.createSVGMatrix=function(){return new SVGMatrix()};b.createSVGRect=function(){return new SVGRect()};b.createSVGTransform=function(){var c=this.createSVGTransformFromMatrix(this.createSVGMatrix());return c};b.createSVGTransformFromMatrix=function(c){var d=new SVGTransform();d.setMatrix(c);return d};b.getScreenCTM=function(){if(!!this._cacheScreenCTM){return(this._cacheScreenCTM)}var q=this.viewport.width,z=this.viewport.height,t,o,r,d,c,e,j,g,p,i,s,v,u,f;if(!this.useCurrentView){t=this.viewBox.baseVal;o=this.preserveAspectRatio.baseVal}else{t=this.currentView.viewBox.baseVal;o=this.currentView.preserveAspectRatio.baseVal}if(!!!t._isUsed){this._tx=this._ty=0;r=this.createSVGMatrix();this._cacheScreenCTM=r;return r}else{d=t.x;c=t.y;e=t.width;j=t.height;g=q/e;p=z/j;i=1;s=1;v=0;u=0;if(o.align===1){i=g;s=p;v=-d*i;u=-c*s}else{var l=(o.align+1)%3+1;var k=Math.round(o.align/3);switch(o.meetOrSlice){case 1:i=s=Math.min(g,p);break;case 2:i=s=Math.max(g,p);break}v=-d*i;u=-c*s;switch(l){case 1:break;case 2:v+=(q-e*i)/2;break;case 3:v+=q-e*i;break}switch(k){case 1:break;case 2:u+=(z-j*s)/2;break;case 3:u+=z-j*s;break}}}this._tx=v;this._ty=u;f=this._tar.style;f.marginLeft=v+"px";f.marginTop=u+"px";r=this.createSVGMatrix();r.a=i;r.d=s;this._cacheScreenCTM=r;q=z=t=o=d=c=e=j=g=p=i=s=v=u=f=void 0;return r}})(SVGSVGElement.prototype);function SVGFitToViewBox(){this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio()}function SVGViewSpec(b){SVGFitToViewBox.apply(this,arguments);this.transform=new SVGTransformList();this.viewTarget=b;this.viewBoxString=this.preserveAspectRatioString=this.transformString=this.viewTargetString=""}SVGViewSpec.prototype=Object._create(SVGFitToViewBox);function SVGGElement(b){SVGElement.apply(this);this._tar=b.createElement("v:group");b=void 0;this.addEventListener("DOMNodeInserted",function(d){var c=d.target;if(d.eventPhase===3){return}var g=c.nextSibling,e=c.parentNode._tar,f=true;if(g&&g._tar&&e&&(g._tar.parentNode===e)){e.insertBefore(c._tar,g._tar)}else{if(g&&!g._tar&&e){while(g){if(g._tar&&(g._tar.parentNode===e)){e.insertBefore(c._tar,g._tar);f=false}g=g.nextSibling}if(f){e.appendChild(c._tar)}}else{if(!g&&e){e.appendChild(c._tar)}}}g=e=f=d=c=void 0},false)}SVGGElement.prototype=Object._create(SVGElement);function SVGDefsElement(){SVGElement.apply(this);this.style.setProperty("display","none")}SVGDefsElement.prototype=Object._create(SVGElement);function SVGDescElement(){SVGElement.apply(this)}SVGDescElement.prototype=Object._create(SVGElement);function SVGTitleElement(){SVGElement.apply(this);this.addEventListener("DOMCharacterDataModified",function(b){b.target.ownerDocument.title=b.target.firstChild.nodeValue},false)}SVGTitleElement.prototype=Object._create(SVGElement);function SVGSymbolElement(b){SVGElement.apply(this,arguments)}SVGSymbolElement.prototype=Object._create(SVGElement);function SVGUseElement(){SVGGElement.apply(this,arguments);var b=SVGAnimatedLength;this.x=new b();this.y=new b();this.width=new b();this.height=new b();b=void 0;this.instanceRoot=new SVGElement();this.animatedInstanceRoot=new SVGElement();this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===3){return}c.target.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed")},false);this.addEventListener("S_Load",function(k){var g=k.target,c=g.ownerDocument.defaultView.getComputedStyle(g,""),l=parseFloat(c.getPropertyValue("font-size")),o=g.ownerDocument.documentElement.createSVGTransform(),i=g._instance,f,d,e,j;g.x.baseVal._emToUnit(l);g.y.baseVal._emToUnit(l);g.width.baseVal._emToUnit(l);g.height.baseVal._emToUnit(l);g.instanceRoot=g.animatedInstanceRoot=g.ownerDocument.importNode(i,true);o.setTranslate(g.x.baseVal.value,g.y.baseVal.value);g.transform.baseVal.appendItem(o);if(g._instance.localName==="symbol"){f=g.ownerDocument.createElementNS("http://www.w3.org/2000/svg","svg");f.addEventListener("DOMNodeInsertedIntoDocument",function(p){p.target.nearestViewportElement=p.currentTarget},true);g._tar.appendChild(f._tar);j=g.getScreenCTM();f.setAttributeNS(null,"width",g.width.baseVal.value);f.setAttributeNS(null,"height",g.height.baseVal.value);i.hasAttributeNS(null,"viewBox")&&f.setAttributeNS(null,"viewBox",i.getAttributeNS(null,"viewBox"));i.hasAttributeNS(null,"preserveAspectRatio")&&f.setAttributeNS(null,"preserveAspectRatio",i.getAttributeNS(null,"preserveAspectRatio"));f._cacheScreenCTM=j.multiply(f.getScreenCTM());d=g.instanceRoot.firstChild;while(d){e=d.nextSibling;f.appendChild(d);d.getScreenCTM&&d.getScreenCTM();d=e}g.appendChild(f)}else{g.appendChild(g.instanceRoot)}k=o=g=evtt=c=l=f=d=e=j=void 0},false);SVGURIReference.apply(this)}SVGUseElement.prototype=Object._create(SVGElement);function SVGImageElement(c){SVGElement.apply(this,arguments);this._tar=c.createElement("v:image");var b=SVGAnimatedLength;this.x=new b();this.y=new b();this.width=new b();this.height=new b();c=b=void 0;this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.addEventListener("DOMNodeInserted",function(e){if(e.eventPhase===3){return}var d=e.target;d.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed");if(d.nextSibling){if(!!d.parentNode._tar&&!!d.nextSibling._tar){d.parentNode._tar.insertBefore(d._tar,d.nextSibling._tar)}}else{if(!!d.parentNode._tar){d.parentNode._tar.appendChild(d._tar)}}d.addEventListener("DOMNodeInsertedIntoDocument",function(p){var k=p.target,g=k.ownerDocument.defaultView.getComputedStyle(k,""),q=parseFloat(g.getPropertyValue("font-size")),l=k._tar.style,j=k.getScreenCTM(),i=k.ownerDocument.documentElement.createSVGPoint(),o=parseFloat(g.getPropertyValue("fill-opacity")),f;k.x.baseVal._emToUnit(q);k.y.baseVal._emToUnit(q);k.width.baseVal._emToUnit(q);k.height.baseVal._emToUnit(q);l.position="absolute";i.x=k.x.baseVal.value;i.y=k.y.baseVal.value;i=i.matrixTransform(j);l.left=i.x+"px";l.top=i.y+"px";l.width=k.width.baseVal.value*j.a+"px";l.height=k.height.baseVal.value*j.d+"px";if(o!==1){l.filter="progid:DXImageTransform.Microsoft.Alpha";f=k._tar.filters.item("DXImageTransform.Microsoft.Alpha");f.Style=0;f.Opacity=o*100;f=void 0}p=k=g=q=l=j=i=o=void 0},false);e=d=void 0},false);SVGURIReference.apply(this)}SVGImageElement.prototype=Object._create(SVGElement);function SVGSwitchElement(){SVGElement.apply(this)}SVGSwitchElement.prototype=Object._create(SVGElement);var sieb_s;function GetSVGDocument(b){this._tar=b;this._next=null}function _ca_(){var b=NAIBU._that;if((b.xmlhttp.readyState===4)&&(b.xmlhttp.status===200)){b._ca()}b=void 0}GetSVGDocument.prototype={_init:function(){var c=NAIBU.xmlhttp,b=this._tar,d=(this._tar.nodeName==="OBJECT")?"data":"src";b.style.display="none";this._baseURL=b.getAttribute(d);c.open("GET",this._baseURL,true);c.setRequestHeader("X-Requested-With","XMLHttpRequest");this.xmlhttp=c;NAIBU._that=this;c.onreadystatechange=_ca_;c.send(null);c=b=d=void 0},_ca:function(){var u=this._tar.previousSibling,K=u.contentWindow,f;if(K){K.screen.updateInterval=999;f=K.document;f.write("");f.close()}else{f=document}var J=f.namespaces;if(J&&!J.v){J.add("v","urn:schemas-microsoft-com:vml");J.add("o","urn:schemas-microsoft-com:office:office");var l=f.createStyleSheet(),j="behavior: url(#default#VML);display: inline-block;} ";l.cssText="v\\:rect{"+j+"v\\:image{"+j+"v\\:fill{"+j+"v\\:stroke{"+j+"o\\:opacity2{"+j+"dn\\:defs{display:none}v\\:group{text-indent:0px;position:relative;width:100%;height:100%;"+j+"v\\:shape{width:100%;height:100%;"+j;J=l=j=void 0}DOMImplementation._doc_=f;var G=this.xmlhttp.responseText,B=this._tar,O=DOMImplementation.createDocument("http://www.w3.org/2000/svg","svg"),I=O.documentElement,q=I.viewport,z,C,F,r,L,X,R=I._tar,o=f.createElement("div"),aa=f.createElement("v:group"),A=f.createElement("v:rect"),Q,t,g,v,ac,U,Z,ab,Y,H,k,e,V,E,N,T=parseFloat,p=NAIBU.doc||this.xmlhttp.responseXML,d=f.createElement("div");if(!p){this.xmlhttp.onreadystatechange=NAIBU.emptyFunction;return}O.URL=this._baseURL;O._iframe=u;d.setAttribute("id","_NAIBU_outline");f.body.appendChild(d);o.style.margin="-1px,0px,0px,-1px";if(K){f.body.style.backgroundColor=B.parentNode.currentStyle.backgroundColor}p.async=p.validateOnParse=p.resolveExternals=false;p.preserveWhiteSpace=true;p.loadXML(G.replace(/^[\s\S]*?<svg/,"<svg"));screen.updateInterval=999;if(p.doctype){var P=G,M=p.doctype.entities,D;for(var W=0;W<M.length;++W){D=M.item(W);P=P.replace((new RegExp("&"+D.nodeName+";","g")),D.firstChild.xml)}p.loadXML(P);P=M=D=void 0}q.top=q.left=0;q.width=B.clientWidth;q.height=B.clientHeight;if(q.height<24){q.height=screen.availHeight}if(I.viewport.height<24){I.viewport.height=screen.width}z=B.getAttribute("width");C=B.getAttribute("height");z&&I.setAttributeNS(null,"width",z);C&&I.setAttributeNS(null,"height",C);F=p.documentElement.firstChild;r=p.documentElement.attributes;for(var W=0,b=r.length;W<b;++W){I.setAttributeNodeNS(O.importNode(r[W],false))}G=r=void 0;aa.style.width=q.width+"px";aa.style.height=q.height+"px";aa.coordsize=q.width+" "+q.height;o.appendChild(aa);if(K){f.body.appendChild(o)}else{this._tar.parentNode.insertBefore(o,this._tar)}aa.appendChild(R);while(F){I.appendChild(O.importNode(F,true));F=F.nextSibling}F=void 0;O._window=K;Q=I.ownerDocument.defaultView.getComputedStyle(I,"");t=T(Q.getPropertyValue("font-size"));I.x.baseVal._emToUnit(t);I.y.baseVal._emToUnit(t);I.width.baseVal._emToUnit(t);I.height.baseVal._emToUnit(t);g=I.width.baseVal.value;v=I.height.baseVal.value;U=A.style;U.position="absolute";L=q.width;X=q.height;U.width=L+"px";U.height=X+"px";U.zIndex=-1;A.stroked=A.filled="false";I._tar.appendChild(A);ac=I._tar.style;ac.visibility="visible";ac.position="absolute";ac.overflow="hidden";Z=L>g?g:L;ab=X>v?v:X;U=A.currentStyle;k=T(U.left);e=T(U.top);V=-I._tx;bt=-I._ty;if(k!==0&&!isNaN(k)){V=k;aa.style.left=-V+"px"}if(e!==0&&!isNaN(k)){bt=e;aa.style.top=-bt+"px"}H=V+Z+1;Y=bt+ab+1;ac.clip="rect("+bt+"px "+H+"px "+Y+"px "+V+"px)";this._document=O;N=function(){if("_svgload_limited" in O.documentElement){O.documentElement._svgload_limited--;if(O.documentElement._svgload_limited<0){var i=O.createEvent("SVGEvents");i.initEvent("SVGLoad",false,false);O.documentElement.dispatchEvent(i);i=void 0}}};E=O.documentElement._tar.getElementsByTagName("div");for(var W=0,S;E[W];++W){S=E[W];if(S.firstChild.nodeName!=="shape"){var c=S.style;c.left=T(c.left)-V+"px";c.top=T(c.top)-bt+"px"}}K&&K.scroll(-O.documentElement._tx,-O.documentElement._ty);O._isLoaded=1;O.defaultView._cache=O.defaultView._cache_ele=null;d=f=evt=p=B=I=q=z=C=R=o=aa=A=g=v=Q=t=void 0;ac=U=E=S=W=c=k=e=V=bt=E=T=L=X=Z=ab=Y=H=void 0;this.xmlhttp.onreadystatechange=NAIBU.emptyFunction;if(this._next){N();K&&(u.contentWindow.screen.updateInterval=0);N=u=K=O=void 0;this._next._init()}else{if(O.implementation._buffer_){screen.updateInterval=0;NAIBU._buff_num=0;NAIBU._buff=setInterval(function(){var ah=NAIBU._buff_num,s=DOMImplementation._buffer_,ag=s?s.length:0,af,ad;if(ag===0){clearInterval(NAIBU._buff);N();N=O=s=ah=void 0}else{for(var ae=0;ae<50;++ae){af=s[ah];ad=s[ah+1];af.dispatchEvent(ad);ah+=2;af=ad=void 0;if(ah>=ag){clearInterval(NAIBU._buff);N();DOMImplementation._buffer_=null;NAIBU.Time.start();N=O=s=ah=ag=void 0;return}}NAIBU._buff_num=ah}s=ah=ag=void 0},1);u=K=void 0}else{N();N=u=K=O=void 0;NAIBU.Time.start()}delete NAIBU.doc}},getSVGDocument:function(){return(this._document)}};NAIBU.emptyFunction=function(){};function SVGStyleElement(b){SVGElement.apply(this);LinkStyle.apply(this);this.xmlspace;this.type="text/css";this.media;this.title;SVGURIReference.apply(this);this.addEventListener("DOMAttrModified",function(c){if(c.attrName==="type"){c.target.type=c.newValue}else{if(c.attrName==="title"){c.target.title=c.newValue}}c=void 0},false);this.addEventListener("S_Load",function(u){var q=u.target,s=q.sheet,c=q._text,g=q.ownerDocument,d=b.createElement("style"),t,p,k,f;NAIBU._temp_doc=g;s=g.styleSheets[g.styleSheets.length]=DOMImplementation.createCSSStyleSheet(q.title,q.media);s.ownerNode=q;b.documentElement.firstChild.appendChild(d);d.styleSheet.cssText=c;for(var o=0,v=d.styleSheet.rules,r=v.length;o<r;++o){t=v[o];k=new CSSStyleRule();k.selectorText=t.selectorText;k.style.cssText=t.style.cssText;p=k.style.cssText.split(";");for(var l=0,e=p.length;l<e;++l){f=p[l].split(": ");k.style.setProperty(f[0],f[1])}s.cssRules[s.cssRules.length]=k}g.documentElement.addEventListener("DOMNodeInsertedIntoDocument",function(F){var C=F.target,E=C.ownerDocument,G=E.styleSheets[0]?E.styleSheets[0].cssRules:[],z,j,B=C.className.baseVal||".,.";for(var A=0,D=G.length;A<D;++A){z=G[A].selectorText;j=C._rules||[];if((z.indexOf("."+B)>-1)||(z.indexOf("#"+C.id)>-1)||(C.nodeName===z)){j[j.length]=G[A]}C._rules=j}C=E=G=void 0},true);q=u=d=s=c=g=o=v=r=void 0},false);this.addEventListener("DOMNodeInserted",function(d){var c=d.target;if(d.eventPhase===3){if(c.nodeName==="#cdata-section"){d.currentTarget._text=c.data}return}c.addEventListener("DOMNodeInsertedIntoDocument",function(g){var f=g.target;if((g.eventPhase===2)&&!f.getAttributeNodeNS("http://www.w3.org/1999/xlink","xlink:href")){var e=f.ownerDocument.createEvent("SVGEvents");e.initEvent("S_Load",false,false);g.currentTarget.dispatchEvent(e)}f=g=void 0},false)},false)}SVGStyleElement.prototype=Object._create(SVGElement);function SVGPoint(){}SVGPoint.prototype.x=SVGPoint.prototype.y=0;SVGPoint.prototype.matrixTransform=function(b){if(!isFinite(b.a)||!isFinite(b.b)||!isFinite(b.c)||!isFinite(b.d)||!isFinite(b.e)||!isFinite(b.f)){throw (new Error("Type Error: 引数の値がNumber型ではありません"))}var c=new SVGPoint();c.x=b.a*this.x+b.c*this.y+b.e;c.y=b.b*this.x+b.d*this.y+b.f;return c};function SVGPointList(){}function SVGMatrix(){}SVGMatrix.prototype={a:1,b:0,c:0,d:1,e:0,f:0,multiply:function(c){var f=new SVGMatrix(),b=c,e=isFinite,d=this;if(!e(b.a)||!e(b.b)||!e(b.c)||!e(b.d)||!e(b.e)||!e(b.f)){throw (new Error("Type Error: 引数の値がNumber型ではありません"))}f.a=d.a*b.a+d.c*b.b;f.b=d.b*b.a+d.d*b.b;f.c=d.a*b.c+d.c*b.d;f.d=d.b*b.c+d.d*b.d;f.e=d.a*b.e+d.c*b.f+d.e;f.f=d.b*b.e+d.d*b.f+d.f;b=d=c=e=void 0;return f},inverse:function(){var b=new SVGMatrix(),c=this._determinant();if(c!==0){b.a=this.d/c;b.b=-this.b/c;b.c=-this.c/c;b.d=this.a/c;b.e=(this.c*this.f-this.d*this.e)/c;b.f=(this.b*this.e-this.a*this.f)/c;return b}else{throw (new SVGException(2))}},translate:function(c,e){var b=new SVGMatrix();b.e=c;b.f=e;var d=this.multiply(b);b=void 0;return d},scale:function(d){var b=new SVGMatrix();b.a=d;b.d=d;var c=this.multiply(b);b=void 0;return c},scaleNonUniform:function(c,e){var b=new SVGMatrix();b.a=c;b.d=e;var d=this.multiply(b);b=void 0;return d},rotate:function(e){var c=new SVGMatrix(),b=e/180*Math.PI;c.a=Math.cos(b);c.b=Math.sin(b);c.c=-c.b;c.d=c.a;var d=this.multiply(c);c=b=void 0;return d},rotateFromVector:function(d,f){if((d===0)||(f===0)||!isFinite(d)||!isFinite(f)){throw (new SVGException(1))}var c=new SVGMatrix(),b=Math.atan2(f,d);c.a=Math.cos(b);c.b=Math.sin(b);c.c=-c.b;c.d=c.a;var e=this.multiply(c);c=b=void 0;return e},flipX:function(){var b=new SVGMatrix();b.a=-b.a;var c=this.multiply(b);b=void 0;return c},flipY:function(){var b=new SVGMatrix();b.d=-b.d;var c=this.multiply(b);b=void 0;return c},skewX:function(e){var c=new SVGMatrix(),b=e/180*Math.PI;c.c=Math.tan(b);var d=this.multiply(c);c=void 0;return d},skewY:function(e){var c=new SVGMatrix(),b=e/180*Math.PI;c.b=Math.tan(b);var d=this.multiply(c);c=void 0;return d},_determinant:function(){return(this.a*this.d-this.b*this.c)}};function SVGTransform(){this.matrix=new SVGMatrix()}SVGTransform.SVG_TRANSFORM_UNKNOWN=0;SVGTransform.SVG_TRANSFORM_MATRIX=1;SVGTransform.SVG_TRANSFORM_TRANSLATE=2;SVGTransform.SVG_TRANSFORM_SCALE=3;SVGTransform.SVG_TRANSFORM_ROTATE=4;SVGTransform.SVG_TRANSFORM_SKEWX=5;SVGTransform.SVG_TRANSFORM_SKEWY=6;SVGTransform.prototype={_matrix:(new SVGMatrix()),type:0,angle:0,setMatrix:function(b){this.type=1;this.matrix=this._matrix.multiply(b)},setTranslate:function(c,b){this.type=2;this.matrix=this._matrix.translate(c,b)},setScale:function(c,b){this.type=3;this.matrix=this._matrix.scaleNonUniform(c,b)},setRotate:function(c,b,d){this.angle=c;this.type=4;this.matrix=this._matrix.rotate(c);this.matrix.e=(1-this.matrix.a)*b-this.matrix.c*d;this.matrix.f=-this.matrix.b*b+(1-this.matrix.d)*d},setSkewX:function(b){this.angle=b;this.type=5;this.matrix=this._matrix.skewX(b)},setSkewY:function(b){this.angle=b;this.type=6;this.matrix=this._matrix.skewY(b)}};function SVGTransformList(){}SVGTransformList.prototype.createSVGTransformFromMatrix=function(b){var c=new SVGTransform();c.setMatrix(b);return c};SVGTransformList.prototype.consolidate=function(){if(this.numberOfItems===0){return null}else{var e=this.getItem(0),c=e.matrix;for(var d=1,b=this.numberOfItems;d<b;++d){c=c.multiply(this.getItem(d).matrix)}e.setMatrix(c);this.initialize(e);return e}};function SVGAnimatedTransformList(){this.animVal=this.baseVal=new SVGTransformList()}function SVGPreserveAspectRatio(){this.align=6;this.meetOrSlice=1}function SVGAnimatedPreserveAspectRatio(){this.animVal=this.baseVal=new SVGPreserveAspectRatio()}function SVGPathSeg(){this.pathSegType=0;this.pathSegTypeAsLetter=null}function SVGPathSegClosePath(){}SVGPathSegClosePath.prototype={pathSegType:1,pathSegTypeAsLetter:"z"};function SVGPathSegMovetoAbs(){}SVGPathSegMovetoAbs.prototype={pathSegType:2,pathSegTypeAsLetter:"M"};function SVGPathSegMovetoRel(){}SVGPathSegMovetoRel.prototype={pathSegType:3,pathSegTypeAsLetter:"m"};function SVGPathSegLinetoAbs(){}SVGPathSegLinetoAbs.prototype={pathSegType:4,pathSegTypeAsLetter:"L"};function SVGPathSegLinetoRel(){}SVGPathSegLinetoRel.prototype={pathSegType:5,pathSegTypeAsLetter:"l"};function SVGPathSegCurvetoCubicAbs(){}SVGPathSegCurvetoCubicAbs.prototype={pathSegType:6,pathSegTypeAsLetter:"C"};function SVGPathSegCurvetoCubicRel(){}SVGPathSegCurvetoCubicRel.prototype={pathSegType:7,pathSegTypeAsLetter:"c"};function SVGPathSegCurvetoQuadraticAbs(){this.pathSegType=8;this.pathSegTypeAsLetter="Q"}function SVGPathSegCurvetoQuadraticRel(){this.pathSegType=9;this.pathSegTypeAsLetter="q"}function SVGPathSegArcAbs(){}SVGPathSegArcAbs.prototype={largeArcFlag:true,sweepFlag:true,pathSegType:10,pathSegTypeAsLetter:"A"};function SVGPathSegArcRel(){}SVGPathSegArcRel.prototype={largeArcFlag:true,sweepFlag:true,pathSegType:11,pathSegTypeAsLetter:"a"};function SVGPathSegLinetoHorizontalAbs(){this.pathSegType=12;this.pathSegTypeAsLetter="H"}function SVGPathSegLinetoHorizontalRel(){this.pathSegType=13;this.pathSegTypeAsLetter="h"}function SVGPathSegLinetoVerticalAbs(){this.pathSegType=14;this.pathSegTypeAsLetter="V"}function SVGPathSegLinetoVerticalRel(){this.pathSegType=15;this.pathSegTypeAsLetter="v"}function SVGPathSegCurvetoCubicSmoothAbs(){this.pathSegType=16;this.pathSegTypeAsLetter="S"}function SVGPathSegCurvetoCubicSmoothRel(){this.pathSegType=17;this.pathSegTypeAsLetter="s"}function SVGPathSegCurvetoQuadraticSmoothAbs(){this.pathSegType=18;this.pathSegTypeAsLetter="T"}function SVGPathSegCurvetoQuadraticSmoothRel(){this.pathSegType=19;this.pathSegTypeAsLetter="t"}function SVGPathSegList(){}for(var prop in SVGStringList.prototype){SVGNumberList.prototype[prop]=SVGLengthList.prototype[prop]=SVGPointList.prototype[prop]=SVGTransformList.prototype[prop]=SVGPathSegList.prototype[prop]=SVGStringList.prototype[prop]}prop=void 0;(function(d,c){NAIBU.freeArg=function(){b=d=c=void 0};NAIBU._setPaint=function(N,L){if(!N._tar){return}var R=N.ownerDocument,j=R._document_,e=N._tar,Q=R.defaultView.getComputedStyle(N,""),J=Q.getPropertyCSSValue("fill"),u=Q.getPropertyCSSValue("stroke"),s=J.paintType,O=u.paintType,F,D,v=1,H="color",A,r,K,E,p,C,I,f,l,o,G,z,P,B,k,q;while(e.firstChild){e.removeChild(e.firstChild)}if((s===1)||(s===102)){if(s===102){Q.setProperty(H,Q.getPropertyValue(H))}F=j.createElement("v:fill");D=J.rgbColor;v=1;F.setAttribute(H,"rgb("+D.red.getFloatValue(v)+","+D.green.getFloatValue(v)+","+D.blue.getFloatValue(v)+")");K=+(Q.getPropertyValue("fill-opacity"))*Q._list._opacity;if(K<1){F.setAttribute("opacity",K+"")}e.appendChild(F);F=D=K=void 0}else{if(J.uri){A=R.getElementById(J.uri);if(A){r=R._domnodeEvent();r._tar=j.createElement("v:fill");r._style=Q;r._ttar=N;A.dispatchEvent(r);if(A.localName!=="radialGradient"){e.appendChild(r._tar)}A=r=void 0}}else{e.filled="false"}}if((O===1)||(O===102)){if(O===102){Q.setProperty(H,Q.getPropertyValue(H))}f=j.createElement("v:stroke");G=Q.getPropertyCSSValue("stroke-width");z=R.documentElement.viewport.width;P=R.documentElement.viewport.height;G._percent=c.sqrt((z*z+P*P)/2);B=G.getFloatValue(1)*c.sqrt(c.abs(L._determinant()));f.setAttribute("weight",B+"px");G=z=P=void 0;if(!u.uri){D=u.rgbColor;f.setAttribute(H,"rgb("+D.red.getFloatValue(v)+","+D.green.getFloatValue(v)+","+D.blue.getFloatValue(v)+")");l=+(Q.getPropertyValue("stroke-opacity"))*(+(Q.getPropertyValue("opacity")));if(B<1){l*=B}if(l<1){f.setAttribute("opacity",l+"")}D=l=void 0}f.setAttribute("miterlimit",Q.getPropertyValue("stroke-miterlimit"));f.setAttribute("joinstyle",Q.getPropertyValue("stroke-linejoin"));if(Q.getPropertyValue("stroke-linecap")==="butt"){f.setAttribute("endcap","flat")}else{f.setAttribute("endcap",Q.getPropertyValue("stroke-linecap"))}k=Q.getPropertyValue("stroke-dasharray");if(k!=="none"){if(k.indexOf(",")>0){E=k.split(",");for(var M=0,g=E.length;M<g;++M){E[M]=c.ceil(+(E[M])/parseFloat(Q.getPropertyValue("stroke-width")))}q=E.join(" ");if(E.length%2===1){q+=" "+q}}f.setAttribute("dashstyle",q);k=E=void 0}e.appendChild(f);f=k=void 0}else{e.stroked="false"}if(e.style){p=Q.getPropertyCSSValue("cursor");if(p&&!p._isDefault){e.style.cursor=p.cssText.split(":")[1]}C=Q.getPropertyCSSValue("visibility");if(C&&!C._isDefault){e.style.visibility=C.cssText.split(":")[1]}I=Q.getPropertyCSSValue("display");if(I&&!I._isDefault&&(I.cssText.indexOf("none")>-1)){e.style.display="none"}else{if(I&&!I._isDefault&&(I.cssText.indexOf("inline-block")===-1)){e.style.display="inline-block"}}}R=j=e=J=u=O=s=Q=p=N=L=C=I=v=void 0};function b(f){SVGElement.apply(this);this._tar=f.createElement("v:shape");var e=SVGPathSegList;this.pathSegList=new e();this.animatedPathSegList=this.pathSegList;this.normalizedPathSegList=new e();e=f=void 0;this.animatedNormalizedPathSegList=this.normalizedPathSegList;this.pathLength=new SVGAnimatedNumber();this.addEventListener("DOMAttrModified",this._attrModi,false);this.addEventListener("DOMNodeInserted",this._nodeInsert,false)}b.prototype=Object._create(SVGElement);(function(e){e._attrModi=function(K){var P=K.target;if(K.attrName==="d"&&K.newValue!==""){var H=P.normalizedPathSegList,O=P.pathSegList;if(H.numberOfItems>0){H.clear();O.clear()}var V=P._com,S=V.isSp,v=K.newValue.replace(V.isRa," -").replace(V.isRb," ").replace(V.isRc,",$1 ").replace(V.isRd,",$1 1").replace(V.isRe,"").replace(/\.(\d+)\./g,".$1 0.").replace(/[^\w\d\+\-\.\,\n\r\s].*/,"").split(","),l=v.length,B=V._isZ,E=V._isM,L=V._isC,F=V._isL,r=P.createSVGPathSegCurvetoCubicAbs,Q=P.createSVGPathSegLinetoAbs,M,q;for(var U=0;U<l;++U){var u=v[U].match(S),R;for(var T=1,g=u[0],J=u.length;T<J;++T){if(L[g]){R=r(+u[T+4],+u[T+5],+u[T],+u[T+1],+u[T+2],+u[T+3]);T+=5}else{if(F[g]){R=Q(+u[T],+u[T+1]);++T}else{if(E[g]){R=P.createSVGPathSegMovetoAbs(+u[T],+u[T+1]);++T}else{if(B[g]){R=P.createSVGPathSegClosePath()}else{if(g==="A"){M=u[T+3];if(M.length>1&&(+M>=0)){u.splice(T+3,1,M.charAt(0),M.slice(1));++J}q=u[T+4];if(q.length>1&&(+q>=0)){u.splice(T+4,1,q.charAt(0),q.slice(1));++J}M=u[T+3];q=u[T+4];if(((+M<0)||(+M>1))||((+q<0)||(+q>1))){T+=6;continue}R=P.createSVGPathSegArcAbs(+u[T+5],+u[T+6],+u[T],+u[T+1],+u[T+2],+M,+q);T+=6}else{if(g==="m"){R=P.createSVGPathSegMovetoRel(+u[T],+u[T+1]);++T}else{if(g==="l"){R=P.createSVGPathSegLinetoRel(+u[T],+u[T+1]);++T}else{if(g==="c"){R=P.createSVGPathSegCurvetoCubicRel(+u[T+4],+u[T+5],+u[T],+u[T+1],+u[T+2],+u[T+3]);T+=5}else{if(g==="Q"){R=P.createSVGPathSegCurvetoQuadraticAbs(+u[T+2],+u[T+3],+u[T],+u[T+1]);T+=3}else{if(g==="q"){R=P.createSVGPathSegCurvetoQuadraticRel(+u[T+2],+u[T+3],+u[T],+u[T+1]);T+=3}else{if(g==="a"){M=u[T+3];if(M.length>1&&(+M>=0)){u.splice(T+3,1,M.charAt(0),M.slice(1));++J}q=u[T+4];if(q.length>1&&(+q>=0)){u.splice(T+4,1,q.charAt(0),q.slice(1));++J}M=u[T+3];q=u[T+4];if(((+M<0)||(+M>1))||((+q<0)||(+q>1))){T+=6;continue}R=P.createSVGPathSegArcRel(+u[T+5],+u[T+6],+u[T],+u[T+1],+u[T+2],+M,+q);T+=6}else{if(g==="S"){R=P.createSVGPathSegCurvetoCubicSmoothAbs(+u[T+2],+u[T+3],+u[T],+u[T+1]);T+=3}else{if(g==="s"){R=P.createSVGPathSegCurvetoCubicSmoothRel(+u[T+2],+u[T+3],+u[T],+u[T+1]);T+=3}else{if(g==="T"){R=P.createSVGPathSegCurvetoQuadraticSmoothAbs(+u[T],+u[T+1]);++T}else{if(g==="t"){R=P.createSVGPathSegCurvetoQuadraticSmoothRel(+u[T],+u[T+1]);++T}else{if(g==="H"){R=P.createSVGPathSegLinetoHorizontalAbs(+u[T])}else{if(g==="h"){R=P.createSVGPathSegLinetoHorizontalRel(+u[T])}else{if(g==="V"){R=P.createSVGPathSegLinetoVerticalAbs(+u[T])}else{if(g==="v"){R=P.createSVGPathSegLinetoVerticalRel(+u[T])}else{R=new SVGPathSeg()}}}}}}}}}}}}}}}}}}}O.appendItem(R)}}u=R=S=v=void 0;var D=0,C=0,N=0,A=0,p=0,o=0;for(var T=0,t=O.numberOfItems;T<t;++T){var f=O.getItem(T),W=f.pathSegType,g=f.pathSegTypeAsLetter;if(W===0){}else{var I=D,G=C;if(W%2===1){D+=f.x;C+=f.y}else{D=f.x;C=f.y}if(L[g]){H.appendItem(f)}else{if(F[g]){H.appendItem(f)}else{if(E[g]){if(T!==0){var k=O.getItem(T-1);if(k.pathSegTypeAsLetter==="M"){H.appendItem(Q(D,C));continue}}p=D;o=C;H.appendItem(f)}else{if(g==="m"){if(T!==0){var k=O.getItem(T-1);if(k.pathSegTypeAsLetter==="m"){H.appendItem(Q(D,C));continue}}p=D;o=C;H.appendItem(P.createSVGPathSegMovetoAbs(D,C))}else{if(g==="l"){H.appendItem(Q(D,C))}else{if(g==="c"){H.appendItem(r(D,C,f.x1+I,f.y1+G,f.x2+I,f.y2+G))}else{if(B[g]){D=p;C=o;H.appendItem(f)}else{if(g==="Q"){N=2*D-f.x1;A=2*C-f.y1;H.appendItem(r(D,C,(I+2*f.x1)/3,(G+2*f.y1)/3,(2*f.x1+D)/3,(2*f.y1+C)/3))}else{if(g==="q"){var z=f.x1+I,X=f.y1+G;N=2*D-z;A=2*C-X;H.appendItem(r(D,C,(I+2*z)/3,(G+2*X)/3,(2*z+D)/3,(2*X+C)/3));z=X=void 0}else{if(g==="A"||g==="a"){(function(Z,aw,av,az,ax,aF,ay){if(Z.r1===0||Z.r2===0){return}var aK=Z.sweepFlag,aO=Z.angle,an=c.abs(Z.r1),am=c.abs(Z.r2),au=(az-aw)/2,at=(ax-av)/2,Y=c.cos(aO*c.PI/180),aC=c.sin(aO*c.PI/180),aB=Y*au+aC*at,al=-1*aC*au+Y*at,ak=aB*aB,ae=al*al,aA=an*an,ah=am*am,aS=ak/aA+ae/ah,aL;if(aS>1){an=c.sqrt(aS)*an;am=c.sqrt(aS)*am;aL=0}else{var ag=1;if(Z.largeArcFlag===aK){ag=-1}aL=ag*c.sqrt((aA*ah-aA*ae-ah*ak)/(aA*ae+ah*ak))}var aq=aL*an*al/am,s=-1*aL*am*aB/an,aN=Y*aq-aC*s+(az+aw)/2,aM=aC*aq+Y*s+(ax+av)/2,ab=c.atan2((al-s)/am,(aB-aq)/an)-c.atan2(0,1),aP=(ab>=0)?ab:2*c.PI+ab,ab=c.atan2((-al-s)/am,(-aB-aq)/an)-c.atan2((al-s)/am,(aB-aq)/an),af=(ab>=0)?ab:2*c.PI+ab;if(!aK&&af>0){af-=2*c.PI}else{if(aK&&af<0){af+=2*c.PI}}var ac=af*2/c.PI,aD=c.ceil(ac<0?-1*ac:ac),aE=af/aD,aI=8/3*c.sin(aE/4)*c.sin(aE/4)/c.sin(aE/2),aH=Y*an,aG=Y*am,j=aC*an,i=aC*am,ar=c.cos(aP),aj=c.sin(aP),ap=az-aI*(aH*aj+i*ar),aR=ax-aI*(j*aj-aG*ar);for(var aJ=0;aJ<aD;++aJ){aP+=aE;ar=c.cos(aP);aj=c.sin(aP);var ao=aH*ar-i*aj+aN,aQ=j*ar+aG*aj+aM,ad=-aI*(aH*aj+i*ar),aa=-aI*(j*aj-aG*ar);ay.appendItem(r(ao,aQ,ap,aR,ao-ad,aQ-aa));ap=ao+ad;aR=aQ+aa}Z=aw=av=az=ax=aF=ay=void 0})(f,D,C,I,G,P,H)}else{if(g==="S"){if(T!==0){var k=H.getItem(H.numberOfItems-1);if(k.pathSegTypeAsLetter==="C"){var z=2*k.x-k.x2,X=2*k.y-k.y2}else{var z=I,X=G}}else{var z=I,X=G}H.appendItem(r(D,C,z,X,f.x2,f.y2));z=X=void 0}else{if(g==="s"){if(T!==0){var k=H.getItem(H.numberOfItems-1);if(k.pathSegTypeAsLetter==="C"){var z=2*k.x-k.x2,X=2*k.y-k.y2}else{var z=I,X=G}}else{var z=I,X=G}H.appendItem(r(D,C,z,X,f.x2+I,f.y2+G));z=X=void 0}else{if(g==="T"||g==="t"){if(T!==0){var k=O.getItem(T-1);if("QqTt".indexOf(k.pathSegTypeAsLetter)>-1){}else{N=I,A=G}}else{N=I,A=G}H.appendItem(r(D,C,(I+2*N)/3,(G+2*A)/3,(2*N+D)/3,(2*A+C)/3));N=2*D-N;A=2*C-A;xx1=yy1=void 0}else{if(g==="H"||g==="h"){H.appendItem(Q(D,G));C=G}else{if(g==="V"||g==="v"){H.appendItem(Q(I,C));D=I}}}}}}}}}}}}}}}}}}K=P=V=D=C=N=A=p=o=H=O=f=g=W=B=E=F=L=R=r=Q=void 0};e._nodeInsert=function(g){var f=g.target;if(g.eventPhase===3){return}var k=f.nextSibling,i=f.parentNode._tar,j=true;if(k&&k._tar&&i&&(k._tar.parentNode===i)){i.insertBefore(f._tar,k._tar)}else{if(k&&!k._tar&&i){while(k){if(k._tar&&(k._tar.parentNode===i)){i.insertBefore(f._tar,k._tar);j=false}k=k.nextSibling}if(j){i.appendChild(f._tar)}}else{if(!k&&i){i.appendChild(f._tar)}}}k=i=j=void 0;f.addEventListener("DOMNodeInsertedIntoDocument",f._nodeInsertInto,false);g=f=void 0};e._nodeInsertInto=function(r){var v=r.target,u=v.getScreenCTM(),p=v.normalizedPathSegList,C=[],j=u.a,g=u.b,J=u.c,I=u.d,H=u.e,G=u.f,k=v._com._nameCom,o=v._com._isZ,A=v._com._isC;for(var z=0,s=p.numberOfItems;z<s;++z){var l=p[z],F=l.x,D=l.y,B=l.pathSegTypeAsLetter,q=k[B];if(A[B]){q+=[(j*l.x1+J*l.y1+H)|0,(g*l.x1+I*l.y1+G)|0,(j*l.x2+J*l.y2+H)|0,(g*l.x2+I*l.y2+G)|0,(j*F+J*D+H)|0,(g*F+I*D+G)|0].join(" ")}else{if(!o[B]){q+=(j*F+J*D+H)|0;q+=" ";q+=(g*F+I*D+G)|0}}C[z]=q}var E=v.ownerDocument.documentElement,f=v._tar;C.push(" e");f.path=C.join(" ");f.coordsize=E.width.baseVal.value+" "+E.height.baseVal.value;NAIBU._setPaint(v,u);delete v._cacheMatrix;r=v=C=q=F=D=u=p=x=y=mr=j=g=J=I=H=G=E=o=A=z=s=B=l=k=f=void 0};e._com={_nameCom:{z:" x ",Z:" x ",C:"c",L:"l",M:"m"},_isZ:{z:1,Z:1},_isC:{C:1},_isL:{L:1},_isM:{M:1},isRa:/\-/g,isRb:/,/g,isRc:/([a-yA-Y])/g,isRd:/([zZ])/g,isRe:/,/,isSp:/\S+/g};e.getTotalLength=function(){var l=0,g=this.normalizedPathSegList;for(var k=1,o=g.numberOfItems,j=null;k<o;++k){var f=g.getItem(k);if(f.pathSegType===4){var p=g.getItem(k-1);l+=c.sqrt(c.pow((f.x-p.x),2)+c.pow((f.y-p.y),2))}else{if(f.pathSegType===6){}else{if(f.pathSegType===1){var p=g.getItem(k-1),j=g.getItem(0);l+=c.sqrt(c.pow((p.x-j.x),2)+c.pow((p.y-j.y),2))}}}}this.pathLength.baseVal=l;return l};e.getPointAtLength=function(j){var k=this.getPathSegAtLength(j),q=0,p=0,g=this.normalizedPathSegList,l=g.getItem(k),v=this.ownerDocument.documentElement.createSVGPoint();if((k-1)<=0){v.x=l.x;v.y=l.y;return v}var f=g.getItem(k-1);if(l.pathSegType===4){var o=c.sqrt(c.pow((l.x-f.x),2)+c.pow((l.y-f.y),2));var u=(o+this._dis)/o;v.x=f.x+u*(l.x-f.x);v.y=f.y+u*(l.y-f.y)}else{if(l.pathSegType===6){var r=0;r+=c.sqrt(c.pow((l.x1-f.x),2)+c.pow((l.y1-f.y),2));r+=c.sqrt(c.pow((l.x2-l.x1),2)+c.pow((l.y2-l.y1),2));r+=c.sqrt(c.pow((l.x2-l.x1),2)+c.pow((l.y2-l.y1),2));r+=c.sqrt(c.pow((l.x-f.x),2)+c.pow((l.y-f.y),2));var o=r/2;var u=(o+this._dis)/o;v.x=(3*l.x1+l.x-3*l.x2-f.x)*c.pow(u,3)+3*(f.x-2*l.x1+l.x2)*c.pow(u,2)+3*(l.x1-f.x)*u+f.x;v.y=(3*l.y1+l.y-3*l.y2-f.y)*c.pow(u,3)+3*(f.y-2*l.y1+l.y2)*c.pow(u,2)+3*(l.y1-f.y)*u+f.y}else{if(l.pathSegType===2){v.x=l.x;v.y=l.y}else{if(l.pathSegType===1){var i=g.getItem(0),o=c.sqrt(c.pow((l.x-mx.x),2)+c.pow((l.y-i.y),2));var u=(o+this._dis)/o;v.x=i.x+u*(l.x-i.x);v.y=i.y+u*(l.y-i.y)}}}}return v};e.getPathSegAtLength=function(p){var g=this.normalizedPathSegList;for(var k=0,l=g.numberOfItems,j=null;k<l;++k){var f=g.getItem(k);if(f.pathSegType===4){var o=g.getItem(k-1);p-=c.sqrt(c.pow((f.x-o.x),2)+c.pow((f.y-o.y),2))}else{if(f.pathSegType===6){}else{if(f.pathSegType===1){var o=g.getItem(k-1),j=g.getItem(0);p-=c.sqrt(c.pow((o.x-j.x),2)+c.pow((o.y-j.y),2))}}}if(p<=0){this._dis=p;p=void 0;return k}}return(g.numberOfItems-1)};e.createSVGPathSegClosePath=function(){var f=SVGPathSegClosePath;return(new f())};e.createSVGPathSegMovetoAbs=function(f,j){var i=SVGPathSegMovetoAbs,g=new i();g.x=f;g.y=j;return g};e.createSVGPathSegMovetoRel=function(f,i){var g=new SVGPathSegMovetoRel();g.x=f;g.y=i;return g};e.createSVGPathSegLinetoAbs=function(f,i){var g=new SVGPathSegLinetoAbs();g.x=f;g.y=i;return g};e.createSVGPathSegLinetoRel=function(f,i){var g=new SVGPathSegLinetoRel();g.x=f;g.y=i;return g};e.createSVGPathSegCurvetoCubicAbs=function(g,p,j,o,i,k){var f=SVGPathSegCurvetoCubicAbs,l=new f();l.x=g;l.y=p;l.x1=j;l.y1=o;l.x2=i;l.y2=k;return l};e.createSVGPathSegCurvetoCubicRel=function(f,o,i,l,g,j){var k=new SVGPathSegCurvetoCubicRel();k.x=f;k.y=o;k.x1=i;k.y1=l;k.x2=g;k.y2=j;return k};e.createSVGPathSegCurvetoQuadraticAbs=function(f,k,g,j){var i=new SVGPathSegCurvetoQuadraticAbs();i.x=f;i.y=k;i.x1=g;i.y1=j;return i};e.createSVGPathSegCurvetoQuadraticRel=function(f,k,g,j){var i=new SVGPathSegCurvetoQuadraticRel();i.x=f;i.y=k;i.x1=g;i.y1=j;return i};e.createSVGPathSegArcAbs=function(f,p,i,g,o,l,k){var j=new SVGPathSegArcAbs();j.x=f;j.y=p;j.r1=i;j.r2=g;j.angle=o;j.largeArcFlag=l;j.sweepFlag=k;return j};e.createSVGPathSegArcRel=function(f,p,i,g,o,l,k){var j=new SVGPathSegArcRel();j.x=f;j.y=p;j.r1=i;j.r2=g;j.angle=o;j.largeArcFlag=l;j.sweepFlag=k;return j};e.createSVGPathSegLinetoHorizontalAbs=function(f){var g=new SVGPathSegLinetoHorizontalAbs();g.x=f;g.y=0;return g};e.createSVGPathSegLinetoHorizontalRel=function(f){var g=new SVGPathSegLinetoHorizontalRel();g.x=f;g.y=0;return g};e.createSVGPathSegLinetoVerticalAbs=function(g){var f=new SVGPathSegLinetoVerticalAbs();f.x=0;f.y=g;return f};e.createSVGPathSegLinetoVerticalRel=function(g){var f=new SVGPathSegLinetoVerticalRel();f.x=0;f.y=g;return f};e.createSVGPathSegCurvetoCubicSmoothAbs=function(f,k,g,i){var j=new SVGPathSegCurvetoCubicSmoothAbs();j.x=f;j.y=k;j.x2=g;j.y2=i;return j};e.createSVGPathSegCurvetoCubicSmoothRel=function(f,k,g,i){var j=new SVGPathSegCurvetoCubicSmoothRel();j.x=f;j.y=k;j.x2=g;j.y2=i;return j};e.createSVGPathSegCurvetoQuadraticSmoothAbs=function(f,i){var g=new SVGPathSegCurvetoQuadraticSmoothAbs();g.x=f;g.y=i;return g};e.createSVGPathSegCurvetoQuadraticSmoothRel=function(f,i){var g=new SVGPathSegCurvetoQuadraticSmoothRel();g.x=f;g.y=i;return g}})(b.prototype);NAIBU.SVGPathElement=b})(document,Math);function SVGRectElement(c){SVGElement.apply(this);this._tar=c.createElement("v:shape");var b=SVGAnimatedLength;this.x=new b();this.y=new b();this.width=new b();this.height=new b();this.rx=new b();this.ry=new b();c=b=void 0;this.addEventListener("DOMNodeInserted",function(e){if(e.eventPhase===3){return}var d=e.target,i=d.nextSibling,f=d.parentNode._tar,g=true;if(i&&i._tar&&f&&(i._tar.parentNode===f)){f.insertBefore(d._tar,i._tar)}else{if(i&&!i._tar&&f){while(i){if(i._tar&&(i._tar.parentNode===f)){f.insertBefore(d._tar,i._tar);g=false}i=i.nextSibling}if(g){f.appendChild(d._tar)}}else{if(!i&&f){f.appendChild(d._tar)}}}i=f=g=void 0;d.addEventListener("DOMNodeInsertedIntoDocument",function(E){var L=E.target,N=L.ownerDocument.defaultView.getComputedStyle(L,""),o=parseFloat(N.getPropertyValue("font-size"));L.x.baseVal._emToUnit(o);L.y.baseVal._emToUnit(o);L.width.baseVal._emToUnit(o);L.height.baseVal._emToUnit(o);var r=L.getAttributeNS(null,"rx"),q=L.getAttributeNS(null,"ry"),A=L.x.baseVal.value,z=L.y.baseVal.value,u=A+L.width.baseVal.value,X=z+L.height.baseVal.value,O;if((r||q)&&(r!=="0")&&(q!=="0")){L.rx.baseVal._emToUnit(o);L.ry.baseVal._emToUnit(o);var k=L.rx.baseVal,j=L.ry.baseVal,T=L.width.baseVal.value,l=L.height.baseVal.value;k.value=r?k.value:j.value;j.value=q?j.value:k.value;if(k.value>T/2){k.value=T/2}if(j.value>l/2){j.value=l/2}var v=k.value,J=j.value,t=v*0.55228,s=J*0.55228,W=u-v,S=A+v,R=z+J,Q=X-J;O=["m",S,z,"l",W,z,"c",W+t,z,u,R-s,u,R,"l",u,Q,"c",u,Q+s,W+t,X,W,X,"l",S,X,"c",S-t,X,A,Q+s,A,Q,"l",A,R,"c",A,R-s,S-t,z,S,z]}else{O=["m",A,z,"l",A,X,u,X,u,z,"x e"]}var D=L.ownerDocument.documentElement,V=L.getScreenCTM(),P,G,F,C=L._tar,U=L.ownerDocument.documentElement,B=U.width.baseVal.value,M=U.height.baseVal.value,H=Math.round;for(var K=0,I=O.length;K<I;){if(isNaN(O[K])){++K;continue}G=D.createSVGPoint();G.x=O[K];G.y=O[K+1];F=G.matrixTransform(V);O[K]=H(F.x);++K;O[K]=H(F.y);++K;G=F=void 0}P=O.join(" ");C.path=P;C.coordsize=B+" "+M;NAIBU._setPaint(L,V);delete L._cacheMatrix;E=L=N=O=H=P=C=U=o=void 0},false);e=d=void 0},false)}SVGRectElement.prototype=Object._create(SVGElement);function SVGCircleElement(c){SVGElement.apply(this);this._tar=c.createElement("v:shape");var b=SVGAnimatedLength;this.cx=new b();this.cy=new b();this.r=new b();c=b=void 0;this.addEventListener("DOMNodeInserted",function(e){var d=e.target;if(e.eventPhase===3){return}var i=d.nextSibling,f=d.parentNode._tar,g=true;if(i&&i._tar&&f&&(i._tar.parentNode===f)){f.insertBefore(d._tar,i._tar)}else{if(i&&!i._tar&&f){while(i){if(i._tar&&(i._tar.parentNode===f)){f.insertBefore(d._tar,i._tar);g=false}i=i.nextSibling}if(g){f.appendChild(d._tar)}}else{if(!i&&f){f.appendChild(d._tar)}}}i=f=g=void 0;d.addEventListener("DOMNodeInsertedIntoDocument",function(A){var H=A.target,J=H.ownerDocument.defaultView.getComputedStyle(H,""),k=parseFloat(J.getPropertyValue("font-size"));H.cx.baseVal._emToUnit(k);H.cy.baseVal._emToUnit(k);H.r.baseVal._emToUnit(k);var l=H.cx.baseVal.value,j=H.cy.baseVal.value,q=ry=H.r.baseVal.value,B=j-ry,o=l-q,t=j+ry,M=l+q,s=q*0.55228,r=ry*0.55228,K=["m",l,B,"c",l-s,B,o,j-r,o,j,o,j+r,l-s,t,l,t,l+s,t,M,j+r,M,j,M,j-r,l+s,B,l,B,"x e"];var z=H.ownerDocument.documentElement,O=H.getScreenCTM(),E=Math.round;for(var G=0,F=K.length;G<F;){if(isNaN(K[G])){++G;continue}var D=z.createSVGPoint();D.x=K[G];D.y=K[G+1];var C=D.matrixTransform(O);K[G]=E(C.x);++G;K[G]=E(C.y);++G;D=C=void 0}var L=K.join(" "),v=H._tar,N=H.ownerDocument.documentElement,u=N.width.baseVal.value,I=N.height.baseVal.value;v.path=L;v.coordsize=u+" "+I;NAIBU._setPaint(H,O);delete H._cacheMatrix;A=H=K=E=J=k=L=v=void 0},false);e=d=void 0},false)}SVGCircleElement.prototype=Object._create(SVGElement);function SVGEllipseElement(c){SVGElement.apply(this);this._tar=c.createElement("v:shape");var b=SVGAnimatedLength;this.cx=new b();this.cy=new b();this.rx=new b();this.ry=new b();c=b=void 0;this.addEventListener("DOMNodeInserted",function(e){var d=e.target;if(e.eventPhase===3){return}var i=d.nextSibling,f=d.parentNode._tar,g=true;if(i&&i._tar&&f&&(i._tar.parentNode===f)){f.insertBefore(d._tar,i._tar)}else{if(i&&!i._tar&&f){while(i){if(i._tar&&(i._tar.parentNode===f)){f.insertBefore(d._tar,i._tar);g=false}i=i.nextSibling}if(g){f.appendChild(d._tar)}}else{if(!i&&f){f.appendChild(d._tar)}}}i=f=g=void 0;d.addEventListener("DOMNodeInsertedIntoDocument",function(B){var I=B.target,K=I.ownerDocument.defaultView.getComputedStyle(I,""),k=parseFloat(K.getPropertyValue("font-size"));I.cx.baseVal._emToUnit(k);I.cy.baseVal._emToUnit(k);I.rx.baseVal._emToUnit(k);I.ry.baseVal._emToUnit(k);var l=I.cx.baseVal.value,j=I.cy.baseVal.value,r=I.rx.baseVal.value,q=I.ry.baseVal.value,C=j-q,o=l-r,u=j+q,N=l+r,t=r*0.55228,s=q*0.55228,L=["m",l,C,"c",l-t,C,o,j-s,o,j,o,j+s,l-t,u,l,u,l+t,u,N,j+s,N,j,N,j-s,l+t,C,l,C,"x e"];var A=I.ownerDocument.documentElement,P=I.getScreenCTM(),F=Math.round;for(var H=0,G=L.length;H<G;){if(isNaN(L[H])){++H;continue}var E=A.createSVGPoint();E.x=L[H];E.y=L[H+1];var D=E.matrixTransform(P);L[H]=F(D.x);++H;L[H]=F(D.y);++H;E=D=void 0}var M=L.join(" "),z=I._tar,O=I.ownerDocument.documentElement,v=O.width.baseVal.value,J=O.height.baseVal.value;z.path=M;z.coordsize=v+" "+J;NAIBU._setPaint(I,P);delete I._cacheMatrix;B=z=I=K=k=M=L=F=P=v=J=void 0},false);e=d=void 0},false)}SVGEllipseElement.prototype=Object._create(SVGElement);function SVGLineElement(c){SVGElement.apply(this);this._tar=c.createElement("v:shape");var b=SVGAnimatedLength;this.x1=new b();this.y1=new b();this.x2=new b();this.y2=new b();c=b=void 0;this.addEventListener("DOMNodeInserted",function(e){var d=e.target;if(e.eventPhase===3){return}var i=d.nextSibling,f=d.parentNode._tar,g=true;if(i&&i._tar&&f&&(i._tar.parentNode===f)){f.insertBefore(d._tar,i._tar)}else{if(i&&!i._tar&&f){while(i){if(i._tar&&(i._tar.parentNode===f)){f.insertBefore(d._tar,i._tar);g=false}i=i.nextSibling}if(g){f.appendChild(d._tar)}}else{if(!i&&f){f.appendChild(d._tar)}}}i=f=g=void 0;d.addEventListener("DOMNodeInsertedIntoDocument",function(v){var t=v.target,j=t.ownerDocument.defaultView.getComputedStyle(t,""),B=parseFloat(j.getPropertyValue("font-size"));t.x1.baseVal._emToUnit(B);t.y1.baseVal._emToUnit(B);t.x2.baseVal._emToUnit(B);t.y2.baseVal._emToUnit(B);var q=t.ownerDocument.documentElement,r=t.getScreenCTM(),z="m ",l=Math.round,k=q.createSVGPoint();k.x=t.x1.baseVal.value;k.y=t.y1.baseVal.value;var o=k.matrixTransform(r);z+=l(o.x)+" "+l(o.y)+" l ";k.x=t.x2.baseVal.value;k.y=t.y2.baseVal.value;o=k.matrixTransform(r);z+=l(o.x)+" "+l(o.y);k=o=void 0;var A=t._tar,u=q.width.baseVal.value,s=q.height.baseVal.value;A.path=z;A.coordsize=u+" "+s;NAIBU._setPaint(t,r);delete t._cacheMatrix;v=A=t=j=B=z=list=l=r=q=u=s=void 0},false);e=d=void 0},false)}SVGLineElement.prototype=Object._create(SVGElement);NAIBU._GenericSVGPolyElement=function(c,b){SVGElement.apply(this);this._tar=c.createElement("v:shape");c=void 0;this.animatedPoints=this.points=new SVGPointList();this.addEventListener("DOMAttrModified",function(e){var d=e.target;if(e.attrName==="points"){var o=d.points,j=d.ownerDocument.documentElement,k=e.newValue.replace(/^\s+|\s+$/g,"").replace(/\-/g," -").split(/[\s,]+/);for(var g=0,l,f=k.length;g<f;g+=2){if(isNaN(k[g])){--g;continue}l=j.createSVGPoint();l.x=parseFloat(k[g]);l.y=parseFloat(k[g+1]);o.appendItem(l)}}e=d=k=o=j=l=void 0},false);this.addEventListener("DOMNodeInserted",function(e){var d=e.target;if(e.eventPhase===3){return}var i=d.nextSibling,f=d.parentNode._tar,g=true;if(i&&i._tar&&f&&(i._tar.parentNode===f)){f.insertBefore(d._tar,i._tar)}else{if(i&&!i._tar&&f){while(i){if(i._tar&&(i._tar.parentNode===f)){f.insertBefore(d._tar,i._tar);g=false}i=i.nextSibling}if(g){f.appendChild(d._tar)}}else{if(!i&&f){f.appendChild(d._tar)}}}i=f=g=void 0;d.addEventListener("DOMNodeInsertedIntoDocument",function(z){var t=z.target,v=t.points,r=t.getScreenCTM(),k=Math.round;for(var q=0,u=[],s=v.numberOfItems;q<s;++q){var j=v.getItem(q),o=j.matrixTransform(r);u[2*q]=k(o.x);u[2*q+1]=k(o.y);j=o=void 0}u.splice(2,0,"l");var A="m"+u.join(" ")+b,B=t._tar,l=t.ownerDocument.documentElement;w=l.width.baseVal.value,h=l.height.baseVal.value;B.path=A;B.coordsize=w+" "+h;NAIBU._setPaint(t,r);delete t._cacheMatrix;z=B=t=A=u=k=r=w=h=l=void 0},false);e=d=void 0},false)};function SVGPolylineElement(b){NAIBU._GenericSVGPolyElement.call(this,b,"e");b=void 0}SVGPolylineElement.prototype=Object._create(SVGElement);function SVGPolygonElement(b){NAIBU._GenericSVGPolyElement.call(this,b,"x e");b=void 0}SVGPolygonElement.prototype=Object._create(SVGElement);function SVGTextContentElement(b){SVGElement.apply(this);this.textLength=new SVGAnimatedLength();this.lengthAdjust=new SVGAnimatedEnumeration(0);this.addEventListener("DOMNodeInserted",function(p){var j=p.target,o=p.currentTarget,g=p.eventPhase;if((g===1)&&(j.localName==="a")&&(j.namespaceURI==="http://www.w3.org/2000/svg")&&j.firstChild){j=j.firstChild}if((g===1)&&(j.nodeType===3)&&!!!j._tars){j._tars=[];var e=j.data.replace(/^[\r\n\s]+|[\r\n\s]+$/g,"").replace(/[\r\n\s]+/g," ");j.data=e;j.length=e.length;e=e.split("");for(var f=0,c=e.length;f<c;++f){var k=b.createElement("div"),l=k.style;l.position="absolute";l.textIndent=l.marginLeft=l.marginRight=l.marginTop=l.paddingTop=l.paddingLeft="0px";l.whiteSpace="nowrap";k.appendChild(b.createTextNode(e[f]));j._tars[j._tars.length]=k}e=void 0}p=j=o=g=void 0},true);this.addEventListener("DOMNodeRemoved",function(d){var c=d.target;if(d.eventPhase===3){delete d.currentTarget._length;c=d=void 0}},false)}(function(b){b.prototype=Object._create(SVGElement);b.prototype._list=null;b.prototype._length=null;b.prototype._stx=b.prototype._sty=0;b.prototype._chars=0;b.prototype._isYokogaki=true;b.prototype.getNumberOfChars=function(){if(this._length){return(this._length)}else{var c=0,d=function(e){while(e){if(e.length&&(e.nodeType===3)){c+=e.length}else{if(e.getNumberOfChars){c+=e.getNumberOfChars()}else{if(e.firstChild&&(e.nodeType===1)){d(e.firstChild)}}}e=e.nextSibling}e=void 0};d(this.firstChild);this._length=c;return c}};b.prototype.getComputedTextLength=function(){var c=this.textLength.baseVal;if((c.value===0)&&(this.getNumberOfChars()>0)){c.newValueSpecifiedUnits(1,this.getSubStringLength(0,this.getNumberOfChars()))}c=void 0;return(this.textLength.baseVal.value)};b.prototype.getSubStringLength=function(e,i){if(i===0){return 0}var g=this.getNumberOfChars();if(g<(i+e)){i=g-e+1}var c=this.getEndPositionOfChar(i+e-1),d=this.getStartPositionOfChar(e);if(this._isYokogaki){var f=c.x-d.x}else{var f=c.y-d.y}g=c=d=void 0;return f};b.prototype.getStartPositionOfChar=function(d){if(d>this.getNumberOfChars()||d<0){throw (new DOMException(1))}else{var M=this,l=M.firstChild,g=M.parentNode;if(!!!M._list){M._list=[];var C=M._chars,A=M._stx,z=M._sty,F=0,N=M.ownerDocument.defaultView.getComputedStyle(M,null),t=((N.getPropertyValue("writing-mode"))==="lr-tb")?true:false,k=parseFloat(N.getPropertyValue("font-size")),R=M.x.baseVal,Q=M.y.baseVal,G=M.dx.baseVal,E=M.dy.baseVal;if(g&&((g.localName==="text")||(g.localName==="tspan"))){var P=g.x.baseVal,O=g.y.baseVal,u=g.dx.baseVal,r=g.dy.baseVal}else{var P=O=u=r={numberOfItems:0}}var o="f ijltIr.,:;'-\"()",j="1234567890abcdeghknopquvxyz",c,f,e,H,D,K,J,v,q;if(t&&(M.localName==="text")){z+=k*0.2}else{if(M.localName==="text"){A-=k*0.5}}while(l){if(l.nodeType===3){c=l._tars;for(var L=0,I=c.length;L<I;++L){if(F<P.numberOfItems-C){A=P.getItem(F).value;if(!t){A-=k*0.5}}else{if(F<R.numberOfItems){A=R.getItem(F).value;if(!t){A-=k*0.5}}}if(F<O.numberOfItems-C){z=O.getItem(F).value;if(t){z+=k*0.2}}else{if(F<Q.numberOfItems){z=Q.getItem(F).value;if(t){z+=k*0.2}}}if(F<u.numberOfItems-C){A+=u.getItem(F).value}else{if(F<G.numberOfItems){A+=G.getItem(F).value}}if(F<r.numberOfItems-C){z+=r.getItem(F).value}else{if(F<E.numberOfItems){z+=E.getItem(F).value}}f=0;if(t){e=l.data.charAt(L);if(o.indexOf(e)>-1){f=k*0.68}else{if(e==="s"){f=k*0.52}else{if((e==="C")||(e==="D")||(e==="M")||(e==="W")||(e==="G")||(e==="m")){f=k*0.2}else{if(j.indexOf(e)>-1){f=k*0.45}else{f=k*0.3}}}}H=e.charCodeAt(0);if((12288<=H)&&(H<=65533)){f=-k*0.01;if((e==="う")||(e==="く")||(e==="し")||(e==="ち")){f+=k*0.2}}}v=M._list;v[v.length]=A;v[v.length]=z;v[v.length]=k-f;if(t){A+=k;A-=f}else{z+=k}++F}C+=I;if(l.parentNode&&(l.parentNode.localName==="a")){l=l.parentNode}l=l.nextSibling}else{if(((l.localName==="tspan")||(l.localName==="tref"))&&(l.namespaceURI==="http://www.w3.org/2000/svg")&&l.firstChild){l._stx=A;l._sty=z;l._chars=C;D=l.getStartPositionOfChar(l.getNumberOfChars());K=0;J=0;v=l._list;if(t){K=v[v.length-1]}else{J=v[v.length-1]}A=v[v.length-3]+K;z=v[v.length-2]+J;M._list=M._list.concat(v);q=l.getNumberOfChars();F+=q;C+=q;l=l.nextSibling}else{if((l.localName==="a")&&(l.namespaceURI==="http://www.w3.org/2000/svg")&&l.firstChild){l=l.firstChild}else{l=l.nextSibling}}}}M._isYokogaki=t}M=l=g=P=O=R=Q=C=N=A=z=t=o=j=c=f=e=H=D=K=J=v=q=void 0;var B=this.ownerDocument.documentElement.createSVGPoint();B.x=this._list[d*3];B.y=this._list[d*3+1];B=B.matrixTransform(this.getScreenCTM());return B}};b.prototype.getEndPositionOfChar=function(c){if(c>this.getNumberOfChars()||c<0){throw (new DOMException(1))}else{var d=this.getStartPositionOfChar(c);var e=this._list[c*3+2]*Math.sqrt(Math.abs(this.getScreenCTM()._determinant()));if(this._isYokogaki){d.x+=e}else{d.y+=e}return d}};b.prototype.getExtentOfChar=function(c){};b.prototype.getRotationOfChar=function(c){};b.prototype.getCharNumAtPosition=function(c){};b.prototype.selectSubString=function(c,d){}})(SVGTextContentElement);function SVGTextPositioningElement(c){SVGTextContentElement.apply(this,arguments);var b=SVGAnimatedLengthList;this.x=new b();this.y=new b();this.dx=new b();this.dy=new b();b=void 0;this.rotate=new SVGAnimatedNumberList();this.addEventListener("DOMAttrModified",function(t){var o=t.target,f=t.attrName,k=o.ownerDocument.documentElement,j=parseFloat;if((f==="x")||(f==="y")||(f==="dx")||(f==="dy")){var q=t.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/),u=o[f].baseVal;for(var l=0,e=q.length;l<e;++l){var r=k.createSVGLength(),g=q[l].slice(-1),p=0;if(g>="0"&&g<="9"){p=1}else{if(g==="%"){if((f==="x")||(f==="dx")){r._percent*=k.viewport.width}else{if((f==="y")||(f==="dy")){r._percent*=k.viewport.height}}p=2}else{g=q[l].slice(-2);if(g==="em"){var d=o.ownerDocument.defaultView.getComputedStyle(o,null);r._percent*=j(d.getPropertyValue("font-size"));d=void 0;p=3}else{if(g==="ex"){p=4}else{if(g==="px"){p=5}else{if(g==="cm"){p=6}else{if(g==="mm"){p=7}else{if(g==="in"){p=8}else{if(g==="pt"){p=9}else{if(g==="pc"){p=10}}}}}}}}}}var v=j(q[l]);v=isNaN(v)?0:v;r.newValueSpecifiedUnits(p,v);u.appendItem(r)}o._list=null}t=o=void 0},false);this.addEventListener("DOMNodeInserted",function(e){if(e.eventPhase===3){var d=e.target;if(d.nodeType!==3){d._list=void 0;e.currentTarget._list=null}e=d=void 0}},false);if(c){this._tar=c.createElement("v:group");this._doc=c}this.addEventListener("DOMNodeInserted",function(e){if(e.eventPhase===3){return}var d=e.target,i=d.nextSibling,f=d.parentNode._tar,g=true;if(i&&i._tar&&f&&(i._tar.parentNode===f)){f.insertBefore(d._tar,i._tar)}else{if(i&&!i._tar&&f){while(i){if(i._tar&&(i._tar.parentNode===f)){f.insertBefore(d._tar,i._tar);g=false}i=i.nextSibling}if(g){f.appendChild(d._tar)}}else{if(!i&&f){f.appendChild(d._tar)}}}i=f=g=void 0;d.addEventListener("DOMNodeInsertedIntoDocument",d._texto,false);e=d=void 0},false)}SVGTextPositioningElement.prototype=Object._create(SVGTextContentElement);SVGTextPositioningElement.prototype._texto=function(J){var M=J.target,b=M.firstChild,F=M._tar,O=M.ownerDocument.defaultView.getComputedStyle(M,null),D=Math.sqrt(Math.abs(M.getScreenCTM()._determinant())),P=parseFloat(O.getPropertyValue("font-size"))*D,u=M.ownerDocument.documentElement,K=F,W=M.getComputedTextLength(),f=O.getPropertyValue("text-anchor"),d=O.getPropertyValue("text-decoration"),B=F.style,t=[],A=parseFloat(O.getPropertyValue("letter-spacing")),v=parseFloat(O.getPropertyValue("word-spacing"));B.fontSize=P+"px";B.fontFamily=O.getPropertyValue("font-family");B.fontStyle=O.getPropertyValue("font-style");B.fontWeight=O.getPropertyValue("font-weight");if(isFinite(A)){B.letterSpacing=A*D+"px"}if(isFinite(parseFloat(v))){B.wordSpacing=v*D+"px"}for(var V=0,U=0,r=M.getNumberOfChars();V<r;++V){if(b){if(!!b._tars&&(b._tars.length!==0)){var L=(V>U)?V-U:U-V;var H=b._tars[L].style,N=M.getStartPositionOfChar(V);H.position="absolute";if(M._isYokogaki){if(f==="middle"){N.x-=W/2}else{if(f==="end"){N.x-=W}}}else{if(f==="middle"){N.y-=W/2}else{if(f==="end"){N.y-=W}}}H.left=N.x+"px";H.top=N.y+"px";H.width="0px";H.height="0px";H.marginTop=M._isYokogaki?-P-5+"px":"-5px";H.lineHeight=P+10+"px";H.textDecoration=d;H.display="none";F.appendChild(b._tars[L]);H=N=void 0}if(b.nodeName==="#text"){if((b.data.length+U)<=V+1){U=U+b.data.length;if(b.data===""){--V}if(b.parentNode.localName==="a"){b=b.parentNode;F=K}b=b.nextSibling}}else{if(!!b.getNumberOfChars){if((b.getNumberOfChars()+U)<=V+1){U=U+b.getNumberOfChars();b=b.nextSibling}}else{if((b.localName==="a")&&(b.namespaceURI==="http://www.w3.org/2000/svg")&&b.firstChild){F=b._tar;b=b.firstChild;t[t.length]=b;if(V===0){--V}else{V-=2}}}}}}var G=O.getPropertyValue("fill"),g=O.getPropertyCSSValue("cursor"),S=O.getPropertyCSSValue("visibility"),q=O.getPropertyCSSValue("display"),E=M._tar.style,c=M.firstChild._tars,C=c[0]?c[0].innerText.charAt(0):"",Q,I=function(p){if(M._isYokogaki&&(M.firstChild.nodeName==="#text")){var l=M;while(M.x){if(M.x&&(M.localName!=="a")&&((M.x.baseVal.numberOfItems>1)||(M.y.baseVal.numberOfItems>1))){return}M=M.parentNode}M=l;for(var j=1,X=p.length;j<X;++j){Q=p[j];C+=Q.innerText;Q.parentNode.removeChild(Q)}if(p[0]&&p[0].replaceChild){p[0].replaceChild(M._doc.createTextNode(C),p[0].firstChild)}l=C=void 0}};I(c);if(G==="none"){E.color="transparent"}else{if(G.indexOf("url")===-1){E.color=G}else{E.color="black"}}if(g&&!g._isDefault){var e=g.cssText;E.cursor=e.split(":")[1];e=void 0}var k=true,s="block";if(F.lastChild){if(F.lastChild.nodeName!=="rect"){k=false}}else{k=false}if(!k){var z=M._doc.createElement("v:rect"),T=z.style;T.width=T.height="1px";T.left=T.top="0px";z.stroked=z.filled="false";F.appendChild(z)}if(S&&!S._isDefault){E.visibility=S.cssText.split(":")[1]}if(q&&!q._isDefault&&(q.cssText.indexOf("none")>-1)){s="none"}else{if(q&&!q._isDefault){s="block"}}var o=M._tar.firstChild,U=0;while(o){o.style.display=s;o=o.nextSibling}while(t[U]){c=t[U]._tars;C=c[0]?c[0].innerText.charAt(0):"";I(c);for(var R=0,r=c.length;R<r;++R){c[R].style.display=s}R=void 0;++U}delete M._cacheMatrix;I=t=k=J=M=O=d=tpp=K=O=G=g=q=S=B=z=T=s=c=o=A=D=void 0};function SVGTextElement(b){SVGTextPositioningElement.apply(this,arguments)}SVGTextElement.prototype=Object._create(SVGTextPositioningElement);function SVGTSpanElement(){SVGTextElement.apply(this,arguments)}SVGTSpanElement.prototype=Object._create(SVGTextPositioningElement);function SVGTRefElement(b){SVGTextPositioningElement.apply(this,arguments);this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===3){return}c.target.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed")},false);this.addEventListener("S_Load",function(d){var c=d.target,e=c._instance.firstChild;while(e&&(e.nodeName!=="#text")){e=e.nextSibling}e&&c.parentNode.insertBefore(c.ownerDocument.importNode(e,false),c);d.target=c.parentNode;c.parentNode._texto(d);c=e=evtt=void 0},false);SVGURIReference.apply(this)}SVGTRefElement.prototype=Object._create(SVGTextPositioningElement);function SVGTextPathElement(){SVGTextContentElement.apply(this,arguments);this.startOffset;this.method;this.spacing;SVGURIReference.apply(this)}SVGTextPathElement.prototype=Object._create(SVGTextContentElement);(function(b){})(SVGTextPathElement);function SVGPaint(){SVGColor.apply(this)}(function(b){b.prototype=Object._create(SVGColor);b.prototype.paintType=0;b.prototype.uri=null;b.prototype.setUri=function(c){this.setPaint(103,c,null,null)};b.prototype.setPaint=function(c,e,d,f){if((c<101&&e)||(c>102&&!e)){throw new SVGException(1)}this.uri=e;this.paintType=c;if(c===102){c=3}this.setColor(c,d,f)};b=void 0})(SVGPaint);function SVGMarkerElement(){SVGSVGElement.apply(this,[{createElement:function(){}}]);this._tar={style:{}};var b=SVGAnimatedLength;this.refX=new b();this.refY=new b();this.markerUnits=new SVGAnimatedEnumeration();this.markerUnits.baseVal=2;this.markerWidth=new b();this.markerHeight=new b();this.refX.baseVal.newValueSpecifiedUnits(1,0);this.refY.baseVal.newValueSpecifiedUnits(1,0);this.markerWidth.baseVal.newValueSpecifiedUnits(1,3);this.markerHeight.baseVal.newValueSpecifiedUnits(1,3);b=void 0;this.orientType=new SVGAnimatedEnumeration();this.orientType.baseVal=2;this.orientAngle=new SVGAnimatedAngle();this.addEventListener("DOMAttrModified",function(d){var c=d.target,e=d.newValue,f;if(d.attrName==="orient"){if(e==="auto"){c.setOrientToAuto()}else{f=c.ownerDocument.documentElement.createSVGAngle();f.newValueSpecifiedUnits(1,+e);c.setOrientToAngle(f)}}else{if(d.attrName==="markerUnits"){if(e==="strokeWidth"){c.markerUnits.baseVal=2}else{c.markerUnits.baseVal=1}}}},false);this.addEventListener("DOMNodeInsertedIntoDocument",function(c){var d=NAIBU._setPaint,e=c.target.getAttributeNS(null,"id");NAIBU._setPaint=(function(f,g){return function(E,J){f(E,J);var r=E.ownerDocument,j=r.documentElement,F=r.defaultView.getComputedStyle(E,""),D=F.getPropertyValue("marker-start").slice(5,-1),L=F.getPropertyValue("marker-end").slice(5,-1),H=F.getPropertyValue("marker-mid").slice(5,-1),q,s,l,i,k,o,G,J,I,p,K,A,C,v,z,B=function(t,M){s=q.cloneNode(true);l=r.createElementNS("http://www.w3.org/2000/svg","g");while(s.lastChild){l.appendChild(s.lastChild)}i=l.transform.baseVal;o=E.transform.baseVal.consolidate()||r.documentElement.createSVGMatrix();if(q.markerUnits.baseVal===2){G=+F.getPropertyValue("stroke-width")}else{G=1}if(q.hasAttributeNS(null,"viewBox")){q.viewport.width=q.markerWidth.baseVal.value;q.viewport.height=q.markerHeight.baseVal.value;J=j.getScreenCTM.apply(q)}else{J=j.createSVGMatrix()}if(q.orientType.baseVal===1){angle=Math.atan2(K[1].y-K[0].y,K[1].x-K[0].x)*180/Math.PI}else{angle=q.orientAngle.baseVal.value}i.appendItem(i.createSVGTransformFromMatrix(o.translate(t,M).rotate(angle).scale(G).multiply(J).translate(-q.refX.baseVal.value,-q.refY.baseVal.value)));I=r.defaultView.getComputedStyle(q,"");p=l.style;A=/([A-Z])/;C=/\-/;for(var u in CSS2Properties){if(CSS2Properties.hasOwnProperty(u)&&(u!=="_list")){u=u.replace(A,"-");if(RegExp.$1){v="-"+RegExp.$1.toLowerCase()}else{v="-"}u=u.replace(C,v);p.setProperty(u,I.getPropertyValue(u),"")}}E.parentNode.insertBefore(l,E.nextSibling)};if(D===g){q=r.getElementById(D);if(E.normalizedPathSegList||E.points){k=E.normalizedPathSegList||E.points;K=[k.getItem(0),k.getItem(1)]}else{if(E.x1){K=[{x:E.x1,y:E.y1},{x:E.x2,y:E.y2}]}}B(K[0].x,K[0].y)}if(L===g){q=r.getElementById(L);if(E.normalizedPathSegList||E.points){k=E.normalizedPathSegList||E.points;K=[k.getItem(k.numberOfItems-2),k.getItem(k.numberOfItems-1)]}else{if(E.x1){K=[{x:E.x1,y:E.y1},{x:E.x2,y:E.y2}]}}B(K[1].x,K[1].y)}if(H===g){q=r.getElementById(H)}r=j=F=I=p=D=L=H=q=s=l=J=G=i=k=o=K=A=C=v=z=B=void 0}})(d,e)},false)}(function(b){b.prototype=Object._create(SVGSVGElement);b.prototype.getScreenCTM=SVGElement.prototype.getScreenCTM;b.prototype.setOrientToAuto=function(){this.orientType.baseVal=1};b.prototype.setOrientToAngle=function(c){this.orientType.baseVal=2;this.orientAngle.baseVal=c}})(SVGMarkerElement);function SVGColorProfileElement(){SVGElement.apply(this);this._local;this.name;this.renderingIntent;SVGURIReference.apply(this)}SVGColorProfileElement.prototype=Object._create(SVGElement);function SVGColorProfileRule(){SVGCSSRule.apply(this);this.src;this.name;this.renderingIntent}SVGColorProfileRule.prototype=Object._create(SVGCSSRule);function SVGGradientElement(){SVGElement.apply(this);SVGURIReference.apply(this);this.gradientUnits=new SVGAnimatedEnumeration();this.gradientTransform=new SVGAnimatedTransformList();this.spreadMethod=new SVGAnimatedEnumeration();this.addEventListener("DOMNodeInsertedIntoDocument",function(o){var e=o.target,k=o._tar,l=o._style,c=e,z,f,d,r=[],g=[],b=[],q,A,j,u,s;if(!k||!e){e=k=l=c=z=f=d=r=g=b=void 0;return}if(e._instance){c=e._instance}f=c.getElementsByTagNameNS("http://www.w3.org/2000/svg","stop");if(!f){k=l=z=e=c=f=r=g=b=void 0;return}d=f.length;for(var v=0;v<d;++v){q=f[v];A=q.ownerDocument.defaultView.getComputedStyle(q,"");j=A.getPropertyCSSValue("stop-color");if(j&&(j.colorType===3)){A.setProperty("color",A.getPropertyValue("color"))}r[v]="rgb("+j.rgbColor.red.getFloatValue(1)+","+j.rgbColor.green.getFloatValue(1)+","+j.rgbColor.blue.getFloatValue(1)+")";g[v]=q.offset.baseVal.toPrecision(2)+" "+r[v];b[v]=(A.getPropertyValue("stop-opacity")||1)*l.getPropertyValue("fill-opacity")*l.getPropertyValue("opacity")}k.method="none";k.color=r[0];k.color2=r[d-1];if(d>2){k.colors=g.slice(1,-1).join(",");u=b[d-1]+"";s=b[0]+""}else{s=b[d-1]+"";u=b[0]+""}k.opacity=u;k["o:opacity2"]=s;e._color=r;var p=c.getAttributeNS(null,"gradientTransform");if(p){e.setAttributeNS(null,"transform",p)}e=c=k=f=d=r=g=b=o=l=z=q=A=j=u=s=void 0},false)}SVGGradientElement.prototype=Object._create(SVGElement);function SVGLinearGradientElement(){SVGGradientElement.apply(this);var b=SVGAnimatedLength;this.x1=new b();this.y1=new b();this.x2=new b();this.y2=new b();b=void 0;this.addEventListener("DOMNodeInsertedIntoDocument",function(c){var i=c.target,f=c._tar,g=270;if(!!!f){return}var d=i.ownerDocument.defaultView.getComputedStyle(i,"");var e=parseFloat(d.getPropertyValue("font-size"));i.x1.baseVal._emToUnit(e);i.y1.baseVal._emToUnit(e);i.x2.baseVal._emToUnit(e);i.y2.baseVal._emToUnit(e);g=270-Math.atan2(i.y2.baseVal.value-i.y1.baseVal.value,i.x2.baseVal.value-i.x1.baseVal.value)*180/Math.PI;if(g>=360){g-=360}f.setAttribute("type","gradient");f.setAttribute("angle",g+"");c=f=i=g=d=e=void 0},false)}SVGLinearGradientElement.prototype=Object._create(SVGGradientElement);function SVGRadialGradientElement(c){SVGGradientElement.apply(this);var b=SVGAnimatedLength;this.cx=new b();this.cy=new b();this.r=new b();this.fx=new b();this.fy=new b();b=void 0;this.cx.baseVal.value=this.cy.baseVal.value=this.r.baseVal.value=0.5;this.addEventListener("DOMNodeInsertedIntoDocument",function(C){var o=C.target,Y=C._tar,E=C._ttar;if(!!!Y){return}Y.setAttribute("type","gradientTitle");Y.setAttribute("focus","100%");Y.setAttribute("focusposition","0.5 0.5");if(E.localName==="rect"){var M=o.ownerDocument.defaultView.getComputedStyle(E,""),l=parseFloat(M.getPropertyValue("font-size"));o.cx.baseVal._emToUnit(l);o.cy.baseVal._emToUnit(l);o.r.baseVal._emToUnit(l);o.fx.baseVal._emToUnit(l);o.fy.baseVal._emToUnit(l);var z=o.cx.baseVal.value,u=o.cy.baseVal.value,I=o.r.baseVal.value,f=Math.round,B,A;B=A=I;var G=E.getBBox(),s=E.ownerDocument.documentElement.viewport,U=f(s.width),J=f(s.height),O=0,d=0,V=o.getAttributeNS(null,"gradientUnits");if(!V||V==="objectBoundingBox"){z=z>1?z/100:z;u=u>1?u/100:u;I=I>1?I/100:I;var P=G.x,L=G.y,T=G.width,R=G.height;z=z*T+P;u=u*R+L;B=I*T;A=I*R;P=L=T=R=void 0}var D=E.getScreenCTM().multiply(o.getCTM());U=z-B;J=u-A;O=z+B;d=u+A;var k=B*0.55228,j=A*0.55228,v=["m",z,J,"c",z-k,J,U,u-j,U,u,U,u+j,z-k,d,z,d,z+k,d,O,u+j,O,u,O,u-j,z+k,J,z,J,"x e"];for(var Q=0,N=v.length;Q<N;){if(isNaN(v[Q])){++Q;continue}var K=o.ownerDocument.documentElement.createSVGPoint();K.x=parseFloat(v[Q]);K.y=parseFloat(v[Q+1]);var g=K.matrixTransform(D);v[Q]=f(g.x);Q++;v[Q]=f(g.y);Q++;K=g=void 0}var X=v.join(" "),e=c.getElementById("_NAIBU_outline"),F=c.createElement("div"),t=F.style;t.position="absolute";t.display="inline-block";var H=s.width,S=s.height;t.textAlign="left";t.top=t.left="0px";t.width=H+"px";t.height=S+"px";e.appendChild(F);t.filter="progid:DXImageTransform.Microsoft.Compositor";F.filters.item("DXImageTransform.Microsoft.Compositor").Function=23;var q='<v:shape style="display:inline-block; position:relative; antialias:false; top:0px; left:0px;" coordsize="'+H+" "+S+'" path="'+X+'" stroked="f">'+Y.outerHTML+"</v:shape>",W=E._tar.path.value;F.innerHTML='<v:shape style="display:inline-block; position:relative; top:0px; left:0px;" coordsize="'+H+" "+S+'" path="'+W+'" stroked="f" fillcolor="'+o._color[o._color.length-1]+'" ></v:shape>';F.filters[0].apply();F.innerHTML=q;F.filters[0].play();E._tar.parentNode.insertBefore(F,E._tar);E._tar.filled="false";X=e=F=M=l=t=q=W=v=f=gt=z=u=I=H=S=D=void 0}else{if(!Y.parentNode){E._tar.appendChild(Y)}}C=E=Y=gard=void 0},false)}SVGRadialGradientElement.prototype=Object._create(SVGGradientElement);function SVGStopElement(){SVGElement.apply(this);this.offset=new SVGAnimatedNumber();this.addEventListener("DOMAttrModified",function(b){if(b.attrName==="offset"){var c=b.newValue;if(c.slice(-1)!=="%"){b.target.offset.baseVal=+c}else{b.target.offset.baseVal=parseFloat(c)/100}}b=void 0},false)}SVGStopElement.prototype=Object._create(SVGElement);function SVGPatternElement(){SVGElement.apply(this);var b=SVGAnimatedLength;this.patternUnits=new SVGAnimatedEnumeration();this.patternContentUnits=new SVGAnimatedEnumeration();this.patternTransform=new SVGAnimatedTransformList();this.x=new b();this.y=new b();this.width=new b();this.height=new b();b=void 0;SVGURIReference.apply(this);this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.zoomAndPan=1}SVGPatternElement.prototype=Object._create(SVGElement);function SVGClipPathElement(){SVGElement.apply(this);this.clipPathUnits=new SVGAnimatedEnumeration()}SVGClipPathElement.prototype=Object._create(SVGElement);function SVGMaskElement(){SVGElement.apply(this);var b=SVGAnimatedLength;this.maskUnits=new SVGAnimatedEnumeration();this.maskContentUnits=new SVGAnimatedEnumeration();this.x=new b();this.y=new b();this.width=new b();this.height=new b();b=void 0}SVGMaskElement.prototype=Object._create(SVGElement);function SVGFilterElement(){SVGElement.apply(this);var b=SVGAnimatedLength;this.filterUnits=new SVGAnimatedEnumeration();this.primitiveUnits=new SVGAnimatedEnumeration();this.x=new b();this.y=new b();this.width=new b();this.height=new b();b=void 0;this.filterResX=new SVGAnimatedInteger();this.filterResY=new SVGAnimatedInteger();SVGURIReference.apply(this)}SVGFilterElement.prototype=Object._create(SVGElement);function SVGFilterPrimitiveStandardAttributes(c){SVGStylable.apply(this,arguments);this._tar=c;var b=SVGAnimatedLength;this.x=new b();this.y=new b();this.width=new b();this.height=new b();this.result=new b();b=void 0}SVGFilterPrimitiveStandardAttributes.prototype=Object._create(SVGStylable);function SVGFEBlendElement(){SVGElement.apply(this);this.in1=new SVGAnimatedString();this.in2=new SVGAnimatedString();this.mode=new SVGAnimatedEnumeration();this._fpsa=SVGFilterPrimitiveStandardAttributes(this)}SVGFEBlendElement.prototype=Object._create(SVGElement);function SVGFEGaussianBlurElement(){SVGElement.apply(this);this.in1=new SVGAnimatedString();this.stdDeviationX=new SVGAnimatedNumber();this.stdDeviationY=new SVGAnimatedNumber();this._fpsa=SVGFilterPrimitiveStandardAttributes(this)}SVGFEGaussianBlurElement.prototype=Object._create(SVGElement);SVGFEGaussianBlurElement.prototype.setStdDeviation=function(c,b){};function SVGCursorElement(){SVGElement.apply(this);this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();SVGURIReference.apply(this)}SVGCursorElement.prototype=Object._create(SVGElement);function SVGAElement(b){SVGElement.apply(this);this._tar=b.createElement("a");b=void 0;this.target=new SVGAnimatedString();this.target.baseVal="_self";this.addEventListener("DOMAttrModified",function(d){var c=d.target;if(d.eventPhase===3){return}if(d.attrName==="target"){c.target.baseVal=d.newValue}else{if(d.attrName==="xlink:title"){c._tar.setAttribute("title",d.newValue)}}d=void 0},false);this.addEventListener("DOMNodeInserted",function(d){var c=d.target;if(d.eventPhase===3){return}if(c.nextSibling){if(c.parentNode._tar&&c.nextSibling._tar){c.parentNode._tar.insertBefore(c._tar,c.nextSibling._tar)}}else{if(c.parentNode._tar){c.parentNode._tar.appendChild(c._tar)}}var f=c._tar.style;f.cursor="hand";f.left="0px";f.top="0px";f.textDecoration="none";f=void 0;var g=c.target.baseVal,e="replace";if(g==="_blank"){e="new"}c.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show",e);c._tar.style.color=c.ownerDocument.defaultView.getComputedStyle(c,"").getPropertyValue("fill");c=d=void 0},false);this.addEventListener("DOMNodeInsertedIntoDocument",function(d){var c=d.target;if(!!c._tar&&(c.nodeType===1)){var e=c._tar.style;e.cursor="hand";e.textDecoration="none";e=void 0}c=d=void 0;return},true);this.addEventListener("DOMNodeInsertedIntoDocument",function(d){var c=d.target;c._tar.setAttribute("target",c.target.baseVal);if(c.href.baseVal.indexOf(".svg")!==-1){c.addEventListener("click",function(f){var e=f.target,i=document.body,g,j;i.lastChild.innerHTML="<object data='"+e.href.baseVal.split("#")[0]+"' width='"+screen.width+"' height='"+screen.height+"' type='image/svg+xml'></object>";if(e.target.baseVal==="_self"){j=e.ownerDocument._iframe;j.parentNode.insertBefore(i.lastChild.firstChild,j);g=j.nextSibling;if(g&&(g.tagName==="OBJECT")){j.previousSibling.setAttribute("width",g.getAttribute("width"));j.previousSibling.setAttribute("height",g.getAttribute("height"));j.parentNode.removeChild(g)}g=NAIBU._search([j.previousSibling]);j.parentNode.removeChild(j)}else{i.appendChild(i.lastChild.firstChild);while(i.firstChild!==i.lastChild){i.removeChild(i.firstChild)}g=NAIBU._search([i.lastChild])}NAIBU.doc=new ActiveXObject("MSXML2.DomDocument");f.preventDefault();g._next={_init:(function(k){return(function(){document.title=k.getSVGDocument().title;k=void 0})})(g)};g._init();i=g=j=void 0},false)}c=void 0},false);SVGURIReference.apply(this)}SVGAElement.prototype=Object._create(SVGElement);function SVGViewElement(){SVGElement.apply(this);this.viewTarget=new SVGStringList();this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.zoomAndPan=1}SVGViewElement.prototype=Object._create(SVGElement);function SVGScriptElement(){SVGElement.apply(this);this.type;SVGURIReference.apply(this);this.addEventListener("DOMAttrModified",function(evt){if(evt.attrName==="type"){evt.target.type=evt.newValue}evt=void 0},false);this.addEventListener("S_Load",function(evt){var tar=evt.target,script=tar._text;var tod=tar.ownerDocument;NAIBU._temp_doc=tod;script=script.replace(/function\s+([^\s\(]+)\(/g,"document.$1 || (document.$1 = $1);function $1(");script="with({NAIBU:NAIBU, document:NAIBU._temp_doc, window:this}){(function(){"+script+"\n})();}";try{NAIBU.eval(script)}catch(e){script=script.replace(/([^a-zA-Z])document\./g,"$1NAIBU._temp_doc.");NAIBU.eval(script)}tar=evt=script=void 0},false);this.addEventListener("DOMNodeInserted",function(evt){var tar=evt.target;if(evt.eventPhase===3){if(tar.data&&/[a-z]/.test(tar.data)){evt.currentTarget._text=tar.data;evt=tar.ownerDocument.createEvent("SVGEvents");evt.initEvent("S_Load",false,false);evt.currentTarget.dispatchEvent(evt)}evt=tar=void 0;return}tar.addEventListener("DOMNodeInsertedIntoDocument",function(evt){var tar=evt.target;if(evt.eventPhase===2&&!tar.getAttributeNodeNS("http://www.w3.org/1999/xlink","xlink:href")){var evtt=tar.ownerDocument.createEvent("SVGEvents");evtt.initEvent("S_Load",false,false);evt.currentTarget.dispatchEvent(evtt)}tar=evt=evtt=void 0},false)},false)}SVGScriptElement.prototype=Object._create(SVGElement);function SVGEvent(){Event.apply(this)}SVGEvent.prototype=Object._create(Event);function SVGZoomEvent(){UIEvent.apply(this);this.zoomRectScreen=new SVGRect();this.previousScale=this.newScale=1;this.previousTranslate=new SVGPoint();this.newTranslate=new SVGPoint()}SVGZoomEvent.prototype=Object._create(UIEvent);function SVGAnimationElement(){SVGElement.apply(this);this.style.setProperty=function(){};this._tar=null;this.targetElement;this._begin=this._end=this._repeatCount=this._repeatDur=this._dur=this._resatrt=null;this._currentFrame=0;this._isRepeat=false;this._numRepeat=0;this._isStarted=false;this._start=this._finish=this._starting=null;this._activeDur=0;this._from=this._to=this._values=this._by=null;this._keyTimes=null;this.addEventListener("beginEvent",function(r){try{var k=r.target,c=k.getStartTime(),l=k._dur,b=k._getOffset(l),g=k._finish,p=k._end,d=k._repeatDur,f=k._repeatCount,s=null;if(g){for(var j=0,q=g.length;j<q;++j){if(g[j]>=c){g=g[j];break}}}else{p=null}if((d==="indefinite")||(f==="indefinite")){if(p){s=g-c}else{s=null}}else{if(l==="indefinite"){if(!f&&!p){s=null}else{if(f&&!p){s=k._getOffset(d)}else{if(!f&&p){s=g-c}else{s=(k._getOffset(d)>(g-c))?k._getOffset(d):(g-c)}}}}else{if(l&&!d&&!f&&!p){s=b}else{if(l&&!d&&f&&!p){s=b*(+f)}else{if(l&&d&&!f&&!p){s=k._getOffset(d)}else{if(l&&!d&&!f&&p){s=(b>(g-c))?b:(g-c)}else{if(l&&d&&f&&!p){s=(+f*b>k._getOffset(d))?+f*b:k._getOffset(d)}else{if(l&&d&&f&&p){s=(+f*b>Math.min(+d,(g-c)))?+f*b:Math.min(k._getOffset(d),(g-c))}else{if(l&&d&&!f&&p){s=(k._getOffset(d)>(g-c))?k._getOffset(d):(g-c)}else{if(l&&!d&&f&&p){s=(+f*b>(g-c))?+f*b:(g-c)}}}}}}}}}}}catch(o){k.endElementAt(1);throw new DOMException(11)}if((s||(s===0))&&isFinite(s)){p||k.endElementAt(s);k._activeDur=s}k=c=b=l=g=p=d=f=s=void 0},false);this.addEventListener("DOMAttrModified",function(c){if(c.eventPhase===3){return}var b=c.target,d=c.attrName,g=c.newValue;if(d==="begin"){b._begin=g.replace(/\s+/g,"").split(";")}else{if(d==="end"){b._end=g.replace(/\s+/g,"").split(";")}else{if(d==="dur"){b._dur=g}else{if(d==="repeatCount"){b._repeatCount=g;b._isRepeat=true}else{if(d==="repeatDur"){b._repeatCount=g;b._isRepeat=true}else{if(d==="from"){b._from=g}else{if(d==="to"){b._to=g}else{if(d==="values"){b._values=g.split(";")}else{if(d==="by"){b._by=g}else{if(d==="keyTimes"){var f=g.split(";");b._keyTimes=[];for(var e=0;e<f.length;++e){b._keyTimes[e]=parseFloat(f[e])}f=void 0}else{if(d==="restart"){b._restart=g}}}}}}}}}}}c=g=void 0},false);this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===3){return}var b=c.target;b.addEventListener("DOMNodeInsertedIntoDocument",function(e){var d=e.target;if(d._values){}else{if(d._from&&d._to){d._values=[d._from,d._to]}else{if(d._from&&d._by){var o=parseFloat(d._from)+parseFloat(d._by),f=d._from.match(/\D+/)||[""];d._values=[d._from,o+f[0]]}else{if(d._to){d._values=[null,d._to]}else{if(d._by){d._values=[null,null,d._by]}else{if(!d.hasChildNodes()&&!d.hasAttributeNS(null,"path")){return d}}}}}}var k=d,j=function(u,p,t){var s=function(){var z=u.indexOf(".");if((z>0)&&(/[a-z]/i).test(u.charAt(z+1))){return(u.slice(0,z))}z=nn=void 0;return""},v;if(isFinite(parseFloat(u))){k[p](t)}else{if(u.indexOf("repeat(")>-1){var i=parseFloat(u.slice(7)),r=(function(A,z,B){return function(C){if(i===C.target._numRepeat){A[z](B)}}})(k,p,t),v=s();if(v){k.ownerDocument.getElementById(v).addEventListener("repeatEvent",r)}else{k.addEventListener("repeatEvent",r)}}else{if(/\.(begin|end)/.test(u)){v=s();if(v){var r=(function(A,z,B){return function(C){A[z](B)}})(k,p,t),q="";/\.(begin|end)/.test(u);if(RegExp.$1==="begin"){q="beginEvent"}else{if(RegExp.$1==="end"){q="endEvent"}}k.ownerDocument.getElementById(v).addEventListener(q,r,false)}}else{if(u.indexOf("wallclock(")===0){}else{if(u==="indefinite"){}else{if(u.indexOf("accesskey(")>-1){}else{v=s();var r=(function(A,z,B){return function(C){A[z](B)}})(k,p,t);if(v&&u.match(/\.([a-z]+)/i)){k.ownerDocument.getElementById(v).addEventListener(RegExp.$1,r)}else{if(u){k.targetElement.addEventListener(u.match(/^[a-z]+/i)[0],r)}}}}}}}}u=s=v=void 0};if(d._begin){for(var g=0,l=d._begin.length;g<l;++g){j(d._begin[g],"beginElementAt",d._getOffset(d._begin[g]))}}else{d.beginElementAt(0)}if(d._end){for(var g=0,l=d._end.length;g<l;++g){j(d._end[g],"endElementAt",d._getOffset(d._end[g]))}}k=void 0;if(d.hasAttributeNS("http://www.w3.org/1999/xlink","xlink:href")){d.targetElement=d.ownerDocument.getElementById(d.getAttributeNS("http://www.w3.org/1999/xlink","xlink:href").slice(1))}else{d.targetElement=d.parentNode}e=d=void 0},false);c=b=void 0},false)}(function(b){SVGAnimationElement.prototype=b;b.beginElement=function(){var d=this.ownerDocument,c=d.createEvent("TimeEvents");this._starting=d.documentElement.getCurrentTime();if(this._isStarted&&((this._restart==="never")||((this._restart==="whenNotActive")&&(this.getCurrentTime()>0)))){return}if(this.getCurrentTime()>0){this.endElement()}c.initTimeEvent("beginEvent",d.defaultView,0);this.dispatchEvent(c);this._start&&this._start.shift();this._isStarted=true;d=c=void 0};b.endElement=function(){var d=this.ownerDocument,c=d.createEvent("TimeEvents");c.initTimeEvent("endEvent",d.defaultView,0);this.dispatchEvent(c);this._finish&&this._finish.shift();this._currentFrame=0};b.beginElementAt=function(f){var c=this.ownerDocument.documentElement.getCurrentTime(),g=this._start||[];for(var e=0,d=g.length;e<d;++e){if(g[e]===(f+c)){c=g=f=void 0;return}}g.push(f+c);g.sort(function(j,i){return j-i});this._start=g;c=g=f=void 0};b.endElementAt=function(e){var c=this.ownerDocument.documentElement.getCurrentTime(),g=this._finish||[];for(var d=0,f=g.length;d<f;++d){if(g[d]===(e+c)){c=g=e=void 0;return}}g.push(e+c);g.sort(function(j,i){return j-i});this._finish=g;c=start=e=void 0};b._eventRegExp=/(mouse|activ|clic|begi|en)[a-z]+/;b._timeRegExp=/[\-\d\.]+(h|min|s|ms)?$/;b._unit={h:3600000,min:60000,s:1000};b._getOffset=function(e){var c=null,f=[e.indexOf("+"),e.indexOf("-")],d;if(f[0]>-1){d=e.slice(f[0]);c=parseFloat(d)}else{if(f[1]>-1){d=e.slice(f[1]);c=parseFloat(d)}else{d=e;c=parseFloat(e)}}if(isFinite(c)){if(/\d+\:(\d\d)\:([\d\.]+)$/.test(d)){c=(c*3600+parseInt(RegExp.$1,10)*60+parseFloat(RegExp.$2))*1000}else{if(/\d\d\:([\d\.]+)$/.test(d)){c=(c*60+parseFloat(RegExp.$1))*1000}else{if(/(h|min|s)$/.test(d)){c*=this._unit[RegExp.$1]}}}if(isFinite(c)){c*=0.8;return c}}return 0};b.getStartTime=function(){if(this._starting||(this._starting===0)){return(this._starting)}else{throw new DOMException(11)}};b.getCurrentTime=function(){return(this._currentFrame*125*0.8)};b.getSimpleDuration=function(){if(!this._dur&&!this._finish&&(this._dur==="indefinite")){throw new DOMException(9)}else{return(this._getOffset(this._dur))}}})(Object._create(SVGElement));NAIBU.Time={currentFrame:0,Max:17000,start:function(){if(NAIBU.Clip.length>0){screen.updateInterval=42;window.onscroll=function(){screen.updateInterval=0;screen.updateInterval=42};NAIBU.stop=setInterval((function(){try{var d=NAIBU.Time.currentFrame,f=NAIBU.Clip,t=d*100;if(d>NAIBU.Time.Max){clearInterval(NAIBU.stop)}f[0]&&f[0].ownerDocument.documentElement.setCurrentTime(t);for(var g=0,l=f.length;g<l;++g){var r=f[g],o=t+100,q=t-100;if(r._start){var b=r._start[0];if(b&&r._finish&&(b===r._finish[0])){r.endElement()}if((b||(b===0))&&(q<=b)&&(b<t)){r.beginElement()}b=void 0}if(r._isRepeat&&(r.getCurrentTime()>=r.getSimpleDuration()*r._numRepeat)){var j=r.ownerDocument,p=j.createEvent("TimeEvents");++r._numRepeat;p.initTimeEvent("repeatEvent",j.defaultView,r._numRepeat);r.dispatchEvent(p);j=p=void 0}if(r._finish&&(r.getCurrentTime()!==0)){var c=r._finish[0];if((c||(c===0))&&(q<=c)&&(c<=t)){r.endElement()}c=void 0}if(r._frame){++r._currentFrame;r._frame()}}++NAIBU.Time.currentFrame;d=f=t=r=q=o=void 0}catch(k){}}),1)}else{window.onscroll=function(){screen.updateInterval=0;window.onscroll=NAIBU.emptyFunction}}}};NAIBU.Clip=[];function SVGAnimateElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._valueList=[];this._isDiscrete=false;this.addEventListener("DOMAttrModified",function(b){if(b.eventPhase===3){return}if((b.attrName==="calcMode")&&(b.newValue==="discrete")){b.target._isDiscrete=true}},false);this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===3){return}var b=c.target;b.addEventListener("DOMNodeInsertedIntoDocument",function(s){var l=s.target,q=l.getAttributeNS(null,"attributeName"),t=l.targetElement,o=t[q];var j=t.cloneNode(false);if(!l._values[0]){var f=t.ownerDocument.defaultView.getComputedStyle(t,"");l._values[0]=t.getAttributeNS(null,q)||f.getPropertyValue(q);if(!l._values[1]&&l._values[2]){var r=parseFloat(l._values[0])+parseFloat(l._values[2]),p=l._values[0].match(/\D+/)||[""];l._values[1]=r+p[0];l._values.pop();r=p=void 0}}if(("animatedPoints" in t)&&(q==="points")){t.animatedPoints=j.points;for(var k=0,g=l._values,e=g.length;k<e;++k){var d=t.cloneNode(false);delete d._tar;d.setAttributeNS(null,"points",g[k]);l._valueList[l._valueList.length]=d.points}}else{if(!!o){o.animVal=j[q].baseVal;for(var k=0,g=l._values,e=g.length;k<e;++k){var d=t.cloneNode(false);delete d._tar;d.setAttributeNS(null,q,g[k]);l._valueList[l._valueList.length]=d[q].baseVal}}else{if(!!CSS2Properties[q]||q.indexOf("-")>-1){for(var k=0,g=l._values,e=g.length;k<e;++k){if((q==="fill")||(q==="stroke")||(q==="stop-color")){l._valueList[k]=new SVGPaint();l._valueList[k].setPaint(1,null,g[k],null)}else{l._valueList[k]=parseFloat(g[k])}}}else{if(("normalizedPathSegList" in t)&&(q==="d")){t.animatedNormalizedPathSegList=j.normalizedPathSegList;for(var k=0,g=l._values,e=g.length;k<e;++k){var d=t.cloneNode(false);delete d._tar;d.setAttributeNS(null,"d",g[k]);l._valueList[l._valueList.length]=d.normalizedPathSegList}}else{j=void 0;return}}}}s=o=d=j=void 0},false)},false);this.addEventListener("beginEvent",function(d){var c=d.target,e=c.getAttributeNS(null,"attributeName"),g=c.targetElement.attributes.getNamedItemNS(null,e),f=c.targetElement,b=f[e];c._frame=function(){var p=c,q=p._isRepeat?p.getSimpleDuration():p._activeDur,l=p._valueList.length-1,k=p.getCurrentTime();p._activeDur||(q=0);q*=0.8;if((l!==-1)&&(q!==0)&&(k<=q)){if(p._isDiscrete){++l}var A=Math.floor((k*l)/q);if(A===l){A-=1}}else{return}var z=p.ownerDocument._domnodeEvent();if(p._keyTimes){var r=(p._keyTimes[A+1]-p._keyTimes[A])*q;var i=p._keyTimes[A]}else{var r=q/l;var i=A/l}if(("animatedPoints" in f)&&(e==="points")){var j=f.points;f.points=f.animatedPoints;f.dispatchEvent(z);f.animatedPoints=f.points;f.points=j}else{if(!!b){var j=b.baseVal,o=b.animVal;var t=p._valueList[A].value;if(!p._isDiscrete){var s=p._valueList[A+1].value,u=t+(s-t)*(k-i*q)/r}else{var u=t}o.newValueSpecifiedUnits(j.unitType,u);b.baseVal=o;o=void 0;f.dispatchEvent(z);b.animVal=b.baseVal;b.baseVal=j;r=void 0}else{if(!!CSS2Properties[e]||e.indexOf("-")>-1){var j=null;var t=p._valueList[A].value,s=p._valueList[A+1].value;if(!p._isDiscrete){var u=t+(s-t)*(k-i*q)/r}else{var u=t}}else{if(("normalizedPathSegList" in f)&&(e==="d")){var j=f.normalizedPathSegList;f.normalizedPathSegList=f.animatedNormalizedPathSegList;f.dispatchEvent(z);f.animatedNormalizedPathSegList=f.normalizedPathSegList;f.normalizedPathSegList=j}}}}z=p=t=s=u=q=l=A=k=void 0};d=vir=void 0},false);this.addEventListener("endEvent",function(c){var b=c.target,d=b.getAttributeNS(null,"fill");if(!d||(d==="remove")){var c=b.ownerDocument._domnodeEvent();b.targetElement.dispatchEvent(c);c=void 0;b._frame&&b._frame()}delete b._frame},false);this.addEventListener("repeatEvent",function(c){var b=c.target},false)}SVGAnimateElement.prototype=Object._create(SVGAnimationElement);function SVGSetElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._to="";this.addEventListener("DOMAttrModified",function(c){var b=c.target,d=c.attrName;if(d==="to"){b._to=c.newValue}b=d=void 0},false);this.addEventListener("beginEvent",function(d){var c=d.target;c._currentFrame=1;if(c.targetElement){var e=c.getAttributeNS(null,"attributeName"),i=c.targetElement.attributes.getNamedItemNS(null,e),b=c.targetElement[e];if(!!CSS2Properties[e]||e.indexOf("-")>-1){c._prestyle=c.ownerDocument.defaultView.getComputedStyle(c.targetElement,"").getPropertyValue(e);var f=c.ownerDocument.getOverrideStyle(c.targetElement,"");f.setProperty(e,c.getAttributeNS(null,"to"),null);f=void 0}else{if(!!b){var g=b.baseVal;if(g instanceof SVGLength){b.baseVal=c.ownerDocument.documentElement.createSVGLength()}else{if(g instanceof SVGRect){b.baseVal=c.ownerDocument.documentElement.createSVGRect()}}var d=c.ownerDocument.createEvent("MutationEvents");d.initMutationEvent("DOMAttrModified",true,false,i,i,c._to,e,1);c.targetElement.dispatchEvent(d);d=void 0;b.animVal=b.baseVal;b.baseVal=g}}}d=c=e=void 0},false);this.addEventListener("endEvent",function(d){var c=d.target,g=c.getAttributeNS(null,"fill");if(!g||(g==="remove")){var e=c.getAttributeNS(null,"attributeName"),f=c.ownerDocument.getOverrideStyle(c.targetElement,"");if(c._prestyle){f.setProperty(e,c._prestyle,null)}else{var b=c.ownerDocument._domnodeEvent();c.targetElement.dispatchEvent(b)}e=f=b=void 0}c=g=void 0},false);this.addEventListener("repeatEvent",function(c){var b=c.target,d=b.getAttributeNS(null,"attributeName"),e=b.ownerDocument.defaultView.getComputedStyle(b.targetElement,"")},false)}SVGSetElement.prototype=new SVGAnimationElement(1);function SVGAnimateMotionElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this.addEventListener("DOMAttrModified",function(c){if(c.eventPhase===3){return}var b=c.target,e=c.attrName;if(e==="path"){var f=b.ownerDocument.createElementNS("http://www.w3.org/2000/svg","path");f.setAttributeNS(null,"d",c.newValue);b._path=f;f=void 0}},false);this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===3){return}var b=c.target;b.addEventListener("DOMNodeInsertedIntoDocument",function(e){var d=[],j;if(b._values){for(var f=0,k=b._values,g=k.length;f<g;++f){j=k[f];j=j.split(",");d[f]=[+j[0],+j[1]]}b._valueList=d}},false)},false);this.addEventListener("beginEvent",function(c){var b=c.target,d=b.targetElement.transform;d.animVal=new SVGTransformList();if(d.baseVal.numberOfItems!==0){d.baseVal.consolidate();d.animVal.initialize(d.baseVal.createSVGTransformFromMatrix(d.baseVal.getItem(0).matrix))}else{d.animVal.appendItem(b.ownerDocument.documentElement.createSVGTransform())}b._frame=function(){var t=b,q=t._path,u=t._isRepeat?t.getSimpleDuration():t._activeDur,r=u*0.8,g=t.getCurrentTime(),z;t._activeDur||(r=0);if(u===0){u=void 0;return}if(q){var A=q.getTotalLength()*g/r,f=q.getPointAtLength(A),B=t.targetElement.transform;B.animVal.getItem(B.animVal.numberOfItems-1).setTranslate(f.x,f.y);var e=B.baseVal;B.baseVal=B.animVal;t.targetElement._cacheMatrix=null;var v=t.ownerDocument.createEvent("MutationEvents");v.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);t.targetElement.dispatchEvent(v);B.baseVal=e;v=e=B=A=f=void 0}else{if(b._valueList){var s=0,A=0,l=b._valueList,j=l.length-1;if((j!==-1)&&(r!==0)&&(g<=r)){z=Math.floor((g*j)/r);if(z===j){z-=1}}else{return}for(var o=1,k=l.length;o<k;o+=2){s+=Math.sqrt(Math.pow(l[o][1]-l[o-1][1],2)+Math.pow(l[o][0]-l[o-1][0],2))}for(var o=1;o<z;o+=2){A+=Math.sqrt(Math.pow(l[o][1]-l[o-1][1],2)+Math.pow(l[o][0]-l[o-1][0],2))}var f=b.ownerDocument.documentElement.createSVGPoint(),B=t.targetElement.transform;A=(A/s)*r;f.x=l[z][0]+(l[z+1][0]-l[z][0])*(g-A)/r;f.y=l[z][1]+(l[z+1][1]-l[z][1])*(g-A)/r;B.animVal.getItem(B.animVal.numberOfItems-1).setTranslate(f.x,f.y);var e=B.baseVal;B.baseVal=B.animVal;t.targetElement._cacheMatrix=void 0;var v=t.ownerDocument.createEvent("MutationEvents");v.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);t.targetElement.dispatchEvent(v);B.baseVal=e;v=e=B=A=f=o=void 0}}};c=d=tpn=tgsd=void 0},false);this.addEventListener("endEvent",function(e){var c=e.target,f=c.targetElement.transform,g=c.getAttributeNS(null,"fill"),i=c._valueList,d;if(!g||(g==="remove")){var b=c.ownerDocument._domnodeEvent();c.targetElement.dispatchEvent(b);c._frame&&c._frame()}else{f.animVal.getItem(f.animVal.numberOfItems-1).setTranslate(i[i.length-1][0],i[i.length-1][1]);d=f.baseVal;f.baseVal=f.animVal;var b=c.ownerDocument._domnodeEvent();c.targetElement.dispatchEvent(b);f.baseVal=d}delete c._frame;e=b=f=g=c=i=d=void 0},false);this.addEventListener("repeatEvent",function(c){var b=c.target},false)}SVGAnimateMotionElement.prototype=Object._create(SVGAnimationElement);function SVGMPathElement(){SVGElement.apply(this);SVGURIReference.apply(this)}SVGMPathElement.prototype=Object._create(SVGElement);function SVGAnimateColorElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._valueList=[];this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===3){return}var b=c.target;b.addEventListener("DOMNodeInsertedIntoDocument",function(q){var l=q.target,o=l.getAttributeNS(null,"attributeName"),r=l.targetElement,g=l.ownerDocument.defaultView.getComputedStyle(r,""),k,d;if(!l._values[0]){l._values[0]=g.getPropertyValue(o)}for(var j=0,f=l._values,e=f.length;j<e;++j){var p=new SVGColor();if(l._values[j]==="currentColor"){p.setRGBColor(g.getPropertyValue("color")||"black")}else{if(l._values[j]==="inherit"){k=g.getPropertyCSSValue(o);d=k.cssValueType;k.cssValueType=0;p=g.getPropertyCSSValue(o);k.cssValueType=d}else{p.setRGBColor(l._values[j])}}l._valueList[l._valueList.length]=p;p=void 0}l=r=g=k=d=o=void 0},false)},false);this.addEventListener("beginEvent",function(c){var b=c.target,e=b.getAttributeNS(null,"attributeName"),f=b.ownerDocument.getOverrideStyle(b.targetElement,""),d=b.ownerDocument.defaultView.getComputedStyle(b.targetElement,"");b._frame=function(){var D=b;var A=D._isRepeat?D.getSimpleDuration():D._activeDur,o=D._valueList.length-1,l=D.getCurrentTime(),E,B,k;D._activeDur||(A=0);A*=0.8;if((o!==-1)&&(A!==0)&&(l<=A)){E=Math.floor((l*o)/A);if(E===o){E-=1}}else{return}if(b._keyTimes){B=(b._keyTimes[E+1]-b._keyTimes[E])*A;k=b._keyTimes[E]}else{B=A/o;k=E/o}var p=D._valueList[E].rgbColor,t=D._valueList[E+1].rgbColor,s=(l-k*A)/B,u=1,z=p.red.getFloatValue(u),j=p.green.getFloatValue(u),q=p.blue.getFloatValue(u),i=z+(t.red.getFloatValue(u)-z)*s,v=j+(t.green.getFloatValue(u)-j)*s,C=q+(t.blue.getFloatValue(u)-q)*s;f.setProperty(e,"rgb("+Math.ceil(i)+","+Math.ceil(v)+","+Math.ceil(C)+")",null);D=A=o=l=p=t=z=j=q=u=i=v=C=E=void 0};b._frame()},false);this.addEventListener("endEvent",function(d){var c=d.target,e=c.getAttributeNS(null,"fill");if(!e||(e==="remove")){var b=c.ownerDocument._domnodeEvent();c.targetElement.dispatchEvent(b);c._frame&&c._frame()}delete c._frame;d=b=c=e=void 0},false);this.addEventListener("repeatEvent",function(c){var b=c.target},false)}SVGAnimateColorElement.prototype=Object._create(SVGAnimationElement);function SVGAnimateTransformElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this.addEventListener("beginEvent",function(c){var b=c.target,d=b.targetElement.transform;d.animVal=new SVGTransformList();if(d.baseVal.numberOfItems!==0){d.animVal.initialize(d.baseVal.createSVGTransformFromMatrix(d.baseVal.getItem(0).matrix))}d.animVal.appendItem(b.ownerDocument.documentElement.createSVGTransform())},false);this.addEventListener("endEvent",function(d){var c=d.target,e=c.getAttributeNS(null,"fill");if(!e||(e==="remove")){var b=c.ownerDocument._domnodeEvent();c.targetElement.dispatchEvent(b);c._frame&&c._frame()}delete c._frame;d=b=c=e=void 0},false);this.addEventListener("repeatEvent",function(c){var b=c.target},false)}SVGAnimateTransformElement.prototype=Object._create(SVGAnimationElement);function SVGFontElement(){SVGElement.apply(this);this._isExternal=0;this.addEventListener("DOMNodeInserted",function(c){var b=c.target;if(c.eventPhase===3){return}b.addEventListener("DOMNodeInsertedIntoDocument",function(e){var d=e.target,f="http://www.w3.org/2000/svg",i=d.getElementsByTagNameNS(f,"font-face").item(0);var g=function(t){var q=t.target;var o=i.getAttributeNS(null,"font-family");var r=d.ownerDocument.getElementsByTagNameNS(f,"text");for(var p=0,s=d,k=r.length;p<k;++p){var l=r[p],j=s.ownerDocument.defaultView.getComputedStyle(l,"");if(j.getPropertyValue("font-family",null).indexOf(o)>-1){NAIBU._noie_createFont(l,s,true)}}t=d=q=curt=textElments=f=s=void 0};if(!i.__isLinked||d._isExternal){d.ownerDocument.documentElement._svgload_limited=0;d.ownerDocument.documentElement.addEventListener("SVGLoad",g,false)}},false)},false)}SVGFontElement.prototype=Object._create(SVGElement);function SVGGlyphElement(){SVGElement.apply(this)}SVGGlyphElement.prototype=Object._create(SVGElement);function SVGMissingGlyphElement(){SVGElement.apply(this)}SVGMissingGlyphElement.prototype=Object._create(SVGElement);function SVGHKernElement(){SVGElement.apply(this)}SVGHKernElement.prototype=Object._create(SVGElement);function SVGVKernElement(){SVGElement.apply(this)}SVGVKernElement.prototype=Object._create(SVGElement);function SVGFontFaceElement(){SVGElement.apply(this);this._isLinked=0;this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===3){if(b.target.localName==="font-face-uri"){b.currentTarget._isLinked=1}return}},false)}SVGFontFaceElement.prototype=Object._create(SVGElement);function SVGFontFaceSrcElement(){SVGElement.apply(this)}SVGFontFaceSrcElement.prototype=Object._create(SVGElement);function SVGFontFaceUriElement(){SVGElement.apply(this);this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===3){return}b.target.ownerDocument.documentElement._svgload_limited--;b.target.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed")},false);this.addEventListener("S_Load",function(c){var b=c.target,d=b.parentNode.parentNode.parentNode;if(d.localName==="defs"){d=b.parentNode.parentNode}b._instance._isExternal=1;d.parentNode.appendChild(b._instance);c=b=d=void 0},false);SVGURIReference.apply(this)}SVGFontFaceUriElement.prototype=Object._create(SVGElement);function SVGFontFaceFormatElement(){SVGElement.apply(this)}SVGFontFaceFormatElement.prototype=Object._create(SVGElement);function SVGFontFaceNameElement(){SVGElement.apply(this)}SVGFontFaceNameElement.prototype=Object._create(SVGElement);function SVGDefinitionSrcElement(){SVGElement.apply(this)}SVGDefinitionSrcElement.prototype=Object._create(SVGElement);function SVGMetadataElement(){SVGElement.apply(this)}SVGMetadataElement.prototype=Object._create(SVGElement);function SVGForeignObjectElement(){SVGElement.apply(this);var b=SVGAnimatedLength;this.x=new b();this.y=new b();this.width=new b();this.height=new b();b=void 0}SVGForeignObjectElement.prototype=Object._create(SVGElement);DOMImplementation["http://www.w3.org/2000/svg"]={Document:SVGDocument,svg:SVGSVGElement,g:SVGGElement,path:NAIBU.SVGPathElement,title:SVGTitleElement,desc:SVGDescElement,defs:SVGDefsElement,linearGradient:SVGLinearGradientElement,radialGradient:SVGRadialGradientElement,stop:SVGStopElement,rect:SVGRectElement,circle:SVGCircleElement,ellipse:SVGEllipseElement,polyline:SVGPolylineElement,polygon:SVGPolygonElement,text:SVGTextElement,tspan:SVGTSpanElement,image:SVGImageElement,line:SVGLineElement,a:SVGAElement,animateColor:SVGAnimateColorElement,animate:SVGAnimateElement,animateMotion:SVGAnimateMotionElement,animateTransform:SVGAnimateTransformElement,clipPath:SVGClipPathElement,colorProfile:SVGColorProfileElement,cursor:SVGCursorElement,definitionSrc:SVGDefinitionSrcElement,feBlend:SVGFEBlendElement,feGaussianBlur:SVGFEGaussianBlurElement,filter:SVGFilterElement,font:SVGFontElement,"font-face":SVGFontFaceElement,"font-face-format":SVGFontFaceFormatElement,"font-face-name":SVGFontFaceNameElement,"font-face-src":SVGFontFaceSrcElement,"font-face-uri":SVGFontFaceUriElement,foreignObject:SVGForeignObjectElement,glyph:SVGGlyphElement,hkern:SVGHKernElement,marker:SVGMarkerElement,mask:SVGMaskElement,metadata:SVGMetadataElement,missingGlyph:SVGMissingGlyphElement,mpath:SVGMPathElement,script:SVGScriptElement,set:SVGSetElement,style:SVGStyleElement,"switch":SVGSwitchElement,symbol:SVGSymbolElement,textPath:SVGTextPathElement,tref:SVGTRefElement,use:SVGUseElement,view:SVGViewElement,vkern:SVGVKernElement,pattern:SVGPatternElement};NAIBU._fontSearchURI=function(b){var g=b.target.ownerDocument;var c=g.getElementsByTagNameNS("http://www.w3.org/2000/svg","font-face-uri");for(var e=0;e<c.length;++e){var j=c[e].getAttributeNS("http://www.w3.org/1999/xlink","href"),f=j.split(":")[1],d=NAIBU.xmlhttp;d.open("GET",j.replace(/#.+$/,""),true);d.setRequestHeader("X-Requested-With","XMLHttpRequest");d.onreadystatechange=function(){if((d.readyState===4)&&(d.status===200)){var i=(new DOMParser()).parseFromString(d.responseText,"text/xml");NAIBU._font({document:i,docu:g,id:f});d=g=i=void 0}};d.send(null)}};NAIBU._font=function(j){var o=j.document,f="http://www.w3.org/2000/svg";var e=o.getElementsByTagNameNS(f,"font").item(0);var g=e.getElementsByTagNameNS(f,"font-face").item(0).getAttributeNS(null,"font-family");if(g&&(e.getAttributeNS(null,"id")===j.id)){var l=j.docu.getElementsByTagNameNS(f,"text");for(var k=0,d=l.length;k<d;++k){var c=l[k],b=j.docu.defaultView.getComputedStyle(c,"");if(b.getPropertyValue("font-family",null).indexOf(g)>-1){NAIBU._noie_createFont(c,e,false)}}}o=j=void 0};NAIBU._noie_createFont=function(b,P,l){var I=b.ownerDocument.defaultView.getComputedStyle(b,""),Q="http://www.w3.org/2000/svg",J=b.getAttributeNS(null,"writing-mode")||b.parentNode.getAttributeNS(null,"writing-mode"),p=J?"vert-adv-y":"horiz-adv-x",z=b.firstChild,R,k=P.getElementsByTagNameNS(Q,"glyph"),N=parseFloat(P.getElementsByTagNameNS(Q,"font-face").item(0).getAttributeNS(null,"units-per-em")||1000),H=parseFloat((P.getAttributeNS(null,p)||N)),e=parseFloat(b.getAttributeNS(null,"x")||0),d=parseFloat(b.getAttributeNS(null,"y")||0),q=parseFloat(I.getPropertyValue("font-size")),B=q/N,g=false,f=["fill","fill-opacity","stroke","stroke-width","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-dasharray","stroke-opacity","opacity","cursor"];if(k.length>60){return}if(/a/[-1]==="a"){g=true}else{if(l||J){g=true}}if(g){while(z){if(!k){break}R=z.data;if(R!==void 0){var T=[],F=[];for(var L=0,C=k.length;L<C;++L){var u=k[L],s=u.getAttributeNS(null,"unicode")||"なし";var t=u.getAttributeNS(null,"orientation"),O=true,o=true;if(t){if(t==="h"){O=false}}else{o=false}if((J&&O)||!(J||O)||!o){var A=R.indexOf(s);while(A>-1){T[A]=parseFloat(u.getAttributeNS(null,p)||H);F[A]=u.getAttributeNS(null,"d");A=R.indexOf(s,A+1)}}}for(var L=0,M=0;L<R.length;++L){if(T[L]!==void 0){var G=b.ownerDocument.createElementNS(Q,"path");var v=b.ownerDocument.documentElement.createSVGMatrix();v.a=B;v.d=-B;for(var K=0;K<f.length;++K){var S=f[K],c=b.getAttributeNS(null,S)||I.getPropertyValue(S);if(S==="stroke-width"){c=I.getPropertyCSSValue(S).getFloatValue(1)/B;c+=""}if(c){G.setAttributeNS(null,S,c)}}if(J){var D=d+M*B,E=e;if("、。".indexOf(R.charAt(L))>-1){var r=q/Math.SQRT2;E+=r;D-=r;r=void 0}v.e=E;v.f=D}else{v.e=e+M*B;v.f=d}G.setAttributeNS(null,"transform","matrix("+v.a+","+v.b+","+v.c+","+v.d+","+v.e+","+v.f+")");G.setAttributeNS(null,"d",F[L]);b.parentNode.insertBefore(G,b);M+=T[L];v=void 0}}M=T=F=void 0}else{if("tspan|a".indexOf(z.localName)>-1){NAIBU._noie_createFont(z,P,l)}}z=z.nextSibling}if(l){var I=b.ownerDocument.getOverrideStyle(b,null);I.setProperty("visibility","hidden");I=void 0}else{b.setAttributeNS(null,"opacity","0")}}R=J=p=N=H=e=d=q=I=Q=z=void 0};(function(){var e=new CSSStyleDeclaration(),k=e._list,j=0,f=/([A-Z])/,g=/\-/,b,d;for(var c in CSS2Properties){if(CSS2Properties.hasOwnProperty(c)){d=c.replace(f,"-");if(!!RegExp.$1){b="-"+RegExp.$1.toLowerCase()}else{b="-"}d=d.replace(g,b);e.setProperty(d,CSS2Properties[c]);k[d]=k[j];k[j]._isDefault=1;++j;c=d=b=void 0}}k._opacity=1;k._fontSize=12;CSS2Properties._list=k;Document.prototype.defaultView._defaultCSS=k;e=j=f=g=k=null})();NAIBU.addEvent=function(b,c){if(window.addEventListener){window.addEventListener(b,c,false)}else{if(window.attachEvent){window.attachEvent("on"+b,c)}else{window["on"+b]=c}}if(sieb_s){c()}};function unsvgtovml(){try{if("stop" in NAIBU){clearInterval(NAIBU.stop)}window.onscroll=NAIBU.emptyFunction;window.detachEvent("onload",NAIBU._main);NAIBU.freeArg();delete Object._create;Document._destroy();Element=SVGElement=Attr=NamedNodeMap=CSS2Properties=CSSValue=CSSPrimitiveValue=NAIBU.xmlhttp=Node=Event=NAIBU=STLog=SVGColor=SVGPaint=void 0;Array=ActiveXObject=void 0}catch(b){}}NAIBU._main=function(){var H,c=document;try{if(XMLHttpRequest){H=false}else{H=new ActiveXObject("Msxml2.XMLHTTP")}}catch(C){try{H=new ActiveXObject("Microsoft.XMLHTTP")}catch(l){H=false}}if(!H){try{H=new XMLHttpRequest()}catch(C){H=false}}NAIBU.xmlhttp=H;var f,p=c.namespaces;if(p&&!p.v){try{NAIBU.doc=new ActiveXObject("MSXML2.DomDocument")}catch(C){}f=NAIBU.doc;p.add("v","urn:schemas-microsoft-com:vml");p.add("o","urn:schemas-microsoft-com:office:office");var q=c.createStyleSheet(),g="behavior: url(#default#VML);display: inline-block;} ";q.cssText="v\\:rect{"+g+"v\\:image{"+g+"v\\:fill{"+g+"v\\:stroke{"+g+"o\\:opacity2{"+g+"dn\\:defs{display:none}v\\:group{text-indent:0px;position:relative;width:100%;height:100%;"+g+"v\\:shape{width:100%;height:100%;"+g}var D=c.getElementsByTagName("script");for(var v=0;D[v];++v){var z=D[v],A=z.type;if(z.type==="image/svg+xml"){var F=z.text;if(sieb_s&&F.match(/&lt;svg/)){F=F.replace(/<.+?>/g,"");F=F.replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&quot;/g,'"').replace(/&amp;/g,"&")}if(NAIBU.isMSIE){var I=new GetSVGDocument(z);I.xmlhttp={readyState:4,status:200,responseText:F.replace(/\shref=/g," target='_top' xlink:href=")};I._ca()}else{var d=location.href.replace(/\/[^\/]+?$/,"/");F=F.replace(/\shref=(['"a-z]+?):\/\//g," target='_top' xlink:href=$1://").replace(/\shref=(.)/g," target='_top' xlink:href=$1"+d);var o=NAIBU.textToSVG(F,z.getAttribute("width"),z.getAttribute("height"));z.parentNode.insertBefore(o,z)}z=F=void 0}A=void 0}NAIBU.doc=f;f=p=D=void 0;if(H&&NAIBU.isMSIE){if(!!c.createElementNS&&!!c.createElementNS("http://www.w3.org/2000/svg","svg").createSVGRect){}else{var r=c.getElementsByTagName("object"),o=[],k=[],B=function(t){var K,E,J,e="width",s="height";o||(o=[]);c||(c=document);for(var j=0;t[j];++j){E=t[j];o[o.length]=new GetSVGDocument(E);K=c.createElement("iframe");K.style.cssText=E.style.cssText;K.style.background="black";J=E.getAttribute(e);J&&K.setAttribute(e,J);J=E.getAttribute(s);J&&K.setAttribute(s,J);K.marginWidth=K.marginHeight="0px";K.scrolling="no";K.frameBorder="0";E.parentNode.insertBefore(K,E)}j=E=K=t=e=s=void 0;return o[o.length-1]};B(r);var G=c.getElementsByTagName("img"),b=c.getElementsByTagName("embed");for(var v=0,u=0;G[v];++v){if(G[v].getAttribute("src").indexOf(".svg")>-1){k[u]=G[v];++u}}B(k);B(b);NAIBU._search=B;r=b=k=G=B=void 0;for(var v=0;v<o.length;++v){if(v<o.length-1){o[v]._next=o[v+1]}}if(v>0){o[0]._init()}o=void 0}}else{var r=c.getElementsByTagName("object");for(var v=0;v<r.length;++v){if(r[v].contentDocument){NAIBU._fontSearchURI({target:{ownerDocument:r[v].contentDocument}})}else{if(r[v].getSVGDocument){r[v].getSVGDocument()._docElement.addEventListener("SVGLoad",NAIBU._fontSearchURI,false)}else{}}}}H=c=void 0};NAIBU.addEvent("load",NAIBU._main);NAIBU.utf16=function(b){return unescape(b)};NAIBU.unescapeUTF16=function(b){return b.replace(/%u\w\w\w\w/g,NAIBU.utf16)};NAIBU.textToSVG=function(f,b,d){if(navigator.userAgent.indexOf("WebKit")>-1||navigator.userAgent.indexOf("Safari")>-1){var e="data:image/svg+xml;charset=utf-8,"+NAIBU.unescapeUTF16(escape(f));var c=document.createElement("object");c.setAttribute("data",e);c.setAttribute("width",b);c.setAttribute("height",d);c.setAttribute("type","image/svg+xml");return c}else{var g=(new DOMParser()).parseFromString(f,"text/xml");return(document.importNode(g.documentElement,true))}};NAIBU.addEvent("unload",unsvgtovml);
NAIBU.isMSIE=/*@cc_on!@*/false;