/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.image;

import java.io.File;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.printer.PrintStyles;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.io.base.TGSongStreamContext;
import org.herac.tuxguitar.io.image.ImageExporterSettings;
import org.herac.tuxguitar.io.image.ImageFormat;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.chooser.UIDirectoryChooser;
import org.herac.tuxguitar.ui.chooser.UIDirectoryChooserHandler;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UISpinner;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class ImageExporterSettingsDialog {
    private TGContext context;

    public ImageExporterSettingsDialog(TGContext context) {
        this.context = context;
    }

    public void openSettingsDialog(final TGSongStreamContext context, final Runnable callback) {
        TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final PrintStyles styles = this.createDefaultStyles(song);
        final UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UIWindow uiParent = TGWindow.getInstance((TGContext)this.context).getWindow();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty((String)"options"));
        UITableLayout formatLayout = new UITableLayout();
        UILegendPanel formatGroup = uiFactory.createLegendPanel((UIContainer)dialog);
        formatGroup.setLayout((UILayout)formatLayout);
        formatGroup.setText(TuxGuitar.getProperty((String)"tuxguitar-image.format"));
        dialogLayout.set((UIControl)formatGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(300.0f), null, null);
        UILabel formatLabel = uiFactory.createLabel((UIContainer)formatGroup);
        formatLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-image.format"));
        formatLayout.set((UIControl)formatLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIDropDownSelect formatCombo = uiFactory.createDropDownSelect((UIContainer)formatGroup);
        for (int i = 0; i < ImageFormat.IMAGE_FORMATS.length; ++i) {
            formatCombo.addItem(new UISelectItem(ImageFormat.IMAGE_FORMATS[i].getName(), (Object)ImageFormat.IMAGE_FORMATS[i]));
        }
        formatCombo.setSelectedValue((Object)ImageFormat.IMAGE_FORMATS[0]);
        formatLayout.set((UIControl)formatCombo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout trackLayout = new UITableLayout();
        UILegendPanel track = uiFactory.createLegendPanel((UIContainer)dialog);
        track.setLayout((UILayout)trackLayout);
        track.setText(TuxGuitar.getProperty((String)"track"));
        dialogLayout.set((UIControl)track, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(300.0f), null, null);
        UILabel trackLabel = uiFactory.createLabel((UIContainer)track);
        trackLabel.setText(TuxGuitar.getProperty((String)"track"));
        trackLayout.set((UIControl)trackLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIDropDownSelect tracks = uiFactory.createDropDownSelect((UIContainer)track);
        for (int number = 1; number <= song.countTracks(); ++number) {
            tracks.addItem(new UISelectItem(TuxGuitar.getInstance().getSongManager().getTrack(song, number).getName(), (Object)number));
        }
        tracks.setSelectedValue((Object)TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack().getNumber());
        trackLayout.set((UIControl)tracks, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout rangeLayout = new UITableLayout();
        UILegendPanel range = uiFactory.createLegendPanel((UIContainer)dialog);
        range.setLayout((UILayout)rangeLayout);
        range.setText(TuxGuitar.getProperty((String)"print.range"));
        dialogLayout.set((UIControl)range, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(300.0f), null, null);
        boolean minSelection = true;
        final int maxSelection = song.countMeasureHeaders();
        UILabel fromLabel = uiFactory.createLabel((UIContainer)range);
        fromLabel.setText(TuxGuitar.getProperty((String)"edit.from"));
        rangeLayout.set((UIControl)fromLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UISpinner fromSpinner = uiFactory.createSpinner((UIContainer)range);
        fromSpinner.setMaximum(maxSelection);
        fromSpinner.setMinimum(1);
        fromSpinner.setValue(1);
        rangeLayout.set((UIControl)fromSpinner, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(60.0f), null, null);
        UILabel toLabel = uiFactory.createLabel((UIContainer)range);
        toLabel.setText(TuxGuitar.getProperty((String)"edit.to"));
        rangeLayout.set((UIControl)toLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UISpinner toSpinner = uiFactory.createSpinner((UIContainer)range);
        toSpinner.setMinimum(1);
        toSpinner.setMaximum(maxSelection);
        toSpinner.setValue(maxSelection);
        rangeLayout.set((UIControl)toSpinner, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(60.0f), null, null);
        fromSpinner.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                int fromSelection = fromSpinner.getValue();
                int toSelection = toSpinner.getValue();
                if (fromSelection < 1) {
                    fromSpinner.setValue(1);
                } else if (fromSelection > toSelection) {
                    fromSpinner.setValue(toSelection);
                }
            }
        });
        toSpinner.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                int fromSelection;
                int toSelection = toSpinner.getValue();
                if (toSelection < (fromSelection = fromSpinner.getValue())) {
                    toSpinner.setValue(fromSelection);
                } else if (toSelection > maxSelection) {
                    toSpinner.setValue(maxSelection);
                }
            }
        });
        UITableLayout optionsLayout = new UITableLayout();
        UILegendPanel options = uiFactory.createLegendPanel((UIContainer)dialog);
        options.setLayout((UILayout)optionsLayout);
        options.setText(TuxGuitar.getProperty((String)"options"));
        dialogLayout.set((UIControl)options, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(300.0f), null, null);
        final UICheckBox tablatureEnabled = uiFactory.createCheckBox((UIContainer)options);
        tablatureEnabled.setText(TuxGuitar.getProperty((String)"export.tablature-enabled"));
        tablatureEnabled.setSelected(true);
        optionsLayout.set((UIControl)tablatureEnabled, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox scoreEnabled = uiFactory.createCheckBox((UIContainer)options);
        scoreEnabled.setText(TuxGuitar.getProperty((String)"export.score-enabled"));
        scoreEnabled.setSelected(true);
        optionsLayout.set((UIControl)scoreEnabled, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox chordNameEnabled = uiFactory.createCheckBox((UIContainer)options);
        chordNameEnabled.setText(TuxGuitar.getProperty((String)"export.chord-name-enabled"));
        chordNameEnabled.setSelected(true);
        optionsLayout.set((UIControl)chordNameEnabled, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox chordDiagramEnabled = uiFactory.createCheckBox((UIContainer)options);
        chordDiagramEnabled.setText(TuxGuitar.getProperty((String)"export.chord-diagram-enabled"));
        chordDiagramEnabled.setSelected(true);
        optionsLayout.set((UIControl)chordDiagramEnabled, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox blackAndWhite = uiFactory.createCheckBox((UIContainer)options);
        blackAndWhite.setText(TuxGuitar.getProperty((String)"export.black-and-white"));
        blackAndWhite.setSelected(true);
        optionsLayout.set((UIControl)blackAndWhite, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        tablatureEnabled.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (!tablatureEnabled.isSelected()) {
                    scoreEnabled.setSelected(true);
                }
            }
        });
        scoreEnabled.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (!scoreEnabled.isSelected()) {
                    tablatureEnabled.setSelected(true);
                }
            }
        });
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                Integer trackNumber;
                ImageFormat imageFormat = (ImageFormat)formatCombo.getSelectedValue();
                if (imageFormat == null) {
                    imageFormat = ImageFormat.IMAGE_FORMATS[0];
                }
                if ((trackNumber = (Integer)tracks.getSelectedValue()) == null) {
                    trackNumber = 1;
                }
                int style = 0;
                style |= scoreEnabled.isSelected() ? 4 : 0;
                style |= tablatureEnabled.isSelected() ? 8 : 0;
                style |= chordNameEnabled.isSelected() ? 16 : 0;
                style |= chordDiagramEnabled.isSelected() ? 32 : 0;
                int n = blackAndWhite.isSelected() ? 64 : 0;
                styles.setTrackNumber(trackNumber.intValue());
                styles.setFromMeasure(fromSpinner.getValue());
                styles.setToMeasure(toSpinner.getValue());
                styles.setStyle(style |= n);
                dialog.dispose();
                ImageExporterSettings settings = new ImageExporterSettings();
                settings.setStyles(styles);
                settings.setFormat(imageFormat);
                ImageExporterSettingsDialog.this.openDirectoryDialog(uiFactory, settings, context, callback);
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    public void openDirectoryDialog(UIFactory uiFactory, final ImageExporterSettings settings, final TGSongStreamContext context, final Runnable callback) {
        UIWindow uiWindow = TGWindow.getInstance((TGContext)this.context).getWindow();
        UIDirectoryChooser uiDirectoryChooser = uiFactory.createDirectoryChooser(uiWindow);
        uiDirectoryChooser.setText(TuxGuitar.getProperty((String)"tuxguitar-image.directory-dialog.title"));
        uiDirectoryChooser.choose(new UIDirectoryChooserHandler(){

            public void onSelectDirectory(File file) {
                settings.setPath(file != null ? file.getAbsolutePath() : null);
                if (settings.getPath() != null) {
                    context.setAttribute(ImageExporterSettings.class.getName(), (Object)settings);
                    callback.run();
                }
            }
        });
    }

    public PrintStyles createDefaultStyles(TGSong song) {
        PrintStyles styles = new PrintStyles();
        styles.setStyle(8);
        styles.setFromMeasure(1);
        styles.setToMeasure(song.countMeasureHeaders());
        styles.setTrackNumber(1);
        return styles;
    }
}

