/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.auth;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.community.TGCommunitySingleton;
import org.herac.tuxguitar.community.auth.TGCommunityAuth;
import org.herac.tuxguitar.community.utils.TGCommunityWeb;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UILinkEvent;
import org.herac.tuxguitar.ui.event.UILinkListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UILinkLabel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIPasswordField;
import org.herac.tuxguitar.ui.widget.UITextField;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;

public class TGCommunityAuthDialog {
    private TGContext context;
    private TGCommunityAuth auth;
    private Runnable onSuccess;
    private Runnable onCancel;

    public TGCommunityAuthDialog(TGContext context, Runnable onSuccess, Runnable onCancel) {
        this.context = context;
        this.onSuccess = onSuccess;
        this.onCancel = onCancel;
        this.auth = TGCommunitySingleton.getInstance(this.context).getAuth();
    }

    public void open() {
        this.open(TGWindow.getInstance((TGContext)this.context).getWindow());
    }

    public void open(UIWindow parent) {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(parent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        dialog.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.title"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signin"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel usernameLabel = uiFactory.createLabel((UIContainer)group);
        usernameLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signin.username") + ":");
        groupLayout.set((UIControl)usernameLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField usernameText = uiFactory.createTextField((UIContainer)group);
        usernameText.setText(this.auth.getUsername());
        groupLayout.set((UIControl)usernameText, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel passwordLabel = uiFactory.createLabel((UIContainer)group);
        passwordLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signin.password") + ":");
        groupLayout.set((UIControl)passwordLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIPasswordField passwordText = uiFactory.createPasswordField((UIContainer)group);
        passwordText.setText(this.auth.getPassword());
        groupLayout.set((UIControl)passwordText, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UITableLayout joinLayout = new UITableLayout();
        UILegendPanel join = uiFactory.createLegendPanel((UIContainer)dialog);
        join.setLayout((UILayout)joinLayout);
        join.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signup"));
        dialogLayout.set((UIControl)join, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILinkLabel joinLink = uiFactory.createLinkLabel((UIContainer)join);
        joinLink.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signup.tip"));
        joinLink.setWrapWidth(Float.valueOf(320.0f));
        joinLink.addLinkListener(new UILinkListener(){

            public void onLinkSelect(final UILinkEvent event) {
                new Thread(new Runnable(){

                    public void run() throws TGException {
                        TGCommunityWeb.open(TGCommunityAuthDialog.this.getContext(), event.getLink());
                    }
                }).start();
            }
        });
        joinLayout.set((UIControl)joinLink, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGCommunityAuthDialog.this.update(usernameText.getText(), passwordText.getText());
                TGCommunityAuthDialog.this.onFinish(dialog, TGCommunityAuthDialog.this.onSuccess);
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGCommunityAuthDialog.this.onFinish(dialog, TGCommunityAuthDialog.this.onCancel);
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    public void onFinish(UIWindow dialog, Runnable runnable) {
        dialog.dispose();
        if (runnable != null) {
            runnable.run();
        }
    }

    public void update(String username, String password) {
        this.auth.setUsername(username);
        this.auth.setPassword(password);
    }

    public TGContext getContext() {
        return this.context;
    }
}

