/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.custom.tuner;

import org.herac.tuxguitar.app.graphics.TGColorImpl;
import org.herac.tuxguitar.app.graphics.TGFontImpl;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.app.system.color.TGColorManager;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTunerRoughWidget;
import org.herac.tuxguitar.graphics.TGColor;
import org.herac.tuxguitar.graphics.TGFont;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIPaintEvent;
import org.herac.tuxguitar.ui.event.UIPaintListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIFont;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UIResourceFactory;
import org.herac.tuxguitar.ui.widget.UICanvas;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.util.TGContext;

public class TGTunerFineWidget {
    private static final float BOTTOM_Y = 10.0f;
    private TGContext context;
    private UIPanel panel;
    private UICanvas composite = null;
    protected String currentNoteString = null;
    protected int currentNoteValue = -1;
    protected double currentFrequency = 0.0;
    protected UIFont letterFont = null;
    protected final float FINE_TUNING_RANGE = 1.5f;

    public TGTunerFineWidget(TGContext context, UIFactory factory, UILayoutContainer parent) {
        this.context = context;
        this.init(factory, parent);
    }

    private void init(final UIFactory factory, UILayoutContainer parent) {
        UITableLayout layout = new UITableLayout();
        this.panel = factory.createPanel((UIContainer)parent, false);
        this.panel.setLayout((UILayout)layout);
        this.panel.setEnabled(false);
        this.composite = factory.createCanvas((UIContainer)this.panel, true);
        this.composite.setBgColor(TGColorManager.getInstance((TGContext)this.context).getColor(1));
        this.composite.addPaintListener(new UIPaintListener(){

            public void onPaint(UIPaintEvent event) {
                TGPainterImpl painter = new TGPainterImpl((UIResourceFactory)factory, event.getPainter());
                TGTunerFineWidget.this.paintWidget((TGPainter)painter);
            }
        });
        layout.set((UIControl)this.composite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.letterFont = factory.createFont(TGConfigManager.getInstance((TGContext)this.context).getFontModelConfigValue("matrix.font").getName(), 14.0f, true, false);
    }

    public void paintWidget(TGPainter painter) {
        TGColorManager colorManager = TGColorManager.getInstance((TGContext)this.context);
        UIRectangle compositeSize = this.composite.getBounds();
        painter.setForeground((TGColor)new TGColorImpl(colorManager.getColor(2)));
        painter.initPath();
        painter.setLineWidth(2.0f);
        float height = compositeSize.getHeight() - 10.0f - 25.0f;
        painter.moveTo(compositeSize.getWidth() / 2.0f, compositeSize.getHeight() - 10.0f);
        painter.lineTo(compositeSize.getWidth() / 2.0f, 25.0f);
        painter.closePath();
        painter.initPath();
        height = Math.min(height, compositeSize.getWidth() / 2.0f);
        painter.moveTo(compositeSize.getWidth() / 2.0f - height, compositeSize.getHeight() - 10.0f);
        painter.lineTo(compositeSize.getWidth() / 2.0f + height, compositeSize.getHeight() - 10.0f);
        painter.closePath();
        if (this.panel.isEnabled()) {
            painter.setForeground((TGColor)new TGColorImpl(colorManager.getColor(4)));
            painter.setFont((TGFont)new TGFontImpl(this.letterFont));
            painter.drawString(this.currentNoteString, compositeSize.getWidth() * 12.0f / 15.0f, 10.0f);
            if (this.currentFrequency != -1.0) {
                painter.setLineWidth(3.0f);
                painter.setForeground((TGColor)new TGColorImpl(colorManager.getColor(5)));
                painter.initPath();
                painter.moveTo(compositeSize.getWidth() / 2.0f, compositeSize.getHeight() - 10.0f);
                painter.lineTo((float)((double)(compositeSize.getWidth() / 2.0f) + (double)height * Math.cos(this.getAngleRad())), (float)((double)(compositeSize.getHeight() - 10.0f) - (double)height * Math.sin(this.getAngleRad())));
                painter.closePath();
            }
        }
    }

    public void setWantedTone(int tone) {
        this.panel.setEnabled(true);
        this.currentNoteValue = tone;
        this.currentNoteString = TGTunerRoughWidget.TONESSTRING[tone % 12] + (int)Math.floor(tone / 12);
        this.redraw();
    }

    public void setCurrentFrequency(double freq) {
        this.currentFrequency = freq;
        this.redraw();
    }

    public void redraw() {
        this.composite.redraw();
    }

    protected double getAngleRad() {
        double d = this.stickDistance(this.getTone(this.currentFrequency) - (float)this.currentNoteValue);
        this.getClass();
        return Math.PI * (1.0 - (d + 1.5) / (double)(2.0f * this.FINE_TUNING_RANGE));
    }

    private float getTone(double frequency) {
        return (float)(45.0 + 12.0 * (Math.log(frequency / 110.0) / Math.log(2.0)));
    }

    private double stickDistance(double diff) {
        double d = Math.abs(diff);
        this.getClass();
        if (d > 1.5) {
            if (diff > 0.0) {
                this.getClass();
                return 1.5;
            }
            return -this.FINE_TUNING_RANGE;
        }
        return diff;
    }

    public UIControl getControl() {
        return this.panel;
    }

    public boolean isDisposed() {
        return this.panel == null || this.panel.isDisposed();
    }
}

