/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.pdf;

import java.io.OutputStream;
import org.herac.tuxguitar.app.printer.PrintDocument;
import org.herac.tuxguitar.app.printer.PrintLayout;
import org.herac.tuxguitar.app.printer.PrintStyles;
import org.herac.tuxguitar.awt.graphics.TGResourceFactoryImpl;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.graphics.TGDimension;
import org.herac.tuxguitar.graphics.TGMargins;
import org.herac.tuxguitar.graphics.TGResourceFactory;
import org.herac.tuxguitar.graphics.control.TGController;
import org.herac.tuxguitar.graphics.control.TGFactoryImpl;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGSongStream;
import org.herac.tuxguitar.io.base.TGSongStreamContext;
import org.herac.tuxguitar.io.pdf.PDFController;
import org.herac.tuxguitar.io.pdf.PDFDocument;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class PDFSongStream
implements TGSongStream {
    private static final int PAGE_WIDTH = 550;
    private static final int PAGE_HEIGHT = 800;
    private static final int MARGIN_TOP = 20;
    private static final int MARGIN_BOTTOM = 20;
    private static final int MARGIN_LEFT = 20;
    private static final int MARGIN_RIGHT = 20;
    private TGContext context;
    private TGSongStreamContext streamContext;

    public PDFSongStream(TGContext context, TGSongStreamContext streamContext) {
        this.context = context;
        this.streamContext = streamContext;
    }

    public PrintStyles getDefaultStyles(TGSong song) {
        PrintStyles styles = new PrintStyles();
        styles.setStyle(72);
        styles.setFromMeasure(1);
        styles.setToMeasure(song.countMeasureHeaders());
        styles.setTrackNumber(1);
        return styles;
    }

    public void process() throws TGFileFormatException {
        try {
            OutputStream stream = (OutputStream)this.streamContext.getAttribute(OutputStream.class.getName());
            TGSong song = (TGSong)this.streamContext.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
            PrintStyles styles = (PrintStyles)this.streamContext.getAttribute(PrintStyles.class.getName());
            if (styles == null) {
                styles = this.getDefaultStyles(song);
            }
            TGSongManager manager = new TGSongManager((TGFactory)new TGFactoryImpl());
            TGSong clonedSong = song.clone(manager.getFactory());
            TGResourceFactoryImpl factory = new TGResourceFactoryImpl();
            PDFController controller = new PDFController(clonedSong, manager, (TGResourceFactory)factory);
            TGDimension pageSize = new TGDimension(550.0f, 800.0f);
            TGMargins pageMargins = new TGMargins(20.0f, 20.0f, 20.0f, 20.0f);
            PrintLayout layout = new PrintLayout((TGController)controller, styles);
            layout.loadStyles(1.0f);
            layout.updateSong();
            layout.makeDocument((PrintDocument)new PDFDocument(this.context, pageSize, pageMargins, stream));
            controller.getResourceBuffer().disposeAllResources();
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }
}

