/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.tremolopicking;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.action.effect.TGChangeTremoloPickingAction;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIRadioButton;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class TGTremoloPickingDialog {
    private UIRadioButton thirtySecondButton;
    private UIRadioButton sixTeenthButton;
    private UIRadioButton eighthButton;

    public void show(final TGViewContext context) {
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        final TGString string = (TGString)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING);
        TGNote note = (TGNote)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE);
        if (measure != null && beat != null && note != null && string != null) {
            UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
            UIWindow uiParent = (UIWindow)context.getAttribute("parent2");
            UITableLayout dialogLayout = new UITableLayout();
            final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
            dialog.setLayout((UILayout)dialogLayout);
            dialog.setText(TuxGuitar.getProperty("effects.tremolo-picking-editor"));
            int duration = 8;
            if (note.getEffect().isTremoloPicking()) {
                duration = note.getEffect().getTremoloPicking().getDuration().getValue();
            }
            UITableLayout durationLayout = new UITableLayout();
            UILegendPanel durationGroup = uiFactory.createLegendPanel((UIContainer)dialog);
            durationGroup.setText(TuxGuitar.getProperty("duration"));
            durationGroup.setLayout((UILayout)durationLayout);
            dialogLayout.set((UIControl)durationGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.thirtySecondButton = uiFactory.createRadioButton((UIContainer)durationGroup);
            this.thirtySecondButton.setImage(TuxGuitar.getInstance().getIconManager().getDuration(32));
            this.thirtySecondButton.setSelected(duration == 32);
            durationLayout.set((UIControl)this.thirtySecondButton, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.sixTeenthButton = uiFactory.createRadioButton((UIContainer)durationGroup);
            this.sixTeenthButton.setImage(TuxGuitar.getInstance().getIconManager().getDuration(16));
            this.sixTeenthButton.setSelected(duration == 16);
            durationLayout.set((UIControl)this.sixTeenthButton, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.eighthButton = uiFactory.createRadioButton((UIContainer)durationGroup);
            this.eighthButton.setImage(TuxGuitar.getInstance().getIconManager().getDuration(8));
            this.eighthButton.setSelected(duration == 8);
            durationLayout.set((UIControl)this.eighthButton, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
            UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
            buttons.setLayout((UILayout)buttonsLayout);
            dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setDefaultButton();
            buttonOK.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGTremoloPickingDialog.this.changeTremoloPicking(context.getContext(), measure, beat, string, TGTremoloPickingDialog.this.getTremoloPicking());
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonClean = uiFactory.createButton((UIContainer)buttons);
            buttonClean.setText(TuxGuitar.getProperty("clean"));
            buttonClean.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGTremoloPickingDialog.this.changeTremoloPicking(context.getContext(), measure, beat, string, null);
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonClean, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
            TGDialogUtil.openDialog(dialog, 5);
        }
    }

    public TGEffectTremoloPicking getTremoloPicking() {
        TGEffectTremoloPicking effect = TuxGuitar.getInstance().getSongManager().getFactory().newEffectTremoloPicking();
        if (this.thirtySecondButton.isSelected()) {
            effect.getDuration().setValue(32);
        } else if (this.sixTeenthButton.isSelected()) {
            effect.getDuration().setValue(16);
        } else if (this.eighthButton.isSelected()) {
            effect.getDuration().setValue(8);
        } else {
            return null;
        }
        return effect;
    }

    public void changeTremoloPicking(TGContext context, TGMeasure measure, TGBeat beat, TGString string, TGEffectTremoloPicking effect) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.note.effect.change-tremolo-picking");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
        tgActionProcessor.setAttribute(TGChangeTremoloPickingAction.ATTRIBUTE_EFFECT, (Object)effect);
        tgActionProcessor.process();
    }
}

