/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.browser.main;

import java.io.InputStream;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.tools.browser.TGBrowserCollection;
import org.herac.tuxguitar.app.tools.browser.TGBrowserConnection;
import org.herac.tuxguitar.app.tools.browser.TGBrowserConnectionHandler;
import org.herac.tuxguitar.app.tools.browser.TGBrowserFactoryListener;
import org.herac.tuxguitar.app.tools.browser.TGBrowserManager;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowser;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserCallBack;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserElement;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserFactory;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserFactoryHandler;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserMenuBar;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserToolBar;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGCursorController;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.action.file.TGReadSongAction;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UIMouseDoubleClickListener;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UICursor;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UITable;
import org.herac.tuxguitar.ui.widget.UITableItem;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;
import org.herac.tuxguitar.util.error.TGErrorHandler;
import org.herac.tuxguitar.util.error.TGErrorManager;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGBrowserDialog
implements TGBrowserFactoryListener,
TGBrowserConnectionHandler,
TGEventListener {
    private static final int SHELL_WIDTH = 500;
    private static final int SHELL_HEIGHT = 350;
    private TGContext context;
    private TGBrowserCollection collection;
    private TGBrowserConnection connection;
    private UIWindow dialog;
    private UITable<TGBrowserElement> table;
    private List<TGBrowserElement> elements;
    private TGBrowserMenuBar menu;
    private TGBrowserToolBar toolBar;
    private TGCursorController cursorController;

    public TGBrowserDialog(TGContext context) {
        this.context = context;
        this.connection = new TGBrowserConnection(this);
        this.menu = new TGBrowserMenuBar(this);
        this.toolBar = new TGBrowserToolBar(this);
    }

    public TGContext getContext() {
        return this.context;
    }

    public TGBrowserConnection getConnection() {
        return this.connection;
    }

    public TGBrowserCollection getCollection() {
        return this.collection;
    }

    public void setCollection(TGBrowserCollection collection) {
        this.collection = collection;
    }

    public UIWindow getWindow() {
        return this.dialog;
    }

    public void exit() {
        this.closeCollection(true);
        TGBrowserManager.getInstance(this.context).writeCollections();
        TuxGuitar.getInstance().getIconManager().removeLoader(this);
    }

    public void show() {
        this.collection = null;
        this.elements = null;
        this.dialog = this.getUIFactory().createWindow(TGWindow.getInstance(this.context).getWindow(), false, true);
        this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        this.menu.createMenuBar(this.getWindow());
        this.toolBar.createToolBar((UIContainer)this.getWindow());
        this.initTable((UIContainer)this.dialog);
        this.createLayout();
        this.updateCollections(null);
        this.updateTable();
        this.dialog.setBounds(new UIRectangle(0.0f, 0.0f, 500.0f, 350.0f));
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGBrowserDialog.this.exit();
            }
        });
        this.loadProperties();
        this.updateBars();
        TGBrowserManager.getInstance(this.context).setFactoryHandler(this);
        TuxGuitar.getInstance().getIconManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TGDialogUtil.openDialog(this.dialog, 6);
    }

    public void createLayout() {
        UITableLayout uiLayout = new UITableLayout();
        uiLayout.set((UIControl)this.toolBar.getControl(), Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        uiLayout.set(this.table, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        uiLayout.set(this.table, "packed_width", (Object)Float.valueOf(10.0f));
        uiLayout.set(this.table, "packed_height", (Object)Float.valueOf(10.0f));
        this.dialog.setLayout((UILayout)uiLayout);
    }

    public void initTable(UIContainer parent) {
        this.table = this.getUIFactory().createTable(parent, false);
        this.table.setColumns(1);
        this.table.addMouseDoubleClickListener(new UIMouseDoubleClickListener(){

            public void onMouseDoubleClick(UIMouseEvent event) {
                TGBrowserDialog.this.openElement();
            }
        });
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public void updateTable() {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() {
                    if (!TGBrowserDialog.this.isDisposed()) {
                        TGBrowserDialog.this.table.removeItems();
                        if (TGBrowserDialog.this.elements != null) {
                            for (TGBrowserElement element : TGBrowserDialog.this.elements) {
                                TGIconManager iconManager = TGIconManager.getInstance(TGBrowserDialog.this.context);
                                UITableItem item = new UITableItem((Object)element);
                                item.setImage(element.isFolder() ? iconManager.getBrowserFolder() : iconManager.getBrowserFile());
                                item.setText(0, element.getName());
                                TGBrowserDialog.this.table.addItem(item);
                            }
                        }
                    }
                }
            });
        }
    }

    public void updateBars() {
        if (!this.isDisposed()) {
            this.menu.updateItems();
            this.toolBar.updateItems();
        }
    }

    public void updateBarsLater() {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() {
                    TGBrowserDialog.this.updateBars();
                }
            });
        }
    }

    public void updateCollections(final TGBrowserCollection selection) {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() {
                    if (!TGBrowserDialog.this.isDisposed()) {
                        TGBrowserDialog.this.menu.updateCollections(selection);
                        TGBrowserDialog.this.toolBar.updateCollections(selection);
                    }
                }
            });
        }
    }

    public void removeElements() {
        this.elements = null;
    }

    public void addElements(List<TGBrowserElement> elements) {
        this.elements = elements;
    }

    public void removeCollection(TGBrowserCollection collection) {
        if (collection != null) {
            TGBrowserManager.getInstance(this.context).removeCollection(collection);
            if (this.getCollection() != null && this.getCollection().equals(collection)) {
                this.closeCollection();
            } else {
                this.updateCollections(this.getCollection());
            }
        }
    }

    public void openCollection() {
        if (!this.isDisposed() && this.getCollection() != null) {
            TGBrowserFactory tgBrowserFactory = TGBrowserManager.getInstance(this.context).getFactory(this.getCollection().getType());
            if (tgBrowserFactory != null) {
                tgBrowserFactory.createBrowser(new TGBrowserFactoryHandler(){

                    public void onCreateBrowser(TGBrowser browser) {
                        TGBrowserDialog.this.getConnection().open((TGBrowserCallBack<Object>)new TGAbstractBrowserCallBack<Object>(){

                            @Override
                            public void onSuccess(Object data) {
                                TGBrowserDialog.this.onOpenCollection();
                            }
                        }, browser);
                    }

                    public void handleError(Throwable throwable) {
                        TGBrowserDialog.this.notifyError(throwable);
                    }
                }, this.getCollection().getData());
            } else {
                this.closeCollection();
            }
        }
    }

    public void closeCollection() {
        this.closeCollection(false);
    }

    public void closeCollection(boolean force) {
        if ((!this.isDisposed() || force) && this.getCollection() != null) {
            this.getConnection().close((TGBrowserCallBack<Object>)new TGAbstractBrowserCallBack<Object>(){

                @Override
                public void onSuccess(Object data) {
                    TGBrowserDialog.this.onCloseCollection();
                }
            }, force);
        }
    }

    public void cdRoot() {
        if (!this.isDisposed()) {
            this.getConnection().cdRoot((TGBrowserCallBack<Object>)new TGAbstractBrowserCallBack<Object>(){

                @Override
                public void onSuccess(Object data) {
                    TGBrowserDialog.this.onCd();
                }
            });
        }
    }

    public void cdUp() {
        if (!this.isDisposed()) {
            this.getConnection().cdUp((TGBrowserCallBack<Object>)new TGAbstractBrowserCallBack<Object>(){

                @Override
                public void onSuccess(Object data) {
                    TGBrowserDialog.this.onCd();
                }
            });
        }
    }

    public void cdElement(TGBrowserElement element) {
        if (!this.isDisposed()) {
            this.getConnection().cdElement((TGBrowserCallBack<Object>)new TGAbstractBrowserCallBack<Object>(){

                @Override
                public void onSuccess(Object data) {
                    TGBrowserDialog.this.onCd();
                }
            }, element);
        }
    }

    public void listElements() {
        if (!this.isDisposed()) {
            this.getConnection().listElements((TGBrowserCallBack<List<TGBrowserElement>>)new TGAbstractBrowserCallBack<List<TGBrowserElement>>(){

                @Override
                public void onSuccess(List<TGBrowserElement> elements) {
                    TGBrowserDialog.this.notifyElements(elements);
                }
            });
        }
    }

    public void openStream(final TGBrowserElement element) {
        if (!this.isDisposed()) {
            this.getConnection().openStream((TGBrowserCallBack<InputStream>)new TGAbstractBrowserCallBack<InputStream>(){

                @Override
                public void onSuccess(InputStream stream) {
                    TGBrowserDialog.this.onOpenStream(stream, element);
                }
            }, element);
        }
    }

    public void openElement() {
        TGBrowserElement element;
        if (!this.isDisposed() && this.getConnection().isOpen() && (element = (TGBrowserElement)this.table.getSelectedValue()) != null) {
            if (element.isFolder()) {
                this.cdElement(element);
            } else {
                this.openStream(element);
            }
        }
    }

    public void onOpenCollection() {
        if (!this.isDisposed()) {
            this.removeElements();
            this.updateTable();
            this.updateCollections(this.getCollection());
            this.listElements();
        }
    }

    public void onCloseCollection() {
        if (!this.isDisposed()) {
            this.setCollection(null);
            this.removeElements();
            this.updateCollections(this.getCollection());
            this.updateTable();
        }
    }

    public void onCd() {
        if (!this.isDisposed()) {
            this.listElements();
        }
    }

    public void notifyElements(List<TGBrowserElement> elements) {
        if (!this.isDisposed()) {
            this.addElements(elements);
            this.updateTable();
        }
    }

    public void onOpenStream(InputStream stream, final TGBrowserElement element) {
        this.loadCursor(UICursor.WAIT);
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.song.read");
        tgActionProcessor.setAttribute(TGReadSongAction.ATTRIBUTE_INPUT_STREAM, (Object)stream);
        tgActionProcessor.setOnFinish(new Runnable(){

            public void run() {
                TGBrowserDialog.this.loadCursor(UICursor.NORMAL);
            }
        });
        tgActionProcessor.setAttribute(TGErrorHandler.class.getName(), (Object)new TGErrorHandler(){

            public void handleError(Throwable throwable) {
                TGBrowserDialog.this.loadCursor(UICursor.NORMAL);
                TGMessageDialogUtil.errorMessage(TGBrowserDialog.this.getContext(), TGBrowserDialog.this.getWindow(), TuxGuitar.getProperty("file.open.error", new String[]{element.getName()}));
            }
        });
        tgActionProcessor.process();
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.getWindow().setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            this.reload();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("browser.dialog"));
            this.menu.loadProperties();
            this.toolBar.loadProperties();
        }
    }

    public void loadCursor(UICursor cursor) {
        if (!this.isDisposed()) {
            if (this.cursorController == null || !this.cursorController.isControlling((UIControl)this.dialog)) {
                this.cursorController = new TGCursorController(this.context, (UIControl)this.dialog);
            }
            this.cursorController.loadCursor(cursor);
        }
    }

    @Override
    public void notifyAdded() {
        if (!this.isDisposed()) {
            this.reload();
        }
    }

    @Override
    public void notifyRemoved() {
        if (!this.isDisposed()) {
            if (this.getCollection() != null) {
                this.closeCollection();
            }
            this.reload();
        }
    }

    @Override
    public void notifyLockStatusChanged() {
        if (!this.isDisposed()) {
            this.updateBarsLater();
            this.loadCursor(this.getConnection().isLocked() ? UICursor.WAIT : UICursor.NORMAL);
        }
    }

    public void notifyError(Throwable throwable) {
        if (!this.isDisposed()) {
            this.updateTable();
            TGErrorManager.getInstance((TGContext)this.context).handleError(throwable);
        }
    }

    public void reload() {
        if (!this.isDisposed()) {
            this.menu.reload(this.getWindow());
            this.toolBar.reload();
            this.updateTable();
            this.updateCollections(this.getCollection());
            this.createLayout();
            this.getWindow().layout();
        }
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }

    public void processEvent(TGEvent event) {
        if ("ui-icon".equals(event.getEventType())) {
            this.loadIcons();
        } else if ("language".equals(event.getEventType())) {
            this.loadProperties();
        }
    }

    public static TGBrowserDialog getInstance(TGContext context) {
        return (TGBrowserDialog)TGSingletonUtil.getInstance((TGContext)context, (String)TGBrowserDialog.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGBrowserDialog>(){

            public TGBrowserDialog createInstance(TGContext context) {
                return new TGBrowserDialog(context);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TGAbstractBrowserCallBack<T>
    implements TGBrowserCallBack<T> {
        private TGAbstractBrowserCallBack() {
        }

        public void handleError(Throwable throwable) {
            TGBrowserDialog.this.notifyError(throwable);
        }
    }
}

