/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.tab.edit;

import java.util.ArrayList;
import java.util.Iterator;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.tab.Caret;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.app.view.component.tab.edit.MouseKit;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGNoteImpl;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.graphics.control.TGVoiceImpl;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.util.TGAbstractContext;

public class EditorKit {
    public static final String ATTRIBUTE_X = "editorKit-x";
    public static final String ATTRIBUTE_Y = "editorKit-y";
    public static final int MOUSE_MODE_SELECTION = 1;
    public static final int MOUSE_MODE_EDITION = 2;
    private static final int[] FIRST_LINE_VALUES = new int[]{65, 45, 52, 55};
    private int mouseMode;
    private boolean natural;
    private Tablature tablature;
    private MouseKit mouseKit;
    private TGMeasureImpl selectedMeasure;

    public EditorKit(Tablature tablature) {
        this.tablature = tablature;
        this.mouseKit = new MouseKit(this);
        this.setDefaults();
    }

    private void setDefaults() {
        this.setMouseMode(TuxGuitar.getInstance().getConfig().getIntegerValue("editor.mouse.mode", 2));
        this.setNatural(TuxGuitar.getInstance().getConfig().getBooleanValue("editor.natural.key.mode", true));
    }

    public int getMouseMode() {
        return this.mouseMode;
    }

    public void setMouseMode(int mouseMode) {
        this.mouseMode = mouseMode;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public void setNatural(boolean natural) {
        this.natural = natural;
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public MouseKit getMouseKit() {
        return this.mouseKit;
    }

    public boolean isScoreEnabled() {
        return (this.getTablature().getViewLayout().getStyle() & 4) != 0;
    }

    public boolean isMouseEditionAvailable() {
        return this.isScoreEnabled() && this.getMouseMode() == 2;
    }

    public boolean fillSelection(TGAbstractContext context) {
        TGBeatImpl beat;
        TGMeasureImpl measure;
        TGTrackImpl track;
        float x = ((Float)context.getAttribute(ATTRIBUTE_X)).floatValue();
        float y = ((Float)context.getAttribute(ATTRIBUTE_Y)).floatValue();
        if (x >= 0.0f && y >= 0.0f && (track = this.findSelectedTrack(y)) != null && (measure = this.findSelectedMeasure(track, x, y)) != null && (beat = this.findSelectedBeat(measure, x)) != null) {
            TGString string = this.findSelectedString(measure, y);
            if (string == null) {
                string = this.getTablature().getCaret().getSelectedString();
            }
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, (Object)measure.getHeader());
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
            return true;
        }
        return false;
    }

    private TGTrackImpl findSelectedTrack(float y) {
        TGLayout layout = this.getTablature().getViewLayout();
        int number = layout.getTrackNumberAt(y);
        if (number >= 0) {
            return (TGTrackImpl)layout.getSongManager().getTrack(this.getTablature().getSong(), number);
        }
        return null;
    }

    private TGMeasureImpl findSelectedMeasure(TGTrackImpl track, float x, float y) {
        TGMeasureImpl measure = null;
        float minorDistance = 0.0f;
        Iterator it = track.getMeasures();
        while (it.hasNext()) {
            boolean isAtX;
            TGMeasureImpl m = (TGMeasureImpl)it.next();
            if (m.isOutOfBounds() || m.getTs() == null || !(isAtX = x >= m.getPosX() && x <= m.getPosX() + m.getWidth(this.getTablature().getViewLayout()) + m.getSpacing())) continue;
            float measureHeight = m.getTs().getSize();
            float distanceY = Math.min(Math.abs(y - m.getPosY()), Math.abs(y - (m.getPosY() + measureHeight - 10.0f)));
            if (measure != null && !(distanceY < minorDistance)) continue;
            measure = m;
            minorDistance = distanceY;
        }
        return measure;
    }

    private TGBeatImpl findSelectedBeat(TGMeasureImpl measure, float x) {
        TGLayout layout = this.getTablature().getViewLayout();
        int voice = this.getTablature().getCaret().getVoice();
        float posX = measure.getHeaderImpl().getLeftSpacing(layout) + measure.getPosX();
        float bestDiff = -1.0f;
        TGBeatImpl bestBeat = null;
        for (TGBeatImpl beat : measure.getBeats()) {
            if (beat.getVoice(voice).isEmpty()) continue;
            float diff = Math.abs(x - (posX + (beat.getPosX() + beat.getSpacing(layout))));
            if (bestDiff != -1.0f && !(diff < bestDiff)) continue;
            bestBeat = beat;
            bestDiff = diff;
        }
        if (bestBeat == null) {
            bestBeat = (TGBeatImpl)layout.getSongManager().getMeasureManager().getFirstBeat(measure.getBeats());
        }
        return bestBeat;
    }

    private TGString findSelectedString(TGMeasureImpl measure, float y) {
        TGString string = null;
        float stringSpacing = this.getTablature().getViewLayout().getStringSpacing();
        float minorDistance = 0.0f;
        float firstStringY = measure.getPosY() + measure.getTs().getPosition(14);
        for (TGString currString : measure.getTrack().getStrings()) {
            float distanceX = Math.abs(y - (firstStringY + ((float)currString.getNumber() * stringSpacing - stringSpacing)));
            if (string != null && !(distanceX < minorDistance)) continue;
            string = currString;
            minorDistance = distanceX;
        }
        return string;
    }

    private TGString findBestString(TGTrack track, TGVoice voice, int value) {
        ArrayList<TGString> strings = new ArrayList<TGString>();
        for (int number = 1; number <= track.stringCount(); ++number) {
            boolean used = false;
            TGString string = track.getString(number);
            for (TGNote note : voice.getNotes()) {
                if (note.getString() != string.getNumber()) continue;
                used = true;
            }
            if (used) continue;
            strings.add(string);
        }
        int minFret = -1;
        TGString stringForValue = null;
        for (int i = 0; i < strings.size(); ++i) {
            TGString string = (TGString)strings.get(i);
            int fret = value - string.getValue();
            if (fret < 0 || minFret >= 0 && fret >= minFret) continue;
            stringForValue = string;
            minFret = fret;
        }
        return stringForValue;
    }

    private TGVoiceImpl findBestVoice(TGMeasureImpl measure, float x) {
        TGBeatImpl beat2;
        TGLayout layout = this.getTablature().getViewLayout();
        int voiceIndex = this.getTablature().getCaret().getVoice();
        float posX = measure.getHeaderImpl().getLeftSpacing(layout) + measure.getPosX();
        float bestDiff = -1.0f;
        TGVoiceImpl bestVoice = null;
        TGDuration duration = this.getTablature().getCaret().getDuration();
        for (TGBeatImpl beat2 : measure.getBeats()) {
            TGVoiceImpl voice = beat2.getVoiceImpl(voiceIndex);
            if (voice.isEmpty()) continue;
            float x1 = beat2.getPosX() + beat2.getSpacing(layout);
            float x2 = x1 + voice.getWidth();
            float increment = voice.getWidth();
            if (voice.isRestVoice()) {
                increment = (float)duration.getTime() * voice.getWidth() / (float)voice.getDuration().getTime();
            }
            for (float beatX = x1; beatX < x2; beatX += increment) {
                float diff = Math.abs(x - (posX + beatX));
                if (bestDiff != -1.0f && !(diff < bestDiff)) continue;
                bestVoice = voice;
                bestDiff = diff;
            }
        }
        if (bestVoice == null && (beat2 = layout.getSongManager().getMeasureManager().getFirstBeat(measure.getBeats())) != null) {
            bestVoice = (TGVoiceImpl)beat2.getVoice(voiceIndex);
        }
        return bestVoice;
    }

    public boolean fillAddOrRemoveBeat(TGAbstractContext context) {
        float x = ((Float)context.getAttribute(ATTRIBUTE_X)).floatValue();
        float y = ((Float)context.getAttribute(ATTRIBUTE_Y)).floatValue();
        TGLayout.TrackPosition pos = this.getTablature().getViewLayout().getTrackPositionAt(y);
        if (pos != null) {
            TGTrackImpl track = this.getTablature().getCaret().getTrack();
            TGMeasureImpl measure = this.getTablature().getCaret().getMeasure();
            if (measure.getTs() != null) {
                int minValue = track.getString(track.stringCount()).getValue();
                int maxValue = track.getString(1).getValue() + 29;
                float lineSpacing = this.getTablature().getViewLayout().getScoreLineSpacing();
                float topHeight = measure.getTs().getPosition(8);
                float bottomHeight = measure.getTs().getPosition(14) - measure.getTs().getPosition(9);
                float y1 = pos.getPosY() + measure.getTs().getPosition(8);
                float y2 = y1 + lineSpacing * 5.0f;
                if (y >= y1 - topHeight && y < y2 + bottomHeight) {
                    TGVoiceImpl voice;
                    int value = 0;
                    int tempValue = FIRST_LINE_VALUES[measure.getClef() - 1];
                    double limit = (double)topHeight / ((double)lineSpacing / 2.0);
                    int i = 0;
                    while ((double)i < limit) {
                        tempValue += TGMeasureImpl.ACCIDENTAL_NOTES[(tempValue + 1) % 12] ? 2 : 1;
                        ++i;
                    }
                    float minorDistance = 0.0f;
                    float posY = y1 - topHeight;
                    while (posY <= y2 + bottomHeight) {
                        if (tempValue > 0) {
                            float distanceY = Math.abs(y - posY);
                            if (value == 0 || distanceY < minorDistance) {
                                value = tempValue;
                                minorDistance = distanceY;
                            }
                            tempValue -= TGMeasureImpl.ACCIDENTAL_NOTES[(tempValue - 1) % 12] ? 2 : 1;
                        }
                        posY = (float)((double)posY + (double)lineSpacing / 2.0);
                    }
                    if (value >= minValue && value <= maxValue && (voice = this.findBestVoice(measure, x)) != null) {
                        value = this.getRealValue(value);
                        context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE, (Object)voice);
                        context.setAttribute("value", (Object)value);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private long getRealStart(TGVoiceImpl voice, float x) {
        if (voice.isEmpty()) {
            return voice.getBeat().getStart();
        }
        TGLayout layout = this.getTablature().getViewLayout();
        TGMeasureImpl measure = voice.getBeatImpl().getMeasureImpl();
        long beatStart = voice.getBeat().getStart();
        float beatX = measure.getHeaderImpl().getLeftSpacing(layout) + measure.getPosX() + voice.getBeatImpl().getPosX() + voice.getBeatImpl().getSpacing(layout);
        if (x > beatX) {
            long beatLength = voice.getDuration().getTime();
            long beatEnd = beatStart + beatLength;
            return Math.min(beatStart + (long)Math.round(x - beatX) * beatLength / (long)Math.round(voice.getWidth()), beatEnd - 1L);
        }
        return beatStart;
    }

    private int getRealValue(int value) {
        int realValue = value;
        int key = this.getTablature().getCaret().getMeasure().getKeySignature();
        if (key <= 7) {
            if (TGMeasureImpl.KEY_SIGNATURES[key][TGMeasureImpl.ACCIDENTAL_SHARP_NOTES[realValue % 12]] == 2 && this.isNatural()) {
                ++realValue;
            } else if (TGMeasureImpl.KEY_SIGNATURES[key][TGMeasureImpl.ACCIDENTAL_SHARP_NOTES[realValue % 12]] != 2 && !this.isNatural() && TGMeasureImpl.ACCIDENTAL_NOTES[(realValue + 1) % 12]) {
                ++realValue;
            }
        } else if (key > 7) {
            if (TGMeasureImpl.KEY_SIGNATURES[key][TGMeasureImpl.ACCIDENTAL_FLAT_NOTES[realValue % 12]] == 3 && this.isNatural()) {
                --realValue;
            } else if (TGMeasureImpl.KEY_SIGNATURES[key][TGMeasureImpl.ACCIDENTAL_FLAT_NOTES[realValue % 12]] != 3 && !this.isNatural() && TGMeasureImpl.ACCIDENTAL_NOTES[(realValue - 1) % 12]) {
                --realValue;
            }
        }
        return realValue;
    }

    public boolean fillRemoveNoteContext(TGAbstractContext context) {
        TGVoice voice = (TGVoice)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE);
        Integer value = (Integer)context.getAttribute("value");
        for (TGNoteImpl note : voice.getNotes()) {
            if (note.getRealValue() != value.intValue()) continue;
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE, (Object)note);
            return true;
        }
        return false;
    }

    public boolean fillCreateNoteContext(TGAbstractContext targetContext) {
        TGVoiceImpl voice = (TGVoiceImpl)targetContext.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE);
        Integer value = (Integer)targetContext.getAttribute("value");
        float x = ((Float)targetContext.getAttribute(ATTRIBUTE_X)).floatValue();
        long start = this.getRealStart(voice, x);
        Caret caret = this.getTablature().getCaret();
        TGTrackImpl track = caret.getTrack();
        TGString string = this.findBestString((TGTrack)track, (TGVoice)voice, value);
        if (string != null) {
            targetContext.setAttribute("position", (Object)start);
            targetContext.setAttribute("fret", (Object)(value - string.getValue()));
            targetContext.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE, (Object)voice);
            targetContext.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
            targetContext.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)voice.getBeat());
            return true;
        }
        return false;
    }

    public boolean updateSelectedMeasure(TGAbstractContext context) {
        boolean selectionUpdated;
        float x = ((Float)context.getAttribute(ATTRIBUTE_X)).floatValue();
        float y = ((Float)context.getAttribute(ATTRIBUTE_Y)).floatValue();
        TGMeasureImpl previousSelection = this.selectedMeasure;
        TGTrackImpl track = this.findSelectedTrack(y);
        if (track != null) {
            this.selectedMeasure = this.findSelectedMeasure(track, x, y);
        }
        if (!(selectionUpdated = false) && this.selectedMeasure == null && previousSelection != null) {
            selectionUpdated = true;
        }
        if (!selectionUpdated && this.selectedMeasure != null && previousSelection == null) {
            selectionUpdated = true;
        }
        if (!selectionUpdated && this.selectedMeasure != null) {
            selectionUpdated = !this.selectedMeasure.equals(previousSelection);
        }
        return selectionUpdated;
    }

    public void resetSelectedMeasure() {
        this.selectedMeasure = null;
    }

    public void paintSelection(TGLayout layout, TGPainter painter) {
        TGMeasureImpl measure;
        if (!TuxGuitar.getInstance().getPlayer().isRunning() && (measure = this.selectedMeasure) != null && measure.getTs() != null && measure.getTrack().stringCount() > 0) {
            float scale = layout.getScale();
            int minValue = measure.getTrack().getString(measure.getTrack().stringCount()).getValue();
            int maxValue = measure.getTrack().getString(1).getValue() + 29;
            float lineSpacing = layout.getScoreLineSpacing();
            float width = (int)(10.0f * scale);
            float topHeight = measure.getTs().getPosition(8);
            float bottomHeight = measure.getTs().getPosition(14) - measure.getTs().getPosition(9);
            int tempValue = 0;
            float x1 = 0.0f;
            float x2 = 0.0f;
            float y1 = measure.getPosY() + measure.getTs().getPosition(8);
            float y2 = y1 + lineSpacing * 5.0f;
            block0: for (int b = 0; b < measure.countBeats(); ++b) {
                float y;
                TGBeatImpl beat = (TGBeatImpl)measure.getBeat(b);
                if (!this.isPaintableBeat((TGBeat)beat)) continue;
                x1 = measure.getHeaderImpl().getLeftSpacing(layout) + measure.getPosX() + beat.getPosX() + beat.getSpacing(layout);
                x2 = x1 + width;
                painter.setForeground(layout.getResources().getLineColor());
                tempValue = FIRST_LINE_VALUES[measure.getClef() - 1];
                for (y = y1 - lineSpacing; y >= y1 - topHeight && (tempValue += TGMeasureImpl.ACCIDENTAL_NOTES[((tempValue += TGMeasureImpl.ACCIDENTAL_NOTES[(tempValue + 1) % 12] ? 2 : 1) + 1) % 12] ? 2 : 1) <= maxValue; y -= lineSpacing) {
                    painter.initPath();
                    painter.setAntialias(false);
                    painter.moveTo(x1, y);
                    painter.lineTo(x2, y);
                    painter.closePath();
                }
                tempValue = FIRST_LINE_VALUES[measure.getClef() - 1] - 14;
                for (y = y2; y <= y2 + bottomHeight; y += lineSpacing) {
                    if (tempValue <= 0) continue;
                    if ((tempValue -= TGMeasureImpl.ACCIDENTAL_NOTES[((tempValue -= TGMeasureImpl.ACCIDENTAL_NOTES[(tempValue - 1) % 12] ? 2 : 1) - 1) % 12] ? 2 : 1) < minValue) continue block0;
                    painter.initPath();
                    painter.setAntialias(false);
                    painter.moveTo(x1, y);
                    painter.lineTo(x2, y);
                    painter.closePath();
                }
            }
        }
    }

    private boolean isPaintableBeat(TGBeat beat) {
        if (beat.getStart() == beat.getMeasure().getStart()) {
            return true;
        }
        return !beat.getVoice(this.getTablature().getCaret().getVoice()).isEmpty();
    }
}

