/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.tab;

import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.transport.TGTransport;
import org.herac.tuxguitar.app.util.MidiTickUtil;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.graphics.TGColor;
import org.herac.tuxguitar.graphics.TGColorModel;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.TGResource;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.song.managers.TGMeasureManager;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;

public class Caret {
    private Tablature tablature;
    private TGTrackImpl selectedTrack;
    private TGMeasureImpl selectedMeasure;
    private TGBeat selectedBeat;
    private TGNote selectedNote;
    private TGDuration selectedDuration;
    private long position;
    private int string;
    private int voice;
    private int velocity;
    private boolean restBeat;
    private boolean changes;
    private TGColor color1;
    private TGColor color2;

    public Caret(Tablature tablature) {
        this.tablature = tablature;
        this.selectedDuration = this.getSongManager().getFactory().newDuration();
        this.string = 1;
        this.velocity = 95;
        this.changes = false;
    }

    public synchronized void update() {
        int trackNumber = this.selectedTrack != null ? this.selectedTrack.getNumber() : 1;
        this.update(trackNumber, this.position, this.string);
    }

    public synchronized void update(int trackNumber) {
        this.update(trackNumber, this.position, this.string);
    }

    public synchronized void update(int trackNumber, long position, int string) {
        this.update(trackNumber, position, string, this.getVelocity());
    }

    public synchronized void update(int trackNumber, long position, int string, int velocity) {
        long realPosition = TuxGuitar.getInstance().getPlayer().isRunning() ? MidiTickUtil.getStart(TuxGuitar.getInstance().getPlayer().getTickPosition()) : position;
        TGTrackImpl track = this.findTrack(trackNumber);
        TGMeasureImpl measure = this.findMeasure(realPosition, track);
        TGBeat beat = this.findBeat(realPosition, measure);
        if (track != null && measure != null && beat != null) {
            this.moveTo(track, measure, beat, string);
        }
        this.setVelocity(velocity);
    }

    public void moveTo(TGTrackImpl selectedTrack, TGMeasureImpl selectedMeasure, TGBeat selectedBeat, int string) {
        this.selectedTrack = selectedTrack;
        this.selectedMeasure = selectedMeasure;
        this.selectedBeat = selectedBeat;
        this.string = string;
        this.updatePosition();
        this.updateDuration();
        this.updateString();
        this.updateNote();
        this.updateBeat();
        this.checkTransport();
        this.setChanges(true);
    }

    private TGTrackImpl findTrack(int number) {
        TGTrackImpl track = (TGTrackImpl)this.getSongManager().getTrack(this.getSong(), number);
        if (track == null) {
            track = (TGTrackImpl)this.getSongManager().getFirstTrack(this.getSong());
        }
        return track;
    }

    private TGMeasureImpl findMeasure(long position, TGTrackImpl track) {
        TGMeasureImpl measure = null;
        if (track != null && (measure = (TGMeasureImpl)this.getSongManager().getTrackManager().getMeasureAt((TGTrack)track, position)) == null) {
            measure = (TGMeasureImpl)this.getSongManager().getTrackManager().getFirstMeasure((TGTrack)track);
        }
        return measure;
    }

    private TGBeat findBeat(long position, TGMeasureImpl measure) {
        TGBeat beat = null;
        if (measure != null) {
            TGMeasureManager manager = this.getSongManager().getMeasureManager();
            TGVoice voice = manager.getVoiceIn((TGMeasure)measure, position, this.getVoice());
            if (voice != null) {
                beat = voice.getBeat();
            }
            if (beat == null) {
                beat = manager.getFirstBeat(measure.getBeats());
            }
        }
        return beat;
    }

    public synchronized void goToTickPosition() {
        long start = MidiTickUtil.getStart(TuxGuitar.getInstance().getPlayer().getTickPosition());
        this.update(this.selectedTrack.getNumber(), start, this.string);
        this.setChanges(true);
    }

    public void paintCaret(TGLayout layout, TGPainter painter) {
        if (!TuxGuitar.getInstance().getPlayer().isRunning() && this.selectedMeasure != null && !this.selectedMeasure.isOutOfBounds() && this.selectedBeat instanceof TGBeatImpl) {
            TGBeatImpl beat = (TGBeatImpl)this.selectedBeat;
            if ((layout.getStyle() & 8) != 0) {
                boolean expectedVoice = this.getSelectedNote() == null || this.getSelectedNote().getVoice().getIndex() == this.getVoice();
                float stringSpacing = this.tablature.getViewLayout().getStringSpacing();
                float leftSpacing = beat.getMeasureImpl().getHeaderImpl().getLeftSpacing(layout);
                float width = (stringSpacing - 3.0f * layout.getScale()) * 2.0f;
                float height = (stringSpacing - 3.0f * layout.getScale()) * 2.0f;
                float xMargin = width / 2.0f - 2.0f * layout.getScale();
                float yMargin = height / 2.0f;
                float x = this.selectedMeasure.getPosX() + beat.getPosX() + beat.getSpacing(layout) + leftSpacing - xMargin;
                float y = this.selectedMeasure.getPosY() + this.selectedMeasure.getTs().getPosition(14) + ((float)this.string * stringSpacing - stringSpacing) - yMargin;
                this.setPaintStyle(painter, expectedVoice);
                painter.initPath();
                painter.setAntialias(false);
                painter.addRectangle(x, y, width, height);
                painter.closePath();
            } else if ((layout.getStyle() & 4) != 0) {
                float line = this.tablature.getViewLayout().getScoreLineSpacing();
                float leftSpacing = beat.getMeasureImpl().getHeaderImpl().getLeftSpacing(layout);
                float xMargin = 2.0f * layout.getScale();
                float x1 = this.selectedMeasure.getPosX() + beat.getPosX() + beat.getSpacing(layout) + leftSpacing - xMargin;
                float x2 = x1 + layout.getScoreNoteWidth() + xMargin;
                float y1 = this.selectedMeasure.getPosY() + this.selectedMeasure.getTs().getPosition(0) - line;
                float y2 = this.selectedMeasure.getPosY() + this.selectedMeasure.getTs().getPosition(16);
                this.setPaintStyle(painter, true);
                painter.initPath();
                painter.moveTo(x1, y1);
                painter.lineTo(x1 + (x2 - x1) / 2.0f, y1 + line / 2.0f);
                painter.lineTo(x2, y1);
                painter.moveTo(x1, y2 + line);
                painter.lineTo(x1 + (x2 - x1) / 2.0f, y2 + line / 2.0f);
                painter.lineTo(x2, y2 + line);
                painter.closePath();
            }
        }
    }

    public void setPaintStyle(TGPainter painter, boolean expectedVoice) {
        TGColor foreground;
        TGColor tGColor = foreground = expectedVoice ? this.color1 : this.color2;
        if (foreground != null) {
            painter.setForeground(foreground);
        }
    }

    public boolean moveRight() {
        if (this.getSelectedBeat() != null) {
            TGBeat beat;
            TGMeasureImpl measure = this.getMeasure();
            TGVoice voice = this.getSongManager().getMeasureManager().getNextVoice(measure.getBeats(), (TGBeat)this.getSelectedBeat(), this.getVoice());
            TGBeat tGBeat = beat = voice != null ? voice.getBeat() : null;
            if (beat == null) {
                measure = (TGMeasureImpl)this.getSongManager().getTrackManager().getNextMeasure((TGMeasure)this.getMeasure());
                if (measure == null) {
                    return false;
                }
                voice = this.getSongManager().getMeasureManager().getFirstVoice(measure.getBeats(), this.getVoice());
                TGBeat tGBeat2 = beat = voice != null ? voice.getBeat() : null;
                if (beat == null) {
                    beat = this.getSongManager().getMeasureManager().getFirstBeat(measure.getBeats());
                }
            }
            if (beat != null) {
                this.moveTo(this.getTrack(), measure, beat, this.getStringNumber());
            }
        }
        return true;
    }

    public void moveLeft() {
        if (this.getSelectedBeat() != null) {
            TGBeat beat;
            TGMeasureImpl measure = this.getMeasure();
            TGVoice voice = this.getSongManager().getMeasureManager().getPreviousVoice(measure.getBeats(), (TGBeat)this.getSelectedBeat(), this.getVoice());
            TGBeat tGBeat = beat = voice != null ? voice.getBeat() : null;
            if (beat == null) {
                measure = (TGMeasureImpl)this.getSongManager().getTrackManager().getPrevMeasure((TGMeasure)this.getMeasure());
                if (measure == null) {
                    return;
                }
                voice = this.getSongManager().getMeasureManager().getLastVoice(measure.getBeats(), this.getVoice());
                TGBeat tGBeat2 = beat = voice != null ? voice.getBeat() : null;
                if (beat == null) {
                    beat = this.getSongManager().getMeasureManager().getFirstBeat(measure.getBeats());
                }
            }
            if (beat != null) {
                this.moveTo(this.getTrack(), measure, beat, this.getStringNumber());
            }
        }
    }

    private void updateDuration() {
        if (this.selectedBeat != null && !this.selectedBeat.getVoice(this.getVoice()).isRestVoice()) {
            this.selectedDuration.copyFrom(this.selectedBeat.getVoice(this.getVoice()).getDuration());
        }
    }

    public void moveUp() {
        int stringCount = this.selectedTrack.stringCount();
        int nextString = (this.string - 2 + stringCount) % stringCount + 1;
        this.setStringNumber(nextString);
    }

    public void moveDown() {
        int stringCount = this.selectedTrack.stringCount();
        int nextString = this.string % stringCount + 1;
        this.setStringNumber(nextString);
    }

    public void setStringNumber(int number) {
        this.string = number;
        this.updateNote();
    }

    public int getStringNumber() {
        return this.string;
    }

    public long getPosition() {
        return this.position;
    }

    public TGMeasureImpl getMeasure() {
        return this.selectedMeasure;
    }

    public TGTrackImpl getTrack() {
        return this.selectedTrack;
    }

    public TGDuration getDuration() {
        return this.selectedDuration;
    }

    public void setSelectedDuration(TGDuration selectedDuration) {
        this.selectedDuration = selectedDuration;
    }

    public TGString getSelectedString() {
        List strings = this.selectedTrack.getStrings();
        for (TGString instrumentString : strings) {
            if (instrumentString.getNumber() != this.string) continue;
            return instrumentString;
        }
        return null;
    }

    public void changeDuration(TGDuration duration) {
        this.getSongManager().getMeasureManager().changeDuration((TGMeasure)this.getMeasure(), (TGBeat)this.getSelectedBeat(), duration, this.getVoice(), true);
        this.setChanges(true);
    }

    private void updatePosition() {
        this.position = this.getSelectedBeat().getStart();
    }

    private void updateString() {
        if (this.string < 1 || this.string > this.getTrack().stringCount()) {
            this.string = 1;
        }
    }

    private void checkTransport() {
        TGTransport.getInstance(this.tablature.getContext()).gotoMeasure(this.getMeasure().getHeader());
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanges(boolean changes) {
        this.changes = changes;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }

    private void updateNote() {
        this.selectedNote = null;
        TGString string = this.getSelectedString();
        if (string != null) {
            this.selectedNote = this.getSongManager().getMeasureManager().getNote((TGMeasure)this.getMeasure(), this.getPosition(), string.getNumber());
        }
    }

    public TGNote getSelectedNote() {
        return this.selectedNote;
    }

    private void updateBeat() {
        this.restBeat = this.selectedBeat.isRestBeat();
    }

    public TGBeatImpl getSelectedBeat() {
        return (TGBeatImpl)this.selectedBeat;
    }

    public TGSongManager getSongManager() {
        return this.tablature.getSongManager();
    }

    public TGSong getSong() {
        return this.tablature.getSong();
    }

    public int getVoice() {
        return this.voice;
    }

    public void setVoice(int voice) {
        this.voice = voice;
        this.update();
    }

    public boolean isRestBeatSelected() {
        return this.restBeat;
    }

    public void setColor1(TGColorModel cm) {
        this.disposeResource((TGResource)this.color1);
        this.color1 = this.tablature.getResourceFactory().createColor(cm);
    }

    public void setColor2(TGColorModel cm) {
        this.disposeResource((TGResource)this.color2);
        this.color2 = this.tablature.getResourceFactory().createColor(cm);
    }

    public void disposeResource(TGResource resource) {
        if (resource != null && !resource.isDisposed()) {
            resource.dispose();
        }
    }

    public void dispose() {
        this.disposeResource((TGResource)this.color1);
        this.disposeResource((TGResource)this.color2);
    }
}

