/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGOutputStreamBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGFileFormatUtils {
    public static String getFileExtension(String path) {
        int index = path.lastIndexOf(".");
        if (index > 0) {
            return path.substring(index);
        }
        return null;
    }

    public static TGFileFormat getFileFormat(String path) {
        String extension;
        if (path != null && (extension = TGFileFormatUtils.getFileExtension(path)) != null) {
            Iterator it = TuxGuitar.getInstance().getFileFormatManager().getOutputStreams();
            while (it.hasNext()) {
                TGOutputStreamBase writer = (TGOutputStreamBase)it.next();
                if (!TGFileFormatUtils.isSupportedExtension(writer.getFileFormat(), extension)) continue;
                return writer.getFileFormat();
            }
        }
        return null;
    }

    public static boolean isSupportedExtension(TGFileFormat format, String extension) {
        String[] supportedFormats = format.getSupportedFormats();
        for (int i = 0; i < supportedFormats.length; ++i) {
            if (!extension.toLowerCase().equals("." + supportedFormats[i].toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupportedFormat(List<TGFileFormat> formats, String fileName) {
        String extension;
        if (fileName != null && (extension = TGFileFormatUtils.getFileExtension(fileName)) != null) {
            for (TGFileFormat format : formats) {
                if (!TGFileFormatUtils.isSupportedExtension(format, extension)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSupportedFormat(String path) {
        String extension;
        if (path != null && (extension = TGFileFormatUtils.getFileExtension(path)) != null) {
            Iterator it = TuxGuitar.getInstance().getFileFormatManager().getOutputStreams();
            while (it.hasNext()) {
                TGOutputStreamBase writer = (TGOutputStreamBase)it.next();
                if (!TGFileFormatUtils.isSupportedExtension(writer.getFileFormat(), extension)) continue;
                return true;
            }
        }
        return false;
    }

    public static InputStream getInputStream(InputStream in) throws Throwable {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int read = 0;
        while ((read = in.read()) != -1) {
            out.write(read);
        }
        byte[] bytes = out.toByteArray();
        in.close();
        out.close();
        out.flush();
        return new ByteArrayInputStream(bytes);
    }
}

