/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.ui;

import java.util.Iterator;
import org.herac.tuxguitar.resource.TGResourceLoader;
import org.herac.tuxguitar.resource.TGResourceManager;
import org.herac.tuxguitar.ui.UIApplication;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGServiceReader;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGApplication {
    public static final String NAME = "TuxGuitar";
    private TGContext context;
    private UIApplication application;
    private UIFactory factory;

    public TGApplication(TGContext context) {
        this.context = context;
        this.application = this.lookupApplication();
        this.application.setApplicationName(NAME);
        this.factory = this.application.getFactory();
    }

    private UIApplication lookupApplication() {
        Iterator it = TGServiceReader.lookupProviders(UIApplication.class, (TGResourceLoader)TGResourceManager.getInstance((TGContext)this.context));
        if (it.hasNext()) {
            return (UIApplication)it.next();
        }
        throw new TGException("No implementation class found for: " + UIApplication.class.getName());
    }

    public UIApplication getApplication() {
        return this.application;
    }

    public UIFactory getFactory() {
        return this.factory;
    }

    public boolean isDisposed() {
        return this.application.isDisposed();
    }

    public void dispose() {
        this.application.dispose();
    }

    public static TGApplication getInstance(TGContext context) {
        return (TGApplication)TGSingletonUtil.getInstance((TGContext)context, (String)TGApplication.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGApplication>(){

            public TGApplication createInstance(TGContext context) {
                return new TGApplication(context);
            }
        });
    }
}

