/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.clipboard;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.clipboard.CannotInsertTransferException;
import org.herac.tuxguitar.app.clipboard.Transferable;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.song.helpers.TGSongSegment;
import org.herac.tuxguitar.song.helpers.TGSongSegmentHelper;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;

public class MeasureTransferable
implements Transferable {
    public static final int TRANSFER_TYPE_REPLACE = 1;
    public static final int TRANSFER_TYPE_INSERT = 2;
    private TablatureEditor tablatureEditor;
    private TGSongSegment segment;
    private int transferType;
    private int pasteCount;

    public MeasureTransferable(TablatureEditor tablatureEditor, int p1, int p2, boolean allTracks) {
        this.tablatureEditor = tablatureEditor;
        this.transferType = 1;
        this.getTransfer(p1, p2, allTracks);
    }

    private void getTransfer(int p1, int p2, boolean allTracks) {
        TGSong song = this.tablatureEditor.getTablature().getSong();
        if (allTracks) {
            this.segment = new TGSongSegmentHelper(TuxGuitar.getInstance().getSongManager()).copyMeasures(song, p1, p2);
        } else {
            TGTrackImpl track = this.tablatureEditor.getTablature().getCaret().getTrack();
            this.segment = new TGSongSegmentHelper(TuxGuitar.getInstance().getSongManager()).copyMeasures(song, p1, p2, (TGTrack)track);
        }
        this.skipMarkers(this.segment);
    }

    public void insertTransfer() throws CannotInsertTransferException {
        TGSongSegmentHelper helper = new TGSongSegmentHelper(TuxGuitar.getInstance().getSongManager());
        TGSongSegment segment = helper.createSegmentCopies(this.segment, this.pasteCount);
        if (this.transferType == 1) {
            this.replaceMeasures(helper, segment);
        } else if (this.transferType == 2) {
            this.insertMeasures(helper, segment);
        }
    }

    public void insertMeasures(TGSongSegmentHelper helper, TGSongSegment segment) throws CannotInsertTransferException {
        TGMeasureImpl measure = this.tablatureEditor.getTablature().getCaret().getMeasure();
        TGTrackImpl track = this.tablatureEditor.getTablature().getCaret().getTrack();
        TGSong song = this.tablatureEditor.getTablature().getSong();
        if (measure == null || segment.isEmpty()) {
            throw new CannotInsertTransferException();
        }
        int toTrack = segment.getTracks().size() == 1 ? track.getNumber() : 0;
        TGMeasureHeader first = (TGMeasureHeader)segment.getHeaders().get(0);
        int fromNumber = measure.getNumber();
        long theMove = measure.getStart() - first.getStart();
        helper.insertMeasures(song, segment.clone(TuxGuitar.getInstance().getSongManager().getFactory()), fromNumber, theMove, toTrack);
    }

    public void replaceMeasures(TGSongSegmentHelper helper, TGSongSegment segment) throws CannotInsertTransferException {
        TGMeasureImpl measure = this.tablatureEditor.getTablature().getCaret().getMeasure();
        TGTrackImpl track = this.tablatureEditor.getTablature().getCaret().getTrack();
        TGSong song = this.tablatureEditor.getTablature().getSong();
        if (measure == null || segment.isEmpty()) {
            throw new CannotInsertTransferException();
        }
        TGMeasureHeader first = (TGMeasureHeader)segment.getHeaders().get(0);
        int toTrack = segment.getTracks().size() == 1 ? track.getNumber() : 0;
        int count = segment.getHeaders().size();
        int current = measure.getNumber();
        int freeSpace = track.countMeasures() - (current - 1);
        long theMove = measure.getStart() - first.getStart();
        for (int i = freeSpace; i < count; ++i) {
            TuxGuitar.getInstance().getSongManager().addNewMeasureBeforeEnd(song);
        }
        helper.replaceMeasures(song, segment.clone(TuxGuitar.getInstance().getSongManager().getFactory()), theMove, toTrack);
    }

    public void setTransferType(int transferType) {
        this.transferType = transferType;
    }

    public void setPasteCount(int pasteCount) {
        this.pasteCount = pasteCount;
    }

    private void skipMarkers(TGSongSegment segment) {
        for (TGMeasureHeader header : segment.getHeaders()) {
            header.setMarker(null);
        }
    }
}

