/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.listener.undoable;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.app.action.TGActionMap;
import org.herac.tuxguitar.app.action.listener.undoable.TGUndoableContext;
import org.herac.tuxguitar.app.action.listener.undoable.TGUndoableJoined;
import org.herac.tuxguitar.editor.undo.TGUndoableActionController;
import org.herac.tuxguitar.editor.undo.TGUndoableEdit;
import org.herac.tuxguitar.editor.undo.TGUndoableManager;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGUndoableActionListener
implements TGEventListener {
    private TGContext context;
    private TGActionMap<TGUndoableActionController> controllers;

    public TGUndoableActionListener(TGContext context) {
        this.context = context;
        this.controllers = new TGActionMap();
    }

    public TGActionMap<TGUndoableActionController> getControllers() {
        return this.controllers;
    }

    public void processPreExecution(String actionId, TGActionContext actionContext) {
        TGUndoableContext undoableContext = TGUndoableContext.getInstance(actionContext);
        TGUndoableActionController controller = this.controllers.get(actionId);
        if (controller != null) {
            TGUndoableEdit undoableEdit;
            if (undoableContext.getUndoable() == null) {
                undoableContext.setUndoable(new TGUndoableJoined(this.context));
            }
            if ((undoableEdit = controller.startUndoable(this.context, actionContext)) != null) {
                undoableContext.addUndoableToCurrentLevel(undoableEdit);
            }
        }
        undoableContext.incrementLevel();
    }

    public void processPostExecution(String actionId, TGActionContext actionContext) {
        TGUndoableActionController controller;
        TGUndoableContext undoableContext = TGUndoableContext.getInstance(actionContext);
        undoableContext.decrementLevel();
        TGUndoableEdit undoableEdit = undoableContext.getUndoableFromCurrentLevel();
        if (undoableEdit != null && (controller = this.controllers.get(actionId)) != null && (undoableEdit = controller.endUndoable(this.context, actionContext, undoableEdit)) != null) {
            undoableContext.getUndoable().addUndoableEdit(undoableEdit);
        }
        if (undoableContext.getLevel() == 0 && undoableContext.getUndoable() != null && !undoableContext.getUndoable().isEmpty()) {
            TGUndoableManager.getInstance((TGContext)this.context).addEdit((TGUndoableEdit)undoableContext.getUndoable().endUndo());
            undoableContext.reset();
        }
    }

    public void processPreExecution(TGEvent event) {
        String actionId = (String)event.getAttribute("actionId");
        TGActionContext actionContext = (TGActionContext)event.getAttribute("sourceContext");
        if (!this.isByPassUndoable(actionContext)) {
            this.processPreExecution(actionId, actionContext);
        }
    }

    public void processPostExecution(TGEvent event) {
        String actionId = (String)event.getAttribute("actionId");
        TGActionContext actionContext = (TGActionContext)event.getAttribute("sourceContext");
        if (!this.isByPassUndoable(actionContext)) {
            this.processPostExecution(actionId, actionContext);
        }
    }

    public boolean isByPassUndoable(TGActionContext actionContext) {
        return Boolean.TRUE.equals(actionContext.getAttribute("byPassUndoable"));
    }

    public void processEvent(TGEvent event) {
        if ("action-pre-execution".equals(event.getEventType())) {
            this.processPreExecution(event);
        } else if ("action-post-execution".equals(event.getEventType())) {
            this.processPostExecution(event);
        }
    }
}

