/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.impl.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.action.TGActionException;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.app.action.impl.file.TGSongStreamActionBase;
import org.herac.tuxguitar.app.document.TGDocumentFileManager;
import org.herac.tuxguitar.app.view.dialog.file.TGFileChooserHandler;
import org.herac.tuxguitar.io.base.TGLocalFileExporter;
import org.herac.tuxguitar.io.base.TGSongStreamContext;
import org.herac.tuxguitar.util.TGContext;

public class TGExportFileAction
extends TGSongStreamActionBase {
    public static final String NAME = "action.file.export";

    public TGExportFileAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(final TGActionContext context) {
        final TGSongStreamContext streamContext = this.findSongStreamContext(context);
        TGLocalFileExporter exporter = (TGLocalFileExporter)context.getAttribute(ATTRIBUTE_PROVIDER);
        TGDocumentFileManager tgDocumentFileManager = TGDocumentFileManager.getInstance(this.getContext());
        tgDocumentFileManager.chooseFileNameForSave(new TGFileChooserHandler(){

            public void updateFileName(String fileName) {
                OutputStream stream = TGExportFileAction.this.createOutputStream(fileName);
                if (stream != null) {
                    streamContext.setAttribute(OutputStream.class.getName(), (Object)stream);
                    new Thread(new Runnable(){

                        public void run() {
                            TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)TGExportFileAction.this.getContext());
                            tgActionManager.execute("action.song.export", context);
                        }
                    }).start();
                }
            }
        }, exporter.getFileFormat());
    }

    public OutputStream createOutputStream(String fileName) {
        try {
            return new BufferedOutputStream(new FileOutputStream(new File(fileName)));
        }
        catch (Throwable e) {
            throw new TGActionException(e.getMessage(), e);
        }
    }
}

