/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.swt.menu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.ui.UIComponent;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.menu.UIMenuCheckableItem;
import org.herac.tuxguitar.ui.menu.UIMenuItem;
import org.herac.tuxguitar.ui.menu.UIMenuSubMenuItem;
import org.herac.tuxguitar.ui.swt.menu.SWTMenuActionItem;
import org.herac.tuxguitar.ui.swt.menu.SWTMenuCheckableItem;
import org.herac.tuxguitar.ui.swt.menu.SWTMenuItem;
import org.herac.tuxguitar.ui.swt.menu.SWTMenuSubMenuItem;
import org.herac.tuxguitar.ui.swt.widget.SWTEventReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTMenu
extends SWTEventReceiver<Menu>
implements UIMenu {
    private List<UIMenuItem> menuItems = new ArrayList<UIMenuItem>();

    public SWTMenu(Shell shell, int style) {
        super(new Menu((Decorations)shell, style));
    }

    public Integer getItemCount() {
        return this.menuItems.size();
    }

    public UIMenuItem getItem(int index) {
        return index >= 0 && index < this.menuItems.size() ? this.menuItems.get(index) : null;
    }

    public List<UIMenuItem> getItems() {
        return new ArrayList<UIMenuItem>(this.menuItems);
    }

    public UIComponent createSeparator() {
        MenuItem menuItem = new MenuItem((Menu)this.getControl(), 2);
        return this.append(new SWTMenuItem(menuItem, this));
    }

    public UIMenuActionItem createActionItem() {
        MenuItem menuItem = new MenuItem((Menu)this.getControl(), 8);
        return (UIMenuActionItem)this.append(new SWTMenuActionItem(menuItem, this));
    }

    public UIMenuCheckableItem createCheckItem() {
        MenuItem menuItem = new MenuItem((Menu)this.getControl(), 32);
        return (UIMenuCheckableItem)this.append(new SWTMenuCheckableItem(menuItem, this));
    }

    public UIMenuCheckableItem createRadioItem() {
        MenuItem menuItem = new MenuItem((Menu)this.getControl(), 16);
        return (UIMenuCheckableItem)this.append(new SWTMenuCheckableItem(menuItem, this));
    }

    public UIMenuSubMenuItem createSubMenuItem() {
        MenuItem menuItem = new MenuItem((Menu)this.getControl(), 64);
        return (UIMenuSubMenuItem)this.append(new SWTMenuSubMenuItem(menuItem, this));
    }

    public <T extends UIMenuItem> T append(UIMenuItem item) {
        this.menuItems.add(item);
        return (T)item;
    }

    public void dispose(SWTMenuItem item) {
        if (this.menuItems.contains(item)) {
            this.menuItems.remove(item);
        }
        ((MenuItem)item.getControl()).dispose();
    }

    public void dispose() {
        ((Menu)this.getControl()).dispose();
    }

    public boolean isDisposed() {
        return ((Menu)this.getControl()).isDisposed();
    }
}

