/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.track;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableTrackInstrument
extends TGUndoableTrackBase {
    private int doAction;
    private int trackNumber;
    private int undoChannelId;
    private int redoChannelId;

    private TGUndoableTrackInstrument(TGContext context) {
        super(context);
    }

    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.setTrackChannel(actionContext, this.getTrack(this.trackNumber), this.getChannel(this.redoChannelId));
        this.doAction = 1;
    }

    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.setTrackChannel(actionContext, this.getTrack(this.trackNumber), this.getChannel(this.undoChannelId));
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableTrackInstrument startUndo(TGContext context, TGTrack track) {
        TGUndoableTrackInstrument undoable = new TGUndoableTrackInstrument(context);
        undoable.doAction = 1;
        undoable.trackNumber = track.getNumber();
        undoable.undoChannelId = track.getChannelId();
        return undoable;
    }

    public TGUndoableTrackInstrument endUndo(TGTrack track) {
        this.redoChannelId = track.getChannelId();
        return this;
    }

    public TGTrack getTrack(int number) {
        return this.getSongManager().getTrack(this.getSong(), number);
    }

    public TGChannel getChannel(int channelId) {
        return this.getSongManager().getChannel(this.getSong(), channelId);
    }
}

