/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.helpers;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.helpers.TGTrackSegment;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGSongSegment {
    private List<TGMeasureHeader> headers = new ArrayList<TGMeasureHeader>();
    private List<TGTrackSegment> tracks = new ArrayList<TGTrackSegment>();

    public List<TGMeasureHeader> getHeaders() {
        return this.headers;
    }

    public List<TGTrackSegment> getTracks() {
        return this.tracks;
    }

    public void addTrack(int track, List<TGMeasure> measures) {
        this.tracks.add(new TGTrackSegment(track, measures));
    }

    public boolean isEmpty() {
        return this.headers.isEmpty() || this.tracks.isEmpty();
    }

    public TGSongSegment clone(TGFactory factory) {
        int i;
        TGSongSegment segment = new TGSongSegment();
        for (i = 0; i < this.getHeaders().size(); ++i) {
            TGMeasureHeader header = this.getHeaders().get(i);
            segment.getHeaders().add(header.clone(factory));
        }
        for (i = 0; i < this.getTracks().size(); ++i) {
            TGTrackSegment trackMeasure = this.getTracks().get(i);
            segment.getTracks().add((TGTrackSegment)trackMeasure.clone(factory, segment.getHeaders()));
        }
        return segment;
    }
}

