/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGMeasureHeader;

public class TGMeasureHeaderImpl
extends TGMeasureHeader {
    private static final int DEFAULT_TIME_SIGNATURE_SPACING = 30;
    private static final int DEFAULT_LEFT_SPACING = 15;
    private static final int DEFAULT_RIGHT_SPACING = 15;
    private static final int PAINT_TEMPO = 1;
    private static final int PAINT_TRIPLET_FEEL = 2;
    private static final int PAINT_TIME_SIGNATURE = 4;
    private int paintFlags;
    private float maxQuarterSpacing;
    private float maxClefSpacing;
    private float maxKeySignatureSpacing;
    private float maxWidth;

    public TGMeasureHeaderImpl(TGFactory factory) {
        super(factory);
    }

    public void reset() {
        this.maxWidth = 0.0f;
        this.paintFlags = 0;
        this.maxQuarterSpacing = 0.0f;
        this.maxClefSpacing = 0.0f;
        this.maxKeySignatureSpacing = 0.0f;
    }

    public void update(TGLayout layout, int index) {
        this.reset();
        this.calculateMeasureChanges(layout);
        int trackCount = this.getSong().countTracks();
        for (int trackIdx = 0; trackIdx < trackCount; ++trackIdx) {
            TGTrackImpl track = (TGTrackImpl)this.getSong().getTrack(trackIdx);
            TGMeasureImpl measure = (TGMeasureImpl)track.getMeasure(index);
            measure.calculateMeasureChanges(layout);
        }
    }

    public void calculateMeasureChanges(TGLayout layout) {
        TGMeasureHeader previous = layout.getSongManager().getPrevMeasureHeader(layout.getSong(), this);
        if (previous == null) {
            this.paintFlags |= 1;
            this.paintFlags |= this.getTripletFeel() != 1 ? 2 : 0;
            this.paintFlags |= 4;
        } else {
            if (this.getTempo().getValue() != previous.getTempo().getValue()) {
                this.paintFlags |= 1;
            }
            if (this.getTripletFeel() != previous.getTripletFeel()) {
                this.paintFlags |= 2;
            }
            int thisNumerator = this.getTimeSignature().getNumerator();
            int thisValue = this.getTimeSignature().getDenominator().getValue();
            int prevNumerator = previous.getTimeSignature().getNumerator();
            int prevValue = previous.getTimeSignature().getDenominator().getValue();
            if (thisNumerator != prevNumerator || thisValue != prevValue) {
                this.paintFlags |= 4;
            }
        }
    }

    public boolean shouldPaintTempo() {
        return (this.paintFlags & 1) != 0;
    }

    public boolean shouldPaintTripletFeel() {
        return (this.paintFlags & 2) != 0;
    }

    public boolean shouldPaintTimeSignature() {
        return (this.paintFlags & 4) != 0;
    }

    public float getMaxQuarterSpacing() {
        return this.maxQuarterSpacing;
    }

    public void notifyQuarterSpacing(float spacing) {
        this.maxQuarterSpacing = spacing > this.maxQuarterSpacing ? spacing : this.maxQuarterSpacing;
    }

    public float getClefSpacing(TGLayout layout, TGMeasureImpl measure) {
        return !measure.isPaintClef() && (layout.getStyle() & 2) == 0 ? 0.0f : this.maxClefSpacing;
    }

    public float getKeySignatureSpacing(TGLayout layout, TGMeasureImpl measure) {
        return !measure.isPaintKeySignature() && (layout.getStyle() & 2) == 0 ? 0.0f : this.maxKeySignatureSpacing;
    }

    public float getTempoSpacing(TGLayout layout) {
        return this.shouldPaintTempo() ? Math.round(45.0f * layout.getScale()) : 0;
    }

    public float getTripletFeelSpacing(TGLayout layout) {
        return this.shouldPaintTripletFeel() ? Math.round(55.0f * layout.getScale()) : 0;
    }

    public float getTimeSignatureSpacing(TGLayout layout) {
        return this.shouldPaintTimeSignature() ? Math.round(30.0f * layout.getScale()) : 0;
    }

    public float getLeftSpacing(TGLayout layout) {
        return Math.round(15.0f * layout.getScale());
    }

    public float getRightSpacing(TGLayout layout) {
        return Math.round(15.0f * layout.getScale());
    }

    public float getFirstNoteSpacing(TGLayout layout, TGMeasureImpl measure) {
        float topSpacing = this.getTempoSpacing(layout) + this.getTripletFeelSpacing(layout);
        float middleSpacing = this.getClefSpacing(layout, measure) + this.getKeySignatureSpacing(layout, measure) + this.getTimeSignatureSpacing(layout);
        return Math.round(Math.max(topSpacing, middleSpacing) + 10.0f * layout.getScale());
    }

    public void notifyClefSpacing(float spacing) {
        this.maxClefSpacing = spacing > this.maxClefSpacing ? spacing : this.maxClefSpacing;
    }

    public void notifyKeySignatureSpacing(float spacing) {
        this.maxKeySignatureSpacing = spacing > this.maxKeySignatureSpacing ? spacing : this.maxKeySignatureSpacing;
    }

    public void notifyWidth(float width) {
        this.maxWidth = width > this.maxWidth ? width : this.maxWidth;
    }

    public float getMaxWidth() {
        return this.maxWidth;
    }
}

