/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gm.GMChannelRoute;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.gtp.GTPOutputStream;
import org.herac.tuxguitar.io.gtp.GTPSettings;
import org.herac.tuxguitar.io.gtp.GTPVoiceJoiner;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGStroke;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GP3OutputStream
extends GTPOutputStream {
    private static final String GP3_VERSION = "FICHIER GUITAR PRO v3.00";
    private static final int GP_BEND_SEMITONE = 25;
    private static final int GP_BEND_POSITION = 60;

    public GP3OutputStream(GTPSettings settings) {
        super(settings);
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("Guitar Pro 3", new String[]{"gp3"});
    }

    public void writeSong(TGSong song) {
        try {
            if (song.isEmpty()) {
                throw new TGFileFormatException("Empty Song!!!");
            }
            this.configureChannelRouter(song);
            TGMeasureHeader header = song.getMeasureHeader(0);
            this.writeStringByte(GP3_VERSION, 30, "UTF-8");
            this.writeInfo(song);
            this.writeBoolean(header.getTripletFeel() == 2);
            this.writeInt(header.getTempo().getValue());
            this.writeInt(0);
            this.writeChannels(song);
            this.writeInt(song.countMeasureHeaders());
            this.writeInt(song.countTracks());
            this.writeMeasureHeaders(song);
            this.writeTracks(song);
            this.writeMeasures(song, header.getTempo().clone(this.getFactory()));
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeInfo(TGSong song) throws IOException {
        List<String> comments = this.toCommentLines(song.getComments());
        this.writeStringByteSizeOfInteger(song.getName());
        this.writeStringByteSizeOfInteger("");
        this.writeStringByteSizeOfInteger(song.getArtist());
        this.writeStringByteSizeOfInteger(song.getAlbum());
        this.writeStringByteSizeOfInteger(song.getAuthor());
        this.writeStringByteSizeOfInteger(song.getCopyright());
        this.writeStringByteSizeOfInteger(song.getWriter());
        this.writeStringByteSizeOfInteger("");
        this.writeInt(comments.size());
        for (int i = 0; i < comments.size(); ++i) {
            this.writeStringByteSizeOfInteger(comments.get(i));
        }
    }

    private void writeChannels(TGSong song) throws IOException {
        TGChannel[] channels = this.makeChannels(song);
        for (int i = 0; i < channels.length; ++i) {
            this.writeInt(channels[i].getProgram());
            this.writeByte(this.toChannelByte(channels[i].getVolume()));
            this.writeByte(this.toChannelByte(channels[i].getBalance()));
            this.writeByte(this.toChannelByte(channels[i].getChorus()));
            this.writeByte(this.toChannelByte(channels[i].getReverb()));
            this.writeByte(this.toChannelByte(channels[i].getPhaser()));
            this.writeByte(this.toChannelByte(channels[i].getTremolo()));
            this.writeBytes(new byte[]{0, 0});
        }
    }

    private void writeMeasureHeaders(TGSong song) throws IOException {
        TGTimeSignature timeSignature = this.getFactory().newTimeSignature();
        if (song.countMeasureHeaders() > 0) {
            for (int i = 0; i < song.countMeasureHeaders(); ++i) {
                TGMeasureHeader measure = song.getMeasureHeader(i);
                this.writeMeasureHeader(measure, timeSignature);
                timeSignature.setNumerator(measure.getTimeSignature().getNumerator());
                timeSignature.getDenominator().setValue(measure.getTimeSignature().getDenominator().getValue());
            }
        }
    }

    private void writeMeasures(TGSong song, TGTempo tempo) throws IOException {
        for (int i = 0; i < song.countMeasureHeaders(); ++i) {
            TGMeasureHeader header = song.getMeasureHeader(i);
            for (int j = 0; j < song.countTracks(); ++j) {
                TGTrack track = song.getTrack(j);
                TGMeasure measure = track.getMeasure(i);
                this.writeMeasure(measure, header.getTempo().getValue() != tempo.getValue());
            }
            tempo.copyFrom(header.getTempo());
        }
    }

    private void writeMeasureHeader(TGMeasureHeader measure, TGTimeSignature timeSignature) throws IOException {
        int flags = 0;
        if (measure.getNumber() == 1 || measure.getTimeSignature().getNumerator() != timeSignature.getNumerator()) {
            flags |= 1;
        }
        if (measure.getNumber() == 1 || measure.getTimeSignature().getDenominator().getValue() != timeSignature.getDenominator().getValue()) {
            flags |= 2;
        }
        if (measure.isRepeatOpen()) {
            flags |= 4;
        }
        if (measure.getRepeatClose() > 0) {
            flags |= 8;
        }
        if (measure.hasMarker()) {
            flags |= 0x20;
        }
        this.writeUnsignedByte(flags);
        if ((flags & 1) != 0) {
            this.writeByte((byte)measure.getTimeSignature().getNumerator());
        }
        if ((flags & 2) != 0) {
            this.writeByte((byte)measure.getTimeSignature().getDenominator().getValue());
        }
        if ((flags & 8) != 0) {
            this.writeByte((byte)measure.getRepeatClose());
        }
        if ((flags & 0x20) != 0) {
            this.writeMarker(measure.getMarker());
        }
    }

    private void writeTracks(TGSong song) throws IOException {
        for (int i = 0; i < song.countTracks(); ++i) {
            TGTrack track = song.getTrack(i);
            this.createTrack(track);
        }
    }

    private void createTrack(TGTrack track) throws IOException {
        GMChannelRoute channel = this.getChannelRoute(track.getChannelId());
        int flags = 0;
        if (this.isPercussionChannel(track.getSong(), track.getChannelId())) {
            flags |= 1;
        }
        this.writeUnsignedByte(flags);
        this.writeStringByte(track.getName(), 40);
        this.writeInt(track.getStrings().size());
        for (int i = 0; i < 7; ++i) {
            int value = 0;
            if (track.getStrings().size() > i) {
                TGString string = (TGString)track.getStrings().get(i);
                value = string.getValue();
            }
            this.writeInt(value);
        }
        this.writeInt(1);
        this.writeInt(channel.getChannel1() + 1);
        this.writeInt(channel.getChannel2() + 1);
        this.writeInt(24);
        this.writeInt(Math.min(Math.max(track.getOffset(), 0), 12));
        this.writeColor(track.getColor());
    }

    private void writeMeasure(TGMeasure srcMeasure, boolean changeTempo) throws IOException {
        TGMeasure measure = new GTPVoiceJoiner(this.getFactory(), srcMeasure).process();
        int beatCount = measure.countBeats();
        this.writeInt(beatCount);
        for (int i = 0; i < beatCount; ++i) {
            TGBeat beat = measure.getBeat(i);
            this.writeBeat(beat, measure, changeTempo && i == 0);
        }
    }

    private void writeBeat(TGBeat beat, TGMeasure measure, boolean changeTempo) throws IOException {
        int i;
        TGNote note;
        TGVoice voice = beat.getVoice(0);
        TGDuration duration = voice.getDuration();
        int flags = 0;
        if (duration.isDotted() || duration.isDoubleDotted()) {
            flags |= 1;
        }
        if (!duration.getDivision().isEqual(TGDivisionType.NORMAL)) {
            flags |= 0x20;
        }
        if (beat.isTextBeat()) {
            flags |= 4;
        }
        if (changeTempo) {
            flags |= 0x10;
        }
        TGNoteEffect effect = null;
        if (voice.isRestVoice()) {
            flags |= 0x40;
        } else if (voice.countNotes() > 0 && ((effect = (note = voice.getNote(0)).getEffect()).isVibrato() || effect.isTremoloBar() || effect.isTapping() || effect.isSlapping() || effect.isPopping() || effect.isHarmonic() || effect.isFadeIn() || beat.getStroke().getDirection() != 0)) {
            flags |= 8;
        }
        this.writeUnsignedByte(flags);
        if ((flags & 0x40) != 0) {
            this.writeUnsignedByte(2);
        }
        this.writeByte(this.parseDuration(duration));
        if ((flags & 0x20) != 0) {
            this.writeInt(duration.getDivision().getEnters());
        }
        if ((flags & 4) != 0) {
            this.writeText(beat.getText());
        }
        if ((flags & 8) != 0) {
            this.writeBeatEffects(beat, effect);
        }
        if ((flags & 0x10) != 0) {
            this.writeMixChange(measure.getTempo());
        }
        int stringFlags = 0;
        if (!voice.isRestVoice()) {
            for (i = 0; i < voice.countNotes(); ++i) {
                TGNote playedNote = voice.getNote(i);
                int string = 7 - playedNote.getString();
                stringFlags |= 1 << string;
            }
        }
        this.writeUnsignedByte(stringFlags);
        block1: for (i = 6; i >= 0; --i) {
            if ((stringFlags & 1 << i) == 0) continue;
            for (int n = 0; n < voice.countNotes(); ++n) {
                TGNote playedNote = voice.getNote(n);
                if (playedNote.getString() != 6 - i + 1) continue;
                this.writeNote(playedNote);
                continue block1;
            }
        }
    }

    private void writeNote(TGNote note) throws IOException {
        int flags = 48;
        if (note.getEffect().isGhostNote()) {
            flags |= 4;
        }
        if (note.getEffect().isBend() || note.getEffect().isGrace() || note.getEffect().isSlide() || note.getEffect().isHammer() || note.getEffect().isLetRing()) {
            flags |= 8;
        }
        this.writeUnsignedByte(flags);
        if ((flags & 0x20) != 0) {
            int typeHeader = 1;
            if (note.isTiedNote()) {
                typeHeader = 2;
            } else if (note.getEffect().isDeadNote()) {
                typeHeader = 3;
            }
            this.writeUnsignedByte(typeHeader);
        }
        if ((flags & 0x10) != 0) {
            this.writeByte((byte)((note.getVelocity() - 15) / 16 + 1));
        }
        if ((flags & 0x20) != 0) {
            this.writeByte((byte)note.getValue());
        }
        if ((flags & 8) != 0) {
            this.writeNoteEffects(note.getEffect());
        }
    }

    private byte parseDuration(TGDuration duration) {
        byte value = 0;
        switch (duration.getValue()) {
            case 1: {
                value = -2;
                break;
            }
            case 2: {
                value = -1;
                break;
            }
            case 4: {
                value = 0;
                break;
            }
            case 8: {
                value = 1;
                break;
            }
            case 16: {
                value = 2;
                break;
            }
            case 32: {
                value = 3;
                break;
            }
            case 64: {
                value = 4;
            }
        }
        return value;
    }

    private void writeText(TGText text) throws IOException {
        this.writeStringByteSizeOfInteger(text.getValue());
    }

    private void writeBeatEffects(TGBeat beat, TGNoteEffect noteEffect) throws IOException {
        int flags = 0;
        if (noteEffect.isVibrato()) {
            ++flags;
        }
        if (noteEffect.isTremoloBar() || noteEffect.isTapping() || noteEffect.isSlapping() || noteEffect.isPopping()) {
            flags += 32;
        }
        if (beat.getStroke().getDirection() != 0) {
            flags |= 0x40;
        }
        if (noteEffect.isHarmonic() && noteEffect.getHarmonic().getType() == 1) {
            flags += 4;
        }
        if (noteEffect.isHarmonic() && noteEffect.getHarmonic().getType() != 1) {
            flags += 8;
        }
        if (noteEffect.isFadeIn()) {
            flags += 16;
        }
        this.writeUnsignedByte(flags);
        if ((flags & 0x20) != 0) {
            if (noteEffect.isTremoloBar()) {
                this.writeUnsignedByte(0);
                this.writeInt(100);
            } else if (noteEffect.isTapping()) {
                this.writeUnsignedByte(1);
                this.writeInt(0);
            } else if (noteEffect.isSlapping()) {
                this.writeUnsignedByte(2);
                this.writeInt(0);
            } else if (noteEffect.isPopping()) {
                this.writeUnsignedByte(3);
                this.writeInt(0);
            }
        }
        if ((flags & 0x40) != 0) {
            this.writeUnsignedByte(beat.getStroke().getDirection() == -1 ? this.toStrokeValue(beat.getStroke()) : 0);
            this.writeUnsignedByte(beat.getStroke().getDirection() == 1 ? this.toStrokeValue(beat.getStroke()) : 0);
        }
    }

    private void writeNoteEffects(TGNoteEffect effect) throws IOException {
        int flags = 0;
        if (effect.isBend()) {
            flags |= 1;
        }
        if (effect.isHammer()) {
            flags |= 2;
        }
        if (effect.isSlide()) {
            flags |= 4;
        }
        if (effect.isLetRing()) {
            flags |= 8;
        }
        if (effect.isGrace()) {
            flags |= 0x10;
        }
        this.writeUnsignedByte(flags);
        if ((flags & 1) != 0) {
            this.writeBend(effect.getBend());
        }
        if ((flags & 0x10) != 0) {
            this.writeGrace(effect.getGrace());
        }
    }

    private void writeBend(TGEffectBend bend) throws IOException {
        int points = bend.getPoints().size();
        this.writeByte((byte)1);
        this.writeInt(0);
        this.writeInt(points);
        for (int i = 0; i < points; ++i) {
            TGEffectBend.BendPoint point = (TGEffectBend.BendPoint)bend.getPoints().get(i);
            this.writeInt(point.getPosition() * 60 / 12);
            this.writeInt(point.getValue() * 25 / 1);
            this.writeByte((byte)0);
        }
    }

    private void writeGrace(TGEffectGrace grace) throws IOException {
        if (grace.isDead()) {
            this.writeUnsignedByte(255);
        } else {
            this.writeUnsignedByte(grace.getFret());
        }
        this.writeUnsignedByte((grace.getDynamic() - 15) / 16 + 1);
        if (grace.getTransition() == 0) {
            this.writeUnsignedByte(0);
        } else if (grace.getTransition() == 1) {
            this.writeUnsignedByte(1);
        } else if (grace.getTransition() == 2) {
            this.writeUnsignedByte(2);
        } else if (grace.getTransition() == 3) {
            this.writeUnsignedByte(3);
        }
        this.writeUnsignedByte(grace.getDuration());
    }

    private void writeMixChange(TGTempo tempo) throws IOException {
        for (int i = 0; i < 7; ++i) {
            this.writeByte((byte)-1);
        }
        this.writeInt(tempo.getValue());
        this.writeByte((byte)0);
    }

    private void writeMarker(TGMarker marker) throws IOException {
        this.writeStringByteSizeOfInteger(marker.getTitle());
        this.writeColor(marker.getColor());
    }

    private void writeColor(TGColor color) throws IOException {
        this.writeUnsignedByte(color.getR());
        this.writeUnsignedByte(color.getG());
        this.writeUnsignedByte(color.getB());
        this.writeByte((byte)0);
    }

    private TGChannel[] makeChannels(TGSong song) {
        TGChannel[] channels = new TGChannel[64];
        for (int i = 0; i < channels.length; ++i) {
            channels[i] = this.getFactory().newChannel();
            channels[i].setProgram((short)24);
            channels[i].setVolume((short)13);
            channels[i].setBalance((short)8);
            channels[i].setChorus((short)0);
            channels[i].setReverb((short)0);
            channels[i].setPhaser((short)0);
            channels[i].setTremolo((short)0);
        }
        Iterator it = song.getChannels();
        while (it.hasNext()) {
            TGChannel tgChannel = (TGChannel)it.next();
            GMChannelRoute gmChannelRoute = this.getChannelRoute(tgChannel.getChannelId());
            channels[gmChannelRoute.getChannel1()].setProgram(tgChannel.getProgram());
            channels[gmChannelRoute.getChannel1()].setVolume(tgChannel.getVolume());
            channels[gmChannelRoute.getChannel1()].setBalance(tgChannel.getBalance());
            channels[gmChannelRoute.getChannel2()].setProgram(tgChannel.getProgram());
            channels[gmChannelRoute.getChannel2()].setVolume(tgChannel.getVolume());
            channels[gmChannelRoute.getChannel2()].setBalance(tgChannel.getBalance());
        }
        return channels;
    }

    private int toStrokeValue(TGStroke stroke) {
        if (stroke.getValue() == 64) {
            return 2;
        }
        if (stroke.getValue() == 32) {
            return 3;
        }
        if (stroke.getValue() == 16) {
            return 4;
        }
        if (stroke.getValue() == 8) {
            return 5;
        }
        if (stroke.getValue() == 4) {
            return 6;
        }
        return 2;
    }

    private byte toChannelByte(short s) {
        return (byte)((s + 1) / 8);
    }

    private List<String> toCommentLines(String comments) {
        ArrayList<String> lines = new ArrayList<String>();
        String line = comments;
        while (line.length() > 127) {
            String subline = line.substring(0, 127);
            lines.add(subline);
            line = line.substring(127);
        }
        lines.add(line);
        return lines;
    }
}

