/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.custom.converter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.herac.tuxguitar.app.tools.custom.converter.TGConverterFormat;
import org.herac.tuxguitar.app.tools.custom.converter.TGConverterListener;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGLocalFileExporter;
import org.herac.tuxguitar.io.base.TGLocalFileImporter;
import org.herac.tuxguitar.io.base.TGOutputStreamBase;
import org.herac.tuxguitar.io.base.TGRawImporter;
import org.herac.tuxguitar.io.base.TGSongLoaderHandle;
import org.herac.tuxguitar.io.base.TGSongStream;
import org.herac.tuxguitar.io.base.TGSongStreamContext;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGConverter {
    public static final int SLEEP_TIME = 20;
    public static final int FILE_OK = 250;
    public static final int FILE_BAD = 403;
    public static final int FILE_COULDNT_WRITE = 401;
    public static final int FILE_NOT_FOUND = 404;
    public static final int OUT_OF_MEMORY = 500;
    public static final int EXPORTER_NOT_FOUND = 590;
    public static final int UNKNOWN_ERROR = 666;
    private TGContext context;
    private String sourceFolder;
    private String destinationFolder;
    private TGConverterFormat format;
    private TGConverterListener listener;
    private boolean cancelled;

    public TGConverter(TGContext context, String sourceFolder, String destinationFolder) {
        this.context = context;
        this.sourceFolder = sourceFolder;
        this.destinationFolder = destinationFolder;
    }

    public void convert(String fileName, String convertFileName) {
        try {
            this.getListener().notifyFileProcess(convertFileName);
            TGSongManager manager = new TGSongManager();
            TGSong song = null;
            try {
                TGSongLoaderHandle tgSongLoaderHandle = new TGSongLoaderHandle();
                tgSongLoaderHandle.setFactory(manager.getFactory());
                tgSongLoaderHandle.setInputStream((InputStream)new FileInputStream(fileName));
                TGFileFormatManager.getInstance((TGContext)this.context).getLoader().load(tgSongLoaderHandle);
                song = tgSongLoaderHandle.getSong();
            }
            catch (TGFileFormatException e) {
                song = this.importSong(manager.getFactory(), fileName);
            }
            if (song != null) {
                TGOutputStreamBase exporter;
                manager.autoCompleteSilences(song);
                manager.orderBeats(song);
                new File(new File(convertFileName).getParent()).mkdirs();
                if (this.format != null && this.format.getExporter() instanceof TGOutputStreamBase) {
                    exporter = (TGOutputStreamBase)this.format.getExporter();
                    exporter.init(manager.getFactory(), (OutputStream)new BufferedOutputStream(new FileOutputStream(convertFileName)));
                    exporter.writeSong(song);
                } else if (this.format != null && this.format.getExporter() instanceof TGLocalFileExporter) {
                    exporter = (TGLocalFileExporter)this.format.getExporter();
                    TGSongStreamContext streamContext = new TGSongStreamContext();
                    streamContext.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
                    streamContext.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER, (Object)manager);
                    streamContext.setAttribute(OutputStream.class.getName(), (Object)new BufferedOutputStream(new FileOutputStream(convertFileName)));
                    TGSongStream songStream = exporter.openStream(streamContext);
                    songStream.process();
                }
                this.getListener().notifyFileResult(convertFileName, 250);
            } else {
                this.getListener().notifyFileResult(fileName, 403);
            }
        }
        catch (TGFileFormatException e) {
            this.getListener().notifyFileResult(fileName, 401);
        }
        catch (FileNotFoundException ex) {
            this.getListener().notifyFileResult(fileName, 404);
        }
        catch (OutOfMemoryError e) {
            this.getListener().notifyFileResult(convertFileName, 500);
        }
        catch (Throwable throwable) {
            this.getListener().notifyFileResult(convertFileName, 666);
        }
    }

    private String checkIfExists(String convertFileName, int level) {
        if (new File(convertFileName).exists()) {
            String tmpName = convertFileName;
            String tmpExtension = "";
            String tmpLevel = "(" + (level + 1) + ")";
            String lastLevel = "(" + level + ")";
            int index = convertFileName.lastIndexOf(level == 0 ? "." : lastLevel + ".");
            if (index != -1) {
                tmpExtension = tmpName.substring(index + (level == 0 ? 0 : lastLevel.length()), tmpName.length());
                tmpName = tmpName.substring(0, index);
            }
            return this.checkIfExists(tmpName + tmpLevel + tmpExtension, level + 1);
        }
        return convertFileName;
    }

    public void process() {
        this.getListener().notifyStart();
        this.process(new File(this.sourceFolder));
        this.getListener().notifyFinish();
    }

    private void process(File folder) {
        String[] fileNames;
        if (!this.isCancelled() && (fileNames = folder.list()) != null) {
            for (int i = 0; i < fileNames.length; ++i) {
                File file = new File(folder.getPath() + "/" + fileNames[i]);
                if (file.isDirectory()) {
                    this.process(file);
                } else if (!this.isCancelled()) {
                    String fileName = file.getAbsolutePath();
                    String convertFileName = this.getConvertFileName(fileName);
                    this.convert(fileName, convertFileName);
                    this.sleep();
                }
                fileNames[i] = null;
            }
        }
    }

    private String getConvertFileName(String path) {
        String convertPath = this.destinationFolder + File.separator + path.substring(this.sourceFolder.length());
        int lastDot = convertPath.lastIndexOf(".");
        if (lastDot != -1) {
            convertPath = convertPath.substring(0, lastDot) + "." + this.format.getExtension();
        }
        return this.checkIfExists(new File(convertPath).getAbsolutePath(), 0);
    }

    private TGSong importSong(TGFactory factory, String filename) {
        Iterator importers = TGFileFormatManager.getInstance((TGContext)this.context).getImporters();
        while (importers.hasNext()) {
            try {
                TGLocalFileImporter currentImporter;
                TGRawImporter rawImporter = (TGRawImporter)importers.next();
                if (!(rawImporter instanceof TGLocalFileImporter) || !this.isSupportedExtension(filename, currentImporter = (TGLocalFileImporter)rawImporter)) continue;
                TGSongStreamContext streamContext = new TGSongStreamContext();
                streamContext.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER, (Object)new TGSongManager());
                streamContext.setAttribute(InputStream.class.getName(), (Object)new BufferedInputStream(new FileInputStream(filename)));
                TGSongStream songStream = currentImporter.openStream(streamContext);
                songStream.process();
                return (TGSong)streamContext.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    private boolean isSupportedExtension(String filename, TGLocalFileImporter currentImporter) {
        try {
            String extension = filename.substring(filename.lastIndexOf("."), filename.length());
            String[] formats = currentImporter.getFileFormat().getSupportedFormats();
            for (int i = 0; i < formats.length; ++i) {
                if (!extension.toLowerCase().equals("." + formats[i].toLowerCase())) continue;
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    private void sleep() {
        try {
            Thread.sleep(20L);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setFormat(TGConverterFormat format) {
        this.format = format;
    }

    public TGConverterListener getListener() {
        return this.listener;
    }

    public void setListener(TGConverterListener listener) {
        this.listener = listener;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

