/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.ptb.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.io.ptb.base.PTPosition;

public class PTSection {
    private int number;
    private int staffs;
    private List positions;

    public PTSection(int n) {
        this.number = n;
        this.positions = new ArrayList();
    }

    public int getNumber() {
        return this.number;
    }

    public int getStaffs() {
        return this.staffs;
    }

    public void setStaffs(int n) {
        this.staffs = n;
    }

    public List getPositions() {
        return this.positions;
    }

    public PTPosition getPosition(int n) {
        PTPosition pTPosition;
        Iterator iterator = this.getPositions().iterator();
        while (iterator.hasNext()) {
            pTPosition = (PTPosition)iterator.next();
            if (pTPosition.getPosition() != n) continue;
            return pTPosition;
        }
        pTPosition = new PTPosition(n);
        this.getPositions().add(pTPosition);
        return pTPosition;
    }

    public int getNextPositionNumber() {
        int n = 0;
        Iterator iterator = this.getPositions().iterator();
        while (iterator.hasNext()) {
            PTPosition pTPosition = (PTPosition)iterator.next();
            n = Math.max(n, pTPosition.getPosition() + 1);
        }
        return n;
    }

    public void sort() {
        int n = this.getPositions().size();
        for (int i = 0; i < n; ++i) {
            PTPosition pTPosition = null;
            for (int j = i; j < n; ++j) {
                PTPosition pTPosition2 = (PTPosition)this.getPositions().get(j);
                if (pTPosition != null && pTPosition2.getPosition() >= pTPosition.getPosition()) continue;
                pTPosition = pTPosition2;
            }
            this.getPositions().remove(pTPosition);
            this.getPositions().add(i, pTPosition);
        }
    }
}

