/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.custom.tuner;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTunerDialog;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTunerSettings;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class TGTunerSettingsDialog {
    private static final int SHELL_WIDTH = 350;
    protected TGTunerDialog tunerDialog = null;
    protected Combo sampleRateCombo = null;
    protected Combo sampleSizeCombo = null;
    protected Combo bufferSizeCombo = null;
    protected Combo FFTSizeCombo = null;
    protected Scale noiseGate = null;
    protected Label noiseGateValue = null;
    protected Text settingsInfo = null;
    protected boolean updated;

    public TGTunerSettingsDialog(TGTunerDialog tGTunerDialog) {
        this.tunerDialog = tGTunerDialog;
        this.updated = false;
    }

    public void show() {
        final Shell shell = DialogUtils.newDialog((Shell)TuxGuitar.instance().getShell(), (int)2160);
        shell.setLayout((Layout)new GridLayout());
        shell.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        shell.setText(TuxGuitar.getProperty((String)"tuner.settings"));
        shell.setMinimumSize(350, -1);
        Group group = new Group((Composite)shell, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"tuner.device-settings"));
        Composite composite = this.createGroup(TuxGuitar.getProperty((String)"tuner.sound-format"), (Composite)group);
        new Label(composite, 16384).setText(TuxGuitar.getProperty((String)"tuner.sample-rate"));
        this.sampleRateCombo = new Combo(composite, 12);
        this.sampleRateCombo.add("48000");
        this.sampleRateCombo.add("44100");
        this.sampleRateCombo.add("22050");
        this.sampleRateCombo.add("11025");
        this.sampleRateCombo.add("8000");
        this.sampleRateCombo.addSelectionListener((SelectionListener)new UpdatedListener());
        new Label(composite, 16384).setText(TuxGuitar.getProperty((String)"tuner.sample-size"));
        this.sampleSizeCombo = new Combo(composite, 12);
        this.sampleSizeCombo.add("16");
        this.sampleSizeCombo.add("8");
        this.sampleSizeCombo.addSelectionListener((SelectionListener)new UpdatedListener());
        Composite composite2 = this.createGroup(TuxGuitar.getProperty((String)"tuner.sampling-and-analyze"), (Composite)group);
        new Label(composite2, 16384).setText(TuxGuitar.getProperty((String)"tuner.sampling-buffer-size"));
        this.bufferSizeCombo = new Combo(composite2, 12);
        this.bufferSizeCombo.add(new Integer(512).toString());
        this.bufferSizeCombo.add(new Integer(1024).toString());
        this.bufferSizeCombo.add(new Integer(2048).toString());
        this.bufferSizeCombo.add(new Integer(4096).toString());
        this.bufferSizeCombo.add(new Integer(8192).toString());
        this.bufferSizeCombo.add(new Integer(16348).toString());
        this.bufferSizeCombo.addSelectionListener((SelectionListener)new UpdatedListener());
        new Label(composite2, 16384).setText(TuxGuitar.getProperty((String)"tuner.fourier-buffer-size"));
        this.FFTSizeCombo = new Combo(composite2, 12);
        this.FFTSizeCombo.add(new Integer(1024).toString());
        this.FFTSizeCombo.add(new Integer(2048).toString());
        this.FFTSizeCombo.add(new Integer(4096).toString());
        this.FFTSizeCombo.add(new Integer(8192).toString());
        this.FFTSizeCombo.add(new Integer(16384).toString());
        this.FFTSizeCombo.add(new Integer(32768).toString());
        this.FFTSizeCombo.addSelectionListener((SelectionListener)new UpdatedListener());
        Composite composite3 = this.createGroup(TuxGuitar.getProperty((String)"tuner.noise-gate"), (Composite)group);
        this.noiseGate = new Scale(composite3, 2048);
        this.noiseGate.setMaximum(100);
        this.noiseGate.setIncrement(5);
        this.noiseGate.setPageIncrement(10);
        this.noiseGate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGTunerSettingsDialog.this.noiseGateValue.setText(new Integer(TGTunerSettingsDialog.this.noiseGate.getSelection()).toString() + "%");
            }
        });
        this.noiseGate.addSelectionListener((SelectionListener)new UpdatedListener());
        this.noiseGate.setLayoutData((Object)new GridData(0, 0, true, false, 1, 1));
        ((GridData)this.noiseGate.getLayoutData()).widthHint = 270;
        ((GridData)this.noiseGate.getLayoutData()).grabExcessHorizontalSpace = true;
        this.noiseGateValue = new Label(composite3, 16384);
        this.noiseGateValue.setText("                       ");
        Composite composite4 = this.createGroup(TuxGuitar.getProperty((String)"tuner.info"), (Composite)group);
        this.settingsInfo = new Text(composite4, 10);
        this.settingsInfo.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        ((GridData)this.settingsInfo.getLayoutData()).heightHint = 30;
        ((GridData)this.settingsInfo.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.settingsInfo.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.settingsInfo.getLayoutData()).widthHint = 300;
        Composite composite5 = new Composite((Composite)shell, 0);
        composite5.setLayout((Layout)new GridLayout(2, false));
        composite5.setLayoutData((Object)new GridData(4, 4, true, true));
        Button button = new Button(composite5, 8);
        button.setText(TuxGuitar.getProperty((String)"ok"));
        button.setLayoutData((Object)TGTunerDialog.getGridData(80, 25));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGTunerSettingsDialog.this.dispose(shell, true);
            }
        });
        Button button2 = new Button(composite5, 8);
        button2.setText(TuxGuitar.getProperty((String)"close"));
        button2.setLayoutData((Object)TGTunerDialog.getGridData(80, 25));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGTunerSettingsDialog.this.dispose(shell, false);
            }
        });
        this.loadSettings(this.tunerDialog.getTuner().getSettings(), shell);
        DialogUtils.openDialog((Shell)shell, (int)10);
    }

    protected void loadSettings(TGTunerSettings tGTunerSettings, Shell shell) {
        block9: {
            boolean bl = false;
            if (tGTunerSettings == null) {
                tGTunerSettings = TGTunerSettings.getDefaults();
                bl = true;
            }
            boolean bl2 = false;
            int n = 0;
            try {
                while (!bl2) {
                    if (Float.parseFloat(this.sampleRateCombo.getItem(n)) == tGTunerSettings.getSampleRate()) {
                        this.sampleRateCombo.select(n);
                        bl2 = true;
                    }
                    ++n;
                }
                n = 0;
                bl2 = false;
                while (!bl2) {
                    if (Integer.parseInt(this.sampleSizeCombo.getItem(n)) == tGTunerSettings.getSampleSize()) {
                        this.sampleSizeCombo.select(n);
                        bl2 = true;
                    }
                    ++n;
                }
                n = 0;
                bl2 = false;
                while (!bl2) {
                    if (Integer.parseInt(this.FFTSizeCombo.getItem(n)) == tGTunerSettings.getFFTSize()) {
                        this.FFTSizeCombo.select(n);
                        bl2 = true;
                    }
                    ++n;
                }
                this.bufferSizeCombo.setText(new Integer(tGTunerSettings.getBufferSize()).toString());
                this.noiseGate.setSelection((int)Math.round(tGTunerSettings.getTreshold() * 100.0));
                this.noiseGateValue.setText(new Integer(this.noiseGate.getSelection()).toString() + "%");
            }
            catch (Exception exception) {
                if (bl) break block9;
                MessageDialog.errorMessage((Shell)shell, (String)"Failed to load TuxGuitar settings.\nLoading defaults.");
                this.loadSettings(TGTunerSettings.getDefaults(), shell);
            }
        }
    }

    protected void dispose(Shell shell, boolean bl) {
        try {
            if (this.updated & bl) {
                TGTunerSettings tGTunerSettings = new TGTunerSettings();
                tGTunerSettings.setSampleRate(this.getSampleRate());
                tGTunerSettings.setSampleSize(Integer.parseInt(this.sampleSizeCombo.getItem(this.sampleSizeCombo.getSelectionIndex())));
                tGTunerSettings.setBufferSize(this.getBufferSize());
                tGTunerSettings.setFFTSize(this.getFFTSize());
                tGTunerSettings.setTreshold((float)this.noiseGate.getSelection() / 100.0f);
                tGTunerSettings.setWaitPeriod(100);
                this.checkBufferValues(tGTunerSettings);
                this.tunerDialog.getTuner().setSettings(tGTunerSettings);
            }
            this.tunerDialog.getTuner().resumeFromPause();
            shell.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MessageDialog.errorMessage((Shell)shell, (String)exception.getMessage());
        }
    }

    private float getSampleRate() {
        return Float.parseFloat(this.sampleRateCombo.getItem(this.sampleRateCombo.getSelectionIndex()));
    }

    private int getFFTSize() {
        return Integer.parseInt(this.FFTSizeCombo.getItem(this.FFTSizeCombo.getSelectionIndex()));
    }

    private int getBufferSize() {
        return Integer.parseInt(this.bufferSizeCombo.getText());
    }

    protected Composite createGroup(String string, Composite composite) {
        Group group = new Group(composite, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(string);
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite2;
    }

    protected void checkBufferValues(TGTunerSettings tGTunerSettings) throws Exception {
        if (tGTunerSettings.bufferSize % tGTunerSettings.sampleSize != 0 || tGTunerSettings.bufferSize > tGTunerSettings.fftSize) {
            throw new Exception("Invalid sampling buffer size");
        }
    }

    protected class UpdatedListener
    extends SelectionAdapter {
        protected UpdatedListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            TGTunerSettingsDialog.this.updated = true;
            TGTunerSettingsDialog.this.settingsInfo.setText(" Minimal freq diff = " + this.getMinimalFrequencyDiff() + "Hz   \n Time to fill the buffer = " + this.getTimeToFillBuffer() + " sec");
        }

        private double getMinimalFrequencyDiff() {
            return (double)TGTunerSettingsDialog.this.getSampleRate() / (double)TGTunerSettingsDialog.this.getFFTSize();
        }

        private double getTimeToFillBuffer() {
            return (float)TGTunerSettingsDialog.this.getBufferSize() / TGTunerSettingsDialog.this.getSampleRate();
        }
    }
}

