/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.custom.tuner;

public class TGTunerQueue {
    int QUEUE_SIZE = 5;
    protected int head = 0;
    protected double[] queue = new double[this.QUEUE_SIZE];
    private double[] similars = new double[this.QUEUE_SIZE];
    private final double upperTollerance = 1.05;
    private final double lowerTollerance = 0.95;

    public TGTunerQueue() {
        this.clear();
    }

    public void add(double d) {
        ++this.head;
        this.head %= this.QUEUE_SIZE;
        this.queue[this.head] = d;
    }

    public double getFreqApproximation() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.QUEUE_SIZE; ++n2) {
            this.similars[n2] = -2.0;
        }
        for (n2 = 0; n2 < this.QUEUE_SIZE; ++n2) {
            if (this.queue[n2] == -1.0) continue;
            for (n = 0; n < this.QUEUE_SIZE; ++n) {
                if (this.queue[n2] > this.queue[n] * this.lowerTollerance && this.queue[n2] < this.queue[n] * this.upperTollerance) {
                    this.similars[n2] = this.similars[n2] + 2.0;
                }
                if (this.queue[n2] / 2.0 > this.queue[n] * this.lowerTollerance && this.queue[n2] / 2.0 < this.queue[n] * this.upperTollerance) {
                    int n3 = n2;
                    this.similars[n3] = this.similars[n3] + 1.0;
                }
                if (!(this.queue[n2] * 2.0 > this.queue[n] * this.lowerTollerance) || !(this.queue[n2] * 2.0 < this.queue[n] * this.upperTollerance)) continue;
                int n4 = n2;
                this.similars[n4] = this.similars[n4] + 1.0;
            }
        }
        n2 = 0;
        for (n = 1; n < this.QUEUE_SIZE; ++n) {
            if (!(this.similars[n] >= this.similars[n2])) continue;
            n2 = n;
        }
        return this.queue[n2];
    }

    public void clear() {
        for (int i = 0; i < this.QUEUE_SIZE; ++i) {
            this.queue[i] = -1.0;
        }
        this.head = 0;
    }
}

