/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.ascii;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.herac.tuxguitar.io.ascii.ASCIIOutputStream;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;

public class ASCIITabOutputStream {
    private static final String[] TONIC_NAMES = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    private static final int MAX_LINE_LENGTH = 80;
    private TGSongManager manager;
    private PrintStream stream;
    private ASCIIOutputStream out;

    public ASCIITabOutputStream(PrintStream printStream) {
        this.stream = printStream;
    }

    public ASCIITabOutputStream(OutputStream outputStream) {
        this(new PrintStream(outputStream));
    }

    public ASCIITabOutputStream(String string) throws FileNotFoundException {
        this(new FileOutputStream(string));
    }

    public void writeSong(TGSong tGSong) {
        this.manager = new TGSongManager();
        this.manager.setSong(tGSong);
        this.out = new ASCIIOutputStream(this.stream);
        this.drawSong();
        this.out.flush();
        this.out.close();
    }

    private void drawSong() {
        TGSong tGSong = this.manager.getSong();
        this.out.drawStringLine("Title: " + tGSong.getName());
        this.out.drawStringLine("Artist: " + tGSong.getArtist());
        this.out.drawStringLine("Album: " + tGSong.getAlbum());
        this.out.drawStringLine("Author: " + tGSong.getAuthor());
        Iterator iterator = tGSong.getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            this.out.nextLine();
            this.drawTrack(tGTrack);
            this.out.nextLine();
        }
    }

    private void drawTrack(TGTrack tGTrack) {
        int n;
        this.out.nextLine();
        this.out.drawStringLine("Track " + tGTrack.getNumber() + ": " + tGTrack.getName());
        String[] stringArray = new String[tGTrack.getStrings().size()];
        int n2 = 1;
        for (n = 0; n < tGTrack.getStrings().size(); ++n) {
            TGString tGString = (TGString)tGTrack.getStrings().get(n);
            stringArray[n] = TONIC_NAMES[tGString.getValue() % TONIC_NAMES.length];
            n2 = Math.max(n2, stringArray[n].length());
        }
        n = 0;
        boolean bl = false;
        while (!bl) {
            this.out.nextLine();
            int n3 = n;
            for (int i = 0; i < tGTrack.getStrings().size(); ++i) {
                TGString tGString = (TGString)tGTrack.getStrings().get(i);
                this.out.drawTuneSegment(stringArray[i], n2);
                int n4 = tGTrack.countMeasures();
                for (int j = n3; j < n4; ++j) {
                    TGMeasure tGMeasure = tGTrack.getMeasure(j);
                    this.drawMeasure(tGMeasure, tGString);
                    n = j + 1;
                    bl = this.manager.getTrackManager().isLastMeasure(tGMeasure);
                    if (this.out.getPosX() > 80) break;
                }
                this.out.drawBarSegment();
                this.out.nextLine();
            }
            this.out.nextLine();
        }
        this.out.nextLine();
    }

    private void drawMeasure(TGMeasure tGMeasure, TGString tGString) {
        this.out.drawBarSegment();
        this.out.drawStringSegments(1);
        TGBeat tGBeat = this.manager.getMeasureManager().getFirstBeat(tGMeasure.getBeats());
        while (tGBeat != null) {
            int n = 0;
            TGNote tGNote = this.manager.getMeasureManager().getNote(tGBeat, tGString.getNumber());
            if (tGNote != null) {
                n = Integer.toString(tGNote.getValue()).length() - 1;
                this.out.drawNote(tGNote.getValue());
            } else {
                this.out.drawStringSegments(1);
            }
            TGBeat tGBeat2 = this.manager.getMeasureManager().getNextBeat(tGMeasure.getBeats(), tGBeat);
            long l = tGBeat2 != null ? tGBeat2.getStart() - tGBeat.getStart() : tGMeasure.getStart() + tGMeasure.getLength() - tGBeat.getStart();
            this.out.drawStringSegments(this.getDurationScaping(l) - n);
            tGBeat = tGBeat2;
        }
    }

    private int getDurationScaping(long l) {
        int n = 6;
        if (l <= 120L) {
            n = 1;
        } else if (l <= 240L) {
            n = 2;
        } else if (l <= 480L) {
            n = 3;
        } else if (l <= 960L) {
            n = 4;
        } else if (l <= 1920L) {
            n = 5;
        }
        return n;
    }
}

