/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGVoice;

public abstract class TGStroke {
    public static final int STROKE_NONE = 0;
    public static final int STROKE_UP = 1;
    public static final int STROKE_DOWN = -1;
    private int direction = 0;
    private int value;

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public int getIncrementTime(TGBeat tGBeat) {
        long l = 0L;
        if (this.value > 0) {
            for (int i = 0; i < tGBeat.countVoices(); ++i) {
                TGVoice tGVoice = tGBeat.getVoice(i);
                if (tGVoice.isEmpty()) continue;
                long l2 = tGVoice.getDuration().getTime();
                if (l != 0L && l2 >= l) continue;
                l = l2 <= 960L ? l2 : 960L;
            }
            if (l > 0L) {
                return Math.round((float)l / 8.0f * (4.0f / (float)this.value));
            }
        }
        return 0;
    }

    public TGStroke clone(TGFactory tGFactory) {
        TGStroke tGStroke = tGFactory.newStroke();
        this.copy(tGStroke);
        return tGStroke;
    }

    public void copy(TGStroke tGStroke) {
        tGStroke.setValue(this.getValue());
        tGStroke.setDirection(this.getDirection());
    }
}

