/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGTupleto;

public abstract class TGDuration {
    public static final long QUARTER_TIME = 960L;
    public static final int WHOLE = 1;
    public static final int HALF = 2;
    public static final int QUARTER = 4;
    public static final int EIGHTH = 8;
    public static final int SIXTEENTH = 16;
    public static final int THIRTY_SECOND = 32;
    public static final int SIXTY_FOURTH = 64;
    private int value = 4;
    private boolean dotted = false;
    private boolean doubleDotted = false;
    private TGTupleto tupleto;

    public TGDuration(TGFactory tGFactory) {
        this.tupleto = tGFactory.newTupleto();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public boolean isDotted() {
        return this.dotted;
    }

    public void setDotted(boolean bl) {
        this.dotted = bl;
    }

    public boolean isDoubleDotted() {
        return this.doubleDotted;
    }

    public void setDoubleDotted(boolean bl) {
        this.doubleDotted = bl;
    }

    public TGTupleto getTupleto() {
        return this.tupleto;
    }

    public long getTime() {
        long l = (long)(960.0f * (4.0f / (float)this.value));
        if (this.dotted) {
            l += l / 2L;
        } else if (this.doubleDotted) {
            l += l / 4L * 3L;
        }
        return this.tupleto.convertTime(l);
    }

    public static TGDuration fromTime(TGFactory tGFactory, long l) {
        TGDuration tGDuration = tGFactory.newDuration();
        tGDuration.setValue(64);
        tGDuration.setDotted(false);
        tGDuration.setDoubleDotted(false);
        tGDuration.getTupleto().setEnters(3);
        tGDuration.getTupleto().setTimes(2);
        return TGDuration.fromTime(tGFactory, l, tGDuration);
    }

    public static TGDuration fromTime(TGFactory tGFactory, long l, TGDuration tGDuration) {
        return TGDuration.fromTime(tGFactory, l, tGDuration, 10);
    }

    public static TGDuration fromTime(TGFactory tGFactory, long l, TGDuration tGDuration, int n) {
        TGDuration tGDuration2 = tGDuration.clone(tGFactory);
        TGDuration tGDuration3 = tGFactory.newDuration();
        tGDuration3.setValue(1);
        tGDuration3.setDotted(true);
        boolean bl = false;
        while (!bl) {
            long l2 = tGDuration3.getTime();
            if (l2 - (long)n <= l && Math.abs(l2 - l) < Math.abs(tGDuration2.getTime() - l)) {
                tGDuration2 = tGDuration3.clone(tGFactory);
            }
            if (tGDuration3.isDotted()) {
                tGDuration3.setDotted(false);
            } else if (tGDuration3.getTupleto().isEqual(TGTupleto.NORMAL)) {
                tGDuration3.getTupleto().setEnters(3);
                tGDuration3.getTupleto().setTimes(2);
            } else {
                tGDuration3.setValue(tGDuration3.getValue() * 2);
                tGDuration3.setDotted(true);
                tGDuration3.getTupleto().setEnters(1);
                tGDuration3.getTupleto().setTimes(1);
            }
            if (tGDuration3.getValue() <= 64) continue;
            bl = true;
        }
        return tGDuration2;
    }

    public int getIndex() {
        int n = 0;
        int n2 = this.value;
        while ((n2 >>= 1) > 0) {
            ++n;
        }
        return n;
    }

    public boolean isEqual(TGDuration tGDuration) {
        return this.getValue() == tGDuration.getValue() && this.isDotted() == tGDuration.isDotted() && this.isDoubleDotted() == tGDuration.isDoubleDotted() && this.getTupleto().isEqual(tGDuration.getTupleto());
    }

    public TGDuration clone(TGFactory tGFactory) {
        TGDuration tGDuration = tGFactory.newDuration();
        this.copy(tGDuration);
        return tGDuration;
    }

    public void copy(TGDuration tGDuration) {
        tGDuration.setValue(this.getValue());
        tGDuration.setDotted(this.isDotted());
        tGDuration.setDoubleDotted(this.isDoubleDotted());
        this.getTupleto().copy(tGDuration.getTupleto());
    }
}

