/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGTrackManager {
    private TGSongManager songManager;

    public TGTrackManager(TGSongManager tGSongManager) {
        this.songManager = tGSongManager;
    }

    public TGSongManager getSongManager() {
        return this.songManager;
    }

    public TGMeasure getFirstMeasure(TGTrack tGTrack) {
        TGMeasure tGMeasure = null;
        Iterator iterator = tGTrack.getMeasures();
        while (iterator.hasNext()) {
            TGMeasure tGMeasure2 = (TGMeasure)iterator.next();
            if (tGMeasure != null && tGMeasure2.getStart() >= tGMeasure.getStart()) continue;
            tGMeasure = tGMeasure2;
        }
        return tGMeasure;
    }

    public TGMeasure getLastMeasure(TGTrack tGTrack) {
        return tGTrack.getMeasure(tGTrack.countMeasures() - 1);
    }

    public TGMeasure getPrevMeasure(TGMeasure tGMeasure) {
        return tGMeasure.getTrack().getMeasure(tGMeasure.getNumber() - 2);
    }

    public TGMeasure getNextMeasure(TGMeasure tGMeasure) {
        return tGMeasure.getTrack().getMeasure(tGMeasure.getNumber());
    }

    public TGMeasure getMeasureAt(TGTrack tGTrack, long l) {
        Iterator iterator = tGTrack.getMeasures();
        while (iterator.hasNext()) {
            TGMeasure tGMeasure = (TGMeasure)iterator.next();
            long l2 = tGMeasure.getStart();
            long l3 = tGMeasure.getLength();
            if (l < l2 || l >= l2 + l3) continue;
            return tGMeasure;
        }
        return null;
    }

    public TGMeasure getMeasure(TGTrack tGTrack, int n) {
        Iterator iterator = tGTrack.getMeasures();
        while (iterator.hasNext()) {
            TGMeasure tGMeasure = (TGMeasure)iterator.next();
            if (tGMeasure.getNumber() != n) continue;
            return tGMeasure;
        }
        return null;
    }

    public List getMeasuresBeforeEnd(TGTrack tGTrack, long l) {
        ArrayList<TGMeasure> arrayList = new ArrayList<TGMeasure>();
        Iterator iterator = tGTrack.getMeasures();
        while (iterator.hasNext()) {
            TGMeasure tGMeasure = (TGMeasure)iterator.next();
            if (tGMeasure.getStart() < l) continue;
            arrayList.add(tGMeasure);
        }
        return arrayList;
    }

    public List getMeasuresBetween(TGTrack tGTrack, long l, long l2) {
        ArrayList<TGMeasure> arrayList = new ArrayList<TGMeasure>();
        Iterator iterator = tGTrack.getMeasures();
        while (iterator.hasNext()) {
            TGMeasure tGMeasure = (TGMeasure)iterator.next();
            if (tGMeasure.getStart() + tGMeasure.getLength() <= l || tGMeasure.getStart() >= l2) continue;
            arrayList.add(tGMeasure);
        }
        return arrayList;
    }

    public void addNewMeasureBeforeEnd(TGTrack tGTrack, TGMeasureHeader tGMeasureHeader) {
        this.addNewMeasureAfter(tGTrack, tGMeasureHeader, this.getLastMeasure(tGTrack));
    }

    public void addNewMeasureAfter(TGTrack tGTrack, TGMeasureHeader tGMeasureHeader, TGMeasure tGMeasure) {
        TGMeasure tGMeasure2 = this.getSongManager().getFactory().newMeasure(tGMeasureHeader);
        tGMeasure2.setClef(tGMeasure.getClef());
        tGMeasure2.setKeySignature(tGMeasure.getKeySignature());
        this.addMeasure(tGTrack, tGMeasure2);
    }

    public void addNewMeasure(TGTrack tGTrack, TGMeasureHeader tGMeasureHeader) {
        TGMeasure tGMeasure = this.getMeasure(tGTrack, tGMeasureHeader.getNumber() == 1 ? tGMeasureHeader.getNumber() + 1 : tGMeasureHeader.getNumber() - 1);
        TGMeasure tGMeasure2 = this.getSongManager().getFactory().newMeasure(tGMeasureHeader);
        tGMeasure2.setTrack(tGTrack);
        tGMeasure2.setClef(tGMeasure.getClef());
        tGMeasure2.setKeySignature(tGMeasure.getKeySignature());
        this.addMeasure(tGTrack, tGMeasureHeader.getNumber() - 1, tGMeasure2);
    }

    public void addMeasure(TGTrack tGTrack, TGMeasure tGMeasure) {
        tGTrack.addMeasure(tGMeasure);
    }

    public void addMeasure(TGTrack tGTrack, int n, TGMeasure tGMeasure) {
        tGTrack.addMeasure(n, tGMeasure);
    }

    public void removeLastMeasure(TGTrack tGTrack) {
        this.removeMeasure(this.getLastMeasure(tGTrack));
    }

    public void removeMeasure(TGTrack tGTrack, long l) {
        this.removeMeasure(this.getMeasureAt(tGTrack, l));
    }

    public void removeMeasure(TGMeasure tGMeasure) {
        tGMeasure.getTrack().removeMeasure(tGMeasure.getNumber() - 1);
    }

    public TGMeasure replaceMeasure(TGTrack tGTrack, TGMeasure tGMeasure) {
        TGMeasure tGMeasure2 = this.getMeasureAt(tGTrack, tGMeasure.getStart());
        tGMeasure2.makeEqual(tGMeasure);
        return tGMeasure2;
    }

    public void moveMeasure(TGMeasure tGMeasure, long l) {
        this.getSongManager().getMeasureManager().moveAllBeats(tGMeasure, l);
    }

    public void moveOutOfBoundsBeatsToNewMeasure(TGTrack tGTrack, long l) {
        Iterator iterator = this.getMeasuresBeforeEnd(tGTrack, l).iterator();
        while (iterator.hasNext()) {
            TGMeasure tGMeasure = (TGMeasure)iterator.next();
            this.getSongManager().getMeasureManager().moveOutOfBoundsBeatsToNewMeasure(tGMeasure);
        }
    }

    public void changeKeySignature(TGTrack tGTrack, long l, int n, boolean bl) {
        this.changeKeySignature(tGTrack, this.getMeasureAt(tGTrack, l), n, bl);
    }

    public void changeKeySignature(TGTrack tGTrack, TGMeasure tGMeasure, int n, boolean bl) {
        tGMeasure.setKeySignature(n);
        if (bl) {
            List list = this.getMeasuresBeforeEnd(tGTrack, tGMeasure.getStart() + 1L);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TGMeasure tGMeasure2 = (TGMeasure)iterator.next();
                tGMeasure2.setKeySignature(n);
            }
        }
    }

    public void changeClef(TGTrack tGTrack, long l, int n, boolean bl) {
        this.changeClef(tGTrack, this.getMeasureAt(tGTrack, l), n, bl);
    }

    public void changeClef(TGTrack tGTrack, TGMeasure tGMeasure, int n, boolean bl) {
        tGMeasure.setClef(n);
        if (bl) {
            List list = this.getMeasuresBeforeEnd(tGTrack, tGMeasure.getStart() + 1L);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TGMeasure tGMeasure2 = (TGMeasure)iterator.next();
                tGMeasure2.setClef(n);
            }
        }
    }

    public void changeInfo(TGTrack tGTrack, String string, TGColor tGColor, int n) {
        tGTrack.setName(string);
        tGTrack.setOffset(n);
        tGTrack.getColor().setR(tGColor.getR());
        tGTrack.getColor().setG(tGColor.getG());
        tGTrack.getColor().setB(tGColor.getB());
    }

    public void changeInstrumentStrings(TGTrack tGTrack, List list) {
        if (list.size() < tGTrack.getStrings().size()) {
            this.removeNotesAfterString(tGTrack, list.size());
        }
        tGTrack.setStrings(list);
    }

    public void removeNotesAfterString(TGTrack tGTrack, int n) {
        Iterator iterator = tGTrack.getMeasures();
        while (iterator.hasNext()) {
            TGMeasure tGMeasure = (TGMeasure)iterator.next();
            this.getSongManager().getMeasureManager().removeNotesAfterString(tGMeasure, n);
        }
    }

    public void changeInstrument(TGTrack tGTrack, int n, boolean bl) {
        tGTrack.getChannel().setInstrument((short)n);
        if (bl) {
            TGChannel.setPercusionChannel(tGTrack.getChannel());
            tGTrack.setStrings(TGSongManager.createPercusionStrings(this.getSongManager().getFactory(), tGTrack.getStrings().size()));
        } else if (tGTrack.getChannel().isPercussionChannel()) {
            TGChannel tGChannel = this.songManager.getFreeChannel((short)n, false);
            tGTrack.getChannel().setChannel(tGChannel.getChannel());
            tGTrack.getChannel().setEffectChannel(tGChannel.getEffectChannel());
        }
        this.songManager.updateChannel(tGTrack.getChannel());
    }

    public void autoCompleteSilences(TGTrack tGTrack) {
        Iterator iterator = tGTrack.getMeasures();
        while (iterator.hasNext()) {
            TGMeasure tGMeasure = (TGMeasure)iterator.next();
            this.songManager.getMeasureManager().autoCompleteSilences(tGMeasure);
        }
    }

    public void orderBeats(TGTrack tGTrack) {
        Iterator iterator = tGTrack.getMeasures();
        while (iterator.hasNext()) {
            TGMeasure tGMeasure = (TGMeasure)iterator.next();
            this.songManager.getMeasureManager().orderBeats(tGMeasure);
        }
    }

    public boolean isFirstMeasure(TGMeasure tGMeasure) {
        return tGMeasure.getNumber() == 1;
    }

    public boolean isLastMeasure(TGMeasure tGMeasure) {
        return this.getSongManager().getSong().countMeasureHeaders() == tGMeasure.getNumber();
    }
}

