/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class TGMeasureManager {
    private TGSongManager songManager;

    public TGMeasureManager(TGSongManager tGSongManager) {
        this.songManager = tGSongManager;
    }

    public TGSongManager getSongManager() {
        return this.songManager;
    }

    public void orderBeats(TGMeasure tGMeasure) {
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            TGBeat tGBeat = null;
            for (int j = i; j < tGMeasure.countBeats(); ++j) {
                TGBeat tGBeat2 = tGMeasure.getBeat(j);
                if (tGBeat != null && tGBeat2.getStart() >= tGBeat.getStart()) continue;
                tGBeat = tGBeat2;
            }
            tGMeasure.moveBeat(i, tGBeat);
        }
    }

    public void addBeat(TGMeasure tGMeasure, TGBeat tGBeat) {
        tGMeasure.addBeat(tGBeat);
    }

    public void removeBeat(TGBeat tGBeat) {
        tGBeat.getMeasure().removeBeat(tGBeat);
    }

    public void removeBeat(TGMeasure tGMeasure, long l, boolean bl) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.removeBeat(tGBeat, bl);
        }
    }

    public void removeBeat(TGBeat tGBeat, boolean bl) {
        TGMeasure tGMeasure = tGBeat.getMeasure();
        this.removeBeat(tGBeat);
        if (bl) {
            TGDuration tGDuration = this.getMinimumDuration(tGBeat);
            long l = tGBeat.getStart();
            long l2 = tGDuration != null ? tGDuration.getTime() : 0L;
            TGBeat tGBeat2 = this.getNextBeat(tGMeasure.getBeats(), tGBeat);
            if (tGBeat2 != null) {
                l2 = tGBeat2.getStart() - l;
            }
            this.moveBeats(tGBeat.getMeasure(), l + l2, -l2, tGDuration);
        }
    }

    public void removeEmptyBeats(TGMeasure tGMeasure) {
        TGBeat tGBeat;
        ArrayList<TGBeat> arrayList = new ArrayList<TGBeat>();
        Iterator iterator = tGMeasure.getBeats().iterator();
        while (iterator.hasNext()) {
            tGBeat = (TGBeat)iterator.next();
            boolean bl = true;
            for (int i = 0; i < tGBeat.countVoices(); ++i) {
                TGVoice tGVoice = tGBeat.getVoice(i);
                if (tGVoice.isEmpty()) continue;
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(tGBeat);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            tGBeat = (TGBeat)iterator.next();
            this.removeBeat(tGBeat);
        }
    }

    public void removeBeatsBeforeEnd(TGMeasure tGMeasure, long l) {
        List list = this.getBeatsBeforeEnd(tGMeasure.getBeats(), l);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGBeat tGBeat = (TGBeat)iterator.next();
            this.removeBeat(tGBeat);
        }
    }

    public void addNote(TGMeasure tGMeasure, long l, TGNote tGNote, TGDuration tGDuration, int n) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.addNote(tGBeat, tGNote, tGDuration, n);
        }
    }

    public void addNote(TGBeat tGBeat, TGNote tGNote, TGDuration tGDuration, int n) {
        this.addNote(tGBeat, tGNote, tGDuration, tGBeat.getStart(), n);
    }

    public void addNote(TGBeat tGBeat, TGNote tGNote, TGDuration tGDuration, long l, int n) {
        boolean bl = tGBeat.getVoice(n).isEmpty();
        if (bl) {
            tGBeat.getVoice(n).setEmpty(false);
        }
        if (this.validateDuration(tGBeat.getMeasure(), tGBeat, n, tGDuration, true, true)) {
            TGVoice tGVoice;
            for (int i = 0; i < tGBeat.countVoices(); ++i) {
                this.removeNote(tGBeat.getMeasure(), tGBeat.getStart(), i, tGNote.getString(), false);
            }
            tGDuration.copy(tGBeat.getVoice(n).getDuration());
            this.tryChangeSilenceAfter(tGBeat.getMeasure(), tGBeat.getVoice(n));
            TGVoice tGVoice2 = tGBeat.getVoice(n);
            if (tGVoice2.getBeat().getStart() != l && (tGVoice = this.getVoiceIn(tGVoice2.getBeat().getMeasure(), l, n)) != null) {
                tGVoice2 = tGVoice;
            }
            tGVoice2.addNote(tGNote);
        } else {
            tGBeat.getVoice(n).setEmpty(bl);
        }
    }

    public void removeNote(TGNote tGNote) {
        tGNote.getVoice().removeNote(tGNote);
    }

    public void removeNote(TGMeasure tGMeasure, long l, int n, int n2) {
        this.removeNote(tGMeasure, l, n, n2, true);
    }

    public void removeNote(TGMeasure tGMeasure, long l, int n, int n2, boolean bl) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            TGVoice tGVoice = tGBeat.getVoice(n);
            for (int i = 0; i < tGVoice.countNotes(); ++i) {
                TGNote tGNote = tGVoice.getNote(i);
                if (tGNote.getString() != n2) continue;
                this.removeNote(tGNote);
                if (bl && tGBeat.isRestBeat()) {
                    tGBeat.getStroke().setDirection(0);
                    this.removeChord(tGMeasure, tGBeat.getStart());
                }
                return;
            }
        }
    }

    public void removeNotesAfterString(TGMeasure tGMeasure, int n) {
        Object object;
        ArrayList<TGNote> arrayList = new ArrayList<TGNote>();
        Iterator iterator = tGMeasure.getBeats().iterator();
        while (iterator.hasNext()) {
            object = (TGBeat)iterator.next();
            for (int i = 0; i < ((TGBeat)object).countVoices(); ++i) {
                TGVoice tGVoice = ((TGBeat)object).getVoice(i);
                Iterator iterator2 = tGVoice.getNotes().iterator();
                while (iterator2.hasNext()) {
                    TGNote tGNote = (TGNote)iterator2.next();
                    if (tGNote.getString() <= n) continue;
                    arrayList.add(tGNote);
                }
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            TGNote tGNote = (TGNote)object.next();
            this.removeNote(tGNote);
        }
    }

    public List getNotes(TGMeasure tGMeasure, long l) {
        ArrayList<TGNote> arrayList = new ArrayList<TGNote>();
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            for (int i = 0; i < tGBeat.countVoices(); ++i) {
                TGVoice tGVoice = tGBeat.getVoice(i);
                Iterator iterator = tGVoice.getNotes().iterator();
                while (iterator.hasNext()) {
                    TGNote tGNote = (TGNote)iterator.next();
                    arrayList.add(tGNote);
                }
            }
        }
        return arrayList;
    }

    public TGNote getNote(TGMeasure tGMeasure, long l, int n) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            return this.getNote(tGBeat, n);
        }
        return null;
    }

    public TGNote getNote(TGBeat tGBeat, int n) {
        for (int i = 0; i < tGBeat.countVoices(); ++i) {
            TGNote tGNote;
            TGVoice tGVoice = tGBeat.getVoice(i);
            if (tGVoice.isEmpty() || (tGNote = this.getNote(tGVoice, n)) == null) continue;
            return tGNote;
        }
        return null;
    }

    public TGNote getNote(TGVoice tGVoice, int n) {
        Iterator iterator = tGVoice.getNotes().iterator();
        while (iterator.hasNext()) {
            TGNote tGNote = (TGNote)iterator.next();
            if (tGNote.getString() != n) continue;
            return tGNote;
        }
        return null;
    }

    public TGNote getPreviousNote(TGMeasure tGMeasure, long l, int n, int n2) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            TGBeat tGBeat2 = this.getPreviousBeat(tGMeasure.getBeats(), tGBeat);
            while (tGBeat2 != null) {
                TGVoice tGVoice = tGBeat2.getVoice(n);
                if (!tGVoice.isEmpty()) {
                    for (int i = 0; i < tGVoice.countNotes(); ++i) {
                        TGNote tGNote = tGVoice.getNote(i);
                        if (tGNote.getString() != n2) continue;
                        return tGNote;
                    }
                }
                tGBeat2 = this.getPreviousBeat(tGMeasure.getBeats(), tGBeat2);
            }
        }
        return null;
    }

    public TGNote getNextNote(TGMeasure tGMeasure, long l, int n, int n2) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            TGBeat tGBeat2 = this.getNextBeat(tGMeasure.getBeats(), tGBeat);
            while (tGBeat2 != null) {
                TGVoice tGVoice = tGBeat2.getVoice(n);
                if (!tGVoice.isEmpty()) {
                    for (int i = 0; i < tGVoice.countNotes(); ++i) {
                        TGNote tGNote = tGVoice.getNote(i);
                        if (tGNote.getString() != n2) continue;
                        return tGNote;
                    }
                }
                tGBeat2 = this.getNextBeat(tGMeasure.getBeats(), tGBeat2);
            }
        }
        return null;
    }

    public TGDuration getMinimumDuration(TGBeat tGBeat) {
        TGDuration tGDuration = null;
        for (int i = 0; i < tGBeat.countVoices(); ++i) {
            TGVoice tGVoice = tGBeat.getVoice(i);
            if (tGVoice.isEmpty() || tGDuration != null && tGVoice.getDuration().getTime() >= tGDuration.getTime()) continue;
            tGDuration = tGVoice.getDuration();
        }
        return tGDuration;
    }

    public TGBeat getBeat(TGMeasure tGMeasure, long l) {
        Iterator iterator = tGMeasure.getBeats().iterator();
        while (iterator.hasNext()) {
            TGBeat tGBeat = (TGBeat)iterator.next();
            if (tGBeat.getStart() != l) continue;
            return tGBeat;
        }
        return null;
    }

    public TGBeat getBeatIn(TGMeasure tGMeasure, long l) {
        TGBeat tGBeat = null;
        Iterator iterator = tGMeasure.getBeats().iterator();
        while (iterator.hasNext()) {
            TGBeat tGBeat2 = (TGBeat)iterator.next();
            TGDuration tGDuration = this.getMinimumDuration(tGBeat2);
            if (tGBeat2.getStart() > l || tGBeat2.getStart() + tGDuration.getTime() <= l || tGBeat != null && tGBeat2.getStart() <= tGBeat.getStart()) continue;
            tGBeat = tGBeat2;
        }
        return tGBeat;
    }

    public TGVoice getVoiceIn(TGMeasure tGMeasure, long l, int n) {
        Iterator iterator = tGMeasure.getBeats().iterator();
        while (iterator.hasNext()) {
            TGBeat tGBeat = (TGBeat)iterator.next();
            TGVoice tGVoice = tGBeat.getVoice(n);
            if (tGVoice.isEmpty() || tGBeat.getStart() > l || tGBeat.getStart() + tGVoice.getDuration().getTime() <= l) continue;
            return tGVoice;
        }
        return null;
    }

    public TGBeat getNextBeat(List list, TGBeat tGBeat) {
        TGBeat tGBeat2 = null;
        for (int i = 0; i < list.size(); ++i) {
            TGBeat tGBeat3 = (TGBeat)list.get(i);
            if (tGBeat3.getStart() <= tGBeat.getStart()) continue;
            if (tGBeat2 == null) {
                tGBeat2 = tGBeat3;
                continue;
            }
            if (tGBeat3.getStart() >= tGBeat2.getStart()) continue;
            tGBeat2 = tGBeat3;
        }
        return tGBeat2;
    }

    public TGBeat getPreviousBeat(List list, TGBeat tGBeat) {
        TGBeat tGBeat2 = null;
        for (int i = 0; i < list.size(); ++i) {
            TGBeat tGBeat3 = (TGBeat)list.get(i);
            if (tGBeat3.getStart() >= tGBeat.getStart()) continue;
            if (tGBeat2 == null) {
                tGBeat2 = tGBeat3;
                continue;
            }
            if (tGBeat3.getStart() <= tGBeat2.getStart()) continue;
            tGBeat2 = tGBeat3;
        }
        return tGBeat2;
    }

    public TGBeat getFirstBeat(List list) {
        TGBeat tGBeat = null;
        for (int i = 0; i < list.size(); ++i) {
            TGBeat tGBeat2 = (TGBeat)list.get(i);
            if (tGBeat != null && tGBeat2.getStart() >= tGBeat.getStart()) continue;
            tGBeat = tGBeat2;
        }
        return tGBeat;
    }

    public TGBeat getLastBeat(List list) {
        TGBeat tGBeat = null;
        for (int i = 0; i < list.size(); ++i) {
            TGBeat tGBeat2 = (TGBeat)list.get(i);
            if (tGBeat != null && tGBeat.getStart() >= tGBeat2.getStart()) continue;
            tGBeat = tGBeat2;
        }
        return tGBeat;
    }

    public List getBeatsBeforeEnd(List list, long l) {
        ArrayList<TGBeat> arrayList = new ArrayList<TGBeat>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGBeat tGBeat = (TGBeat)iterator.next();
            if (tGBeat.getStart() < l) continue;
            arrayList.add(tGBeat);
        }
        return arrayList;
    }

    public void moveOutOfBoundsBeatsToNewMeasure(TGMeasure tGMeasure) {
        Object object;
        ArrayList<TGBeat> arrayList = new ArrayList<TGBeat>();
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            object = tGMeasure.getBeat(i);
            if (((TGBeat)object).getStart() >= tGMeasure.getStart() && ((TGBeat)object).getStart() < tGMeasure.getStart() + tGMeasure.getLength()) continue;
            arrayList.add((TGBeat)object);
        }
        while (!arrayList.isEmpty()) {
            TGBeat tGBeat = (TGBeat)arrayList.get(0);
            tGBeat.getMeasure().removeBeat(tGBeat);
            tGBeat.setMeasure(null);
            object = this.getSongManager().getTrackManager().getMeasureAt(tGMeasure.getTrack(), tGBeat.getStart());
            while (object == null) {
                this.getSongManager().addNewMeasureBeforeEnd();
                object = this.getSongManager().getTrackManager().getMeasureAt(tGMeasure.getTrack(), tGBeat.getStart());
            }
            ((TGMeasure)object).addBeat(tGBeat);
            arrayList.remove(0);
        }
    }

    public void moveAllBeats(TGMeasure tGMeasure, long l) {
        this.moveBeats(tGMeasure.getBeats(), l);
    }

    public boolean moveBeats(TGMeasure tGMeasure, long l, long l2, TGDuration tGDuration) {
        if (l2 == 0L) {
            return false;
        }
        boolean bl = true;
        long l3 = tGMeasure.getStart();
        long l4 = l3 + tGMeasure.getLength();
        List list = this.getBeatsBeforeEnd(tGMeasure.getBeats(), l);
        this.moveBeats(list, l2);
        if (bl) {
            TGDuration tGDuration2;
            ArrayList<TGBeat> arrayList = new ArrayList<TGBeat>();
            ArrayList arrayList2 = new ArrayList(tGMeasure.getBeats());
            TGBeat tGBeat = this.getFirstBeat(arrayList2);
            while (tGBeat != null && tGBeat.isRestBeat() && !tGBeat.isTextBeat() && tGBeat.getStart() < l3) {
                arrayList2.remove(tGBeat);
                arrayList.add(tGBeat);
                tGBeat = this.getNextBeat(arrayList2, tGBeat);
            }
            TGBeat tGBeat2 = this.getLastBeat(arrayList2);
            TGDuration tGDuration3 = tGDuration2 = tGBeat2 != null ? this.getMinimumDuration(tGBeat2) : null;
            while (tGBeat2 != null && tGDuration2 != null && tGBeat2.isRestBeat() && !tGBeat2.isTextBeat() && tGBeat2.getStart() + tGDuration2.getTime() > l4) {
                arrayList2.remove(tGBeat2);
                arrayList.add(tGBeat2);
                tGBeat2 = this.getPreviousBeat(arrayList2, tGBeat2);
                tGDuration2 = tGBeat2 != null ? this.getMinimumDuration(tGBeat2) : null;
            }
            if (tGBeat != null && tGBeat2 != null && tGDuration2 != null && (tGBeat.getStart() < l3 || tGBeat2.getStart() + tGDuration2.getTime() > l4)) {
                bl = false;
            }
            if (bl) {
                TGBeat tGBeat3;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    tGBeat3 = (TGBeat)iterator.next();
                    this.removeBeat(tGBeat3);
                }
                if (tGDuration != null) {
                    if (l2 < 0L) {
                        tGBeat2 = this.getLastBeat(tGMeasure.getBeats());
                        tGDuration2 = tGBeat2 != null ? this.getMinimumDuration(tGBeat2) : null;
                        tGBeat3 = this.getSongManager().getFactory().newBeat();
                        tGBeat3.setStart(tGBeat2 != null && tGDuration2 != null ? tGBeat2.getStart() + tGDuration2.getTime() : l);
                        if (tGBeat3.getStart() + tGDuration.getTime() <= l4) {
                            for (int i = 0; i < tGBeat3.countVoices(); ++i) {
                                TGVoice tGVoice = tGBeat3.getVoice(i);
                                tGVoice.setEmpty(false);
                                tGDuration.copy(tGVoice.getDuration());
                            }
                            this.addBeat(tGMeasure, tGBeat3);
                        }
                    } else {
                        tGBeat = this.getFirstBeat(this.getBeatsBeforeEnd(tGMeasure.getBeats(), l));
                        tGBeat3 = this.getSongManager().getFactory().newBeat();
                        tGBeat3.setStart(l);
                        if (tGBeat3.getStart() + tGDuration.getTime() <= (tGBeat != null ? tGBeat.getStart() : l4)) {
                            for (int i = 0; i < tGBeat3.countVoices(); ++i) {
                                TGVoice tGVoice = tGBeat3.getVoice(i);
                                tGVoice.setEmpty(false);
                                tGDuration.copy(tGVoice.getDuration());
                            }
                            this.addBeat(tGMeasure, tGBeat3);
                        }
                    }
                }
            }
        }
        if (!bl) {
            this.moveBeats(list, -l2);
        }
        return bl;
    }

    private void moveBeats(List list, long l) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGBeat tGBeat = (TGBeat)iterator.next();
            this.moveBeat(tGBeat, l);
        }
    }

    private void moveBeat(TGBeat tGBeat, long l) {
        long l2 = tGBeat.getStart();
        tGBeat.setStart(l2 + l);
    }

    public void cleanBeat(TGBeat tGBeat) {
        tGBeat.getStroke().setDirection(0);
        if (tGBeat.getText() != null) {
            tGBeat.removeChord();
        }
        if (tGBeat.getChord() != null) {
            tGBeat.removeText();
        }
        this.cleanBeatNotes(tGBeat);
    }

    public void cleanBeatNotes(TGBeat tGBeat) {
        for (int i = 0; i < tGBeat.countVoices(); ++i) {
            this.cleanVoiceNotes(tGBeat.getVoice(i));
        }
    }

    public void cleanBeatNotes(TGMeasure tGMeasure, long l) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.cleanBeatNotes(tGBeat);
        }
    }

    public void cleanVoiceNotes(TGVoice tGVoice) {
        if (!tGVoice.isEmpty()) {
            while (tGVoice.countNotes() > 0) {
                TGNote tGNote = tGVoice.getNote(0);
                this.removeNote(tGNote);
            }
        }
    }

    public void addChord(TGMeasure tGMeasure, long l, TGChord tGChord) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.addChord(tGBeat, tGChord);
        }
    }

    public void addChord(TGBeat tGBeat, TGChord tGChord) {
        tGBeat.removeChord();
        tGBeat.setChord(tGChord);
    }

    public TGChord getChord(TGMeasure tGMeasure, long l) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            return tGBeat.getChord();
        }
        return null;
    }

    public void removeChord(TGMeasure tGMeasure, long l) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            tGBeat.removeChord();
        }
    }

    public void addText(TGMeasure tGMeasure, long l, TGText tGText) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.addText(tGBeat, tGText);
        }
    }

    public void addText(TGBeat tGBeat, TGText tGText) {
        tGBeat.removeText();
        if (!tGText.isEmpty()) {
            tGBeat.setText(tGText);
        }
    }

    public TGText getText(TGMeasure tGMeasure, long l) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            return tGBeat.getText();
        }
        return null;
    }

    public void removeText(TGBeat tGBeat) {
        tGBeat.removeText();
    }

    public boolean removeText(TGMeasure tGMeasure, long l) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.removeText(tGBeat);
            return true;
        }
        return false;
    }

    public void cleanMeasure(TGMeasure tGMeasure) {
        while (tGMeasure.countBeats() > 0) {
            this.removeBeat(tGMeasure.getBeat(0));
        }
    }

    public int shiftNoteUp(TGMeasure tGMeasure, long l, int n) {
        return this.shiftNote(tGMeasure, l, n, -1);
    }

    public int shiftNoteDown(TGMeasure tGMeasure, long l, int n) {
        return this.shiftNote(tGMeasure, l, n, 1);
    }

    private int shiftNote(TGMeasure tGMeasure, long l, int n, int n2) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            int n3 = tGNote.getString() + n2;
            while (this.getNote(tGMeasure, l, n3) != null) {
                n3 += n2;
            }
            if (n3 >= 1 && n3 <= tGMeasure.getTrack().stringCount()) {
                TGString tGString = tGMeasure.getTrack().getString(tGNote.getString());
                TGString tGString2 = tGMeasure.getTrack().getString(n3);
                int n4 = tGNote.getValue() + tGString.getValue();
                if (n4 >= tGString2.getValue() && (tGString2.getValue() + 30 > n4 || tGMeasure.getTrack().isPercussionTrack())) {
                    tGNote.setValue(n4 - tGString2.getValue());
                    tGNote.setString(tGString2.getNumber());
                    return tGNote.getString();
                }
            }
        }
        return 0;
    }

    public boolean moveSemitoneUp(TGMeasure tGMeasure, long l, int n) {
        return this.moveSemitone(tGMeasure, l, n, 1);
    }

    public boolean moveSemitoneDown(TGMeasure tGMeasure, long l, int n) {
        return this.moveSemitone(tGMeasure, l, n, -1);
    }

    private boolean moveSemitone(TGMeasure tGMeasure, long l, int n, int n2) {
        int n3;
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null && (n3 = tGNote.getValue() + n2) >= 0 && (n3 < 30 || tGMeasure.getTrack().isPercussionTrack())) {
            tGNote.setValue(n3);
            return true;
        }
        return false;
    }

    public boolean setStroke(TGMeasure tGMeasure, long l, int n, int n2) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            tGBeat.getStroke().setValue(n);
            tGBeat.getStroke().setDirection(n2);
            return true;
        }
        return false;
    }

    public void autoCompleteSilences(TGMeasure tGMeasure) {
        int n;
        Object object;
        TGBeat tGBeat = this.getFirstBeat(tGMeasure.getBeats());
        if (tGBeat == null) {
            this.createSilences(tGMeasure, tGMeasure.getStart(), tGMeasure.getLength(), 0);
            return;
        }
        for (int i = 0; i < 2; ++i) {
            object = this.getFirstVoice(tGMeasure.getBeats(), i);
            if (object == null || ((TGVoice)object).getBeat().getStart() <= tGMeasure.getStart()) continue;
            this.createSilences(tGMeasure, tGMeasure.getStart(), ((TGVoice)object).getBeat().getStart() - tGMeasure.getStart(), i);
        }
        long[] lArray = new long[tGBeat.countVoices()];
        object = new long[tGBeat.countVoices()];
        for (n = 0; n < ((Object)object).length; ++n) {
            lArray[n] = 0L;
            object[n] = 0L;
        }
        while (tGBeat != null) {
            for (n = 0; n < tGBeat.countVoices(); ++n) {
                TGVoice tGVoice = tGBeat.getVoice(n);
                if (tGVoice.isEmpty()) continue;
                long l = tGBeat.getStart() + tGVoice.getDuration().getTime();
                long l2 = tGMeasure.getStart() + tGMeasure.getLength();
                TGVoice tGVoice2 = this.getNextVoice(tGMeasure.getBeats(), tGBeat, tGVoice.getIndex());
                if (tGVoice2 != null) {
                    l2 = tGVoice2.getBeat().getStart();
                }
                if (l >= l2) continue;
                lArray[n] = l;
                object[n] = l2 - l;
            }
            for (n = 0; n < ((Object)object).length; ++n) {
                if (object[n] > 0L) {
                    this.createSilences(tGMeasure, lArray[n], (long)object[n], n);
                }
                lArray[n] = 0L;
                object[n] = 0L;
            }
            tGBeat = this.getNextBeat(tGMeasure.getBeats(), tGBeat);
        }
    }

    private void createSilences(TGMeasure tGMeasure, long l, long l2, int n) {
        long l3 = l;
        List list = TGMeasureManager.createDurations(this.getSongManager().getFactory(), l2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGDuration tGDuration = (TGDuration)iterator.next();
            boolean bl = false;
            long l4 = this.getRealStart(tGMeasure, l3);
            TGBeat tGBeat = this.getBeat(tGMeasure, l4);
            if (tGBeat == null) {
                tGBeat = this.getSongManager().getFactory().newBeat();
                tGBeat.setStart(this.getRealStart(tGMeasure, l3));
                bl = true;
            }
            TGVoice tGVoice = tGBeat.getVoice(n);
            tGVoice.setEmpty(false);
            tGDuration.copy(tGVoice.getDuration());
            if (bl) {
                this.addBeat(tGMeasure, tGBeat);
            }
            l3 += tGDuration.getTime();
        }
    }

    public long getRealStart(TGMeasure tGMeasure, long l) {
        boolean bl;
        long l2 = l;
        long l3 = TGSongManager.getDivisionLength(tGMeasure.getHeader());
        boolean bl2 = bl = l2 % l3 == 0L;
        if (!bl) {
            TGDuration tGDuration = this.getSongManager().getFactory().newDuration();
            tGDuration.setValue(64);
            tGDuration.getTupleto().setEnters(3);
            tGDuration.getTupleto().setTimes(2);
            int n = 0;
            while ((long)n < tGDuration.getTime()) {
                boolean bl3 = bl = ++l2 % l3 == 0L;
                if (bl) break;
                ++n;
            }
            if (!bl) {
                l2 = l;
            }
        }
        return l2;
    }

    public void changeTieNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            this.changeTieNote(tGNote);
        }
    }

    public void changeTieNote(TGNote tGNote) {
        tGNote.setTiedNote(!tGNote.isTiedNote());
        tGNote.getEffect().setDeadNote(false);
    }

    public void changeVibratoNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setVibrato(!tGNote.getEffect().isVibrato());
        }
    }

    public void changeDeadNote(TGNote tGNote) {
        tGNote.getEffect().setDeadNote(!tGNote.getEffect().isDeadNote());
        tGNote.setTiedNote(false);
    }

    public void changeSlideNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setSlide(!tGNote.getEffect().isSlide());
        }
    }

    public void changeHammerNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setHammer(!tGNote.getEffect().isHammer());
        }
    }

    public void changePalmMute(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setPalmMute(!tGNote.getEffect().isPalmMute());
        }
    }

    public void changeStaccato(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setStaccato(!tGNote.getEffect().isStaccato());
        }
    }

    public void changeTapping(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setTapping(!tGNote.getEffect().isTapping());
        }
    }

    public void changeSlapping(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setSlapping(!tGNote.getEffect().isSlapping());
        }
    }

    public void changePopping(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setPopping(!tGNote.getEffect().isPopping());
        }
    }

    public void changeBendNote(TGMeasure tGMeasure, long l, int n, TGEffectBend tGEffectBend) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setBend(tGEffectBend);
        }
    }

    public void changeTremoloBar(TGMeasure tGMeasure, long l, int n, TGEffectTremoloBar tGEffectTremoloBar) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setTremoloBar(tGEffectTremoloBar);
        }
    }

    public void changeGhostNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setGhostNote(!tGNote.getEffect().isGhostNote());
        }
    }

    public void changeAccentuatedNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setAccentuatedNote(!tGNote.getEffect().isAccentuatedNote());
        }
    }

    public void changeHeavyAccentuatedNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setHeavyAccentuatedNote(!tGNote.getEffect().isHeavyAccentuatedNote());
        }
    }

    public void changeHarmonicNote(TGMeasure tGMeasure, long l, int n, TGEffectHarmonic tGEffectHarmonic) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setHarmonic(tGEffectHarmonic);
        }
    }

    public void changeGraceNote(TGMeasure tGMeasure, long l, int n, TGEffectGrace tGEffectGrace) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setGrace(tGEffectGrace);
        }
    }

    public void changeTrillNote(TGMeasure tGMeasure, long l, int n, TGEffectTrill tGEffectTrill) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setTrill(tGEffectTrill);
        }
    }

    public void changeTremoloPicking(TGMeasure tGMeasure, long l, int n, TGEffectTremoloPicking tGEffectTremoloPicking) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setTremoloPicking(tGEffectTremoloPicking);
        }
    }

    public void changeFadeIn(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setFadeIn(!tGNote.getEffect().isFadeIn());
        }
    }

    public void changeVelocity(int n, TGMeasure tGMeasure, long l, int n2) {
        TGNote tGNote = this.getNote(tGMeasure, l, n2);
        if (tGNote != null) {
            tGNote.setVelocity(n);
        }
    }

    public static List createDurations(TGFactory tGFactory, long l) {
        TGDuration tGDuration;
        ArrayList<TGDuration> arrayList = new ArrayList<TGDuration>();
        TGDuration tGDuration2 = tGFactory.newDuration();
        tGDuration2.setValue(64);
        tGDuration2.setDotted(false);
        tGDuration2.setDoubleDotted(false);
        tGDuration2.getTupleto().setEnters(3);
        tGDuration2.getTupleto().setTimes(2);
        for (long i = l; i > tGDuration2.getTime(); i -= tGDuration.getTime()) {
            tGDuration = TGDuration.fromTime(tGFactory, i, tGDuration2, 10);
            arrayList.add(tGDuration.clone(tGFactory));
        }
        return arrayList;
    }

    public TGVoice getNextVoice(List list, TGBeat tGBeat, int n) {
        TGVoice tGVoice = null;
        for (int i = 0; i < list.size(); ++i) {
            TGBeat tGBeat2 = (TGBeat)list.get(i);
            if (tGBeat2.getStart() <= tGBeat.getStart() || tGBeat2.getVoice(n).isEmpty()) continue;
            if (tGVoice == null) {
                tGVoice = tGBeat2.getVoice(n);
                continue;
            }
            if (tGBeat2.getStart() >= tGVoice.getBeat().getStart()) continue;
            tGVoice = tGBeat2.getVoice(n);
        }
        return tGVoice;
    }

    public TGVoice getPreviousVoice(List list, TGBeat tGBeat, int n) {
        TGVoice tGVoice = null;
        for (int i = 0; i < list.size(); ++i) {
            TGBeat tGBeat2 = (TGBeat)list.get(i);
            if (tGBeat2.getStart() >= tGBeat.getStart() || tGBeat2.getVoice(n).isEmpty()) continue;
            if (tGVoice == null) {
                tGVoice = tGBeat2.getVoice(n);
                continue;
            }
            if (tGBeat2.getStart() <= tGVoice.getBeat().getStart()) continue;
            tGVoice = tGBeat2.getVoice(n);
        }
        return tGVoice;
    }

    public TGVoice getFirstVoice(List list, int n) {
        TGVoice tGVoice = null;
        for (int i = 0; i < list.size(); ++i) {
            TGBeat tGBeat = (TGBeat)list.get(i);
            if (tGVoice != null && tGBeat.getStart() >= tGVoice.getBeat().getStart() || tGBeat.getVoice(n).isEmpty()) continue;
            tGVoice = tGBeat.getVoice(n);
        }
        return tGVoice;
    }

    public TGVoice getLastVoice(List list, int n) {
        TGVoice tGVoice = null;
        for (int i = 0; i < list.size(); ++i) {
            TGBeat tGBeat = (TGBeat)list.get(i);
            if (tGVoice != null && tGVoice.getBeat().getStart() >= tGBeat.getStart() || tGBeat.getVoice(n).isEmpty()) continue;
            tGVoice = tGBeat.getVoice(n);
        }
        return tGVoice;
    }

    public TGVoice getNextRestVoice(List list, TGVoice tGVoice) {
        TGVoice tGVoice2 = this.getNextVoice(list, tGVoice.getBeat(), tGVoice.getIndex());
        while (tGVoice2 != null && !tGVoice2.isRestVoice()) {
            tGVoice2 = this.getNextVoice(list, tGVoice2.getBeat(), tGVoice2.getIndex());
        }
        return tGVoice2;
    }

    public List getVoicesBeforeEnd(List list, long l, int n) {
        ArrayList<TGVoice> arrayList = new ArrayList<TGVoice>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGVoice tGVoice;
            TGBeat tGBeat = (TGBeat)iterator.next();
            if (tGBeat.getStart() < l || (tGVoice = tGBeat.getVoice(n)).isEmpty()) continue;
            arrayList.add(tGVoice);
        }
        return arrayList;
    }

    public void addSilence(TGMeasure tGMeasure, long l, TGDuration tGDuration, int n) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.addSilence(tGBeat, tGDuration, n);
        }
    }

    public void addSilence(TGBeat tGBeat, TGDuration tGDuration, int n) {
        this.addSilence(tGBeat, tGDuration, tGBeat.getStart(), n);
    }

    public void addSilence(TGBeat tGBeat, TGDuration tGDuration, long l, int n) {
        boolean bl = tGBeat.getVoice(n).isEmpty();
        if (bl) {
            tGBeat.getVoice(n).setEmpty(false);
        }
        if (this.validateDuration(tGBeat.getMeasure(), tGBeat, n, tGDuration, true, true)) {
            TGVoice tGVoice;
            tGDuration.copy(tGBeat.getVoice(n).getDuration());
            this.tryChangeSilenceAfter(tGBeat.getMeasure(), tGBeat.getVoice(n));
            TGVoice tGVoice2 = tGBeat.getVoice(n);
            if (tGVoice2.getBeat().getStart() != l && (tGVoice = this.getVoiceIn(tGVoice2.getBeat().getMeasure(), l, n)) != null) {
                tGVoice2 = tGVoice;
            }
            tGVoice2.setEmpty(false);
        } else {
            tGBeat.getVoice(n).setEmpty(bl);
        }
    }

    public void removeVoice(TGVoice tGVoice) {
        tGVoice.setEmpty(true);
        TGBeat tGBeat = tGVoice.getBeat();
        for (int i = 0; i < tGBeat.countVoices(); ++i) {
            if (tGBeat.getVoice(i).isEmpty()) continue;
            return;
        }
        this.removeBeat(tGBeat);
    }

    public void removeVoice(TGVoice tGVoice, boolean bl) {
        this.removeVoice(tGVoice);
        if (bl) {
            long l = tGVoice.getBeat().getStart();
            long l2 = tGVoice.getDuration().getTime();
            TGVoice tGVoice2 = this.getNextVoice(tGVoice.getBeat().getMeasure().getBeats(), tGVoice.getBeat(), tGVoice.getIndex());
            if (tGVoice2 != null) {
                l2 = tGVoice2.getBeat().getStart() - l;
            }
            this.moveVoices(tGVoice.getBeat().getMeasure(), l + l2, -l2, tGVoice.getIndex(), tGVoice.getDuration());
        }
    }

    public void removeVoice(TGMeasure tGMeasure, long l, int n, boolean bl) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.removeVoice(tGBeat.getVoice(n), bl);
        }
    }

    public void removeMeasureVoices(TGMeasure tGMeasure, int n) {
        Object object;
        boolean bl = false;
        ArrayList<TGVoice> arrayList = new ArrayList<TGVoice>();
        Iterator iterator = tGMeasure.getBeats().iterator();
        while (iterator.hasNext()) {
            object = (TGBeat)iterator.next();
            TGVoice tGVoice = ((TGBeat)object).getVoice(n);
            if (tGVoice.isRestVoice()) {
                arrayList.add(tGVoice);
                continue;
            }
            if (tGVoice.isEmpty()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (TGVoice)iterator.next();
                this.removeVoice((TGVoice)object);
            }
        }
    }

    public void changeVoiceDirection(TGVoice tGVoice, int n) {
        tGVoice.setDirection(n);
    }

    public void changeDuration(TGMeasure tGMeasure, TGBeat tGBeat, TGDuration tGDuration, int n, boolean bl) {
        TGDuration tGDuration2 = tGBeat.getVoice(n).getDuration().clone(this.getSongManager().getFactory());
        if (this.validateDuration(tGMeasure, tGBeat, n, tGDuration, bl, false)) {
            tGBeat.getVoice(n).setDuration(tGDuration.clone(this.getSongManager().getFactory()));
            this.tryChangeSilenceAfter(tGMeasure, tGBeat.getVoice(n));
        } else {
            tGDuration2.copy(tGBeat.getVoice(n).getDuration());
        }
    }

    public void tryChangeSilenceAfter(TGMeasure tGMeasure, TGVoice tGVoice) {
        this.autoCompleteSilences(tGMeasure);
        TGVoice tGVoice2 = this.getNextVoice(tGMeasure.getBeats(), tGVoice.getBeat(), tGVoice.getIndex());
        long l = tGVoice.getBeat().getStart() + tGVoice.getDuration().getTime();
        long l2 = tGMeasure.getStart() + tGMeasure.getLength();
        if (tGVoice2 != null && !tGVoice2.isEmpty() && tGVoice2.isRestVoice() && l <= l2) {
            long l3 = this.getRealStart(tGMeasure, l) - this.getRealStart(tGMeasure, tGVoice2.getBeat().getStart());
            if (tGVoice2.getBeat().getStart() + l3 < l2 && tGVoice2.getBeat().getStart() + tGVoice2.getDuration().getTime() + l3 <= l2) {
                this.moveVoice(tGVoice2, l3);
                this.changeDuration(tGMeasure, tGVoice2.getBeat(), tGVoice.getDuration().clone(this.getSongManager().getFactory()), tGVoice2.getIndex(), false);
            }
        }
    }

    private void moveVoices(List list, long l) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            TGVoice tGVoice = (TGVoice)list.get(l < 0L ? i : n - 1 - i);
            this.moveVoice(tGVoice, l);
        }
    }

    public void moveVoice(TGVoice tGVoice, long l) {
        long l2 = tGVoice.getBeat().getStart() + l;
        TGBeat tGBeat = this.getBeat(tGVoice.getBeat().getMeasure(), l2);
        if (tGBeat == null) {
            tGBeat = this.getSongManager().getFactory().newBeat();
            tGBeat.setStart(l2);
            this.addBeat(tGVoice.getBeat().getMeasure(), tGBeat);
        }
        this.moveVoice(tGVoice, tGBeat);
    }

    public void moveVoice(TGVoice tGVoice, TGBeat tGBeat) {
        TGBeat tGBeat2 = tGVoice.getBeat();
        if (!tGBeat2.equals(tGBeat)) {
            if (tGBeat2.getVoice(tGVoice.getIndex()).equals(tGVoice)) {
                if (tGBeat2.isTextBeat() && this.isUniqueVoice(tGVoice, false)) {
                    tGBeat.setText(tGBeat2.getText());
                    tGBeat2.removeText();
                }
                if (this.isUniqueVoice(tGVoice, true)) {
                    if (tGBeat2.isChordBeat()) {
                        tGBeat.setChord(tGBeat2.getChord());
                        tGBeat2.removeChord();
                    }
                    if (tGBeat2.getStroke().getDirection() != 0) {
                        tGBeat2.getStroke().copy(tGBeat.getStroke());
                        tGBeat2.getStroke().setDirection(0);
                    }
                }
                TGVoice tGVoice2 = this.getSongManager().getFactory().newVoice(tGVoice.getIndex());
                tGBeat2.setVoice(tGVoice.getIndex(), tGVoice2);
                this.removeVoice(tGVoice2);
            }
            tGBeat.setVoice(tGVoice.getIndex(), tGVoice);
        }
    }

    public boolean validateDuration(TGMeasure tGMeasure, TGBeat tGBeat, int n, TGDuration tGDuration, boolean bl, boolean bl2) {
        long l;
        int n2 = 10;
        this.orderBeats(tGMeasure);
        long l2 = tGMeasure.getStart();
        long l3 = l2 + tGMeasure.getLength();
        long l4 = tGBeat.getStart();
        long l5 = tGDuration.getTime();
        long l6 = l4 + l5;
        List list = tGMeasure.getBeats();
        TGBeat tGBeat2 = this.getBeat(tGMeasure, l4);
        TGVoice tGVoice = null;
        if (tGBeat2 != null && !(tGVoice = tGBeat2.getVoice(n)).isEmpty() && l5 <= tGVoice.getDuration().getTime()) {
            return true;
        }
        TGVoice tGVoice2 = this.getNextVoice(list, tGBeat, n);
        if (tGVoice == null || tGVoice.isEmpty()) {
            if ((tGVoice2 == null || tGVoice2.isEmpty()) && l6 < l3 + (long)n2) {
                return true;
            }
            if (tGVoice2 != null && !tGVoice2.isEmpty() && l6 < tGVoice2.getBeat().getStart() + (long)n2) {
                return true;
            }
        }
        if (tGVoice2 != null && !tGVoice2.isEmpty() && tGVoice2.isRestVoice()) {
            l = 0L;
            ArrayList<TGVoice> arrayList = new ArrayList<TGVoice>();
            while (tGVoice2 != null && !tGVoice2.isEmpty() && tGVoice2.isRestVoice() && !tGVoice2.getBeat().isTextBeat()) {
                arrayList.add(tGVoice2);
                l = tGVoice2.getBeat().getStart() + tGVoice2.getDuration().getTime();
                tGVoice2 = this.getNextVoice(list, tGVoice2.getBeat(), n);
            }
            if (tGVoice2 == null || tGVoice2.isEmpty()) {
                l = l3;
            } else if (!tGVoice2.isRestVoice() || tGVoice2.getBeat().isTextBeat()) {
                l = tGVoice2.getBeat().getStart();
            }
            if (l6 <= l + (long)n2) {
                while (!arrayList.isEmpty()) {
                    TGVoice tGVoice3 = (TGVoice)arrayList.get(0);
                    arrayList.remove(tGVoice3);
                    this.removeVoice(tGVoice3, false);
                }
                return true;
            }
        }
        if (bl && (tGVoice2 = this.getNextVoice(list, tGBeat, n)) != null) {
            l = l5 - (tGVoice2.getBeat().getStart() - l4);
            long l7 = 0L;
            TGVoice tGVoice4 = this.getNextRestVoice(list, tGBeat.getVoice(n));
            while (tGVoice4 != null) {
                l7 += tGVoice4.getDuration().getTime();
                tGVoice4 = this.getNextRestVoice(list, tGVoice4);
            }
            if (l <= l7 + (long)n2) {
                List list2 = this.getVoicesBeforeEnd(tGMeasure.getBeats(), tGVoice2.getBeat().getStart(), n);
                while (!list2.isEmpty()) {
                    TGVoice tGVoice5 = (TGVoice)list2.get(0);
                    if (tGVoice5.isRestVoice()) {
                        l -= tGVoice5.getDuration().getTime();
                        this.removeVoice(tGVoice5, false);
                    } else if (l > 0L) {
                        this.moveVoice(tGVoice5, l);
                    }
                    list2.remove(0);
                }
                return true;
            }
        }
        if (bl2 && tGVoice != null && !tGVoice.isEmpty()) {
            tGVoice.getDuration().copy(tGDuration);
            return true;
        }
        return false;
    }

    public boolean moveVoices(TGMeasure tGMeasure, long l, long l2, int n, TGDuration tGDuration) {
        TGDuration tGDuration2;
        if (l2 == 0L) {
            return false;
        }
        boolean bl = true;
        long l3 = tGMeasure.getStart();
        long l4 = l3 + tGMeasure.getLength();
        List list = this.getVoicesBeforeEnd(tGMeasure.getBeats(), l, n);
        ArrayList<TGVoice> arrayList = new ArrayList<TGVoice>();
        List list2 = this.getBeatsBeforeEnd(tGMeasure.getBeats(), l);
        TGVoice tGVoice = this.getFirstVoice(list2, n);
        while (!(tGVoice == null || !tGVoice.isRestVoice() || tGVoice.getBeat().isTextBeat() && this.isUniqueVoice(tGVoice, false) || tGVoice.getBeat().getStart() + l2 >= l3)) {
            list2.remove(tGVoice.getBeat());
            arrayList.add(tGVoice);
            tGVoice = this.getNextVoice(list2, tGVoice.getBeat(), n);
        }
        TGVoice tGVoice2 = this.getLastVoice(list2, n);
        TGDuration tGDuration3 = tGDuration2 = tGVoice2 != null ? tGVoice2.getDuration() : null;
        while (!(tGVoice2 == null || tGDuration2 == null || !tGVoice2.isRestVoice() || tGVoice2.getBeat().isTextBeat() && this.isUniqueVoice(tGVoice2, false) || tGVoice2.getBeat().getStart() + tGDuration2.getTime() + l2 <= l4)) {
            list2.remove(tGVoice2.getBeat());
            arrayList.add(tGVoice2);
            tGVoice2 = this.getPreviousVoice(list2, tGVoice2.getBeat(), n);
            tGDuration2 = tGVoice2 != null ? tGVoice2.getDuration() : null;
        }
        if (tGVoice != null && tGVoice2 != null && tGDuration2 != null && (tGVoice.getBeat().getStart() + l2 < l3 || tGVoice2.getBeat().getStart() + tGDuration2.getTime() + l2 > l4)) {
            bl = false;
        }
        if (bl) {
            this.moveVoices(list, l2);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                TGVoice tGVoice3 = (TGVoice)iterator.next();
                this.removeVoice(tGVoice3);
            }
            if (tGDuration != null) {
                if (l2 < 0L) {
                    long l5;
                    tGVoice2 = this.getLastVoice(tGMeasure.getBeats(), n);
                    tGDuration2 = tGVoice2 != null ? tGVoice2.getDuration() : null;
                    long l6 = l5 = tGVoice2 != null && tGDuration2 != null ? tGVoice2.getBeat().getStart() + tGDuration2.getTime() : l;
                    if (l5 + tGDuration.getTime() <= l4) {
                        boolean bl2 = false;
                        TGBeat tGBeat = this.getBeat(tGMeasure, l5);
                        if (tGBeat == null) {
                            tGBeat = this.getSongManager().getFactory().newBeat();
                            tGBeat.setStart(l5);
                            bl2 = true;
                        }
                        TGVoice tGVoice4 = tGBeat.getVoice(n);
                        tGVoice4.setEmpty(false);
                        tGDuration.copy(tGVoice4.getDuration());
                        if (bl2) {
                            this.addBeat(tGMeasure, tGBeat);
                        }
                    }
                } else {
                    tGVoice = this.getFirstVoice(this.getBeatsBeforeEnd(tGMeasure.getBeats(), l), n);
                    if (l + tGDuration.getTime() <= (tGVoice != null ? tGVoice.getBeat().getStart() : l4)) {
                        boolean bl3 = false;
                        TGBeat tGBeat = this.getBeat(tGMeasure, l);
                        if (tGBeat == null) {
                            tGBeat = this.getSongManager().getFactory().newBeat();
                            tGBeat.setStart(l);
                            bl3 = true;
                        }
                        TGVoice tGVoice5 = tGBeat.getVoice(n);
                        tGVoice5.setEmpty(false);
                        tGDuration.copy(tGVoice5.getDuration());
                        if (bl3) {
                            this.addBeat(tGMeasure, tGBeat);
                        }
                    }
                }
            }
            this.removeEmptyBeats(tGMeasure);
        }
        return bl;
    }

    public boolean isUniqueVoice(TGVoice tGVoice, boolean bl) {
        TGBeat tGBeat = tGVoice.getBeat();
        for (int i = 0; i < tGBeat.countVoices(); ++i) {
            TGVoice tGVoice2;
            if (i == tGVoice.getIndex() || (tGVoice2 = tGBeat.getVoice(i)).isEmpty() || bl && tGVoice2.isRestVoice()) continue;
            return false;
        }
        return true;
    }
}

