/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.base;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGOutputStreamBase;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGSong;

public class TGSongWriter {
    public void write(TGFactory tGFactory, TGSong tGSong, String string) throws TGFileFormatException {
        try {
            Iterator iterator = TGFileFormatManager.instance().getOutputStreams();
            while (iterator.hasNext()) {
                TGOutputStreamBase tGOutputStreamBase = (TGOutputStreamBase)iterator.next();
                if (!this.isSupportedExtension(tGOutputStreamBase, string)) continue;
                tGOutputStreamBase.init(tGFactory, new BufferedOutputStream(new FileOutputStream(new File(string))));
                tGOutputStreamBase.writeSong(tGSong);
                return;
            }
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
        throw new TGFileFormatException("Unsupported file format");
    }

    private boolean isSupportedExtension(TGOutputStreamBase tGOutputStreamBase, String string) {
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return tGOutputStreamBase.isSupportedExtension(string.substring(n));
        }
        return false;
    }
}

