/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.util.TGClassLoader;
import org.herac.tuxguitar.util.TGLibraryLoader;
import org.herac.tuxguitar.util.TGVersion;

public class TGFileUtils {
    private static final String TG_CONFIG_PATH = "tuxguitar.config.path";
    private static final String TG_SHARE_PATH = "tuxguitar.share.path";
    private static final String TG_CLASS_PATH = "tuxguitar.class.path";
    private static final String TG_LIBRARY_PATH = "tuxguitar.library.path";
    private static final String TG_LIBRARY_PREFIX = "tuxguitar.library.prefix";
    private static final String TG_LIBRARY_EXTENSION = "tuxguitar.library.extension";
    public static final String PATH_USER_CONFIG = TGFileUtils.getUserConfigDir();
    public static final String PATH_USER_PLUGINS_CONFIG = TGFileUtils.getUserPluginsConfigDir();
    public static final String[] TG_STATIC_SHARED_PATHS = TGFileUtils.getStaticSharedPaths();

    public static InputStream getResourceAsStream(String string) {
        try {
            if (TG_STATIC_SHARED_PATHS != null) {
                for (int i = 0; i < TG_STATIC_SHARED_PATHS.length; ++i) {
                    File file = new File(TG_STATIC_SHARED_PATHS[i] + File.separator + string);
                    if (!file.exists()) continue;
                    return new FileInputStream(file);
                }
            }
            return TGClassLoader.instance().getClassLoader().getResourceAsStream(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static URL getResourceUrl(String string) {
        try {
            if (TG_STATIC_SHARED_PATHS != null) {
                for (int i = 0; i < TG_STATIC_SHARED_PATHS.length; ++i) {
                    File file = new File(TG_STATIC_SHARED_PATHS[i] + File.separator + string);
                    if (!file.exists()) continue;
                    return file.toURI().toURL();
                }
            }
            return TGClassLoader.instance().getClassLoader().getResource(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static Enumeration getResourceUrls(String string) {
        try {
            Serializable serializable;
            Vector<URL> vector = new Vector<URL>();
            if (TG_STATIC_SHARED_PATHS != null) {
                for (int i = 0; i < TG_STATIC_SHARED_PATHS.length; ++i) {
                    serializable = new File(TG_STATIC_SHARED_PATHS[i] + File.separator + string);
                    if (!((File)serializable).exists()) continue;
                    vector.addElement(((File)serializable).toURI().toURL());
                }
            }
            Enumeration<URL> enumeration = TGClassLoader.instance().getClassLoader().getResources(string);
            while (enumeration.hasMoreElements()) {
                serializable = enumeration.nextElement();
                if (vector.contains(serializable)) continue;
                vector.addElement((URL)serializable);
            }
            return vector.elements();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static String getResourcePath(String string) {
        try {
            URL uRL;
            if (TG_STATIC_SHARED_PATHS != null) {
                for (int i = 0; i < TG_STATIC_SHARED_PATHS.length; ++i) {
                    File file = new File(TG_STATIC_SHARED_PATHS[i] + File.separator + string);
                    if (!file.exists()) continue;
                    return file.getAbsolutePath() + File.separator;
                }
            }
            if ((uRL = TGClassLoader.instance().getClassLoader().getResource(string)) != null) {
                return new File(URLDecoder.decode(uRL.getPath(), "UTF-8")).getAbsolutePath() + File.separator;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static void loadClasspath() {
        String string;
        String string2 = TGFileUtils.getResourcePath("plugins");
        if (string2 != null) {
            TGClassLoader.instance().addPaths(new File(string2));
        }
        if ((string = System.getProperty(TG_CLASS_PATH)) != null) {
            String[] stringArray = string.split(File.pathSeparator);
            for (int i = 0; i < stringArray.length; ++i) {
                TGClassLoader.instance().addPaths(new File(stringArray[i]));
            }
        }
    }

    public static void loadLibraries() {
        String string = System.getProperty(TG_LIBRARY_PATH);
        if (string != null) {
            String[] stringArray = string.split(File.pathSeparator);
            String string2 = System.getProperty(TG_LIBRARY_PREFIX);
            String string3 = System.getProperty(TG_LIBRARY_EXTENSION);
            for (int i = 0; i < stringArray.length; ++i) {
                TGLibraryLoader.instance().loadLibraries(new File(stringArray[i]), string2, string3);
            }
        }
    }

    public static String[] getFileNames(String string) {
        try {
            Object object;
            String string2 = TGFileUtils.getResourcePath(string);
            if (string2 != null && ((File)(object = new File(string2))).exists() && ((File)object).isDirectory()) {
                return ((File)object).list();
            }
            object = TGFileUtils.getResourceAsStream(string + "/list.properties");
            if (object != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                ArrayList<String> arrayList = new ArrayList<String>();
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    arrayList.add(string3);
                }
                String[] stringArray = new String[arrayList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static Image loadImage(String string) {
        return TGFileUtils.loadImage(TuxGuitar.instance().getConfig().getStringConfigValue("skin"), string);
    }

    public static Image loadImage(String string, String string2) {
        try {
            InputStream inputStream = TGFileUtils.getResourceAsStream("skins/" + string + "/" + string2);
            if (inputStream != null) {
                return new Image((Device)TuxGuitar.instance().getDisplay(), new ImageData(inputStream));
            }
            System.err.println(string2 + ": not found");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return new Image((Device)TuxGuitar.instance().getDisplay(), 16, 16);
    }

    public static boolean isLocalFile(URL uRL) {
        try {
            if (uRL.getProtocol().equals(new File(uRL.getFile()).toURI().toURL().getProtocol())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    private static String getUserConfigDir() {
        File file;
        String string = System.getProperty(TG_CONFIG_PATH);
        if (string == null) {
            string = System.getProperty("user.home") + File.separator + ".tuxguitar-" + TGVersion.CURRENT.getVersion();
        }
        if (!(file = new File(string)).exists()) {
            file.mkdirs();
        }
        return string;
    }

    private static String getUserPluginsConfigDir() {
        String string = TGFileUtils.getUserConfigDir() + File.separator + "plugins";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return string;
    }

    private static String[] getStaticSharedPaths() {
        String string = System.getProperty(TG_SHARE_PATH);
        if (string != null) {
            return string.split(File.pathSeparator);
        }
        return null;
    }
}

