/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.measure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.helpers.TGSongSegment;
import org.herac.tuxguitar.song.helpers.TGSongSegmentHelper;
import org.herac.tuxguitar.song.models.TGMarker;

public class UndoableReplaceMeasures
implements UndoableEdit {
    private int doAction = 1;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private UndoMarkers undoMarkers;
    private TGSongSegment undoTrackMeasures;
    private TGSongSegment redoTrackMeasures;
    private int toTrack;
    private int count;
    private int freeSpace;
    private long theMove;

    public UndoableReplaceMeasures(int n, int n2, int n3) {
        this.toTrack = n3;
        this.undoCaret = new UndoableCaretHelper();
        this.undoMarkers = new UndoMarkers();
        this.undoTrackMeasures = new TGSongSegmentHelper(TuxGuitar.instance().getSongManager()).copyMeasures(n, n2);
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        for (int i = this.freeSpace; i < this.count; ++i) {
            TuxGuitar.instance().getSongManager().addNewMeasureBeforeEnd();
        }
        new TGSongSegmentHelper(TuxGuitar.instance().getSongManager()).replaceMeasures(this.redoTrackMeasures.clone(TuxGuitar.instance().getSongManager().getFactory()), this.theMove, this.toTrack);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        for (int i = this.freeSpace; i < this.count; ++i) {
            TuxGuitar.instance().getSongManager().removeLastMeasure();
        }
        new TGSongSegmentHelper(TuxGuitar.instance().getSongManager()).replaceMeasures(this.undoTrackMeasures.clone(TuxGuitar.instance().getSongManager().getFactory()), 0L, 0);
        TuxGuitar.instance().fireUpdate();
        this.undoMarkers.undo();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public UndoableReplaceMeasures endUndo(TGSongSegment tGSongSegment, int n, int n2, long l) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoTrackMeasures = tGSongSegment;
        this.count = n;
        this.freeSpace = n2;
        this.theMove = l;
        return this;
    }

    private class UndoMarkers {
        private List markers = new ArrayList();

        public UndoMarkers() {
            Iterator iterator = TuxGuitar.instance().getSongManager().getMarkers().iterator();
            while (iterator.hasNext()) {
                this.markers.add(((TGMarker)iterator.next()).clone(TuxGuitar.instance().getSongManager().getFactory()));
            }
        }

        public void undo() {
            TuxGuitar.instance().getSongManager().removeAllMarkers();
            Iterator iterator = this.markers.iterator();
            while (iterator.hasNext()) {
                TGMarker tGMarker = (TGMarker)iterator.next();
                TuxGuitar.instance().getSongManager().updateMarker(tGMarker.clone(TuxGuitar.instance().getSongManager().getFactory()));
            }
        }
    }
}

