/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.measure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.helpers.TGSongSegment;
import org.herac.tuxguitar.song.helpers.TGSongSegmentHelper;
import org.herac.tuxguitar.song.models.TGMarker;

public class UndoableRemoveMeasure
implements UndoableEdit {
    private int doAction = 1;
    private UndoableCaretHelper undoCaret = new UndoableCaretHelper();
    private UndoableCaretHelper redoCaret;
    private TGSongSegment tracksMeasures;
    private UndoMarkers undoMarkers;
    private int n1;
    private int n2;

    public UndoableRemoveMeasure(int n, int n2) {
        this.n1 = n;
        this.n2 = n2;
        this.tracksMeasures = new TGSongSegmentHelper(TuxGuitar.instance().getSongManager()).copyMeasures(n, n2);
        this.undoMarkers = new UndoMarkers();
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().removeMeasureHeaders(this.n1, this.n2);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        new TGSongSegmentHelper(TuxGuitar.instance().getSongManager()).insertMeasures(this.tracksMeasures.clone(TuxGuitar.instance().getSongManager().getFactory()), this.n1, 0L, 0);
        TuxGuitar.instance().fireUpdate();
        this.undoMarkers.undo();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public UndoableRemoveMeasure endUndo() {
        this.redoCaret = new UndoableCaretHelper();
        return this;
    }

    private class UndoMarkers {
        private List markers = new ArrayList();

        public UndoMarkers() {
            Iterator iterator = TuxGuitar.instance().getSongManager().getMarkers().iterator();
            while (iterator.hasNext()) {
                this.markers.add(((TGMarker)iterator.next()).clone(TuxGuitar.instance().getSongManager().getFactory()));
            }
        }

        public void undo() {
            TuxGuitar.instance().getSongManager().removeAllMarkers();
            Iterator iterator = this.markers.iterator();
            while (iterator.hasNext()) {
                TGMarker tGMarker = (TGMarker)iterator.next();
                TuxGuitar.instance().getSongManager().updateMarker(tGMarker.clone(TuxGuitar.instance().getSongManager().getFactory()));
            }
        }
    }
}

