/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.TGSong;

public class UndoableChangeInfo
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private String undoName;
    private String undoArtist;
    private String undoAlbum;
    private String undoAuthor;
    private String redoName;
    private String redoArtist;
    private String redoAlbum;
    private String redoAuthor;

    private UndoableChangeInfo() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().setProperties(this.redoName, this.redoArtist, this.redoAlbum, this.redoAuthor);
        TuxGuitar.instance().showTitle();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TuxGuitar.instance().getSongManager().setProperties(this.undoName, this.undoArtist, this.undoAlbum, this.undoAuthor);
        TuxGuitar.instance().showTitle();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeInfo startUndo() {
        TGSong tGSong = TuxGuitar.instance().getSongManager().getSong();
        UndoableChangeInfo undoableChangeInfo = new UndoableChangeInfo();
        undoableChangeInfo.doAction = 1;
        undoableChangeInfo.undoCaret = new UndoableCaretHelper();
        undoableChangeInfo.undoName = tGSong.getName();
        undoableChangeInfo.undoArtist = tGSong.getArtist();
        undoableChangeInfo.undoAlbum = tGSong.getAlbum();
        undoableChangeInfo.undoAuthor = tGSong.getAuthor();
        return undoableChangeInfo;
    }

    public UndoableChangeInfo endUndo() {
        TGSong tGSong = TuxGuitar.instance().getSongManager().getSong();
        this.redoCaret = new UndoableCaretHelper();
        this.redoName = tGSong.getName();
        this.redoArtist = tGSong.getArtist();
        this.redoAlbum = tGSong.getAlbum();
        this.redoAuthor = tGSong.getAuthor();
        return this;
    }
}

