/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.browser.dialog;

import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.actions.file.FileActionUtils;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserCollection;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserConnection;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserConnectionHandler;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserFactoryHandler;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserManager;
import org.herac.tuxguitar.gui.tools.browser.base.TGBrowserElement;
import org.herac.tuxguitar.gui.tools.browser.base.TGBrowserFactory;
import org.herac.tuxguitar.gui.tools.browser.dialog.TGBrowserElementComparator;
import org.herac.tuxguitar.gui.tools.browser.dialog.TGBrowserMenuBar;
import org.herac.tuxguitar.gui.tools.browser.dialog.TGBrowserToolBar;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.song.models.TGSong;

public class TGBrowserDialog
implements TGBrowserFactoryHandler,
TGBrowserConnectionHandler,
IconLoader,
LanguageLoader {
    private static final int SHELL_WIDTH = 500;
    private static final int SHELL_HEIGHT = 350;
    public static final int CALL_OPEN = 1;
    public static final int CALL_CLOSE = 2;
    public static final int CALL_CD_ROOT = 3;
    public static final int CALL_CD_UP = 4;
    public static final int CALL_LIST = 5;
    public static final int CALL_ELEMENT = 6;
    private TGBrowserCollection collection;
    private TGBrowserConnection connection = new TGBrowserConnection(this);
    private Shell dialog;
    protected Table table;
    protected TableColumn column;
    protected List elements;
    protected TGBrowserMenuBar menu = new TGBrowserMenuBar(this);
    protected TGBrowserToolBar toolBar = new TGBrowserToolBar(this);

    public TGBrowserConnection getConnection() {
        return this.connection;
    }

    public TGBrowserCollection getCollection() {
        return this.collection;
    }

    public void setCollection(TGBrowserCollection tGBrowserCollection) {
        this.collection = tGBrowserCollection;
    }

    public Shell getShell() {
        return this.dialog;
    }

    public void exit() {
        this.getConnection().release();
        this.getConnection().close(2);
        TGBrowserManager.instance().writeCollections();
        TuxGuitar.instance().getIconManager().removeLoader(this);
    }

    public void show() {
        this.dialog = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 2160);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        this.menu.init(this.getShell());
        this.toolBar.init(this.getShell());
        this.initTable((Composite)this.dialog);
        this.updateCollections(null);
        this.updateTable();
        this.dialog.setSize(500, 350);
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TGBrowserDialog.this.exit();
            }
        });
        this.loadProperties();
        this.updateBars();
        TGBrowserManager.instance().setFactoryHandler(this);
        TuxGuitar.instance().getIconManager().addLoader(this);
        TuxGuitar.instance().getLanguageManager().addLoader(this);
        DialogUtils.openDialog(this.dialog, 8);
    }

    private void initTable(Composite composite) {
        this.table = new Table(composite, 67588);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setLinesVisible(TuxGuitar.instance().getConfig().getBooleanConfigValue("browser.lines-visible"));
        this.table.setHeaderVisible(false);
        this.column = new TableColumn(this.table, 16384);
        this.table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                TGBrowserDialog.this.openElement();
            }
        });
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    private void updateTable() {
        if (!this.isDisposed()) {
            new SyncThread(new Runnable(){

                public void run() {
                    if (!TGBrowserDialog.this.isDisposed()) {
                        TGBrowserDialog.this.table.removeAll();
                        if (TGBrowserDialog.this.elements != null) {
                            Iterator iterator = TGBrowserDialog.this.elements.iterator();
                            while (iterator.hasNext()) {
                                TGBrowserElement tGBrowserElement = (TGBrowserElement)iterator.next();
                                TableItem tableItem = new TableItem(TGBrowserDialog.this.table, 0);
                                tableItem.setImage(tGBrowserElement.isFolder() ? TuxGuitar.instance().getIconManager().getBrowserFolder() : TuxGuitar.instance().getIconManager().getBrowserFile());
                                tableItem.setText(tGBrowserElement.getName());
                            }
                        }
                        TGBrowserDialog.this.updateColumn();
                    }
                }
            }).start();
        }
    }

    protected void updateColumn() {
        if (!this.isDisposed()) {
            this.column.pack();
        }
    }

    public void updateBars() {
        if (!this.isDisposed()) {
            this.menu.updateItems();
            this.toolBar.updateItems();
        }
    }

    public void updateCollections(final TGBrowserCollection tGBrowserCollection) {
        if (!this.isDisposed()) {
            new SyncThread(new Runnable(){

                public void run() {
                    if (!TGBrowserDialog.this.isDisposed()) {
                        TGBrowserDialog.this.menu.updateCollections(tGBrowserCollection);
                        TGBrowserDialog.this.toolBar.updateCollections(tGBrowserCollection);
                    }
                }
            }).start();
        }
    }

    public TGBrowserElement getSelection(int n) {
        if (!this.isDisposed() && this.getConnection().isOpen() && this.elements != null && n >= 0 && n < this.elements.size()) {
            return (TGBrowserElement)this.elements.get(n);
        }
        return null;
    }

    protected void removeElements() {
        this.elements = null;
    }

    protected void addElements(List list) {
        if (list != null) {
            Collections.sort(list, new TGBrowserElementComparator());
        }
        this.elements = list;
    }

    protected void openCollection() {
        if (!this.isDisposed() && this.getCollection() != null) {
            TGBrowserFactory tGBrowserFactory = TGBrowserManager.instance().getFactory(this.getCollection().getType());
            this.getConnection().open(1, tGBrowserFactory.newTGBrowser(this.getCollection().getData()));
        }
    }

    protected void closeCollection() {
        if (!this.isDisposed() && this.getCollection() != null) {
            this.getConnection().close(2);
        }
    }

    protected void removeCollection(TGBrowserCollection tGBrowserCollection) {
        if (tGBrowserCollection != null) {
            TGBrowserManager.instance().removeCollection(tGBrowserCollection);
            if (this.getCollection() != null && this.getCollection().equals(tGBrowserCollection)) {
                this.getConnection().close(2);
            } else {
                this.updateCollections(this.getCollection());
            }
        }
    }

    public void openElement() {
        TGBrowserElement tGBrowserElement = this.getSelection(this.table.getSelectionIndex());
        if (tGBrowserElement != null) {
            this.getConnection().openStream(6, tGBrowserElement);
        }
    }

    public void notifyLockStatusChanged() {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TGBrowserDialog.this.isDisposed()) {
                    TGBrowserDialog.this.updateBars();
                    TuxGuitar.instance().loadCursor((Control)TGBrowserDialog.this.getShell(), TGBrowserDialog.this.getConnection().isLocked() ? 1 : 0);
                }
            }
        }).start();
    }

    public void notifyOpened(int n) {
        if (!this.isDisposed()) {
            this.removeElements();
            this.updateTable();
            this.updateCollections(this.getCollection());
            this.getConnection().release();
            this.getConnection().listElements(5);
        }
    }

    public void notifyClosed(int n) {
        if (n != 1) {
            this.setCollection(null);
        }
        this.removeElements();
        this.updateCollections(this.getCollection());
        this.updateTable();
        if (n != 1) {
            this.getConnection().release();
        }
    }

    public void notifyError(int n, Throwable throwable) {
        if (!this.isDisposed()) {
            this.updateTable();
            this.getConnection().release();
            MessageDialog.errorMessage(this.getShell(), throwable);
        }
    }

    public void notifyCd(int n) {
        if (!this.isDisposed()) {
            this.getConnection().release();
            this.getConnection().listElements(5);
        }
    }

    public void notifyElements(int n, List list) {
        if (!this.isDisposed()) {
            this.addElements(list);
            this.updateTable();
            this.getConnection().release();
        }
    }

    public void notifyStream(int n, final InputStream inputStream, final TGBrowserElement tGBrowserElement) {
        if (!this.isDisposed()) {
            ActionLock.lock();
            new SyncThread(new Runnable(){

                public void run() {
                    if (!TuxGuitar.isDisposed()) {
                        TuxGuitar.instance().getPlayer().reset();
                        if (TuxGuitar.instance().getFileHistory().isUnsavedFile()) {
                            ConfirmDialog confirmDialog = new ConfirmDialog(TuxGuitar.getProperty("file.save-changes-question"));
                            confirmDialog.setDefaultStatus(ConfirmDialog.STATUS_CANCEL);
                            int n = confirmDialog.confirm(ConfirmDialog.BUTTON_YES | ConfirmDialog.BUTTON_NO | ConfirmDialog.BUTTON_CANCEL, ConfirmDialog.BUTTON_YES);
                            if (n == ConfirmDialog.STATUS_CANCEL) {
                                TGBrowserDialog.this.getConnection().release();
                                ActionLock.unlock();
                                return;
                            }
                            if (n == ConfirmDialog.STATUS_YES) {
                                final String string = FileActionUtils.getFileName();
                                if (string == null) {
                                    TGBrowserDialog.this.getConnection().release();
                                    ActionLock.unlock();
                                    return;
                                }
                                new Thread(new Runnable(){

                                    public void run() {
                                        if (!TuxGuitar.isDisposed()) {
                                            FileActionUtils.save(string);
                                            new SyncThread(new Runnable(){

                                                public void run() {
                                                    if (!TuxGuitar.isDisposed()) {
                                                        TGBrowserDialog.this.openStream(inputStream, tGBrowserElement);
                                                    }
                                                }
                                            }).start();
                                        }
                                    }
                                }).start();
                                return;
                            }
                        }
                        TGBrowserDialog.this.openStream(inputStream, tGBrowserElement);
                    }
                }
            }).start();
        }
    }

    protected void openStream(final InputStream inputStream, final TGBrowserElement tGBrowserElement) {
        new Thread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    try {
                        TGSong tGSong = TGFileFormatManager.instance().getLoader().load(TuxGuitar.instance().getSongManager().getFactory(), inputStream);
                        TuxGuitar.instance().fireNewSong(tGSong, null);
                    }
                    catch (Throwable throwable) {
                        TuxGuitar.instance().newSong();
                        MessageDialog.errorMessage(TGBrowserDialog.this.getShell(), new TGFileFormatException(TuxGuitar.getProperty("file.open.error", new String[]{tGBrowserElement.getName()}), throwable));
                    }
                    TGBrowserDialog.this.getConnection().release();
                    ActionLock.unlock();
                }
            }
        }).start();
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.getShell().setImage(TuxGuitar.instance().getIconManager().getAppIcon());
            this.reload();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("browser.dialog"));
            this.menu.loadProperties();
            this.toolBar.loadProperties();
        }
    }

    public void notifyAdded() {
        this.reload();
    }

    public void notifyRemoved() {
        if (this.getCollection() != null) {
            this.closeCollection();
        }
        this.reload();
    }

    protected void reload() {
        if (!this.isDisposed()) {
            this.menu.reload(this.getShell());
            this.toolBar.reload();
            this.updateTable();
            this.updateCollections(this.getCollection());
            this.getShell().layout();
        }
    }
}

