/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.browser;

import java.io.InputStream;
import java.util.List;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserConnectionHandler;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserException;
import org.herac.tuxguitar.gui.tools.browser.base.TGBrowser;
import org.herac.tuxguitar.gui.tools.browser.base.TGBrowserElement;

public class TGBrowserConnection {
    private boolean locked;
    private TGBrowser browser;
    private TGBrowserConnectionHandler handler;

    public TGBrowserConnection(TGBrowserConnectionHandler tGBrowserConnectionHandler) {
        this.handler = tGBrowserConnectionHandler;
    }

    protected void lock() {
        this.locked = true;
        this.handler.notifyLockStatusChanged();
    }

    protected void unlock() {
        this.locked = false;
        this.handler.notifyLockStatusChanged();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public TGBrowser getBrowser() {
        return this.browser;
    }

    public boolean isOpen() {
        return this.getBrowser() != null;
    }

    public void open(final int n, TGBrowser tGBrowser) {
        if (!this.isLocked()) {
            this.close(n);
            this.lock();
            this.browser = tGBrowser;
            new Thread(new Runnable(){

                public void run() {
                    try {
                        if (TGBrowserConnection.this.getBrowser() != null) {
                            TGBrowserConnection.this.getBrowser().open();
                            TGBrowserConnection.this.notifyOpened(n);
                        } else {
                            TGBrowserConnection.this.notifyClosed(n);
                        }
                    }
                    catch (TGBrowserException tGBrowserException) {
                        TGBrowserConnection.this.notifyError(n, tGBrowserException);
                        tGBrowserException.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void close(final int n) {
        if (!this.isLocked()) {
            this.lock();
            final TGBrowser tGBrowser = this.getBrowser();
            this.browser = null;
            new Thread(new Runnable(){

                public void run() {
                    try {
                        if (tGBrowser != null) {
                            tGBrowser.close();
                            TGBrowserConnection.this.notifyClosed(n);
                        } else {
                            TGBrowserConnection.this.notifyClosed(n);
                        }
                    }
                    catch (TGBrowserException tGBrowserException) {
                        TGBrowserConnection.this.notifyError(n, tGBrowserException);
                        tGBrowserException.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void cdRoot(final int n) {
        if (!this.isLocked()) {
            this.lock();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        if (TGBrowserConnection.this.isOpen()) {
                            TGBrowserConnection.this.getBrowser().cdRoot();
                            TGBrowserConnection.this.notifyCd(n);
                        } else {
                            TGBrowserConnection.this.notifyClosed(n);
                        }
                    }
                    catch (TGBrowserException tGBrowserException) {
                        TGBrowserConnection.this.notifyError(n, tGBrowserException);
                        tGBrowserException.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void cdUp(final int n) {
        if (!this.isLocked()) {
            this.lock();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        if (TGBrowserConnection.this.isOpen()) {
                            TGBrowserConnection.this.getBrowser().cdUp();
                            TGBrowserConnection.this.notifyCd(n);
                        } else {
                            TGBrowserConnection.this.notifyClosed(n);
                        }
                    }
                    catch (TGBrowserException tGBrowserException) {
                        TGBrowserConnection.this.notifyError(n, tGBrowserException);
                        tGBrowserException.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void cd(final int n, final TGBrowserElement tGBrowserElement) {
        if (!this.isLocked()) {
            this.lock();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        if (TGBrowserConnection.this.isOpen()) {
                            TGBrowserConnection.this.getBrowser().cdElement(tGBrowserElement);
                            TGBrowserConnection.this.notifyCd(n);
                        } else {
                            TGBrowserConnection.this.notifyClosed(n);
                        }
                    }
                    catch (TGBrowserException tGBrowserException) {
                        TGBrowserConnection.this.notifyError(n, tGBrowserException);
                        tGBrowserException.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void listElements(final int n) {
        if (!this.isLocked()) {
            this.lock();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        if (TGBrowserConnection.this.isOpen()) {
                            List list = TGBrowserConnection.this.getBrowser().listElements();
                            TGBrowserConnection.this.notifyElements(n, list);
                        } else {
                            TGBrowserConnection.this.notifyClosed(n);
                        }
                    }
                    catch (TGBrowserException tGBrowserException) {
                        TGBrowserConnection.this.notifyError(n, tGBrowserException);
                        tGBrowserException.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void openStream(final int n, final TGBrowserElement tGBrowserElement) {
        if (!this.isLocked()) {
            this.lock();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        if (tGBrowserElement == null) {
                            TGBrowserConnection.this.release();
                            return;
                        }
                        if (tGBrowserElement.isFolder()) {
                            TGBrowserConnection.this.release();
                            TGBrowserConnection.this.cd(n, tGBrowserElement);
                        } else {
                            InputStream inputStream = tGBrowserElement.getInputStream();
                            TGBrowserConnection.this.notifyStream(n, inputStream, tGBrowserElement);
                        }
                    }
                    catch (TGBrowserException tGBrowserException) {
                        TGBrowserConnection.this.notifyError(n, tGBrowserException);
                        tGBrowserException.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void release() {
        this.unlock();
    }

    public void notifyCd(int n) {
        this.handler.notifyCd(n);
    }

    public void notifyClosed(int n) {
        this.handler.notifyClosed(n);
    }

    public void notifyElements(int n, List list) {
        this.handler.notifyElements(n, list);
    }

    public void notifyError(int n, Throwable throwable) {
        this.handler.notifyError(n, throwable);
    }

    public void notifyOpened(int n) {
        this.handler.notifyOpened(n);
    }

    public void notifyStream(int n, InputStream inputStream, TGBrowserElement tGBrowserElement) {
        this.handler.notifyStream(n, inputStream, tGBrowserElement);
    }
}

