/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.table;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.table.TGTableViewer;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGTableCanvasPainter
implements PaintListener {
    private TGTableViewer viewer;
    private TGTrack track;

    public TGTableCanvasPainter(TGTableViewer tGTableViewer, TGTrack tGTrack) {
        this.viewer = tGTableViewer;
        this.track = tGTrack;
    }

    public void paintControl(PaintEvent paintEvent) {
        TGPainter tGPainter = new TGPainter(paintEvent.gc);
        this.paintTrack(tGPainter);
    }

    protected void paintTrack(TGPainter tGPainter) {
        if (!TuxGuitar.instance().isLocked()) {
            TuxGuitar.instance().lock();
            int n = -this.viewer.getHScrollSelection();
            int n2 = 0;
            int n3 = this.viewer.getTable().getRowHeight();
            int n4 = tGPainter.getGC().getDevice().getBounds().width;
            boolean bl = TuxGuitar.instance().getPlayer().isRunning();
            tGPainter.setBackground(tGPainter.getGC().getDevice().getSystemColor(15));
            tGPainter.initPath(2);
            tGPainter.addRectangle(0.0f, n2, n4, n3);
            tGPainter.closePath();
            Color color = new Color(tGPainter.getGC().getDevice(), this.track.getColor().getR(), this.track.getColor().getG(), this.track.getColor().getB());
            tGPainter.setBackground(color);
            tGPainter.setForeground(color);
            int n5 = this.track.countMeasures();
            for (int i = 0; i < n5; ++i) {
                TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)this.track.getMeasure(i);
                if (this.isRestMeasure(tGMeasureImpl)) {
                    tGPainter.initPath();
                    tGPainter.addRectangle(n, n2, n3 - 2, n3 - 1);
                    tGPainter.closePath();
                } else {
                    tGPainter.initPath(2);
                    tGPainter.addRectangle(n, n2, n3 - 1, n3);
                    tGPainter.closePath();
                }
                boolean bl2 = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getMeasure().equals(tGMeasureImpl);
                if (bl && tGMeasureImpl.isPlaying(this.viewer.getEditor().getTablature().getViewLayout()) || !bl && bl2) {
                    tGPainter.setBackground(tGPainter.getGC().getDevice().getSystemColor(2));
                    tGPainter.initPath(2);
                    tGPainter.addRectangle(n + 4, n2 + 4, n3 - 9, n3 - 8);
                    tGPainter.closePath();
                    tGPainter.setBackground(color);
                }
                n += n3;
            }
            color.dispose();
            TuxGuitar.instance().unlock();
        }
    }

    private boolean isRestMeasure(TGMeasureImpl tGMeasureImpl) {
        int n = tGMeasureImpl.countBeats();
        for (int i = 0; i < n; ++i) {
            if (tGMeasureImpl.getBeat(i).isRestBeat()) continue;
            return false;
        }
        return true;
    }
}

