/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.language;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.system.language.TGResourceBundle;
import org.herac.tuxguitar.gui.util.TGFileUtils;

public class LanguageManager {
    public static final String PACKAGE = "lang";
    public static final String PREFIX = "messages";
    public static final String EXTENSION = ".properties";
    private TGResourceBundle resources;
    private String[] languages;
    private List loaders = new ArrayList();

    public LanguageManager() {
        this.loadLanguages();
    }

    public void addLoader(LanguageLoader languageLoader) {
        if (!this.loaders.contains(languageLoader)) {
            this.loaders.add(languageLoader);
        }
    }

    public void removeLoader(LanguageLoader languageLoader) {
        if (this.loaders.contains(languageLoader)) {
            this.loaders.remove(languageLoader);
        }
    }

    private void fireChanges() {
        Iterator iterator = this.loaders.iterator();
        while (iterator.hasNext()) {
            LanguageLoader languageLoader = (LanguageLoader)iterator.next();
            languageLoader.loadProperties();
        }
    }

    public void setLanguage(String string) {
        try {
            String string2 = "lang.messages";
            Locale locale = this.getLocale(string);
            this.resources = TGResourceBundle.getBundle(string2, locale);
            this.fireChanges();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Locale getLocale(String string) {
        if (this.isSupportedLanguage(string)) {
            String[] stringArray = string.split("_");
            String string2 = stringArray.length > 0 ? stringArray[0] : "";
            String string3 = stringArray.length > 1 ? stringArray[1] : "";
            String string4 = stringArray.length > 2 ? stringArray[2] : "";
            return new Locale(string2, string3, string4);
        }
        return Locale.getDefault();
    }

    private boolean isSupportedLanguage(String string) {
        if (string != null && string.length() > 0 && this.languages != null) {
            for (int i = 0; i < this.languages.length; ++i) {
                if (!this.languages[i].equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public String getProperty(String string, String string2) {
        try {
            String string3 = this.resources.getString(string);
            return string3 == null ? string2 : string3;
        }
        catch (Throwable throwable) {
            return string2;
        }
    }

    public String getProperty(String string) {
        return this.getProperty(string, string);
    }

    public String getProperty(String string, Object[] objectArray) {
        return this.getProperty(string, string, objectArray);
    }

    public String getProperty(String string, String string2, Object[] objectArray) {
        String string3 = this.getProperty(string, string2);
        return objectArray != null ? MessageFormat.format(string3, objectArray) : string3;
    }

    public String[] getLanguages() {
        return this.languages;
    }

    public String getLanguage() {
        if (this.resources != null) {
            Locale locale = this.resources.getLocale();
            boolean bl = locale.getLanguage() != null && locale.getLanguage().length() > 0;
            boolean bl2 = locale.getCountry() != null && locale.getCountry().length() > 0;
            boolean bl3 = locale.getVariant() != null && locale.getVariant().length() > 0;
            String string = new String();
            if (bl) {
                string = string + locale.getLanguage();
            }
            if (bl2) {
                string = string + "_" + locale.getCountry();
            }
            if (bl3) {
                string = string + "_" + (bl2 ? locale.getVariant() : "_" + locale.getVariant());
            }
            return string;
        }
        return null;
    }

    private void loadLanguages() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = TGFileUtils.getFileNames(PACKAGE);
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].indexOf("messages_") != 0) continue;
                int n2 = stringArray[n].indexOf("messages_");
                int n3 = stringArray[n].indexOf(EXTENSION);
                if (n2 != 0 || n3 <= "messages_".length()) continue;
                arrayList.add(stringArray[n].substring("messages_".length(), n3));
            }
        }
        this.languages = new String[arrayList.size()];
        for (n = 0; n < this.languages.length; ++n) {
            this.languages[n] = (String)arrayList.get(n);
        }
    }
}

