/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.system.config.TGConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;
import org.herac.tuxguitar.gui.util.WindowTitleUtil;

public class MainOption
extends Option {
    protected boolean initialized = false;
    protected Button showSplash;
    protected Button autoSizeTable;
    protected Text windowTitle;

    public MainOption(TGConfigEditor tGConfigEditor, ToolBar toolBar, Composite composite) {
        super(tGConfigEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.main"));
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.main"));
        this.getToolItem().setImage(TuxGuitar.instance().getIconManager().getOptionMain());
        this.getToolItem().addSelectionListener((SelectionListener)this);
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("settings.config.main.window-title"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)this.getTabbedData());
        this.windowTitle = new Text(composite, 2048);
        this.windowTitle.setLayoutData((Object)new GridData(4, 4, true, true));
        this.windowTitle.setTextLimit(80);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.showImageLabel(composite2, 0, composite2.getDisplay().getSystemImage(2));
        this.showLabel(composite2, 16576, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.help"));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("appname"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.appname"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("appversion"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.appversion"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("filename"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.filename"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("filepath"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.filepath"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("songname"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.songname"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("songalbum"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.songalbum"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("songartist"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.songartist"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("songauthor"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.songauthor"));
        this.showLabel(this.getComposite(), 17472, 1, 0, TuxGuitar.getProperty("settings.config.main.options"));
        Composite composite4 = new Composite(this.getComposite(), 0);
        composite4.setLayout((Layout)new GridLayout());
        composite4.setLayoutData((Object)this.getTabbedData());
        this.autoSizeTable = new Button(composite4, 32);
        this.autoSizeTable.setText(TuxGuitar.getProperty("settings.config.main.table.auto-size.enabled"));
        this.showSplash = new Button(composite4, 32);
        this.showSplash.setText(TuxGuitar.getProperty("settings.config.main.splash-enabled"));
        this.loadConfig();
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                final String string = MainOption.this.getConfig().getStringConfigValue("window.title");
                final boolean bl = MainOption.this.getConfig().getBooleanConfigValue("show.splash");
                final boolean bl2 = MainOption.this.getConfig().getBooleanConfigValue("table.auto-size");
                new SyncThread(new Runnable(){

                    public void run() {
                        if (!MainOption.this.isDisposed()) {
                            (this).MainOption.this.windowTitle.setText(string);
                            (this).MainOption.this.showSplash.setSelection(bl);
                            (this).MainOption.this.autoSizeTable.setSelection(bl2);
                            (this).MainOption.this.initialized = true;
                            MainOption.this.pack();
                        }
                    }
                }).start();
            }
        }).start();
    }

    public void updateConfig() {
        if (this.initialized) {
            this.getConfig().setProperty("window.title", this.windowTitle.getText());
            this.getConfig().setProperty("show.splash", this.showSplash.getSelection());
            this.getConfig().setProperty("table.auto-size", this.autoSizeTable.getSelection());
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setProperty("window.title", this.getDefaults().getProperty("window.title"));
            this.getConfig().setProperty("show.splash", this.getDefaults().getProperty("show.splash"));
            this.getConfig().setProperty("table.auto-size", this.getDefaults().getProperty("table.auto-size"));
        }
    }

    public void applyConfig(boolean bl) {
        if (bl || this.initialized) {
            TuxGuitar.instance().showTitle();
            TuxGuitar.instance().getTable().loadConfig();
        }
    }
}

