/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.mixer;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.mixer.TGMixer;
import org.herac.tuxguitar.gui.mixer.TGMixerTrackChannel;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackChannel;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGMixerTrack {
    protected TGTrack track;
    protected TGMixer mixer;
    protected TGMixerTrackChannel mixerChannel;
    protected Button checkSolo;
    protected Button checkMute;
    private TGMixerScale scaleVolume;
    private TGMixerScale scaleBalance;
    private TGMixerScalePopup scaleChorus;
    private TGMixerScalePopup scaleReverb;
    private TGMixerScalePopup scalePhaser;
    private TGMixerScalePopup scaleTremolo;
    private Label volumeValueLabel;
    private Label volumeValueTitleLabel;

    public TGMixerTrack(TGMixer tGMixer, TGTrack tGTrack) {
        this.mixer = tGMixer;
        this.track = tGTrack;
    }

    public void init(Composite composite) {
        Composite composite2 = new Composite(composite, 2048);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.mixerChannel = new TGMixerTrackChannel(this);
        this.mixerChannel.init(composite2);
        this.checkSolo = new Button(composite2, 32);
        this.checkSolo.setSelection(this.track.isSolo());
        this.checkSolo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UndoableTrackChannel undoableTrackChannel = UndoableTrackChannel.startUndo();
                TGMixerTrack.this.track.setSolo(TGMixerTrack.this.checkSolo.getSelection());
                if (TGMixerTrack.this.track.isSolo()) {
                    TGMixerTrack.this.track.setMute(false);
                }
                TGMixerTrack.this.mixer.fireChanges(TGMixerTrack.this.track.getChannel(), 2);
                TuxGuitar.instance().getUndoableManager().addEdit(undoableTrackChannel.endUndo());
                TuxGuitar.instance().updateCache(true);
            }
        });
        this.checkMute = new Button(composite2, 32);
        this.checkMute.setSelection(this.track.isMute());
        this.checkMute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UndoableTrackChannel undoableTrackChannel = UndoableTrackChannel.startUndo();
                TGMixerTrack.this.track.setMute(TGMixerTrack.this.checkMute.getSelection());
                if (TGMixerTrack.this.track.isMute()) {
                    TGMixerTrack.this.track.setSolo(false);
                }
                TGMixerTrack.this.mixer.fireChanges(TGMixerTrack.this.track.getChannel(), 1);
                TuxGuitar.instance().getUndoableManager().addEdit(undoableTrackChannel.endUndo());
                TuxGuitar.instance().updateCache(true);
            }
        });
        new Label(composite2, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(4, false));
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scaleChorus = new TGMixerScalePopup(composite3, 512, 64, 16, this.getVerticalScaleData());
        this.scaleChorus.setSelection(this.track.getChannel().getChorus());
        this.scaleReverb = new TGMixerScalePopup(composite3, 512, 64, 32, this.getVerticalScaleData());
        this.scaleReverb.setSelection(this.track.getChannel().getReverb());
        this.scalePhaser = new TGMixerScalePopup(composite3, 512, 64, 64, this.getVerticalScaleData());
        this.scalePhaser.setSelection(this.track.getChannel().getPhaser());
        this.scaleTremolo = new TGMixerScalePopup(composite3, 512, 64, 128, this.getVerticalScaleData());
        this.scaleTremolo.setSelection(this.track.getChannel().getTremolo());
        new Label(composite2, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.scaleBalance = new TGMixerScale(composite2, 256, 64, 8, this.getHorizontalScaleData());
        this.scaleBalance.setSelection(this.track.getChannel().getBalance());
        this.scaleVolume = new TGMixerScale(composite2, 512, 16, 4, new GridData(0x1000000, 4, true, true));
        this.scaleVolume.setSelection(this.track.getChannel().getVolume());
        Label label = new Label(composite2, 258);
        label.setLayoutData((Object)new GridData(4, 1024, true, false));
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        this.volumeValueTitleLabel = new Label(composite4, 16384);
        this.volumeValueLabel = new Label(composite4, 0x1000000);
        this.volumeValueLabel.setLayoutData((Object)this.getVolumeValueLabelData());
        this.volumeValueLabel.setText(Integer.toString(this.track.getChannel().getVolume()));
    }

    private GridData getHorizontalScaleData() {
        GridData gridData = new GridData(0x1000000, 0, false, true);
        gridData.widthHint = 80;
        return gridData;
    }

    private GridData getVerticalScaleData() {
        GridData gridData = new GridData(0x1000000, 4, false, true);
        gridData.heightHint = 65;
        return gridData;
    }

    private GridData getVolumeValueLabelData() {
        GridData gridData = new GridData(0x1000000, 0, true, false);
        gridData.minimumWidth = 40;
        return gridData;
    }

    public void fireChanges(int n) {
        short s;
        if ((n & 2) != 0 || (n & 1) != 0) {
            this.checkSolo.setSelection(this.track.isSolo());
            this.checkMute.setSelection(this.track.isMute());
        }
        if ((n & 0x100) != 0 || (n & 4) != 0) {
            s = this.track.getChannel().getVolume();
            this.scaleVolume.setSelection(s);
            this.volumeValueLabel.setText(Integer.toString(s));
        }
        if ((n & 0x100) != 0 || (n & 8) != 0) {
            s = this.track.getChannel().getBalance();
            this.scaleBalance.setSelection(s);
        }
        if ((n & 0x100) != 0 || (n & 0x10) != 0) {
            s = this.track.getChannel().getChorus();
            this.scaleChorus.setSelection(s);
        }
        if ((n & 0x100) != 0 || (n & 0x20) != 0) {
            s = this.track.getChannel().getReverb();
            this.scaleReverb.setSelection(s);
        }
        if ((n & 0x100) != 0 || (n & 0x40) != 0) {
            s = this.track.getChannel().getPhaser();
            this.scalePhaser.setSelection(s);
        }
        if ((n & 0x100) != 0 || (n & 0x80) != 0) {
            s = this.track.getChannel().getTremolo();
            this.scaleTremolo.setSelection(s);
        }
        if ((n & 0x100) != 0) {
            this.mixerChannel.updateItems(true);
        }
    }

    public void loadProperties() {
        this.checkSolo.setText(TuxGuitar.getProperty("mixer.track.solo"));
        this.checkMute.setText(TuxGuitar.getProperty("mixer.track.mute"));
        this.volumeValueTitleLabel.setText(TuxGuitar.getProperty("mixer.channel.volume") + ":");
        this.scaleVolume.setText(TuxGuitar.getProperty("mixer.channel.volume"));
        this.scaleBalance.setText(TuxGuitar.getProperty("mixer.channel.balance"));
        this.scaleChorus.setText(TuxGuitar.getProperty("mixer.channel.chorus"));
        this.scaleReverb.setText(TuxGuitar.getProperty("mixer.channel.reverb"));
        this.scalePhaser.setText(TuxGuitar.getProperty("mixer.channel.phaser"));
        this.scaleTremolo.setText(TuxGuitar.getProperty("mixer.channel.tremolo"));
        this.mixerChannel.updateItems(true);
    }

    public void updateItems() {
        this.mixerChannel.updateItems(false);
    }

    public TGTrack getTrack() {
        return this.track;
    }

    public TGMixer getMixer() {
        return this.mixer;
    }

    protected void updateChannelValue(int n, int n2) {
        if ((n & 4) != 0) {
            this.track.getChannel().setVolume((short)n2);
        } else if ((n & 8) != 0) {
            this.track.getChannel().setBalance((short)n2);
        } else if ((n & 0x10) != 0) {
            this.track.getChannel().setChorus((short)n2);
        } else if ((n & 0x20) != 0) {
            this.track.getChannel().setReverb((short)n2);
        } else if ((n & 0x40) != 0) {
            this.track.getChannel().setPhaser((short)n2);
        } else if ((n & 0x80) != 0) {
            this.track.getChannel().setTremolo((short)n2);
        }
        this.mixer.fireChanges(this.track.getChannel(), n);
    }

    private class TGMixerScalePopup
    extends TGMixerScale {
        private Shell shell;
        private Composite composite;
        private Button item;

        public TGMixerScalePopup(Composite composite, int n, int n2, int n3, Object object) {
            super(composite, n, n2, n3, object);
        }

        public void init(Composite composite, int n, int n2, int n3, Object object) {
            this.shell = new Shell(composite.getShell(), 8);
            this.shell.setVisible(false);
            this.shell.setLayout((Layout)this.getGridLayout());
            this.shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellDeactivated(ShellEvent shellEvent) {
                    TGMixerScalePopup.this.hideShell();
                }

                public void shellClosed(ShellEvent shellEvent) {
                    shellEvent.doit = false;
                    TGMixerScalePopup.this.hideShell();
                }
            });
            this.composite = new Composite((Composite)this.shell, 2048);
            this.composite.setLayout((Layout)this.getGridLayout());
            this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.item = new Button(composite, 8);
            this.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TGMixerScalePopup.this.showSelect();
                }
            });
            super.init(this.composite, n, n2, n3, object);
        }

        private GridLayout getGridLayout() {
            GridLayout gridLayout = new GridLayout();
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.marginTop = 0;
            gridLayout.marginBottom = 0;
            gridLayout.marginLeft = 0;
            gridLayout.marginHeight = 0;
            return gridLayout;
        }

        public void updateToolTipValue() {
            super.updateToolTipValue();
            if (this.getText() != null) {
                this.item.setToolTipText(this.getText() + ": " + this.getSelection());
            }
        }

        public void setText(String string) {
            super.setText(string);
            if (this.getText() != null && this.getText().length() > 0) {
                this.item.setText(this.getText().substring(0, 1));
            }
        }

        public void showSelect() {
            if (!this.shell.isVisible()) {
                Rectangle rectangle = this.item.getBounds();
                Point point = this.item.getParent().toDisplay(new Point(rectangle.x, rectangle.y));
                this.shell.pack();
                this.shell.setLocation(point.x + rectangle.width / 2 - this.shell.getSize().x / 2, point.y + rectangle.height);
                this.shell.setVisible(true);
                this.shell.setActive();
            }
        }

        public void hideShell() {
            this.shell.setVisible(false);
        }
    }

    private class TGMixerScale {
        private int type;
        private int value;
        private boolean inverted;
        private Scale scale;
        private String text;
        protected UndoableTrackChannel undoable;

        public TGMixerScale(Composite composite, int n, int n2, int n3, Object object) {
            this.init(composite, n, n2, n3, object);
        }

        public void init(Composite composite, int n, int n2, int n3, Object object) {
            this.scale = new Scale(composite, n);
            this.scale.setMaximum(127);
            this.scale.setMinimum(0);
            this.scale.setIncrement(1);
            this.scale.setPageIncrement(n2);
            this.scale.setLayoutData(object);
            this.type = n3;
            this.value = -1;
            this.inverted = (n & 0x200) != 0;
            this.addDefaultListeners();
        }

        public void addDefaultListeners() {
            this.scale.addListener(13, new Listener(){

                public synchronized void handleEvent(Event event) {
                    TGMixerScale.this.updateValue();
                    TGMixerTrack.this.updateChannelValue(TGMixerScale.this.getType(), TGMixerScale.this.getSelection());
                }
            });
            this.scale.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    TGMixerScale.this.undoable = UndoableTrackChannel.startUndo();
                }

                public void mouseUp(MouseEvent mouseEvent) {
                    if (TGMixerScale.this.undoable != null) {
                        TuxGuitar.instance().getUndoableManager().addEdit(TGMixerScale.this.undoable.endUndo());
                        TuxGuitar.instance().getFileHistory().setUnsavedFile();
                        TuxGuitar.instance().updateCache(true);
                        TGMixerScale.this.undoable = null;
                    }
                }
            });
        }

        public void updateValue() {
            this.setSelection(this.inverted ? 127 - this.scale.getSelection() : this.scale.getSelection());
        }

        public int getType() {
            return this.type;
        }

        public int getSelection() {
            if (this.value < 0) {
                this.updateValue();
            }
            return this.value;
        }

        public void setSelection(int n) {
            if (n != this.value) {
                this.value = n;
                this.scale.setSelection(this.inverted ? 127 - this.value : this.value);
                this.updateToolTipValue();
            }
        }

        public void updateToolTipValue() {
            if (this.text != null) {
                this.scale.setToolTipText(this.text + ": " + this.value);
            }
        }

        public void setText(String string) {
            this.text = string;
            this.updateToolTipValue();
        }

        public String getText() {
            return this.text;
        }
    }
}

