/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.marker;

import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.editors.TGUpdateListener;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.marker.MarkerEditor;
import org.herac.tuxguitar.gui.marker.MarkerNavigator;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeMarker;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGMarker;

public class MarkerList
implements TGUpdateListener,
IconLoader,
LanguageLoader {
    private static MarkerList instance;
    protected Shell dialog;
    private Table table;
    private List markers;
    private Composite compositeTable;
    private TableColumn measureColumn;
    private TableColumn titleColumn;
    private Composite compositeButtons;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonDelete;
    private Button buttonGo;
    private Button buttonClose;

    public static MarkerList instance() {
        if (instance == null) {
            instance = new MarkerList();
        }
        return instance;
    }

    private MarkerList() {
    }

    public void show() {
        this.dialog = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 2144);
        this.dialog.setLayout((Layout)new GridLayout(2, false));
        this.dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        this.compositeTable = new Composite((Composite)this.dialog, 0);
        this.compositeTable.setLayout((Layout)new GridLayout());
        this.compositeTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(this.compositeTable, 67584);
        this.table.setLayoutData((Object)new GridData(250, 200));
        this.table.setHeaderVisible(true);
        this.table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                new MarkerNavigator().goToSelectedMarker(MarkerList.this.getSelectedMarker());
                TuxGuitar.instance().updateCache(true);
            }
        });
        this.measureColumn = new TableColumn(this.table, 16384);
        this.measureColumn.setWidth(70);
        this.titleColumn = new TableColumn(this.table, 16384);
        this.titleColumn.setWidth(180);
        this.loadTableItems(false);
        this.compositeButtons = new Composite((Composite)this.dialog, 0);
        this.compositeButtons.setLayout((Layout)new GridLayout(1, false));
        this.compositeButtons.setLayoutData((Object)new GridData(4, 4, true, true));
        this.buttonAdd = new Button(this.compositeButtons, 8);
        this.buttonAdd.setLayoutData((Object)this.makeGridData(4, 128, false));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!ActionLock.isLocked() && !TuxGuitar.instance().isLocked()) {
                    ActionLock.lock();
                    Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
                    TGMarker tGMarker = TuxGuitar.instance().getSongManager().getFactory().newMarker();
                    tGMarker.setMeasure(caret.getMeasure().getNumber());
                    if (new MarkerEditor(tGMarker, 1).open(MarkerList.this.dialog)) {
                        TuxGuitar.instance().updateCache(true);
                        MarkerList.this.loadTableItems(true);
                    }
                    ActionLock.unlock();
                }
            }
        });
        this.buttonEdit = new Button(this.compositeButtons, 8);
        this.buttonEdit.setLayoutData((Object)this.makeGridData(4, 128, false));
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!ActionLock.isLocked() && !TuxGuitar.instance().isLocked()) {
                    ActionLock.lock();
                    TGMarker tGMarker = MarkerList.this.getSelectedMarker();
                    if (tGMarker != null && new MarkerEditor(tGMarker, 2).open(MarkerList.this.dialog)) {
                        TuxGuitar.instance().updateCache(true);
                        MarkerList.this.loadTableItems(true);
                    }
                    ActionLock.unlock();
                }
            }
        });
        this.buttonDelete = new Button(this.compositeButtons, 8);
        this.buttonDelete.setLayoutData((Object)this.makeGridData(4, 128, false));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!ActionLock.isLocked() && !TuxGuitar.instance().isLocked()) {
                    ActionLock.lock();
                    TGMarker tGMarker = MarkerList.this.getSelectedMarker();
                    UndoableChangeMarker undoableChangeMarker = UndoableChangeMarker.startUndo(tGMarker);
                    TuxGuitar.instance().getSongManager().removeMarker(tGMarker);
                    TuxGuitar.instance().getUndoableManager().addEdit(undoableChangeMarker.endUndo(null));
                    TuxGuitar.instance().getFileHistory().setUnsavedFile();
                    TuxGuitar.instance().updateCache(true);
                    MarkerList.this.loadTableItems(true);
                    ActionLock.unlock();
                }
            }
        });
        this.buttonGo = new Button(this.compositeButtons, 8);
        this.buttonGo.setLayoutData((Object)this.makeGridData(4, 1024, true));
        this.buttonGo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!ActionLock.isLocked() && !TuxGuitar.instance().isLocked()) {
                    ActionLock.lock();
                    new MarkerNavigator().goToSelectedMarker(MarkerList.this.getSelectedMarker());
                    TuxGuitar.instance().updateCache(true);
                    ActionLock.unlock();
                }
            }
        });
        this.buttonClose = new Button(this.compositeButtons, 8);
        this.buttonClose.setLayoutData((Object)this.makeGridData(4, 1024, false));
        this.buttonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MarkerList.this.dialog.dispose();
            }
        });
        this.loadIcons();
        this.loadProperties(false);
        this.addListeners();
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                MarkerList.this.removeListeners();
            }
        });
        this.dialog.setDefaultButton(this.buttonGo);
        DialogUtils.openDialog(this.dialog, 10);
    }

    public void addListeners() {
        TuxGuitar.instance().getIconManager().addLoader(this);
        TuxGuitar.instance().getLanguageManager().addLoader(this);
        TuxGuitar.instance().getEditorManager().addUpdateListener(this);
    }

    public void removeListeners() {
        TuxGuitar.instance().getIconManager().removeLoader(this);
        TuxGuitar.instance().getLanguageManager().removeLoader(this);
        TuxGuitar.instance().getEditorManager().removeUpdateListener(this);
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public void update() {
        this.update(false);
    }

    public void update(final boolean bl) {
        if (!this.isDisposed()) {
            new SyncThread(new Runnable(){

                public void run() {
                    if (!MarkerList.this.isDisposed()) {
                        MarkerList.this.loadTableItems(bl);
                    }
                }
            }).start();
        }
    }

    private GridData makeGridData(int n, int n2, boolean bl) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = n;
        gridData.verticalAlignment = n2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = bl;
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void loadTableItems(boolean bl) {
        int n = bl ? this.table.getSelectionIndex() : -1;
        this.table.removeAll();
        this.markers = TuxGuitar.instance().getSongManager().getMarkers();
        Iterator iterator = this.markers.iterator();
        while (iterator.hasNext()) {
            TGMarker tGMarker = (TGMarker)iterator.next();
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(new String[]{Integer.toString(tGMarker.getMeasure()), tGMarker.getTitle()});
        }
        if (n >= 0 && n < this.markers.size()) {
            this.table.select(n);
        }
    }

    protected TGMarker getSelectedMarker() {
        int n = this.table.getSelectionIndex();
        if (n >= 0 && n < this.markers.size()) {
            return (TGMarker)this.markers.get(n);
        }
        return null;
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        }
    }

    public void loadProperties() {
        this.loadProperties(true);
    }

    public void loadProperties(boolean bl) {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("marker.list"));
            this.measureColumn.setText(TuxGuitar.getProperty("measure"));
            this.titleColumn.setText(TuxGuitar.getProperty("title"));
            this.buttonAdd.setText(TuxGuitar.getProperty("add"));
            this.buttonEdit.setText(TuxGuitar.getProperty("edit"));
            this.buttonDelete.setText(TuxGuitar.getProperty("remove"));
            this.buttonGo.setText(TuxGuitar.getProperty("go"));
            this.buttonClose.setText(TuxGuitar.getProperty("close"));
            if (bl) {
                this.table.layout();
                this.compositeTable.layout();
                this.compositeButtons.layout();
                this.dialog.pack(true);
            }
        }
    }

    public void doUpdate(int n) {
        if (n == 3) {
            this.update();
        }
    }
}

