/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ToolItems;
import org.herac.tuxguitar.song.models.TGNote;

public class NoteEffectToolItems
extends ToolItems {
    public static final String NAME = "effect.items";
    private ToolItem deadNote;
    private ToolItem ghostNote;
    private ToolItem accentuatedNote;
    private ToolItem heavyAccentuatedNote;
    private ToolItem harmonicNote;
    private ToolItem graceNote;
    private ToolItem vibrato;
    private ToolItem bend;
    private ToolItem tremoloBar;
    private ToolItem slide;
    private ToolItem hammer;
    private ToolItem trill;
    private ToolItem tremoloPicking;
    private ToolItem palmMute;
    private ToolItem staccato;
    private ToolItem tapping;
    private ToolItem slapping;
    private ToolItem popping;
    private ToolItem fadeIn;

    public NoteEffectToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.deadNote = new ToolItem(toolBar, 32);
        this.deadNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-dead"));
        this.ghostNote = new ToolItem(toolBar, 32);
        this.ghostNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-ghost"));
        this.accentuatedNote = new ToolItem(toolBar, 32);
        this.accentuatedNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-accentuated"));
        this.heavyAccentuatedNote = new ToolItem(toolBar, 32);
        this.heavyAccentuatedNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-heavy-accentuated"));
        this.harmonicNote = new ToolItem(toolBar, 32);
        this.harmonicNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-harmonic"));
        this.graceNote = new ToolItem(toolBar, 32);
        this.graceNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-grace"));
        new ToolItem(toolBar, 2);
        this.vibrato = new ToolItem(toolBar, 32);
        this.vibrato.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-vibrato"));
        this.bend = new ToolItem(toolBar, 32);
        this.bend.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-bend"));
        this.tremoloBar = new ToolItem(toolBar, 32);
        this.tremoloBar.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-tremolo-bar"));
        this.slide = new ToolItem(toolBar, 32);
        this.slide.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-slide"));
        this.hammer = new ToolItem(toolBar, 32);
        this.hammer.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-hammer"));
        new ToolItem(toolBar, 2);
        this.trill = new ToolItem(toolBar, 32);
        this.trill.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-trill"));
        this.tremoloPicking = new ToolItem(toolBar, 32);
        this.tremoloPicking.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-tremolo-picking"));
        this.palmMute = new ToolItem(toolBar, 32);
        this.palmMute.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-palm-mute"));
        this.staccato = new ToolItem(toolBar, 32);
        this.staccato.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-staccato"));
        new ToolItem(toolBar, 2);
        this.tapping = new ToolItem(toolBar, 32);
        this.tapping.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-tapping"));
        this.slapping = new ToolItem(toolBar, 32);
        this.slapping.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-slapping"));
        this.popping = new ToolItem(toolBar, 32);
        this.popping.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-popping"));
        new ToolItem(toolBar, 2);
        this.fadeIn = new ToolItem(toolBar, 32);
        this.fadeIn.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-fade-in"));
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        TGNote tGNote = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getSelectedNote();
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.vibrato.setSelection(tGNote != null && tGNote.getEffect().isVibrato());
        this.vibrato.setEnabled(!bl && tGNote != null);
        this.bend.setSelection(tGNote != null && tGNote.getEffect().isBend());
        this.bend.setEnabled(!bl && tGNote != null);
        this.tremoloBar.setSelection(tGNote != null && tGNote.getEffect().isTremoloBar());
        this.tremoloBar.setEnabled(!bl && tGNote != null);
        this.deadNote.setSelection(tGNote != null && tGNote.getEffect().isDeadNote());
        this.deadNote.setEnabled(!bl && tGNote != null);
        this.slide.setSelection(tGNote != null && tGNote.getEffect().isSlide());
        this.slide.setEnabled(!bl && tGNote != null);
        this.hammer.setSelection(tGNote != null && tGNote.getEffect().isHammer());
        this.hammer.setEnabled(!bl && tGNote != null);
        this.ghostNote.setSelection(tGNote != null && tGNote.getEffect().isGhostNote());
        this.ghostNote.setEnabled(!bl && tGNote != null);
        this.accentuatedNote.setSelection(tGNote != null && tGNote.getEffect().isAccentuatedNote());
        this.accentuatedNote.setEnabled(!bl && tGNote != null);
        this.heavyAccentuatedNote.setSelection(tGNote != null && tGNote.getEffect().isHeavyAccentuatedNote());
        this.heavyAccentuatedNote.setEnabled(!bl && tGNote != null);
        this.harmonicNote.setSelection(tGNote != null && tGNote.getEffect().isHarmonic());
        this.harmonicNote.setEnabled(!bl && tGNote != null);
        this.graceNote.setSelection(tGNote != null && tGNote.getEffect().isGrace());
        this.graceNote.setEnabled(!bl && tGNote != null);
        this.trill.setSelection(tGNote != null && tGNote.getEffect().isTrill());
        this.trill.setEnabled(!bl && tGNote != null);
        this.tremoloPicking.setSelection(tGNote != null && tGNote.getEffect().isTremoloPicking());
        this.tremoloPicking.setEnabled(!bl && tGNote != null);
        this.palmMute.setSelection(tGNote != null && tGNote.getEffect().isPalmMute());
        this.palmMute.setEnabled(!bl && tGNote != null);
        this.staccato.setSelection(tGNote != null && tGNote.getEffect().isStaccato());
        this.staccato.setEnabled(!bl && tGNote != null);
        this.tapping.setSelection(tGNote != null && tGNote.getEffect().isTapping());
        this.tapping.setEnabled(!bl && tGNote != null);
        this.slapping.setSelection(tGNote != null && tGNote.getEffect().isSlapping());
        this.slapping.setEnabled(!bl && tGNote != null);
        this.popping.setSelection(tGNote != null && tGNote.getEffect().isPopping());
        this.popping.setEnabled(!bl && tGNote != null);
        this.fadeIn.setSelection(tGNote != null && tGNote.getEffect().isFadeIn());
        this.fadeIn.setEnabled(!bl && tGNote != null);
    }

    public void loadProperties() {
        this.vibrato.setToolTipText(TuxGuitar.getProperty("effects.vibrato"));
        this.bend.setToolTipText(TuxGuitar.getProperty("effects.bend"));
        this.tremoloBar.setToolTipText(TuxGuitar.getProperty("effects.tremolo-bar"));
        this.popping.setToolTipText(TuxGuitar.getProperty("effects.popping"));
        this.deadNote.setToolTipText(TuxGuitar.getProperty("effects.deadnote"));
        this.slide.setToolTipText(TuxGuitar.getProperty("effects.slide"));
        this.hammer.setToolTipText(TuxGuitar.getProperty("effects.hammer"));
        this.ghostNote.setToolTipText(TuxGuitar.getProperty("effects.ghostnote"));
        this.accentuatedNote.setToolTipText(TuxGuitar.getProperty("effects.accentuatednote"));
        this.heavyAccentuatedNote.setToolTipText(TuxGuitar.getProperty("effects.heavyaccentuatednote"));
        this.harmonicNote.setToolTipText(TuxGuitar.getProperty("effects.harmonic"));
        this.graceNote.setToolTipText(TuxGuitar.getProperty("effects.grace"));
        this.trill.setToolTipText(TuxGuitar.getProperty("effects.trill"));
        this.tremoloPicking.setToolTipText(TuxGuitar.getProperty("effects.tremolo-picking"));
        this.palmMute.setToolTipText(TuxGuitar.getProperty("effects.palm-mute"));
        this.staccato.setToolTipText(TuxGuitar.getProperty("effects.staccato"));
        this.tapping.setToolTipText(TuxGuitar.getProperty("effects.tapping"));
        this.slapping.setToolTipText(TuxGuitar.getProperty("effects.slapping"));
        this.popping.setToolTipText(TuxGuitar.getProperty("effects.popping"));
        this.fadeIn.setToolTipText(TuxGuitar.getProperty("effects.fade-in"));
    }

    public void loadIcons() {
        this.deadNote.setImage(TuxGuitar.instance().getIconManager().getEffectDead());
        this.ghostNote.setImage(TuxGuitar.instance().getIconManager().getEffectGhost());
        this.accentuatedNote.setImage(TuxGuitar.instance().getIconManager().getEffectAccentuated());
        this.heavyAccentuatedNote.setImage(TuxGuitar.instance().getIconManager().getEffectHeavyAccentuated());
        this.harmonicNote.setImage(TuxGuitar.instance().getIconManager().getEffectHarmonic());
        this.graceNote.setImage(TuxGuitar.instance().getIconManager().getEffectGrace());
        this.vibrato.setImage(TuxGuitar.instance().getIconManager().getEffectVibrato());
        this.bend.setImage(TuxGuitar.instance().getIconManager().getEffectBend());
        this.tremoloBar.setImage(TuxGuitar.instance().getIconManager().getEffectTremoloBar());
        this.slide.setImage(TuxGuitar.instance().getIconManager().getEffectSlide());
        this.hammer.setImage(TuxGuitar.instance().getIconManager().getEffectHammer());
        this.trill.setImage(TuxGuitar.instance().getIconManager().getEffectTrill());
        this.tremoloPicking.setImage(TuxGuitar.instance().getIconManager().getEffectTremoloPicking());
        this.palmMute.setImage(TuxGuitar.instance().getIconManager().getEffectPalmMute());
        this.staccato.setImage(TuxGuitar.instance().getIconManager().getEffectStaccato());
        this.tapping.setImage(TuxGuitar.instance().getIconManager().getEffectTapping());
        this.slapping.setImage(TuxGuitar.instance().getIconManager().getEffectSlapping());
        this.popping.setImage(TuxGuitar.instance().getIconManager().getEffectPopping());
        this.fadeIn.setImage(TuxGuitar.instance().getIconManager().getEffectFadeIn());
    }
}

