/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.items.ToolItems;

public class DynamicToolItems
extends ToolItems {
    public static final String NAME = "dynamic.items";
    private ToolBar toolBar;
    private ToolItem pianoPianissimo;
    private ToolItem pianissimo;
    private ToolItem piano;
    private ToolItem mezzoPiano;
    private ToolItem mezzoForte;
    private ToolItem forte;
    private ToolItem fortissimo;
    private ToolItem forteFortissimo;

    public DynamicToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.toolBar = toolBar;
        this.pianoPianissimo = new ToolItem(this.toolBar, 32);
        this.pianoPianissimo.setData((Object)new Integer(15));
        this.pianoPianissimo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.pianissimo = new ToolItem(this.toolBar, 32);
        this.pianissimo.setData((Object)new Integer(31));
        this.pianissimo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.piano = new ToolItem(this.toolBar, 32);
        this.piano.setData((Object)new Integer(47));
        this.piano.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.mezzoPiano = new ToolItem(this.toolBar, 32);
        this.mezzoPiano.setData((Object)new Integer(63));
        this.mezzoPiano.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.mezzoForte = new ToolItem(this.toolBar, 32);
        this.mezzoForte.setData((Object)new Integer(79));
        this.mezzoForte.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.forte = new ToolItem(this.toolBar, 32);
        this.forte.setData((Object)new Integer(95));
        this.forte.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.fortissimo = new ToolItem(this.toolBar, 32);
        this.fortissimo.setData((Object)new Integer(111));
        this.fortissimo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.forteFortissimo = new ToolItem(this.toolBar, 32);
        this.forteFortissimo.setData((Object)new Integer(127));
        this.forteFortissimo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
        int n = caret.getSelectedNote() != null ? caret.getSelectedNote().getVelocity() : caret.getVelocity();
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.pianoPianissimo.setSelection(n == 15);
        this.pianoPianissimo.setEnabled(!bl);
        this.pianissimo.setSelection(n == 31);
        this.pianissimo.setEnabled(!bl);
        this.piano.setSelection(n == 47);
        this.piano.setEnabled(!bl);
        this.mezzoPiano.setSelection(n == 63);
        this.mezzoPiano.setEnabled(!bl);
        this.mezzoForte.setSelection(n == 79);
        this.mezzoForte.setEnabled(!bl);
        this.forte.setSelection(n == 95);
        this.forte.setEnabled(!bl);
        this.fortissimo.setSelection(n == 111);
        this.fortissimo.setEnabled(!bl);
        this.forteFortissimo.setSelection(n == 127);
        this.forteFortissimo.setEnabled(!bl);
    }

    public void loadProperties() {
        this.pianoPianissimo.setToolTipText(TuxGuitar.getProperty("dynamic.piano-pianissimo"));
        this.pianissimo.setToolTipText(TuxGuitar.getProperty("dynamic.pianissimo"));
        this.piano.setToolTipText(TuxGuitar.getProperty("dynamic.piano"));
        this.mezzoPiano.setToolTipText(TuxGuitar.getProperty("dynamic.mezzo-piano"));
        this.mezzoForte.setToolTipText(TuxGuitar.getProperty("dynamic.mezzo-forte"));
        this.forte.setToolTipText(TuxGuitar.getProperty("dynamic.forte"));
        this.fortissimo.setToolTipText(TuxGuitar.getProperty("dynamic.fortissimo"));
        this.forteFortissimo.setToolTipText(TuxGuitar.getProperty("dynamic.forte-fortissimo"));
    }

    public void loadIcons() {
        this.pianoPianissimo.setImage(TuxGuitar.instance().getIconManager().getDynamicPPP());
        this.pianissimo.setImage(TuxGuitar.instance().getIconManager().getDynamicPP());
        this.piano.setImage(TuxGuitar.instance().getIconManager().getDynamicP());
        this.mezzoPiano.setImage(TuxGuitar.instance().getIconManager().getDynamicMP());
        this.mezzoForte.setImage(TuxGuitar.instance().getIconManager().getDynamicMF());
        this.forte.setImage(TuxGuitar.instance().getIconManager().getDynamicF());
        this.fortissimo.setImage(TuxGuitar.instance().getIconManager().getDynamicFF());
        this.forteFortissimo.setImage(TuxGuitar.instance().getIconManager().getDynamicFFF());
    }
}

