/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGSongExporter;
import org.herac.tuxguitar.io.base.TGSongImporter;

public class FileMenuItem
extends MenuItems {
    private MenuItem fileMenuItem;
    private Menu menu;
    private Menu importMenu;
    private Menu exportMenu;
    private Menu historyMenu;
    private MenuItem newSong;
    private MenuItem open;
    private MenuItem openURL;
    private MenuItem save;
    private MenuItem saveAs;
    private MenuItem importItem;
    private MenuItem exportItem;
    private MenuItem printPreview;
    private MenuItem print;
    private MenuItem historyItem;
    private MenuItem[] historyFiles;
    private MenuItem exit;
    private List importItems;
    private List exportItems;

    public FileMenuItem(Shell shell, Menu menu, int n) {
        this.fileMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
        this.importItems = new ArrayList();
        this.exportItems = new ArrayList();
    }

    public void showItems() {
        Object object;
        Object object2;
        this.newSong = new MenuItem(this.menu, 8);
        this.newSong.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.new"));
        this.open = new MenuItem(this.menu, 8);
        this.open.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.open"));
        this.openURL = new MenuItem(this.menu, 8);
        this.openURL.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.open-url"));
        new MenuItem(this.menu, 2);
        this.save = new MenuItem(this.menu, 8);
        this.save.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.save"));
        this.saveAs = new MenuItem(this.menu, 8);
        this.saveAs.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.save-as"));
        new MenuItem(this.menu, 2);
        this.importItems.clear();
        this.importItem = new MenuItem(this.menu, 64);
        this.importMenu = new Menu((Decorations)this.menu.getShell(), 4);
        Iterator iterator = TGFileFormatManager.instance().getImporters();
        while (iterator.hasNext()) {
            object2 = (TGSongImporter)iterator.next();
            object = new MenuItem(this.importMenu, 8);
            object.setData(object2);
            object.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.import"));
            this.importItems.add(object);
        }
        this.exportItems.clear();
        this.exportItem = new MenuItem(this.menu, 64);
        this.exportMenu = new Menu((Decorations)this.menu.getShell(), 4);
        object2 = TGFileFormatManager.instance().getExporters();
        while (object2.hasNext()) {
            object = (TGSongExporter)object2.next();
            MenuItem menuItem = new MenuItem(this.exportMenu, 8);
            menuItem.setData(object);
            menuItem.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.export"));
            this.exportItems.add(menuItem);
        }
        new MenuItem(this.menu, 2);
        this.printPreview = new MenuItem(this.menu, 8);
        this.printPreview.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.print-preview"));
        this.print = new MenuItem(this.menu, 8);
        this.print.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.print"));
        new MenuItem(this.menu, 2);
        this.historyItem = new MenuItem(this.menu, 64);
        this.historyMenu = new Menu((Decorations)this.menu.getShell(), 4);
        this.updateHistoryFiles();
        new MenuItem(this.menu, 2);
        this.exit = new MenuItem(this.menu, 8);
        this.exit.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.exit"));
        this.importItem.setMenu(this.importMenu);
        this.exportItem.setMenu(this.exportMenu);
        this.historyItem.setMenu(this.historyMenu);
        this.fileMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    private void disposeHistoryFiles() {
        for (int i = 0; i < this.historyFiles.length; ++i) {
            this.historyFiles[i].dispose();
        }
    }

    private void updateHistoryFiles() {
        List list = TuxGuitar.instance().getFileHistory().getURLs();
        this.historyFiles = new MenuItem[list.size()];
        for (int i = 0; i < this.historyFiles.length; ++i) {
            URL uRL = (URL)list.get(i);
            this.historyFiles[i] = new MenuItem(this.historyMenu, 8);
            this.historyFiles[i].setText(this.decode(uRL.toString()));
            this.historyFiles[i].setData((Object)uRL);
            this.historyFiles[i].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.open"));
        }
        this.historyItem.setEnabled(this.historyFiles.length > 0);
    }

    private String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string;
        }
    }

    public void update() {
        if (TuxGuitar.instance().getFileHistory().isChanged()) {
            this.disposeHistoryFiles();
            this.updateHistoryFiles();
            TuxGuitar.instance().getFileHistory().setChanged(false);
        }
    }

    public void loadProperties() {
        Object object;
        this.setMenuItemTextAndAccelerator(this.fileMenuItem, "file", null);
        this.setMenuItemTextAndAccelerator(this.newSong, "file.new", "action.file.new");
        this.setMenuItemTextAndAccelerator(this.open, "file.open", "action.file.open");
        this.setMenuItemTextAndAccelerator(this.openURL, "file.open-url", "action.file.open-url");
        this.setMenuItemTextAndAccelerator(this.save, "file.save", "action.file.save");
        this.setMenuItemTextAndAccelerator(this.saveAs, "file.save-as", "action.file.save-as");
        this.setMenuItemTextAndAccelerator(this.importItem, "file.import", "action.file.import");
        this.setMenuItemTextAndAccelerator(this.exportItem, "file.export", "action.file.export");
        this.setMenuItemTextAndAccelerator(this.printPreview, "file.print-preview", "action.file.print-preview");
        this.setMenuItemTextAndAccelerator(this.print, "file.print", "action.file.print");
        this.setMenuItemTextAndAccelerator(this.historyItem, "file.history", null);
        this.setMenuItemTextAndAccelerator(this.exit, "file.exit", "action.file.exit");
        Iterator iterator = this.importItems.iterator();
        while (iterator.hasNext()) {
            object = (MenuItem)iterator.next();
            if (!(object.getData() instanceof TGSongImporter)) continue;
            object.setText(TuxGuitar.getProperty("file.import") + " " + ((TGSongImporter)object.getData()).getImportName());
        }
        object = this.exportItems.iterator();
        while (object.hasNext()) {
            MenuItem menuItem = (MenuItem)object.next();
            if (!(menuItem.getData() instanceof TGSongExporter)) continue;
            menuItem.setText(TuxGuitar.getProperty("file.export") + " " + ((TGSongExporter)menuItem.getData()).getExportName());
        }
    }

    public void loadIcons() {
        this.newSong.setImage(TuxGuitar.instance().getIconManager().getFileNew());
        this.open.setImage(TuxGuitar.instance().getIconManager().getFileOpen());
        this.save.setImage(TuxGuitar.instance().getIconManager().getFileSave());
        this.saveAs.setImage(TuxGuitar.instance().getIconManager().getFileSaveAs());
        this.printPreview.setImage(TuxGuitar.instance().getIconManager().getFilePrintPreview());
        this.print.setImage(TuxGuitar.instance().getIconManager().getFilePrint());
    }
}

