/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGLyricImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.TGTrack;

public class PageViewLayout
extends ViewLayout {
    private static final int STATIC_WIDTH = TuxGuitar.instance().getConfig().getIntConfigValue("layout.page.force-width", 0);
    private int maximumWidth;
    private int marginLeft;
    private int marginRight;

    public PageViewLayout(Tablature tablature, int n) {
        super(tablature, n);
    }

    public int getMode() {
        return 1;
    }

    public void paintSong(TGPainter tGPainter, Rectangle rectangle, int n, int n2) {
        this.maximumWidth = STATIC_WIDTH;
        this.marginLeft = this.getFirstMeasureSpacing();
        this.marginRight = 10;
        this.setWidth(0);
        this.setHeight(0);
        this.clearTrackPositions();
        int n3 = this.getStyle();
        int n4 = (n3 & 2) == 0 ? this.getTablature().getCaret().getTrack().getNumber() : -1;
        int n5 = n2 + this.getFirstTrackSpacing();
        int n6 = this.getFirstTrackSpacing();
        int n7 = 0;
        int n8 = this.getSongManager().getSong().countMeasureHeaders();
        int n9 = 0;
        while (n8 > n9) {
            TempLine tempLine = null;
            Iterator iterator = this.getSongManager().getSong().getTracks();
            while (iterator.hasNext()) {
                TGTrackImpl tGTrackImpl = (TGTrackImpl)iterator.next();
                if (n4 >= 0 && tGTrackImpl.getNumber() != n4) continue;
                TrackSpacing trackSpacing = new TrackSpacing(this);
                trackSpacing.setSize(7, (n3 & 4) != 0 ? this.getScoreLineSpacing() * 5 : 0);
                if (n9 == 0) {
                    ((TGLyricImpl)tGTrackImpl.getLyrics()).start();
                }
                tempLine = this.getTempLines(tGTrackImpl, n9, trackSpacing);
                if ((n3 & 4) != 0) {
                    trackSpacing.setSize(6, Math.abs(tempLine.minY));
                    if (tempLine.maxY + this.getMinScoreTabSpacing() > this.getScoreSpacing()) {
                        trackSpacing.setSize(8, tempLine.maxY - this.getScoreLineSpacing() * 4);
                    }
                }
                if ((n3 & 8) != 0) {
                    trackSpacing.setSize(16, (n3 & 4) != 0 ? this.getMinScoreTabSpacing() : Math.max(Math.abs(tempLine.minY), this.getStringSpacing()));
                    trackSpacing.setSize(17, (n3 & 4) != 0 ? tGTrackImpl.getTabHeight() + this.getStringSpacing() + 1 : Math.max(tempLine.maxY, tGTrackImpl.getTabHeight() + this.getStringSpacing() + 1));
                }
                trackSpacing.setSize(18, 10);
                this.checkDefaultSpacing(trackSpacing);
                this.paintLine(tGTrackImpl, tempLine, tGPainter, n, n5, trackSpacing, rectangle);
                n7 = trackSpacing.getSize();
                this.addTrackPosition(tGTrackImpl.getNumber(), n5, n7);
                int n10 = this.marginLeft + n + tempLine.tempWith + 2;
                int n11 = this.getMaxWidth() - n10;
                if (n11 - 20 > 0 && tempLine.lastIndex + 1 >= n8 && n10 < rectangle.x + rectangle.width) {
                    n10 = n10 < rectangle.x ? rectangle.x : n10;
                    n11 = n11 > rectangle.width ? rectangle.width : n11;
                    this.paintLines(tGTrackImpl, trackSpacing, tGPainter, n10, n5, n11);
                }
                n5 += n7 + this.getTrackSpacing();
                n6 += n7 + this.getTrackSpacing();
            }
            if (tempLine == null) continue;
            n9 = tempLine.lastIndex + 1;
        }
        this.setHeight(n6);
        this.setWidth(this.getWidth() + this.marginRight);
        this.paintCaret(tGPainter);
    }

    public void paintLine(TGTrackImpl tGTrackImpl, TempLine tempLine, TGPainter tGPainter, int n, int n2, TrackSpacing trackSpacing, Rectangle rectangle) {
        int n3;
        int n4 = this.marginLeft + n;
        int n5 = n2;
        int n6 = this.marginLeft;
        boolean bl = n5 + trackSpacing.getSize() > rectangle.y && n5 < rectangle.y + rectangle.height + 80;
        int n7 = 0;
        if (tempLine.fullLine && (n3 = this.getMaxWidth() - tempLine.tempWith) != 0 && tempLine.measures.size() > 0) {
            n7 = n3 / tempLine.measures.size();
        }
        for (n3 = 0; n3 < tempLine.measures.size(); ++n3) {
            boolean bl2;
            int n8 = (Integer)tempLine.measures.get(n3);
            TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)tGTrackImpl.getMeasure(n8);
            tGMeasureImpl.setPosX(n4);
            tGMeasureImpl.setPosY(n5);
            tGMeasureImpl.setTs(trackSpacing);
            ((TGLyricImpl)tGTrackImpl.getLyrics()).setCurrentMeasure(tGMeasureImpl);
            tGMeasureImpl.setFirstOfLine(n3 == 0);
            int n9 = tGMeasureImpl.getWidth(this) + n7;
            boolean bl3 = bl2 = n4 + n9 > rectangle.x && n4 < rectangle.x + rectangle.width;
            if (bl2 && bl) {
                this.paintMeasure(tGMeasureImpl, tGPainter, n7);
                ((TGLyricImpl)tGTrackImpl.getLyrics()).paintCurrentNoteBeats(tGPainter, this, tGMeasureImpl, n4, n5);
            } else {
                tGMeasureImpl.setOutOfBounds(true);
            }
            n4 += n9;
            n6 += n9;
        }
        this.setWidth(Math.max(this.getWidth(), n6));
    }

    public TempLine getTempLines(TGTrack tGTrack, int n, TrackSpacing trackSpacing) {
        int n2 = this.getStyle();
        TempLine tempLine = new TempLine();
        tempLine.maxY = 0;
        tempLine.minY = 0;
        if ((n2 & 8) == 0 && (n2 & 4) != 0) {
            tempLine.maxY = this.getScoreLineSpacing() * 4 + this.getScoreLineSpacing() * 4;
            tempLine.minY = -(this.getScoreLineSpacing() * 3);
        }
        int n3 = tGTrack.countMeasures();
        for (int i = n; i < n3; ++i) {
            TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)tGTrack.getMeasure(i);
            if (tempLine.tempWith + tGMeasureImpl.getWidth(this) >= this.getMaxWidth() && !tempLine.measures.isEmpty()) {
                tempLine.fullLine = true;
                return tempLine;
            }
            tempLine.tempWith += tGMeasureImpl.getWidth(this);
            tempLine.maxY = tGMeasureImpl.getMaxY() > tempLine.maxY ? tGMeasureImpl.getMaxY() : tempLine.maxY;
            tempLine.minY = tGMeasureImpl.getMinY() < tempLine.minY ? tGMeasureImpl.getMinY() : tempLine.minY;
            tempLine.addMeasure(i);
            tGMeasureImpl.registerSpacing(this, trackSpacing);
        }
        return tempLine;
    }

    public int getMaxWidth() {
        if (this.maximumWidth <= 0) {
            int n = 0;
            int n2 = 0;
            int n3 = this.getTablature().getMonitor().getClientArea().width;
            Rectangle rectangle = this.getTablature().getClientArea();
            Composite composite = this.getTablature().getParent();
            while (composite != null) {
                Rectangle rectangle2 = composite.getClientArea();
                if ((composite = composite.getParent()) == null) {
                    n2 = rectangle2.width - (n + rectangle.width);
                    continue;
                }
                n += rectangle2.x;
            }
            this.maximumWidth = n3 - (n + n2);
        }
        return this.maximumWidth - (this.marginLeft + this.marginRight);
    }

    private class TempLine {
        protected int tempWith;
        protected int lastIndex;
        protected boolean fullLine;
        protected int maxY = 0;
        protected int minY = 0;
        protected List measures = new ArrayList();

        protected void addMeasure(int n) {
            this.measures.add(new Integer(n));
            this.lastIndex = n;
        }
    }
}

