/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.herac.tuxguitar.song.models.TGChord;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ChordXMLWriter {
    public static void setChords(List list, String string) {
        File file = new File(string);
        Document document = ChordXMLWriter.createDocument();
        ChordXMLWriter.setChords(list, document);
        ChordXMLWriter.saveDocument(document, file);
    }

    public static Document createDocument() {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return document;
    }

    public static void saveDocument(Document document, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private static void setChords(List list, Document document) {
        Element element = document.createElement("chords");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGChord tGChord = (TGChord)iterator.next();
            Element element2 = document.createElement("chord");
            element.appendChild(element2);
            Attr attr = document.createAttribute("name");
            attr.setNodeValue(tGChord.getName());
            element2.getAttributes().setNamedItem(attr);
            Attr attr2 = document.createAttribute("strings");
            attr2.setNodeValue(Integer.toString(tGChord.getStrings().length));
            element2.getAttributes().setNamedItem(attr2);
            Attr attr3 = document.createAttribute("first-fret");
            attr3.setNodeValue(Integer.toString(tGChord.getFirstFret()));
            element2.getAttributes().setNamedItem(attr3);
            for (int i = 0; i < tGChord.getStrings().length; ++i) {
                Element element3 = document.createElement("string");
                element2.appendChild(element3);
                Attr attr4 = document.createAttribute("number");
                attr4.setNodeValue(Integer.toString(i));
                element3.getAttributes().setNamedItem(attr4);
                Attr attr5 = document.createAttribute("fret");
                attr5.setNodeValue(Integer.toString(tGChord.getFretValue(i)));
                element3.getAttributes().setNamedItem(attr5);
            }
        }
        document.appendChild(element);
    }
}

