/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.chord.ChordDialog;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGTrack;

public class ChordEditor
extends Composite {
    public static final int STRING_SPACING = 30;
    public static final int FRET_SPACING = 30;
    public static final short MIN_FRET = 1;
    public static final short MAX_FRET = 24;
    private ChordDialog dialog;
    private Composite composite;
    private Text chordName;
    private List points;
    private boolean[] fisrtFrets;
    private int[] strings;
    private int[] frets;
    private short fret;
    private short maxStrings;
    private int width;
    private int height;
    private TGTrack currentTrack = null;

    public ChordEditor(Composite composite, int n) {
        super(composite, n);
    }

    public ChordEditor(ChordDialog chordDialog, Composite composite, int n, short s) {
        this(composite, n);
        this.dialog = chordDialog;
        this.setLayout((Layout)chordDialog.gridLayout(1, false, 0, 0));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.init(s);
    }

    public void init(short s) {
        int n;
        this.fret = 1;
        this.maxStrings = s;
        this.fisrtFrets = new boolean[this.maxStrings];
        this.strings = new int[this.maxStrings];
        this.frets = new int[6];
        this.width = 30 * this.maxStrings - 30;
        this.height = 150;
        this.points = new ArrayList();
        for (n = 0; n < this.fisrtFrets.length; ++n) {
            this.fisrtFrets[n] = false;
        }
        for (n = 0; n < this.strings.length; ++n) {
            this.strings[n] = (n + 1) * 30;
        }
        for (n = 0; n < this.frets.length; ++n) {
            this.frets[n] = (n + 1) * 30;
        }
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite = new Composite(composite, 0x20000A00);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.dialog.gridLayout(1, true, 0, 0));
        composite2.setLayoutData((Object)new GridData(4, 1024, true, true));
        Label label = new Label(composite2, 258);
        label.setLayoutData((Object)new GridData(4, 1024, true, true));
        Label label2 = new Label(composite2, 16384);
        label2.setText(TuxGuitar.getProperty("chord.name"));
        label2.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.chordName = new Text(composite2, 2052);
        this.chordName.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.composite.setBackground(this.getDisplay().getSystemColor(1));
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                ChordEditor.this.paintEditor(tGPainter);
            }
        });
        this.composite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                ChordEditor.this.getComposite().setFocus();
                ChordEditor.this.checkPoint(mouseEvent.x, mouseEvent.y);
                ChordEditor.this.redraw();
            }
        });
        this.composite.getVerticalBar().setIncrement(1);
        this.composite.getVerticalBar().setMaximum(21);
        this.composite.getVerticalBar().setMinimum(1);
        this.composite.getVerticalBar().setThumb(1);
        this.composite.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordEditor.this.setFret((short)ChordEditor.this.getComposite().getVerticalBar().getSelection(), false, true);
                ChordEditor.this.redraw();
            }
        });
        this.composite.setLayoutData((Object)this.makeCompositeData());
    }

    private GridData makeCompositeData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = this.getWidth() + 60 + this.composite.getVerticalBar().getSize().x;
        gridData.minimumHeight = this.getHeight() + 60;
        return gridData;
    }

    protected void paintEditor(TGPainter tGPainter) {
        int n;
        int n2 = 15;
        tGPainter.setForeground(this.getDisplay().getSystemColor(2));
        tGPainter.initPath();
        tGPainter.moveTo(20.0f, 20.0f);
        tGPainter.lineTo(30 + (this.width + 10), 20.0f);
        tGPainter.closePath();
        tGPainter.drawString(Integer.toString(this.getFret()), 5, 30);
        tGPainter.initPath();
        for (n = 0; n < this.strings.length; ++n) {
            tGPainter.moveTo(this.strings[n], 30.0f);
            tGPainter.lineTo(this.strings[n], 30 + this.height);
        }
        tGPainter.closePath();
        tGPainter.initPath();
        for (n = 0; n < this.frets.length; ++n) {
            tGPainter.moveTo(30.0f, this.frets[n]);
            tGPainter.lineTo(30 + this.width, this.frets[n]);
        }
        tGPainter.closePath();
        tGPainter.setBackground(this.getDisplay().getSystemColor(2));
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            tGPainter.initPath(2);
            tGPainter.addOval(point.x - n2 / 2, point.y + n2 / 2, n2, n2);
            tGPainter.closePath();
        }
        for (int i = 0; i < this.fisrtFrets.length; ++i) {
            int n3;
            int n4;
            if (this.hasPoints(i)) continue;
            tGPainter.initPath();
            if (this.fisrtFrets[i]) {
                n4 = this.strings[i] - n2 / 2;
                n3 = 30 - n2 - 11;
                tGPainter.addOval(n4, n3, n2 - 1, n2 - 1);
            } else {
                n4 = this.strings[i];
                n3 = 30 - n2 - 4;
                tGPainter.moveTo(n4 - (n2 / 2 - 1), n3 + (n2 / 2 - 1));
                tGPainter.lineTo(n4 + (n2 / 2 - 1), n3 - (n2 / 2 - 1));
                tGPainter.moveTo(n4 - (n2 / 2 - 1), n3 - (n2 / 2 - 1));
                tGPainter.lineTo(n4 + (n2 / 2 - 1), n3 + (n2 / 2 - 1));
            }
            tGPainter.closePath();
        }
    }

    protected void checkPoint(int n, int n2) {
        int n3 = this.getStringIndex(n);
        int n4 = this.getFretIndex(n2);
        if (n2 < 30) {
            this.fisrtFrets[n3] = !this.fisrtFrets[n3];
            this.removePointsAtStringLine(this.strings[n3]);
        } else if (n2 < 180) {
            Point point = new Point(this.strings[n3], this.frets[n4]);
            if (!this.removePoint(point)) {
                this.fisrtFrets[n3] = false;
                this.removePointsAtStringLine(this.strings[n3]);
                this.addPoint(point);
                this.orderPoints();
            }
        } else {
            return;
        }
        this.dialog.getRecognizer().recognize(this.getChord(), true, false);
    }

    private boolean removePoint(Point point) {
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            Point point2 = (Point)iterator.next();
            if (point2.x != point.x || point2.y != point.y) continue;
            this.points.remove(point);
            return true;
        }
        return false;
    }

    private void orderPoints() {
        for (int i = 0; i < this.points.size(); ++i) {
            Point point = null;
            for (int j = i; j < this.points.size(); ++j) {
                Point point2 = (Point)this.points.get(j);
                if (point != null && point2.x >= point.x) continue;
                point = point2;
            }
            this.points.remove(point);
            this.points.add(i, point);
        }
    }

    private void removePointsAtStringLine(int n) {
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            if (point.x != n) continue;
            this.points.remove(point);
            break;
        }
    }

    private void addPoint(Point point) {
        this.points.add(point);
    }

    private int getStringIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.strings.length; ++i) {
            if (n2 < 0) {
                n2 = i;
                continue;
            }
            int n3 = Math.abs(n - this.strings[n2]);
            int n4 = Math.abs(n - this.strings[i]);
            if (n4 >= n3) continue;
            n2 = i;
        }
        return n2;
    }

    private int getFretIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.frets.length; ++i) {
            if (n2 < 0) {
                n2 = i;
                continue;
            }
            int n3 = Math.abs(n - (this.frets[n2] + 15));
            int n4 = Math.abs(n - (this.frets[i] + 15));
            if (n4 >= n3) continue;
            n2 = i;
        }
        return n2;
    }

    private boolean hasPoints(int n) {
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            if (point.x != this.strings[n]) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public int getValue(int n) {
        int n2 = -1;
        if (this.fisrtFrets[this.maxStrings - n]) {
            n2 = 0;
        }
        if (n2 < 0) {
            Iterator iterator = this.points.iterator();
            while (iterator.hasNext()) {
                Point point = (Point)iterator.next();
                if (n != this.maxStrings - this.getStringIndex(point.x)) continue;
                n2 = this.getFretIndex(point.y + 15) + 1;
                n2 += this.getFret() - 1;
            }
        }
        return n2;
    }

    public void addValue(int n, int n2) {
        int n3 = n;
        if (n2 >= 1 && n2 <= this.maxStrings) {
            this.fisrtFrets[this.maxStrings - n2] = false;
            this.removePointsAtStringLine(this.strings[this.maxStrings - n2]);
            if (n3 == 0) {
                this.fisrtFrets[this.maxStrings - n2] = true;
            } else if (n3 >= 0 && (n3 -= this.getFret() - 1) > 0 && n3 <= 6) {
                this.addPoint(new Point(this.strings[this.maxStrings - n2], this.frets[n3 - 1]));
            }
        }
    }

    public short getFret() {
        return this.fret;
    }

    public void setFret(short s) {
        this.setFret(s, true, false);
    }

    protected void setFret(short s, boolean bl, boolean bl2) {
        if (s >= 1 && s <= 24) {
            this.fret = s;
        }
        if (bl) {
            this.composite.getVerticalBar().setSelection((int)this.fret);
        }
        if (bl2) {
            this.dialog.getRecognizer().recognize(this.getChord(), true, false);
        }
    }

    public TGChord getChord() {
        TGChord tGChord = TuxGuitar.instance().getSongManager().getFactory().newChord(this.strings.length);
        tGChord.setName(this.chordName.getText());
        tGChord.setFirstFret(this.fret);
        for (int i = 0; i < tGChord.getStrings().length; ++i) {
            tGChord.addFretValue(i, this.getValue(i + 1));
        }
        return tGChord;
    }

    public void setChord(TGChord tGChord) {
        if (tGChord != null) {
            this.setFret((short)tGChord.getFirstFret());
            for (int i = 0; i < tGChord.getStrings().length; ++i) {
                int n = tGChord.getFretValue(i);
                this.addValue(n, i + 1);
            }
            String string = tGChord.getName();
            this.dialog.getRecognizer().recognize(this.getChord(), string == null, string == null);
            this.previewChord(tGChord);
            if (string != null) {
                this.setChordName(string);
            }
            this.redraw();
        }
    }

    public short getMaxStrings() {
        return this.maxStrings;
    }

    public void setMaxStrings(short s) {
        this.maxStrings = s;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected Composite getComposite() {
        return this.composite;
    }

    public Text getChordName() {
        return this.chordName;
    }

    public void setChordName(String string) {
        this.chordName.setText(string);
    }

    public void redraw() {
        super.redraw();
        this.composite.redraw();
    }

    public void setCurrentTrack(TGTrack tGTrack) {
        this.currentTrack = tGTrack;
    }

    public TGTrack getCurrentTrack() {
        return this.currentTrack;
    }

    public void previewChord(final TGChord tGChord) {
        new Thread(new Runnable(){

            public void run() {
                int n;
                int n2 = 0;
                int n3 = Math.min(ChordEditor.this.getMaxStrings(), tGChord.countStrings());
                for (n = 0; n < n3; ++n) {
                    if (tGChord.getFretValue(n) == -1) continue;
                    ++n2;
                }
                n = 0;
                int[][] nArray = new int[n2][2];
                for (int i = 0; i < n3; ++i) {
                    int n4 = n3 - i;
                    int n5 = tGChord.getFretValue(n4 - 1);
                    if (n5 == -1) continue;
                    nArray[n][0] = ChordEditor.this.getCurrentTrack().getOffset() + ChordEditor.this.getCurrentTrack().getString(n4).getValue() + n5;
                    nArray[n][1] = 95;
                    ++n;
                }
                TGChannel tGChannel = ChordEditor.this.getCurrentTrack().getChannel();
                TuxGuitar.instance().getPlayer().playBeat(tGChannel.getChannel(), tGChannel.getInstrument(), tGChannel.getVolume(), tGChannel.getBalance(), tGChannel.getChorus(), tGChannel.getReverb(), tGChannel.getPhaser(), tGChannel.getTremolo(), nArray, 200L, 200);
            }
        }).start();
    }
}

